/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.debugger;

import java.util.ArrayList;
import java.util.List;

public final class CoroutinesDebugHelper {
    public static long[] getCoroutinesRunningOnCurrentThread(Object debugProbes) throws ReflectiveOperationException {
        Thread currentThread = Thread.currentThread();
        ArrayList<Long> coroutinesIds = new ArrayList<Long>();
        List infos = (List)CoroutinesDebugHelper.invoke(debugProbes, "dumpCoroutinesInfo");
        for (Object info : infos) {
            if (CoroutinesDebugHelper.invoke(info, "getLastObservedThread") != currentThread) continue;
            coroutinesIds.add((Long)CoroutinesDebugHelper.invoke(info, "getSequenceNumber"));
        }
        long[] res = new long[coroutinesIds.size()];
        for (int i = 0; i < res.length; ++i) {
            res[i] = (Long)coroutinesIds.get(i);
        }
        return res;
    }

    private static Object invoke(Object object, String methodName) throws ReflectiveOperationException {
        return object.getClass().getMethod(methodName, new Class[0]).invoke(object, new Object[0]);
    }
}

