/*
 * Decompiled with CFR 0.152.
 */
package git4idea.rebase;

import com.intellij.dvcs.repo.Repository;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.changes.ChangeListManagerImpl;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsCommitMetadata;
import com.intellij.vcs.log.VcsUser;
import com.intellij.vcs.log.util.VcsUserUtil;
import git4idea.i18n.GitBundle;
import git4idea.rebase.GitRewordOperation;
import git4idea.rebase.GitSingleCommitEditingAction;
import git4idea.rebase.log.GitCommitEditingActionBase;
import git4idea.rebase.log.GitCommitEditingNotificationsKt;
import git4idea.rebase.log.GitCommitEditingOperationResult;
import git4idea.rebase.log.GitLogCommitDetailsLoaderKt;
import git4idea.rebase.log.GitNewCommitMessageActionDialog;
import git4idea.repo.GitRepository;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0014J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\t\u001a\u00020\nH\u0014J\b\u0010\r\u001a\u00020\fH\u0014J\u001a\u0010\u000e\u001a\u0004\u0018\u00010\f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\fH\u0014J(\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\fH\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0018"}, d2={"Lgit4idea/rebase/GitRewordAction;", "Lgit4idea/rebase/GitSingleCommitEditingAction;", "()V", "prohibitRebaseDuringRebasePolicy", "Lgit4idea/rebase/log/GitCommitEditingActionBase$ProhibitRebaseDuringRebasePolicy$Prohibit;", "getProhibitRebaseDuringRebasePolicy", "()Lgit4idea/rebase/log/GitCommitEditingActionBase$ProhibitRebaseDuringRebasePolicy$Prohibit;", "actionPerformedAfterChecks", "", "commitEditingData", "Lgit4idea/rebase/GitSingleCommitEditingAction$SingleCommitEditingData;", "checkNotMergeCommit", "", "getFailureTitle", "getProhibitedStateMessage", "operation", "rewordInBackground", "project", "Lcom/intellij/openapi/project/Project;", "commit", "Lcom/intellij/vcs/log/VcsCommitMetadata;", "repository", "Lgit4idea/repo/GitRepository;", "newMessage", "intellij.vcs.git"})
public final class GitRewordAction
extends GitSingleCommitEditingAction {
    @NotNull
    private final GitCommitEditingActionBase.ProhibitRebaseDuringRebasePolicy.Prohibit prohibitRebaseDuringRebasePolicy;

    public GitRewordAction() {
        String string = GitBundle.message("rebase.log.action.operation.reword.name", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        this.prohibitRebaseDuringRebasePolicy = new GitCommitEditingActionBase.ProhibitRebaseDuringRebasePolicy.Prohibit(string);
    }

    @Override
    @NotNull
    protected GitCommitEditingActionBase.ProhibitRebaseDuringRebasePolicy.Prohibit getProhibitRebaseDuringRebasePolicy() {
        return this.prohibitRebaseDuringRebasePolicy;
    }

    @Override
    @Nullable
    protected String checkNotMergeCommit(@NotNull GitSingleCommitEditingAction.SingleCommitEditingData commitEditingData) {
        Intrinsics.checkNotNullParameter((Object)commitEditingData, (String)"commitEditingData");
        VcsCommitMetadata commit = commitEditingData.getSelectedCommit();
        GitRepository repository = commitEditingData.getRepository();
        if (Intrinsics.areEqual((Object)((Hash)commit.getId()).asString(), (Object)repository.getCurrentRevision())) {
            return null;
        }
        return super.checkNotMergeCommit((GitCommitEditingActionBase.MultipleCommitEditingData)commitEditingData);
    }

    @Override
    protected void actionPerformedAfterChecks(@NotNull GitSingleCommitEditingAction.SingleCommitEditingData commitEditingData) {
        Intrinsics.checkNotNullParameter((Object)commitEditingData, (String)"commitEditingData");
        List<VcsCommitMetadata> details = GitLogCommitDetailsLoaderKt.getOrLoadDetails(commitEditingData.getProject(), commitEditingData.getLogData(), commitEditingData.getSelection());
        VcsCommitMetadata commit = (VcsCommitMetadata)CollectionsKt.first(details);
        GitCommitEditingActionBase.MultipleCommitEditingData multipleCommitEditingData = commitEditingData;
        String string = commit.getFullMessage();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getFullMessage(...)");
        String string2 = GitBundle.message("rebase.log.reword.dialog.title", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        Object[] objectArray = new Object[]{((Hash)commit.getId()).toShortString(), VcsUserUtil.getShortPresentation((VcsUser)commit.getAuthor())};
        String string3 = GitBundle.message("rebase.log.reword.dialog.description.label", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
        GitNewCommitMessageActionDialog<GitCommitEditingActionBase.MultipleCommitEditingData> dialog = new GitNewCommitMessageActionDialog<GitCommitEditingActionBase.MultipleCommitEditingData>(multipleCommitEditingData, string, string2, string3);
        dialog.show((Function1<String, Unit>)((Function1)new Function1<String, Unit>(this, commitEditingData, commit){
            final /* synthetic */ GitRewordAction this$0;
            final /* synthetic */ GitSingleCommitEditingAction.SingleCommitEditingData $commitEditingData;
            final /* synthetic */ VcsCommitMetadata $commit;
            {
                this.this$0 = $receiver;
                this.$commitEditingData = $commitEditingData;
                this.$commit = $commit;
                super(1);
            }

            public final void invoke(@NotNull String newMessage) {
                Intrinsics.checkNotNullParameter((Object)newMessage, (String)"newMessage");
                GitRewordAction.access$rewordInBackground(this.this$0, this.$commitEditingData.getProject(), this.$commit, this.$commitEditingData.getRepository(), newMessage);
            }
        }));
    }

    @Override
    @NotNull
    protected String getFailureTitle() {
        String string = GitBundle.message("rebase.log.reword.action.failure.title", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    private final void rewordInBackground(Project project, VcsCommitMetadata commit, GitRepository repository, String newMessage) {
        String string = GitBundle.message("rebase.log.reword.action.progress.indicator.title", new Object[0]);
        new Task.Backgroundable(project, repository, commit, newMessage, string){
            final /* synthetic */ Project $project;
            final /* synthetic */ GitRepository $repository;
            final /* synthetic */ VcsCommitMetadata $commit;
            final /* synthetic */ String $newMessage;
            {
                this.$project = $project;
                this.$repository = $repository;
                this.$commit = $commit;
                this.$newMessage = $newMessage;
                super($project, $super_call_param$1);
            }

            public void run(@NotNull ProgressIndicator indicator) {
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                GitCommitEditingOperationResult operationResult = new GitRewordOperation(this.$repository, this.$commit, this.$newMessage).execute();
                if (operationResult instanceof GitCommitEditingOperationResult.Complete) {
                    GitCommitEditingOperationResult.Complete complete = (GitCommitEditingOperationResult.Complete)operationResult;
                    String string = GitBundle.message("rebase.log.reword.action.notification.successful.title", new Object[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                    String string2 = GitBundle.message("rebase.log.reword.action.progress.indicator.undo.title", new Object[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
                    String string3 = GitBundle.message("rebase.log.reword.action.notification.undo.not.allowed.title", new Object[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
                    String string4 = GitBundle.message("rebase.log.reword.action.notification.undo.failed.title", new Object[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"message(...)");
                    GitCommitEditingNotificationsKt.notifySuccess(complete, string, null, string2, string3, string4);
                    ChangeListManagerImpl.getInstanceImpl((Project)this.$project).replaceCommitMessage(this.$commit.getFullMessage(), this.$newMessage);
                }
            }
        }.queue();
    }

    @Override
    @Nullable
    protected String getProhibitedStateMessage(@NotNull GitSingleCommitEditingAction.SingleCommitEditingData commitEditingData, @NotNull String operation) {
        Intrinsics.checkNotNullParameter((Object)commitEditingData, (String)"commitEditingData");
        Intrinsics.checkNotNullParameter((Object)operation, (String)"operation");
        if (commitEditingData.getRepository().getState() == Repository.State.REBASING && commitEditingData.isHeadCommit()) {
            return null;
        }
        return super.getProhibitedStateMessage((GitCommitEditingActionBase.MultipleCommitEditingData)commitEditingData, operation);
    }

    public static final /* synthetic */ void access$rewordInBackground(GitRewordAction $this, Project project, VcsCommitMetadata commit, GitRepository repository, String newMessage) {
        $this.rewordInBackground(project, commit, repository, newMessage);
    }
}

