/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.editor.tables.actions.column;

import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiFile;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.plugins.markdown.editor.tables.TableModificationUtils;
import org.intellij.plugins.markdown.editor.tables.actions.column.ColumnBasedTableAction;
import org.intellij.plugins.markdown.lang.MarkdownLanguageUtilsKt;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownTable;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lorg/intellij/plugins/markdown/editor/tables/actions/column/TableColumnAlignmentActionsGroup;", "Lcom/intellij/openapi/actionSystem/DefaultActionGroup;", "()V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "intellij.markdown"})
public final class TableColumnAlignmentActionsGroup
extends DefaultActionGroup {
    public void update(@NotNull AnActionEvent event) {
        Integer offset;
        PsiFile file;
        Editor editor2;
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                editor2 = (Editor)event.getData(CommonDataKeys.EDITOR);
                file = (PsiFile)event.getData(CommonDataKeys.PSI_FILE);
                Caret caret = (Caret)event.getData(CommonDataKeys.CARET);
                Integer n = offset = caret != null ? Integer.valueOf(caret.getOffset()) : null;
                if (editor2 == null || file == null || offset == null) break block2;
                Language language = file.getLanguage();
                Intrinsics.checkNotNullExpressionValue((Object)language, (String)"getLanguage(...)");
                if (MarkdownLanguageUtilsKt.isMarkdownLanguage(language)) break block3;
            }
            event.getPresentation().setEnabledAndVisible(false);
            return;
        }
        Document document = editor2.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        Document document2 = document;
        Pair<MarkdownTable, Integer> pair = ColumnBasedTableAction.Companion.findTableAndIndex(event, file, document2, offset);
        MarkdownTable table = (MarkdownTable)pair.component1();
        Integer columnIndex = (Integer)pair.component2();
        event.getPresentation().setEnabledAndVisible(table != null && columnIndex != null && TableModificationUtils.INSTANCE.hasCorrectBorders(table));
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }
}

