/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.lang.parser;

import com.intellij.lang.PsiBuilder;
import com.intellij.lang.WhitespacesAndCommentsBinder;
import com.intellij.lang.WhitespacesBinders;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.psi.tree.IElementType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.intellij.markdown.ast.ASTNode;
import org.intellij.markdown.ast.LeafASTNode;
import org.intellij.markdown.ast.visitors.RecursiveVisitor;
import org.intellij.markdown.flavours.gfm.GFMTokenTypes;
import org.intellij.plugins.markdown.lang.MarkdownElementType;
import org.intellij.plugins.markdown.lang.MarkdownElementTypes;
import org.intellij.plugins.markdown.lang.MarkdownTokenTypeSets;
import org.intellij.plugins.markdown.lang.MarkdownTokenTypes;
import org.intellij.plugins.markdown.lang.parser.MarkdownCollapsableElementType;
import org.intellij.plugins.markdown.lang.psi.util.MarkdownAstUtilsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\b\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\f\u0010\u0015\u001a\u00020\u0005*\u00020\u0014H\u0002R\u001c\u0010\u0007\u001a\u0010\u0012\f\u0012\n \n*\u0004\u0018\u00010\t0\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/intellij/plugins/markdown/lang/parser/PsiBuilderFillingVisitor;", "Lorg/intellij/markdown/ast/visitors/RecursiveVisitor;", "builder", "Lcom/intellij/lang/PsiBuilder;", "startingFromFileLevel", "", "(Lcom/intellij/lang/PsiBuilder;Z)V", "HEADERS", "", "Lorg/intellij/markdown/IElementType;", "kotlin.jvm.PlatformType", "seenFirstMarker", "ensureBuilderInPosition", "", "position", "", "leadingWhitespaces", "Lcom/intellij/lang/WhitespacesAndCommentsBinder;", "visitNode", "node", "Lorg/intellij/markdown/ast/ASTNode;", "isEmptyCell", "intellij.markdown"})
@SourceDebugExtension(value={"SMAP\nPsiBuilderFillingVisitor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PsiBuilderFillingVisitor.kt\norg/intellij/plugins/markdown/lang/parser/PsiBuilderFillingVisitor\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,93:1\n11065#2:94\n11400#2,3:95\n*S KotlinDebug\n*F\n+ 1 PsiBuilderFillingVisitor.kt\norg/intellij/plugins/markdown/lang/parser/PsiBuilderFillingVisitor\n*L\n23#1:94\n23#1:95,3\n*E\n"})
public final class PsiBuilderFillingVisitor
extends RecursiveVisitor {
    @NotNull
    private final PsiBuilder builder;
    private boolean seenFirstMarker;
    @NotNull
    private final Set<org.intellij.markdown.IElementType> HEADERS;

    /*
     * WARNING - void declaration
     */
    public PsiBuilderFillingVisitor(@NotNull PsiBuilder builder, boolean startingFromFileLevel) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        this.builder = builder;
        this.seenFirstMarker = startingFromFileLevel;
        IElementType[] iElementTypeArray = MarkdownTokenTypeSets.HEADERS.getTypes();
        Intrinsics.checkNotNullExpressionValue((Object)iElementTypeArray, (String)"getTypes(...)");
        Object[] objectArray = iElementTypeArray;
        PsiBuilderFillingVisitor psiBuilderFillingVisitor = this;
        boolean $i$f$map = false;
        void var5_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
        boolean $i$f$mapTo = false;
        for (void item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            IElementType iElementType = (IElementType)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(MarkdownElementType.markdownType((IElementType)it));
        }
        psiBuilderFillingVisitor.HEADERS = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    private final boolean isEmptyCell(ASTNode $this$isEmptyCell) {
        return Intrinsics.areEqual((Object)$this$isEmptyCell.getType(), (Object)GFMTokenTypes.CELL) && MarkdownAstUtilsKt.getTextRange($this$isEmptyCell).isEmpty();
    }

    public void visitNode(@NotNull ASTNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        ProgressManager.checkCanceled();
        org.intellij.markdown.IElementType type = node.getType();
        if (this.isEmptyCell(node)) {
            this.ensureBuilderInPosition(node.getStartOffset());
            this.builder.mark().done(MarkdownElementTypes.TABLE_CELL);
        }
        if (node instanceof LeafASTNode && !Intrinsics.areEqual((Object)type, (Object)org.intellij.markdown.MarkdownElementTypes.LINK_LABEL) && !Intrinsics.areEqual((Object)type, (Object)org.intellij.markdown.MarkdownElementTypes.LINK_DESTINATION)) {
            return;
        }
        if (Intrinsics.areEqual((Object)type, (Object)org.intellij.markdown.MarkdownElementTypes.MARKDOWN_FILE)) {
            this.ensureBuilderInPosition(node.getStartOffset());
            super.visitNode(node);
            this.ensureBuilderInPosition(node.getEndOffset());
            return;
        }
        this.ensureBuilderInPosition(node.getStartOffset());
        PsiBuilder.Marker marker2 = this.builder.mark();
        Intrinsics.checkNotNullExpressionValue((Object)marker2, (String)"mark(...)");
        PsiBuilder.Marker marker3 = marker2;
        if (!this.seenFirstMarker) {
            this.seenFirstMarker = true;
            marker3.setCustomEdgeTokenBinders(WhitespacesBinders.GREEDY_LEFT_BINDER, WhitespacesBinders.GREEDY_RIGHT_BINDER);
        } else if (this.HEADERS.contains(type)) {
            marker3.setCustomEdgeTokenBinders(this.leadingWhitespaces(), null);
        }
        super.visitNode(node);
        this.ensureBuilderInPosition(node.getEndOffset());
        if (type instanceof MarkdownCollapsableElementType) {
            marker3.collapse(MarkdownElementType.platformType(type));
            return;
        }
        marker3.done(MarkdownElementType.platformType(type));
    }

    private final void ensureBuilderInPosition(int position) {
        while (this.builder.getCurrentOffset() < position) {
            this.builder.advanceLexer();
        }
    }

    private final WhitespacesAndCommentsBinder leadingWhitespaces() {
        return PsiBuilderFillingVisitor::leadingWhitespaces$lambda$1;
    }

    private static final int leadingWhitespaces$lambda$1(List tokens, boolean bl, WhitespacesAndCommentsBinder.TokenTextGetter getter) {
        int i;
        for (i = 0; i < tokens.size(); ++i) {
            if (!Intrinsics.areEqual(tokens.get(i), (Object)MarkdownTokenTypes.WHITE_SPACE)) continue;
            CharSequence charSequence = getter.get(i);
            Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"get(...)");
            if (!(!StringsKt.isBlank((CharSequence)charSequence))) break;
        }
        return i;
    }
}

