/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.reStructuredText.validation;

import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.python.reStructuredText.RestBundle;
import com.intellij.python.reStructuredText.RestFile;
import com.intellij.python.reStructuredText.psi.RestReferenceTarget;
import com.intellij.python.reStructuredText.validation.RestAnnotator;

public class RestReferenceTargetAnnotator
extends RestAnnotator {
    @Override
    public void visitReferenceTarget(RestReferenceTarget node) {
        RestFile file = (RestFile)node.getContainingFile();
        RestReferenceTarget[] targets = (RestReferenceTarget[])PsiTreeUtil.getChildrenOfType((PsiElement)file, RestReferenceTarget.class);
        String quotedName = node.getReferenceName();
        String name2 = node.getReferenceName(false);
        if (targets != null) {
            if ("__".equals(name2) && !node.hasReference()) {
                this.getHolder().newAnnotation(HighlightSeverity.WARNING, RestBundle.message("ANN.unusable.anonymous.target", new Object[0])).create();
            }
            for (RestReferenceTarget element : targets) {
                if (!element.getReferenceName().equalsIgnoreCase(name2) && !element.getReferenceName(false).equalsIgnoreCase(name2) && !element.getReferenceName().equalsIgnoreCase(quotedName) && !element.getReferenceName(false).equalsIgnoreCase(quotedName) || ((Object)((Object)element)).equals((Object)node) || "__".equals(name2) || "[#]".equals(quotedName) || "[*]".equals(quotedName)) continue;
                this.getHolder().newAnnotation(HighlightSeverity.WARNING, RestBundle.message("ANN.duplicate.target", name2)).create();
            }
        }
    }
}

