/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.controlflow;

import com.intellij.codeInsight.controlflow.ConditionalInstruction;
import com.intellij.codeInsight.controlflow.ControlFlowBuilder;
import com.intellij.codeInsight.controlflow.Instruction;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.ast.PyAstStatementList;
import com.jetbrains.python.codeInsight.controlflow.PyControlFlowBuilder;
import com.jetbrains.python.codeInsight.controlflow.RefutablePatternInstruction;
import com.jetbrains.python.psi.PyCaseClause;
import com.jetbrains.python.psi.PyElementVisitor;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyMatchStatement;
import com.jetbrains.python.psi.PyOrPattern;
import com.jetbrains.python.psi.PyPattern;
import com.jetbrains.python.psi.PyPatternArgumentList;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyWildcardPattern;
import java.util.List;
import java.util.function.BiFunction;
import org.jetbrains.annotations.NotNull;

public final class PyMatchStatementControlFlowBuilder {
    private final ControlFlowBuilder myBuilder;
    private final PyElementVisitor myBaseVisitor;

    public PyMatchStatementControlFlowBuilder(@NotNull ControlFlowBuilder builder, @NotNull PyElementVisitor baseVisitor) {
        if (builder == null) {
            PyMatchStatementControlFlowBuilder.$$$reportNull$$$0(0);
        }
        if (baseVisitor == null) {
            PyMatchStatementControlFlowBuilder.$$$reportNull$$$0(1);
        }
        this.myBuilder = builder;
        this.myBaseVisitor = baseVisitor;
    }

    public void build(@NotNull PyMatchStatement matchStatement) {
        if (matchStatement == null) {
            PyMatchStatementControlFlowBuilder.$$$reportNull$$$0(2);
        }
        this.myBuilder.startNode((PsiElement)matchStatement);
        PyExpression subject = matchStatement.getSubject();
        if (subject != null) {
            subject.accept(this.myBaseVisitor);
        }
        for (PyCaseClause caseClause : matchStatement.getCaseClauses()) {
            this.processCaseClause(caseClause);
        }
    }

    private void processCaseClause(@NotNull PyCaseClause clause) {
        PyPattern pattern;
        if (clause == null) {
            PyMatchStatementControlFlowBuilder.$$$reportNull$$$0(3);
        }
        if ((pattern = clause.getPattern()) != null) {
            this.processPattern(pattern);
            this.retargetOutgoingPatternEdges((PsiElement)pattern, (oldScope, instr) -> instr.isMatched() ? pattern : clause);
        }
        PyAstStatementList statementList = clause.getStatementList();
        PyExpression guard = clause.getGuardCondition();
        if (guard != null) {
            guard.accept(this.myBaseVisitor);
            this.retargetOutgoingEdges((PsiElement)guard, (pendingScope, instr) -> {
                if (instr instanceof ConditionalInstruction && !((ConditionalInstruction)instr).getResult()) {
                    return clause;
                }
                return pendingScope;
            });
            if (!PyControlFlowBuilder.isConjunctionOrDisjunction(guard)) {
                this.myBuilder.addPendingEdge((PsiElement)clause, this.myBuilder.prevInstruction);
            }
            this.myBuilder.startConditionalNode((PsiElement)statementList, (PsiElement)guard, true);
        }
        statementList.accept(this.myBaseVisitor);
        PyMatchStatement matchStatement = (PyMatchStatement)PsiTreeUtil.getParentOfType((PsiElement)clause, PyMatchStatement.class);
        assert (matchStatement != null);
        this.retargetOutgoingEdges((PsiElement)statementList, (pendingScope, instruction) -> matchStatement);
        this.myBuilder.addPendingEdge((PsiElement)matchStatement, this.myBuilder.prevInstruction);
        this.myBuilder.prevInstruction = null;
    }

    private void processPattern(final @NotNull PyPattern pattern) {
        boolean isRefutable;
        if (pattern == null) {
            PyMatchStatementControlFlowBuilder.$$$reportNull$$$0(4);
        }
        boolean bl = isRefutable = !pattern.isIrrefutable();
        if (isRefutable) {
            RefutablePatternInstruction instruction2 = new RefutablePatternInstruction(this.myBuilder, pattern, false);
            this.myBuilder.addNodeAndCheckPending((Instruction)instruction2);
            this.myBuilder.addPendingEdge((PsiElement)pattern, (Instruction)instruction2);
        }
        if (pattern instanceof PyWildcardPattern) {
            this.myBuilder.startNode((PsiElement)pattern);
        } else if (pattern instanceof PyOrPattern) {
            List<PyPattern> alternatives = ((PyOrPattern)pattern).getAlternatives();
            PyPattern lastAlternative = (PyPattern)ContainerUtil.getLastItem(alternatives);
            for (PyPattern alternative : alternatives) {
                this.processPattern(alternative);
                if (alternative != lastAlternative) {
                    this.myBuilder.addPendingEdge((PsiElement)alternative, this.myBuilder.prevInstruction);
                    this.myBuilder.prevInstruction = null;
                }
                this.retargetOutgoingEdges((PsiElement)alternative, (pendingScope, instruction) -> {
                    if (instruction instanceof RefutablePatternInstruction && !((RefutablePatternInstruction)((Object)instruction)).isMatched()) {
                        return alternative;
                    }
                    return pattern;
                });
            }
        } else {
            pattern.acceptChildren(new PyElementVisitor(){

                @Override
                public void visitPyReferenceExpression(@NotNull PyReferenceExpression node) {
                    if (node == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    PyMatchStatementControlFlowBuilder.this.myBaseVisitor.visitPyReferenceExpression(node);
                }

                @Override
                public void visitPyTargetExpression(@NotNull PyTargetExpression node) {
                    if (node == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    PyMatchStatementControlFlowBuilder.this.myBaseVisitor.visitPyTargetExpression(node);
                }

                @Override
                public void visitPyPattern(@NotNull PyPattern node) {
                    if (node == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    PyMatchStatementControlFlowBuilder.this.processPattern(node);
                    PyMatchStatementControlFlowBuilder.this.retargetOutgoingPatternEdges((PsiElement)pattern, (oldScope, instr) -> instr.isMatched() ? oldScope : pattern);
                }

                @Override
                public void visitPyPatternArgumentList(@NotNull PyPatternArgumentList node) {
                    if (node == null) {
                        1.$$$reportNull$$$0(3);
                    }
                    node.acceptChildren(this);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    objectArray2[0] = "node";
                    objectArray2[1] = "com/jetbrains/python/codeInsight/controlflow/PyMatchStatementControlFlowBuilder$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "visitPyReferenceExpression";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "visitPyTargetExpression";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[2] = "visitPyPattern";
                            break;
                        }
                        case 3: {
                            objectArray = objectArray2;
                            objectArray2[2] = "visitPyPatternArgumentList";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
        }
        if (isRefutable) {
            this.myBuilder.addNode((Instruction)new RefutablePatternInstruction(this.myBuilder, pattern, true));
        }
    }

    private void retargetOutgoingEdges(@NotNull PsiElement scopeAncestor, @NotNull BiFunction<PsiElement, Instruction, PsiElement> newScopeProvider) {
        if (scopeAncestor == null) {
            PyMatchStatementControlFlowBuilder.$$$reportNull$$$0(5);
        }
        if (newScopeProvider == null) {
            PyMatchStatementControlFlowBuilder.$$$reportNull$$$0(6);
        }
        this.myBuilder.processPending((oldScope, instruction) -> {
            if (oldScope != null && PsiTreeUtil.isAncestor((PsiElement)scopeAncestor, (PsiElement)oldScope, (boolean)false)) {
                this.myBuilder.addPendingEdge((PsiElement)newScopeProvider.apply(oldScope, instruction), instruction);
            } else {
                this.myBuilder.addPendingEdge(oldScope, instruction);
            }
        });
    }

    private void retargetOutgoingPatternEdges(@NotNull PsiElement scopeAncestor, @NotNull BiFunction<PsiElement, RefutablePatternInstruction, PsiElement> newScopeProvider) {
        if (scopeAncestor == null) {
            PyMatchStatementControlFlowBuilder.$$$reportNull$$$0(7);
        }
        if (newScopeProvider == null) {
            PyMatchStatementControlFlowBuilder.$$$reportNull$$$0(8);
        }
        this.retargetOutgoingEdges(scopeAncestor, (pendingScope, instruction) -> {
            if (instruction instanceof RefutablePatternInstruction) {
                return (PsiElement)newScopeProvider.apply((PsiElement)pendingScope, (RefutablePatternInstruction)((Object)instruction));
            }
            return pendingScope;
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseVisitor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matchStatement";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clause";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopeAncestor";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newScopeProvider";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/python/codeInsight/controlflow/PyMatchStatementControlFlowBuilder";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "build";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "processCaseClause";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "processPattern";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "retargetOutgoingEdges";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "retargetOutgoingPatternEdges";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

