/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.intentions;

import com.intellij.lang.ASTNode;
import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.Presentation;
import com.intellij.modcommand.PsiUpdateModCommandAction;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.PyPsiBundle;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyArgumentList;
import com.jetbrains.python.psi.PyDocStringOwner;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyParenthesizedExpression;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PyTupleExpression;
import com.jetbrains.python.psi.PyUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PyConvertTripleQuotedStringIntention
extends PsiUpdateModCommandAction<PyStringLiteralExpression> {
    PyConvertTripleQuotedStringIntention() {
        super(PyStringLiteralExpression.class);
    }

    @NotNull
    public String getFamilyName() {
        String string = PyPsiBundle.message("INTN.triple.quoted.string", new Object[0]);
        if (string == null) {
            PyConvertTripleQuotedStringIntention.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Nullable
    protected Presentation getPresentation(@NotNull ActionContext context, @NotNull PyStringLiteralExpression element) {
        PyDocStringOwner docStringOwner;
        if (context == null) {
            PyConvertTripleQuotedStringIntention.$$$reportNull$$$0(1);
        }
        if (element == null) {
            PyConvertTripleQuotedStringIntention.$$$reportNull$$$0(2);
        }
        if ((docStringOwner = (PyDocStringOwner)PsiTreeUtil.getParentOfType((PsiElement)element, PyDocStringOwner.class)) != null && docStringOwner.getDocStringExpression() == element) {
            return null;
        }
        for (PyUtil.StringNodeInfo info : PyConvertTripleQuotedStringIntention.extractStringNodesInfo(element)) {
            if (!info.isTripleQuoted() || !info.isTerminated() || !info.getNode().getTextRange().contains(context.offset())) continue;
            return super.getPresentation(context, (PsiElement)element);
        }
        return null;
    }

    protected void invoke(@NotNull ActionContext context, @NotNull PyStringLiteralExpression element, @NotNull ModPsiUpdater updater) {
        if (context == null) {
            PyConvertTripleQuotedStringIntention.$$$reportNull$$$0(3);
        }
        if (element == null) {
            PyConvertTripleQuotedStringIntention.$$$reportNull$$$0(4);
        }
        if (updater == null) {
            PyConvertTripleQuotedStringIntention.$$$reportNull$$$0(5);
        }
        PyElementGenerator elementGenerator = PyElementGenerator.getInstance(context.project());
        StringBuilder result2 = new StringBuilder();
        List<PyUtil.StringNodeInfo> nodeInfos = PyConvertTripleQuotedStringIntention.extractStringNodesInfo(element);
        for (int i = 0; i < nodeInfos.size(); ++i) {
            PyUtil.StringNodeInfo info = nodeInfos.get(i);
            List lines = StringUtil.split((String)info.getContent(), (String)"\n", (boolean)true, (boolean)false);
            boolean lastLineExcluded = false;
            if (lines.size() > 1 && ((String)lines.get(lines.size() - 1)).isEmpty()) {
                lastLineExcluded = true;
                lines = lines.subList(0, lines.size() - 1);
            }
            boolean inLastNode = i == nodeInfos.size() - 1;
            for (int j = 0; j < lines.size(); ++j) {
                boolean inLastLine;
                String line2 = (String)lines.get(j);
                boolean bl = inLastLine = j == lines.size() - 1;
                if (info.isRaw()) {
                    PyConvertTripleQuotedStringIntention.appendSplittedRawStringLine(result2, info, line2);
                    if (!inLastLine || lastLineExcluded) {
                        result2.append(" ").append(info.getSingleQuote()).append("\\n").append(info.getSingleQuote());
                    }
                } else {
                    result2.append(info.getPrefix());
                    result2.append(info.getSingleQuote());
                    result2.append(PyConvertTripleQuotedStringIntention.convertToValidSubString(line2, info.getSingleQuote(), info.isTripleQuoted()));
                    if (!inLastLine || lastLineExcluded) {
                        result2.append("\\n");
                    }
                    result2.append(info.getSingleQuote());
                }
                if (inLastNode && inLastLine) continue;
                result2.append("\n");
            }
        }
        if (result2.indexOf("\n") >= 0) {
            result2.insert(0, "(");
            result2.append(")");
        }
        PyExpression expression = elementGenerator.createExpressionFromText(LanguageLevel.forElement(element), result2.toString());
        PsiElement parent = element.getParent();
        if (expression instanceof PyParenthesizedExpression && (parent instanceof PyParenthesizedExpression || parent instanceof PyTupleExpression || parent instanceof PyArgumentList && ArrayUtil.getFirstElement((Object[])((PyArgumentList)parent).getArguments()) == element)) {
            expression = ((PyParenthesizedExpression)expression).getContainedExpression();
        }
        if (expression instanceof PyStringLiteralExpression && ((PyStringLiteralExpression)expression).isDocString()) {
            expression = elementGenerator.createStringLiteralAlreadyEscaped(result2.toString());
        }
        if (expression != null) {
            element.replace((PsiElement)expression);
        }
    }

    private static void appendSplittedRawStringLine(@NotNull StringBuilder result2, @NotNull PyUtil.StringNodeInfo info, @NotNull String line2) {
        if (result2 == null) {
            PyConvertTripleQuotedStringIntention.$$$reportNull$$$0(6);
        }
        if (info == null) {
            PyConvertTripleQuotedStringIntention.$$$reportNull$$$0(7);
        }
        if (line2 == null) {
            PyConvertTripleQuotedStringIntention.$$$reportNull$$$0(8);
        }
        boolean singleQuoteUsed = false;
        boolean doubleQuoteUsed = false;
        int chunkStart = 0;
        boolean firstChunk = true;
        for (int k = 0; k <= line2.length(); ++k) {
            char chunkQuote;
            if (k < line2.length()) {
                singleQuoteUsed |= line2.charAt(k) == '\'';
                doubleQuoteUsed |= line2.charAt(k) == '\"';
            }
            if ((k == line2.length() || line2.charAt(k) == '\'') && doubleQuoteUsed) {
                chunkQuote = '\'';
                doubleQuoteUsed = false;
            } else if ((k == line2.length() || line2.charAt(k) == '\"') && singleQuoteUsed) {
                chunkQuote = '\"';
                singleQuoteUsed = false;
            } else {
                if (k != line2.length()) continue;
                chunkQuote = info.getSingleQuote();
            }
            if (!firstChunk) {
                result2.append(" ");
            }
            result2.append(info.getPrefix()).append(chunkQuote).append(line2, chunkStart, k).append(chunkQuote);
            firstChunk = false;
            chunkStart = k;
        }
    }

    @NotNull
    private static String convertToValidSubString(@NotNull String content2, char newQuote, boolean isMultiline) {
        if (content2 == null) {
            PyConvertTripleQuotedStringIntention.$$$reportNull$$$0(9);
        }
        String string = isMultiline ? StringUtil.escapeChar((String)content2, (char)newQuote) : content2;
        if (string == null) {
            PyConvertTripleQuotedStringIntention.$$$reportNull$$$0(10);
        }
        return string;
    }

    @NotNull
    private static List<PyUtil.StringNodeInfo> extractStringNodesInfo(@NotNull PyStringLiteralExpression expression) {
        if (expression == null) {
            PyConvertTripleQuotedStringIntention.$$$reportNull$$$0(11);
        }
        List list = ContainerUtil.map(expression.getStringNodes(), node -> new PyUtil.StringNodeInfo((ASTNode)node));
        if (list == null) {
            PyConvertTripleQuotedStringIntention.$$$reportNull$$$0(12);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 11 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/codeInsight/intentions/PyConvertTripleQuotedStringIntention";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updater";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "line";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/codeInsight/intentions/PyConvertTripleQuotedStringIntention";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "convertToValidSubString";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "extractStringNodesInfo";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getPresentation";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "appendSplittedRawStringLine";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "convertToValidSubString";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "extractStringNodesInfo";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 11 -> new IllegalArgumentException(string);
        };
    }
}

