/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.console.pythonCommandQueue;

import com.intellij.icons.AllIcons;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.command.undo.UndoUtil;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.util.LexerEditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.impl.EditorFactoryImpl;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighterFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.ui.AnimatedIcon;
import com.intellij.ui.GotItTooltip;
import com.intellij.ui.JBColor;
import com.intellij.ui.JBSplitter;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.panels.VerticalLayout;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.console.PythonConsoleView;
import com.jetbrains.python.console.PythonDebugConsoleCommunication;
import com.jetbrains.python.console.actions.CommandQueueForPythonConsoleService;
import com.jetbrains.python.console.actions.ShowCommandQueueAction;
import com.jetbrains.python.console.pydev.ConsoleCommunication;
import com.jetbrains.python.console.pythonCommandQueue.QueueElementPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;

public final class PythonCommandQueuePanel
extends JPanel {
    private final JPanel myPanel;
    private final JBSplitter mySplitter;
    private final PythonConsoleView myConsole;
    private final GotItTooltip tooltip;
    private final EditorEx myQueueEditor;
    private final Map<ConsoleCommunication.ConsoleCodeFragment, QueueElementPanel> myQueueElementPanelMap;
    private final CommandQueueForPythonConsoleService myService;
    private QueueElementPanel selectedCommand;
    private ConsoleCommunication communication;
    private static final int PREFERED_WIDTH = 500;
    private static final int PREFERED_HEIGHT = 150;
    private static final int QUEUE_MINIMUM_WIDTH = 200;
    private static final int QUEUE_MINIMUM_HEIGHT = -1;
    private static final int BORDER_OFFSETS = 7;

    public PythonCommandQueuePanel(@NotNull PythonConsoleView console) {
        if (console == null) {
            PythonCommandQueuePanel.$$$reportNull$$$0(0);
        }
        this.myPanel = new JPanel();
        this.myQueueElementPanelMap = new ConcurrentHashMap<ConsoleCommunication.ConsoleCodeFragment, QueueElementPanel>();
        this.myService = (CommandQueueForPythonConsoleService)ApplicationManager.getApplication().getService(CommandQueueForPythonConsoleService.class);
        this.setLayout(new GridLayout());
        this.setBorder((Border)JBUI.Borders.empty());
        this.setPreferredSize(new Dimension(500, 150));
        this.myConsole = console;
        this.tooltip = new GotItTooltip(PyBundle.message("python.console.command.queue.got.it.tooltip.id", new Object[0]), PyBundle.message("python.console.command.queue.got.it.tooltip.text", new Object[0]), (Disposable)this.myConsole).withHeader(PyBundle.message("python.console.command.queue.got.it.tooltip.title", new Object[0]));
        this.mySplitter = new JBSplitter(true);
        this.mySplitter.setSplitterProportionKey(PyBundle.message("python.console.command.queue.add.title", this.getClass().getName()));
        this.mySplitter.setOrientation(false);
        this.mySplitter.setBackground(JBColor.background());
        JBScrollPane scrollPane = new JBScrollPane((Component)this.myPanel);
        this.mySplitter.setFirstComponent((JComponent)scrollPane);
        this.myQueueEditor = this.createEmptyEditor();
        this.mySplitter.setSecondComponent(this.myQueueEditor.getComponent());
        this.add((Component)this.mySplitter);
        this.myPanel.setLayout((LayoutManager)new VerticalLayout(0));
        this.myPanel.setBorder(JBUI.Borders.empty((int)7));
        this.myPanel.setBackground(JBColor.background());
        this.repaintAll();
    }

    public void addCommand(@NotNull ConsoleCommunication.ConsoleCodeFragment command) {
        if (command == null) {
            PythonCommandQueuePanel.$$$reportNull$$$0(1);
        }
        QueueElementPanel elementPanel = new QueueElementPanel(command, (Icon)(this.myService.isOneElement(this.communication) ? new AnimatedIcon.Default() : AllIcons.Nodes.EmptyNode));
        this.myQueueElementPanelMap.put(command, elementPanel);
        this.myPanel.add(elementPanel.getQueuePanel());
        if (this.myService.isOneElement(this.communication)) {
            elementPanel.unsetCancelButton();
            this.commandSelected(elementPanel);
        }
        if (this.myService.isTwoElement(this.communication)) {
            if (this.communication instanceof PythonDebugConsoleCommunication) {
                this.repaintAll();
                return;
            }
            if (!ApplicationManager.getApplication().isUnitTestMode()) {
                this.tooltip.show((JComponent)this.getActionButton(), GotItTooltip.BOTTOM_MIDDLE);
            }
        }
        this.repaintAll();
    }

    private void helperForRemove(@NotNull ConsoleCommunication.ConsoleCodeFragment command) {
        QueueElementPanel removedPanel;
        if (command == null) {
            PythonCommandQueuePanel.$$$reportNull$$$0(2);
        }
        if ((removedPanel = this.myQueueElementPanelMap.remove(command)) != null) {
            this.myPanel.remove(removedPanel.getQueuePanel());
        }
        if (!this.myQueueElementPanelMap.isEmpty()) {
            QueueElementPanel elementPanel;
            ConsoleCommunication.ConsoleCodeFragment firstCommand = this.myService.getFirstCommand(this.communication);
            if (firstCommand != null && (elementPanel = this.myQueueElementPanelMap.get(firstCommand)) != null) {
                elementPanel.setIcon((Icon)new AnimatedIcon.Default());
                elementPanel.unsetCancelButton();
                if (this.selectedCommand == removedPanel) {
                    this.commandSelected(elementPanel);
                }
            }
        } else {
            this.setTextToEditor("");
            this.selectedCommand = null;
        }
    }

    public void removeCommand(@NotNull ConsoleCommunication.ConsoleCodeFragment command) {
        if (command == null) {
            PythonCommandQueuePanel.$$$reportNull$$$0(3);
        }
        this.helperForRemove(command);
        this.repaintAll();
    }

    public void removeCommandByButton(@NotNull ConsoleCommunication.ConsoleCodeFragment command) {
        if (command == null) {
            PythonCommandQueuePanel.$$$reportNull$$$0(4);
        }
        this.myService.removeCommand(this.communication, command);
        this.helperForRemove(command);
        this.repaintAll();
    }

    public void removeAllCommands() {
        this.myQueueElementPanelMap.clear();
        this.myPanel.removeAll();
        if (this.selectedCommand != null) {
            this.setTextToEditor("");
            this.selectedCommand = null;
        }
        this.repaintAll();
    }

    private void repaintAll() {
        this.revalidate();
        this.repaint();
    }

    public void setCommunication(@NotNull ConsoleCommunication communication) {
        if (communication == null) {
            PythonCommandQueuePanel.$$$reportNull$$$0(5);
        }
        this.communication = communication;
    }

    void commandSelected(@NotNull QueueElementPanel elementPanel) {
        if (elementPanel == null) {
            PythonCommandQueuePanel.$$$reportNull$$$0(6);
        }
        if (this.selectedCommand != null) {
            this.selectedCommand.getQueuePanel().setBackground((Color)JBColor.lazy(UIUtil::getListBackground));
            this.selectedCommand.setTextColor();
            this.selectedCommand.setButtonColor();
        }
        this.selectedCommand = elementPanel;
        this.selectedCommand.selectPanel();
        this.setTextToEditor(Objects.requireNonNull(elementPanel.getText()));
        this.mySplitter.setSecondComponent(this.myQueueEditor.getComponent());
    }

    @NotNull
    public EditorEx getQueueEditor() {
        EditorEx editorEx = this.myQueueEditor;
        if (editorEx == null) {
            PythonCommandQueuePanel.$$$reportNull$$$0(7);
        }
        return editorEx;
    }

    private ActionButton getActionButton() {
        return (ActionButton)UIUtil.uiTraverser((Component)this.myConsole.getToolbar().getComponent()).filter(ActionButton.class).filter(button -> ShowCommandQueueAction.isCommandQueueIcon(button.getIcon())).first();
    }

    @NotNull
    private EditorEx createEmptyEditor() {
        EditorFactory editorFactory = EditorFactory.getInstance();
        Document document = ((EditorFactoryImpl)editorFactory).createDocument(false);
        UndoUtil.disableUndoFor((Document)document);
        return (EditorEx)this.createEditor();
    }

    @NotNull
    private Editor createEditor() {
        PsiFile consoleFile = this.myConsole.getFile();
        Language language = consoleFile.getLanguage();
        Project project2 = consoleFile.getProject();
        PsiFile psiFile = PsiFileFactory.getInstance((Project)project2).createFileFromText("a." + consoleFile.getFileType().getDefaultExtension(), language, (CharSequence)StringUtil.convertLineSeparators((String)StringUtil.trimEnd((String)"", (String)"\n")), false, true);
        VirtualFile virtualFile = psiFile.getViewProvider().getVirtualFile();
        if (virtualFile instanceof LightVirtualFile) {
            ((LightVirtualFile)virtualFile).setWritable(true);
        }
        Document document = Objects.requireNonNull(FileDocumentManager.getInstance().getDocument(virtualFile));
        EditorFactory editorFactory = EditorFactory.getInstance();
        EditorEx editor2 = (EditorEx)editorFactory.createViewer(document, project2);
        editor2.getSettings().setFoldingOutlineShown(false);
        editor2.getSettings().setLineMarkerAreaShown(false);
        editor2.getSettings().setIndentGuidesShown(false);
        SyntaxHighlighter highlighter = SyntaxHighlighterFactory.getSyntaxHighlighter((Language)language, (Project)project2, (VirtualFile)psiFile.getViewProvider().getVirtualFile());
        editor2.setHighlighter((EditorHighlighter)new LexerEditorHighlighter(highlighter, editor2.getColorsScheme()));
        EditorEx editorEx = editor2;
        if (editorEx == null) {
            PythonCommandQueuePanel.$$$reportNull$$$0(8);
        }
        return editorEx;
    }

    private void setTextToEditor(@NotNull String text) {
        if (text == null) {
            PythonCommandQueuePanel.$$$reportNull$$$0(9);
        }
        ApplicationManager.getApplication().executeOnPooledThread(() -> WriteCommandAction.writeCommandAction((Project)this.myConsole.getProject()).run(() -> this.myQueueEditor.getDocument().setText((CharSequence)text)));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "console";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "communication";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementPanel";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/console/pythonCommandQueue/PythonCommandQueuePanel";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/console/pythonCommandQueue/PythonCommandQueuePanel";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getQueueEditor";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "addCommand";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "helperForRemove";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "removeCommand";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "removeCommandByButton";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setCommunication";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "commandSelected";
                break;
            }
            case 7: 
            case 8: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setTextToEditor";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7, 8 -> new IllegalStateException(string);
        };
    }
}

