/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.options.OptDropdown;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.jetbrains.python.PyPsiBundle;
import com.jetbrains.python.PythonFileType;
import com.jetbrains.python.inspections.PyEncodingUtil;
import com.jetbrains.python.inspections.PyInspection;
import com.jetbrains.python.inspections.PyInspectionVisitor;
import com.jetbrains.python.inspections.quickfix.AddEncodingQuickFix;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.Arrays;
import java.util.function.Function;
import one.util.streamex.EntryStream;
import org.jetbrains.annotations.NotNull;

public final class PyMandatoryEncodingInspection
extends PyInspection {
    @NlsSafe
    public String myDefaultEncoding = "utf-8";
    public int myEncodingFormatIndex = 0;
    public boolean myAllPythons = false;

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            PyMandatoryEncodingInspection.$$$reportNull$$$0(0);
        }
        if (session == null) {
            PyMandatoryEncodingInspection.$$$reportNull$$$0(1);
        }
        return new Visitor(holder, PyInspectionVisitor.getContext(session));
    }

    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.checkbox((String)"myAllPythons", (String)PyPsiBundle.message("INSP.mandatory.encoding.checkbox.enable.in.python.3", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0]), PyMandatoryEncodingInspection.defaultEncodingDropDown(), PyMandatoryEncodingInspection.encodingFormatDropDown()});
        if (optPane == null) {
            PyMandatoryEncodingInspection.$$$reportNull$$$0(2);
        }
        return optPane;
    }

    @NotNull
    static OptDropdown defaultEncodingDropDown() {
        OptDropdown optDropdown = OptPane.dropdown((String)"myDefaultEncoding", (String)PyPsiBundle.message("INSP.mandatory.encoding.label.select.default.encoding", new Object[0]), Arrays.asList(PyEncodingUtil.POSSIBLE_ENCODINGS), Function.identity(), Function.identity());
        if (optDropdown == null) {
            PyMandatoryEncodingInspection.$$$reportNull$$$0(3);
        }
        return optDropdown;
    }

    @NotNull
    static OptDropdown encodingFormatDropDown() {
        OptDropdown optDropdown = OptPane.dropdown((String)"myEncodingFormatIndex", (String)PyPsiBundle.message("INSP.mandatory.encoding.label.encoding.comment.format", new Object[0]), (OptDropdown.Option[])((OptDropdown.Option[])EntryStream.of((Object[])PyEncodingUtil.ENCODING_FORMAT).mapKeyValue((idx, format) -> OptPane.option((String)String.valueOf(idx), (String)format)).toArray(OptDropdown.Option.class)));
        if (optDropdown == null) {
            PyMandatoryEncodingInspection.$$$reportNull$$$0(4);
        }
        return optDropdown;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/inspections/PyMandatoryEncodingInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/inspections/PyMandatoryEncodingInspection";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "defaultEncodingDropDown";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "encodingFormatDropDown";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4 -> new IllegalStateException(string);
        };
    }

    private class Visitor
    extends PyInspectionVisitor {
        Visitor(@NotNull ProblemsHolder holder, TypeEvalContext context) {
            if (context == null) {
                Visitor.$$$reportNull$$$0(0);
            }
            super(holder, context);
        }

        @Override
        public void visitPyFile(@NotNull PyFile node) {
            if (node == null) {
                Visitor.$$$reportNull$$$0(1);
            }
            if (!PyMandatoryEncodingInspection.this.myAllPythons && !LanguageLevel.forElement((PsiElement)node).isPython2()) {
                return;
            }
            String charsetString = PythonFileType.getCharsetFromEncodingDeclaration(node);
            if (charsetString == null) {
                TextRange tr = new TextRange(0, 0);
                ProblemsHolder holder = this.getHolder();
                if (holder != null) {
                    holder.registerProblem((PsiElement)node, tr, PyPsiBundle.message("INSP.mandatory.encoding.no.encoding.specified.for.file", new Object[0]), new LocalQuickFix[]{new AddEncodingQuickFix(PyMandatoryEncodingInspection.this.myDefaultEncoding, PyMandatoryEncodingInspection.this.myEncodingFormatIndex)});
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/python/inspections/PyMandatoryEncodingInspection$Visitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitPyFile";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

