/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections.quickfix;

import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.codeInsight.imports.AddImportHelper;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyImportStatementBase;
import org.jetbrains.annotations.NotNull;

public class PyAddImportFix
extends PsiUpdateModCommandQuickFix {
    @NotNull
    private final String myImportToAdd;

    public PyAddImportFix(@NotNull String importToAdd) {
        if (importToAdd == null) {
            PyAddImportFix.$$$reportNull$$$0(0);
        }
        this.myImportToAdd = importToAdd;
    }

    @NotNull
    public String getFamilyName() {
        String string = PyBundle.message("QFIX.add.import.add.import", this.myImportToAdd);
        if (string == null) {
            PyAddImportFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    public void applyFix(@NotNull Project project2, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
        if (project2 == null) {
            PyAddImportFix.$$$reportNull$$$0(2);
        }
        if (element == null) {
            PyAddImportFix.$$$reportNull$$$0(3);
        }
        if (updater == null) {
            PyAddImportFix.$$$reportNull$$$0(4);
        }
        PyElementGenerator generator = PyElementGenerator.getInstance(project2);
        PsiFile file = element.getContainingFile();
        PyImportStatementBase statement = generator.createFromText(LanguageLevel.forElement((PsiElement)file), PyImportStatementBase.class, this.myImportToAdd);
        PsiElement recommendedPosition = AddImportHelper.getFileInsertPosition(file);
        file.addAfter((PsiElement)statement, recommendedPosition);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importToAdd";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/inspections/quickfix/PyAddImportFix";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updater";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/inspections/quickfix/PyAddImportFix";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

