/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.packaging.ui;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import com.intellij.execution.ExecutionException;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.DumbAwareToggleAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.webcore.packaging.InstalledPackage;
import com.intellij.webcore.packaging.InstalledPackagesPanel;
import com.intellij.webcore.packaging.PackageManagementService;
import com.intellij.webcore.packaging.PackagesNotificationPanel;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.PySdkBundle;
import com.jetbrains.python.icons.PythonIcons;
import com.jetbrains.python.packaging.PyExecutionException;
import com.jetbrains.python.packaging.PyExecutionFix;
import com.jetbrains.python.packaging.PyPackage;
import com.jetbrains.python.packaging.PyPackageManager;
import com.jetbrains.python.packaging.PyPackageManagerUI;
import com.jetbrains.python.packaging.PyPackageManagers;
import com.jetbrains.python.packaging.PyPackageUtil;
import com.jetbrains.python.packaging.PyPackagesNotificationPanel;
import com.jetbrains.python.packaging.PyPackagingSettings;
import com.jetbrains.python.packaging.bridge.PythonPackageManagementServiceBridge;
import com.jetbrains.python.packaging.ui.PyPackageManagementService;
import com.jetbrains.python.sdk.PySdkExtKt;
import com.jetbrains.python.sdk.PythonSdkUtil;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyInstalledPackagesPanel
extends InstalledPackagesPanel {
    private volatile boolean myHasManagement;

    public PyInstalledPackagesPanel(@NotNull Project project2, @NotNull PackagesNotificationPanel area) {
        if (project2 == null) {
            PyInstalledPackagesPanel.$$$reportNull$$$0(0);
        }
        if (area == null) {
            PyInstalledPackagesPanel.$$$reportNull$$$0(1);
        }
        super(project2, area);
        this.myHasManagement = false;
    }

    public void setShowGrid(boolean v) {
        this.myPackagesTable.setShowGrid(v);
    }

    private Sdk getSelectedSdk() {
        PyPackageManagementService service = (PyPackageManagementService)this.myPackageManagementService;
        return service != null ? service.getSdk() : null;
    }

    public void updateNotifications(@Nullable Sdk selectedSdk) {
        if (selectedSdk == null) {
            this.myNotificationArea.hide();
            return;
        }
        Application application = ApplicationManager.getApplication();
        application.executeOnPooledThread(() -> {
            PyExecutionException exception = null;
            try {
                this.myHasManagement = PyPackageManager.getInstance(selectedSdk).hasManagement();
                application.invokeLater(() -> this.updateUninstallUpgrade(), ModalityState.any());
                if (!this.myHasManagement) {
                    throw new PyExecutionException(PySdkBundle.message("python.sdk.packaging.tools.not.found", new Object[0]), "pip", Collections.emptyList(), "", "", 0, (List<? extends PyExecutionFix>)ImmutableList.of((Object)new PyInstallPackageManagementFix()));
                }
            }
            catch (PyExecutionException e) {
                exception = e;
            }
            catch (ExecutionException e) {
                return;
            }
            PyExecutionException problem = exception;
            application.invokeLater(() -> {
                if (selectedSdk == this.getSelectedSdk()) {
                    this.myNotificationArea.hide();
                    if (problem != null) {
                        boolean invalid;
                        boolean bl = invalid = !PySdkExtKt.getSdkSeemsValid(selectedSdk);
                        if (!invalid) {
                            HtmlBuilder builder = new HtmlBuilder();
                            builder.append(problem.getMessage()).append(". ");
                            for (PyExecutionFix pyExecutionFix : problem.getFixes()) {
                                String key = "id" + pyExecutionFix.hashCode();
                                builder.appendLink(key, pyExecutionFix.getName());
                                builder.append(" ");
                                this.myNotificationArea.addLinkHandler(key, () -> {
                                    Sdk sdk2 = this.getSelectedSdk();
                                    if (sdk2 != null) {
                                        fix.run(sdk2);
                                        this.myNotificationArea.removeLinkHandler(key);
                                        this.updatePackages(PyPackageManagers.getInstance().getManagementService(this.myProject, sdk2));
                                        this.updateNotifications(sdk2);
                                    }
                                });
                            }
                            this.myNotificationArea.showWarning(builder.toString());
                        }
                        this.myInstallEnabled = !invalid && this.installEnabled();
                    }
                }
            }, ModalityState.any());
        });
    }

    protected Set<String> getPackagesToPostpone() {
        return Sets.newHashSet((Object[])new String[]{"pip", "distutils", "setuptools"});
    }

    protected boolean canUninstallPackage(InstalledPackage pkg) {
        String location;
        if (!this.myHasManagement) {
            return false;
        }
        Sdk sdk2 = this.getSelectedSdk();
        if (sdk2 == null) {
            return false;
        }
        if (!PyPackageUtil.packageManagementEnabled(sdk2, false, false)) {
            return false;
        }
        if (PythonSdkUtil.isVirtualEnv(sdk2) && pkg instanceof PyPackage && (location = ((PyPackage)pkg).getLocation()) != null && location.startsWith(PythonSdkUtil.getUserSite())) {
            return false;
        }
        String name2 = pkg.getName();
        return !"pip".equals(name2) && !"setuptools".equals(name2) && !"distribute".equals(name2) && !"python".equals(name2);
    }

    protected boolean canInstallPackage(@NotNull InstalledPackage pyPackage) {
        if (pyPackage == null) {
            PyInstalledPackagesPanel.$$$reportNull$$$0(2);
        }
        return this.installEnabled();
    }

    protected boolean installEnabled() {
        if (!PyPackageUtil.packageManagementEnabled(this.getSelectedSdk(), false, false)) {
            return false;
        }
        return this.myHasManagement;
    }

    protected boolean canUpgradePackage(InstalledPackage pyPackage) {
        if (!PyPackageUtil.packageManagementEnabled(this.getSelectedSdk(), false, false)) {
            return false;
        }
        return this.myHasManagement && !"python".equals(pyPackage.getName());
    }

    protected AnAction @NotNull [] getExtraActions() {
        DumbAwareToggleAction useCondaButton = new DumbAwareToggleAction(PyBundle.messagePointer("action.AnActionButton.text.use.conda.package.manager", new Object[0]), Presentation.NULL_STRING, PythonIcons.Python.Anaconda){

            public boolean isSelected(@NotNull AnActionEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                Sdk sdk2 = PyInstalledPackagesPanel.this.getSelectedSdk();
                PackageManagementService packageManagementService = PyInstalledPackagesPanel.this.myPackageManagementService;
                if (packageManagementService instanceof PythonPackageManagementServiceBridge) {
                    PythonPackageManagementServiceBridge bridge = (PythonPackageManagementServiceBridge)packageManagementService;
                    return sdk2 != null && bridge.isConda() && bridge.getUseConda();
                }
                return false;
            }

            public void setSelected(AnActionEvent e, boolean state2) {
                PackageManagementService packageManagementService;
                Sdk sdk2 = PyInstalledPackagesPanel.this.getSelectedSdk();
                if (sdk2 == null || !((packageManagementService = PyInstalledPackagesPanel.this.myPackageManagementService) instanceof PythonPackageManagementServiceBridge)) {
                    return;
                }
                PythonPackageManagementServiceBridge bridge = (PythonPackageManagementServiceBridge)packageManagementService;
                if (bridge.isConda()) {
                    bridge.setUseConda(state2);
                }
                PyInstalledPackagesPanel.this.updatePackages(PyInstalledPackagesPanel.this.myPackageManagementService);
            }

            public void update(@NotNull AnActionEvent e) {
                PythonPackageManagementServiceBridge bridge;
                PackageManagementService packageManagementService;
                if (e == null) {
                    1.$$$reportNull$$$0(1);
                }
                super.update(e);
                Sdk sdk2 = PyInstalledPackagesPanel.this.getSelectedSdk();
                e.getPresentation().setVisible(sdk2 != null && (packageManagementService = PyInstalledPackagesPanel.this.myPackageManagementService) instanceof PythonPackageManagementServiceBridge && (bridge = (PythonPackageManagementServiceBridge)packageManagementService).isConda());
            }

            @NotNull
            public ActionUpdateThread getActionUpdateThread() {
                ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
                if (actionUpdateThread == null) {
                    1.$$$reportNull$$$0(2);
                }
                return actionUpdateThread;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 2 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "e";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/python/packaging/ui/PyInstalledPackagesPanel$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/python/packaging/ui/PyInstalledPackagesPanel$1";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getActionUpdateThread";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "isSelected";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "update";
                        break;
                    }
                    case 2: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 2 -> new IllegalStateException(string);
                };
            }
        };
        DumbAwareToggleAction showEarlyReleasesButton = new DumbAwareToggleAction(PyBundle.messagePointer("action.AnActionButton.text.show.early.releases", new Object[0]), Presentation.NULL_STRING, AllIcons.Actions.Show){

            public boolean isSelected(@NotNull AnActionEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                return PyPackagingSettings.getInstance((Project)((PyInstalledPackagesPanel)PyInstalledPackagesPanel.this).myProject).earlyReleasesAsUpgrades;
            }

            public void setSelected(@NotNull AnActionEvent e, boolean state2) {
                if (e == null) {
                    2.$$$reportNull$$$0(1);
                }
                PyPackagingSettings.getInstance((Project)((PyInstalledPackagesPanel)PyInstalledPackagesPanel.this).myProject).earlyReleasesAsUpgrades = state2;
                PyInstalledPackagesPanel.this.updatePackages(PyInstalledPackagesPanel.this.myPackageManagementService);
            }

            @NotNull
            public ActionUpdateThread getActionUpdateThread() {
                ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
                if (actionUpdateThread == null) {
                    2.$$$reportNull$$$0(2);
                }
                return actionUpdateThread;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 2 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "e";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/python/packaging/ui/PyInstalledPackagesPanel$2";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/python/packaging/ui/PyInstalledPackagesPanel$2";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getActionUpdateThread";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "isSelected";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "setSelected";
                        break;
                    }
                    case 2: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 2 -> new IllegalStateException(string);
                };
            }
        };
        AnAction[] anActionArray = new AnAction[]{useCondaButton, showEarlyReleasesButton};
        if (anActionArray == null) {
            PyInstalledPackagesPanel.$$$reportNull$$$0(3);
        }
        return anActionArray;
    }

    @NotNull
    protected PackagesNotificationPanel createNotificationPanel() {
        return new PyPackagesNotificationPanel();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "area";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pyPackage";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/packaging/ui/PyInstalledPackagesPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/packaging/ui/PyInstalledPackagesPanel";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtraActions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "canInstallPackage";
                break;
            }
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }

    class PyInstallPackageManagementFix
    implements PyExecutionFix {
        PyInstallPackageManagementFix() {
        }

        @Override
        @NotNull
        public String getName() {
            String string = PyBundle.message("python.packaging.install.packaging.tools", new Object[0]);
            if (string == null) {
                PyInstallPackageManagementFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        public void run(final @NotNull Sdk sdk2) {
            if (sdk2 == null) {
                PyInstallPackageManagementFix.$$$reportNull$$$0(1);
            }
            PyPackageManagerUI ui2 = new PyPackageManagerUI(PyInstalledPackagesPanel.this.myProject, sdk2, new PyPackageManagerUI.Listener(){

                @Override
                public void started() {
                    PyInstalledPackagesPanel.this.myPackagesTable.setPaintBusy(true);
                }

                @Override
                public void finished(List<ExecutionException> exceptions) {
                    PyInstalledPackagesPanel.this.myPackagesTable.setPaintBusy(false);
                    PyPackageManager packageManager = PyPackageManager.getInstance(sdk2);
                    PyPackageManagementService.PyPackageInstallationErrorDescription description = PyPackageManagementService.toErrorDescription(exceptions, sdk2, "packaging tools");
                    if (description != null) {
                        PyPackagesNotificationPanel.showPackageInstallationError(PyBundle.message("python.packaging.failed.to.install.packaging.tools.title", new Object[0]), description);
                    }
                    packageManager.refresh();
                    PyInstalledPackagesPanel.this.updatePackages(PyPackageManagers.getInstance().getManagementService(PyInstalledPackagesPanel.this.myProject, sdk2));
                    PyInstalledPackagesPanel.this.updateNotifications(sdk2);
                }
            });
            ui2.installManagement();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/packaging/ui/PyInstalledPackagesPanel$PyInstallPackageManagementFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sdk";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/packaging/ui/PyInstalledPackagesPanel$PyInstallPackageManagementFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "run";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1 -> new IllegalArgumentException(string);
            };
        }
    }
}

