/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.impl;

import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiListLikeElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.DelegatingScopeProcessor;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.QualifiedName;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.PyElementTypes;
import com.jetbrains.python.PyStubElementTypes;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyElementType;
import com.jetbrains.python.psi.PyElementVisitor;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFromImportStatement;
import com.jetbrains.python.psi.PyImportElement;
import com.jetbrains.python.psi.PyStarImportElement;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PyBaseElementImpl;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import com.jetbrains.python.psi.impl.ResolveResultList;
import com.jetbrains.python.psi.resolve.RatedResolveResult;
import com.jetbrains.python.psi.resolve.ResolveImportUtil;
import com.jetbrains.python.psi.stubs.PyFromImportStatementStub;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyFromImportStatementImpl
extends PyBaseElementImpl<PyFromImportStatementStub>
implements PyFromImportStatement,
PsiListLikeElement {
    public PyFromImportStatementImpl(ASTNode astNode) {
        super(astNode);
    }

    public PyFromImportStatementImpl(PyFromImportStatementStub stub) {
        this(stub, (IStubElementType)PyStubElementTypes.FROM_IMPORT_STATEMENT);
    }

    public PyFromImportStatementImpl(PyFromImportStatementStub stub, IStubElementType nodeType) {
        super(stub, nodeType);
    }

    @Override
    protected void acceptPyVisitor(PyElementVisitor pyVisitor) {
        pyVisitor.visitPyFromImportStatement(this);
    }

    @Override
    public QualifiedName getImportSourceQName() {
        PyFromImportStatementStub stub = (PyFromImportStatementStub)this.getStub();
        if (stub != null) {
            QualifiedName qName = stub.getImportSourceQName();
            if (qName != null && qName.getComponentCount() == 0) {
                return null;
            }
            return qName;
        }
        return PyFromImportStatement.super.getImportSourceQName();
    }

    @Override
    public PyImportElement @NotNull [] getImportElements() {
        return this.getImportElements(PyElementTypes.IMPORT_ELEMENT, PyTokenTypes.IMPORT_KEYWORD);
    }

    protected final PyImportElement @NotNull [] getImportElements(@NotNull IElementType importElementType, @NotNull PyElementType importKeywordToken) {
        PyFromImportStatementStub stub;
        if (importElementType == null) {
            PyFromImportStatementImpl.$$$reportNull$$$0(0);
        }
        if (importKeywordToken == null) {
            PyFromImportStatementImpl.$$$reportNull$$$0(1);
        }
        if ((stub = (PyFromImportStatementStub)this.getStub()) != null) {
            PyImportElement[] pyImportElementArray = (PyImportElement[])stub.getChildrenByType(importElementType, PyImportElement[]::new);
            if (pyImportElementArray == null) {
                PyFromImportStatementImpl.$$$reportNull$$$0(2);
            }
            return pyImportElementArray;
        }
        ArrayList<PyImportElement> result2 = new ArrayList<PyImportElement>();
        ASTNode importKeyword = this.getNode().findChildByType((IElementType)importKeywordToken);
        if (importKeyword != null) {
            for (ASTNode node = importKeyword.getTreeNext(); node != null; node = node.getTreeNext()) {
                if (node.getElementType() != importElementType) continue;
                result2.add((PyImportElement)node.getPsi());
            }
        }
        PyImportElement[] pyImportElementArray = result2.toArray(new PyImportElement[0]);
        if (pyImportElementArray == null) {
            PyFromImportStatementImpl.$$$reportNull$$$0(3);
        }
        return pyImportElementArray;
    }

    @Override
    public int getRelativeLevel() {
        PyFromImportStatementStub stub = (PyFromImportStatementStub)this.getStub();
        if (stub != null) {
            return stub.getRelativeLevel();
        }
        return PyFromImportStatement.super.getRelativeLevel();
    }

    public boolean processDeclarations(@NotNull PsiScopeProcessor processor2, @NotNull ResolveState state2, PsiElement lastParent, @NotNull PsiElement place) {
        if (processor2 == null) {
            PyFromImportStatementImpl.$$$reportNull$$$0(4);
        }
        if (state2 == null) {
            PyFromImportStatementImpl.$$$reportNull$$$0(5);
        }
        if (place == null) {
            PyFromImportStatementImpl.$$$reportNull$$$0(6);
        }
        if (place.getContainingFile() != this.getContainingFile()) {
            return true;
        }
        if (this.isStarImport()) {
            List<PsiElement> targets = ResolveImportUtil.resolveFromImportStatementSource(this, this.getImportSourceQName());
            for (PsiElement target : targets) {
                DelegatingScopeProcessor starImportableNamesProcessor;
                final PsiElement importedFile = PyUtil.turnDirIntoInit(target);
                if (importedFile == null || importedFile.processDeclarations((PsiScopeProcessor)(starImportableNamesProcessor = new DelegatingScopeProcessor(processor2){

                    public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state2) {
                        if (element == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        if (state2 == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        if (element instanceof PyElement && importedFile instanceof PyFile && !PyUtil.isStarImportableFrom(StringUtil.notNullize((String)((PyElement)element).getName()), (PyFile)importedFile)) {
                            return true;
                        }
                        return super.execute(element, state2);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2 = new Object[3];
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[0] = "element";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[0] = "state";
                                break;
                            }
                        }
                        objectArray[1] = "com/jetbrains/python/psi/impl/PyFromImportStatementImpl$1";
                        objectArray[2] = "execute";
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                }), state2, null, place)) continue;
                return false;
            }
        } else {
            PyImportElement[] importElements;
            for (PyImportElement element : importElements = this.getImportElements()) {
                if (processor2.execute((PsiElement)element, state2)) continue;
                return false;
            }
        }
        return true;
    }

    public ASTNode addInternal(ASTNode first, ASTNode last, ASTNode anchor, Boolean before) {
        PyImportElement[] elements;
        boolean addingNewName;
        boolean bl = addingNewName = first == last && first.getElementType() == PyElementTypes.IMPORT_ELEMENT && (anchor == null || anchor.getElementType() == PyElementTypes.IMPORT_ELEMENT);
        if (!addingNewName) {
            return super.addInternal(first, last, anchor, before);
        }
        if (anchor == null && (elements = this.getImportElements()).length != 0) {
            if (before.booleanValue()) {
                anchor = elements[elements.length - 1].getNode();
                before = false;
            } else {
                anchor = elements[0].getNode();
                before = true;
            }
        }
        if (anchor != null && anchor.getTextLength() == 0) {
            this.getNode().replaceChild(anchor, first);
            return first;
        }
        ASTNode result2 = super.addInternal(first, last, anchor, before);
        if (anchor != null && anchor.getElementType() == PyElementTypes.IMPORT_ELEMENT && result2.getElementType() == PyElementTypes.IMPORT_ELEMENT) {
            ASTNode comma = PyElementGenerator.getInstance(this.getProject()).createComma();
            super.addInternal(comma, comma, before != false ? result2 : anchor, Boolean.valueOf(false));
        }
        return result2;
    }

    public void deleteChildInternal(@NotNull ASTNode child) {
        if (child == null) {
            PyFromImportStatementImpl.$$$reportNull$$$0(7);
        }
        if (ArrayUtil.contains((Object)child.getPsi(), (Object[])this.getImportElements())) {
            PyPsiUtils.deleteAdjacentCommaWithWhitespaces((PsiElement)this, child.getPsi());
        }
        super.deleteChildInternal(child);
    }

    @Override
    @Nullable
    public PyStarImportElement getStarImportElement() {
        return (PyStarImportElement)this.getStubOrPsiChild(PyStubElementTypes.STAR_IMPORT_ELEMENT);
    }

    @Override
    @Nullable
    public PsiFileSystemItem resolveImportSource() {
        return (PsiFileSystemItem)FluentIterable.from(this.resolveImportSourceCandidates()).filter(PsiFileSystemItem.class).first().orNull();
    }

    @Override
    @NotNull
    public List<PsiElement> resolveImportSourceCandidates() {
        int level;
        QualifiedName qName = this.getImportSourceQName();
        if (qName == null && (level = this.getRelativeLevel()) > 0) {
            PsiDirectory upper = ResolveImportUtil.stepBackFrom(this.getContainingFile().getOriginalFile(), level);
            List list = ContainerUtil.createMaybeSingletonList((Object)upper);
            if (list == null) {
                PyFromImportStatementImpl.$$$reportNull$$$0(8);
            }
            return list;
        }
        List<PsiElement> list = ResolveImportUtil.resolveFromImportStatementSource(this, qName);
        if (list == null) {
            PyFromImportStatementImpl.$$$reportNull$$$0(9);
        }
        return list;
    }

    @Override
    @NotNull
    public Iterable<PyElement> iterateNames() {
        PyElement resolved = PyUtil.as(this.resolveImplicitSubModule(), PyElement.class);
        ImmutableList immutableList = resolved != null ? ImmutableList.of((Object)resolved) : Collections.emptyList();
        if (immutableList == null) {
            PyFromImportStatementImpl.$$$reportNull$$$0(10);
        }
        return immutableList;
    }

    @Override
    @NotNull
    public List<RatedResolveResult> multiResolveName(@NotNull String name2) {
        PsiElement element;
        QualifiedName importSourceQName;
        if (name2 == null) {
            PyFromImportStatementImpl.$$$reportNull$$$0(11);
        }
        if ((importSourceQName = this.getImportSourceQName()) != null && importSourceQName.endsWith(name2) && (element = this.resolveImplicitSubModule()) != null) {
            List<RatedResolveResult> list = ResolveResultList.to(element);
            if (list == null) {
                PyFromImportStatementImpl.$$$reportNull$$$0(12);
            }
            return list;
        }
        List<RatedResolveResult> list = Collections.emptyList();
        if (list == null) {
            PyFromImportStatementImpl.$$$reportNull$$$0(13);
        }
        return list;
    }

    @Nullable
    private PsiElement resolveImplicitSubModule() {
        QualifiedName importSourceQName = this.getImportSourceQName();
        if (importSourceQName != null) {
            PsiElement resolvedImportSource;
            String name2 = importSourceQName.getLastComponent();
            PsiFile file = this.getContainingFile();
            if (name2 != null && PyUtil.isPackage(file) && (resolvedImportSource = PyUtil.turnInitIntoDir((PsiElement)this.resolveImportSource())) != null && resolvedImportSource.getParent() == file.getContainingDirectory()) {
                return resolvedImportSource;
            }
        }
        return null;
    }

    @NotNull
    public List<? extends PsiElement> getComponents() {
        List<PyImportElement> list = Arrays.asList(this.getImportElements());
        if (list == null) {
            PyFromImportStatementImpl.$$$reportNull$$$0(14);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 8, 9, 10, 12, 13, 14 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importElementType";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importKeywordToken";
                break;
            }
            case 2: 
            case 3: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/psi/impl/PyFromImportStatementImpl";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/psi/impl/PyFromImportStatementImpl";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getImportElements";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveImportSourceCandidates";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "iterateNames";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "multiResolveName";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponents";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getImportElements";
                break;
            }
            case 2: 
            case 3: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: {
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "processDeclarations";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "deleteChildInternal";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "multiResolveName";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 8, 9, 10, 12, 13, 14 -> new IllegalStateException(string);
        };
    }
}

