/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.refactoring.introduce.field;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.introduce.inplace.InplaceVariableIntroducer;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.ast.PyAstFunction;
import com.jetbrains.python.codeInsight.controlflow.ScopeOwner;
import com.jetbrains.python.codeInsight.dataflow.scope.ScopeUtil;
import com.jetbrains.python.inspections.quickfix.AddFieldQuickFix;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyAssignmentStatement;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyDecoratorList;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyParameter;
import com.jetbrains.python.psi.PyQualifiedExpression;
import com.jetbrains.python.psi.PyRecursiveElementVisitor;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyStatement;
import com.jetbrains.python.psi.PyStatementList;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PyFunctionBuilder;
import com.jetbrains.python.psi.types.TypeEvalContext;
import com.jetbrains.python.refactoring.PyReplaceExpressionUtil;
import com.jetbrains.python.refactoring.introduce.IntroduceHandler;
import com.jetbrains.python.refactoring.introduce.IntroduceOperation;
import com.jetbrains.python.refactoring.introduce.field.IntroduceFieldValidator;
import com.jetbrains.python.refactoring.introduce.field.PyIntroduceFieldPanel;
import com.jetbrains.python.refactoring.introduce.variable.PyIntroduceVariableHandler;
import com.jetbrains.python.testing.PythonUnitTestDetectorsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.function.Function;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyIntroduceFieldHandler
extends IntroduceHandler {
    public PyIntroduceFieldHandler() {
        super(new IntroduceFieldValidator(), RefactoringBundle.message((String)"introduce.field.title"));
    }

    @Override
    public void invoke(@NotNull Project project2, Editor editor2, PsiFile file, DataContext dataContext) {
        if (project2 == null) {
            PyIntroduceFieldHandler.$$$reportNull$$$0(0);
        }
        IntroduceOperation operation = new IntroduceOperation(project2, editor2, file, null);
        operation.addAvailableInitPlace(IntroduceHandler.InitPlace.CONSTRUCTOR);
        if (PyIntroduceFieldHandler.isTestClass(file, editor2)) {
            operation.addAvailableInitPlace(IntroduceHandler.InitPlace.SET_UP);
        }
        this.performAction(operation);
    }

    private static boolean isTestClass(@NotNull PsiFile file, Editor editor2) {
        PyClass clazz;
        if (file == null) {
            PyIntroduceFieldHandler.$$$reportNull$$$0(1);
        }
        PsiElement element1 = null;
        SelectionModel selectionModel = editor2.getSelectionModel();
        if (selectionModel.hasSelection()) {
            element1 = file.findElementAt(selectionModel.getSelectionStart());
        } else {
            CaretModel caretModel = editor2.getCaretModel();
            Document document = editor2.getDocument();
            int lineNumber = document.getLineNumber(caretModel.getOffset());
            if (lineNumber >= 0 && lineNumber < document.getLineCount()) {
                element1 = file.findElementAt(document.getLineStartOffset(lineNumber));
            }
        }
        return element1 != null && (clazz = PyUtil.getContainingClassOrSelf(element1)) != null && PythonUnitTestDetectorsKt.isTestClass(clazz, TypeEvalContext.userInitiated(file.getProject(), file));
    }

    @Override
    protected PsiElement replaceExpression(PsiElement expression, PyExpression newExpression, IntroduceOperation operation) {
        if (operation.getInitPlace() != IntroduceHandler.InitPlace.SAME_METHOD) {
            return PyReplaceExpressionUtil.replaceExpression(expression, (PsiElement)newExpression);
        }
        return super.replaceExpression(expression, newExpression, operation);
    }

    @Override
    protected boolean checkEnabled(IntroduceOperation operation) {
        if (PyUtil.getContainingClassOrSelf(operation.getElement()) == null) {
            CommonRefactoringUtil.showErrorHint((Project)operation.getProject(), (Editor)operation.getEditor(), (String)PyBundle.message("refactoring.introduce.field.not.in.class", new Object[0]), (String)this.myDialogTitle, (String)this.getHelpId());
            return false;
        }
        if (PyIntroduceFieldHandler.dependsOnLocalScopeValues(operation.getElement())) {
            operation.removeAvailableInitPlace(IntroduceHandler.InitPlace.CONSTRUCTOR);
            operation.removeAvailableInitPlace(IntroduceHandler.InitPlace.SET_UP);
        }
        return true;
    }

    private static boolean dependsOnLocalScopeValues(PsiElement initializer) {
        ScopeOwner scope = (ScopeOwner)PsiTreeUtil.getParentOfType((PsiElement)initializer, ScopeOwner.class);
        ResolvingVisitor visitor2 = new ResolvingVisitor(scope);
        initializer.accept((PsiElementVisitor)visitor2);
        return visitor2.hasLocalScopeDependencies;
    }

    @Override
    @Nullable
    protected PsiElement addDeclaration(@NotNull PsiElement expression, @NotNull PsiElement declaration, @NotNull IntroduceOperation operation) {
        if (expression == null) {
            PyIntroduceFieldHandler.$$$reportNull$$$0(2);
        }
        if (declaration == null) {
            PyIntroduceFieldHandler.$$$reportNull$$$0(3);
        }
        if (operation == null) {
            PyIntroduceFieldHandler.$$$reportNull$$$0(4);
        }
        PsiElement expr = expression instanceof PyClass ? expression : expression.getParent();
        PyClass clazz = PyUtil.getContainingClassOrSelf(expr);
        assert (clazz != null);
        Project project2 = clazz.getProject();
        if (operation.getInitPlace() == IntroduceHandler.InitPlace.CONSTRUCTOR && !PyIntroduceFieldHandler.inConstructor(expression)) {
            return AddFieldQuickFix.addFieldToInit(project2, clazz, "", new AddFieldDeclaration(declaration));
        }
        if (operation.getInitPlace() == IntroduceHandler.InitPlace.SET_UP) {
            return PyIntroduceFieldHandler.addFieldToSetUp(clazz, new AddFieldDeclaration(declaration));
        }
        return PyIntroduceVariableHandler.doIntroduceVariable(expression, declaration, operation.getOccurrences(), operation.isReplaceAll());
    }

    private static boolean inConstructor(@NotNull PsiElement expression) {
        PyFunction init2;
        if (expression == null) {
            PyIntroduceFieldHandler.$$$reportNull$$$0(5);
        }
        PsiElement expr = expression instanceof PyClass ? expression : expression.getParent();
        PyClass clazz = PyUtil.getContainingClassOrSelf(expr);
        ScopeOwner current = ScopeUtil.getScopeOwner(expression);
        return clazz != null && current instanceof PyFunction && current == (init2 = clazz.findMethodByName("__init__", false, null));
    }

    @NotNull
    private static PsiElement addFieldToSetUp(PyClass clazz, Function<String, PyStatement> callback) {
        PyFunction init2 = clazz.findMethodByName("setUp", false, null);
        if (init2 != null) {
            PsiElement psiElement = AddFieldQuickFix.appendToMethod(init2, callback);
            if (psiElement == null) {
                PyIntroduceFieldHandler.$$$reportNull$$$0(6);
            }
            return psiElement;
        }
        PyFunctionBuilder builder = new PyFunctionBuilder("setUp", clazz);
        builder.parameter("self");
        PyFunction setUp = builder.buildFunction();
        PyStatementList statements = clazz.getStatementList();
        PsiElement anchor = statements.getFirstChild();
        setUp = (PyFunction)statements.addBefore(setUp, anchor);
        PsiElement psiElement = AddFieldQuickFix.appendToMethod(setUp, callback);
        if (psiElement == null) {
            PyIntroduceFieldHandler.$$$reportNull$$$0(7);
        }
        return psiElement;
    }

    @Override
    protected List<PsiElement> getOccurrences(PsiElement element, @NotNull PyExpression expression) {
        if (expression == null) {
            PyIntroduceFieldHandler.$$$reportNull$$$0(8);
        }
        if (PyIntroduceFieldHandler.isAssignedLocalVariable(element)) {
            PyFunction function = (PyFunction)PsiTreeUtil.getParentOfType((PsiElement)element, PyFunction.class);
            Collection references2 = ReferencesSearch.search((PsiElement)element, (SearchScope)new LocalSearchScope((PsiElement)function)).findAll();
            ArrayList<PsiElement> result2 = new ArrayList<PsiElement>();
            for (PsiReference reference : references2) {
                PsiElement refElement = reference.getElement();
                if (refElement == element) continue;
                result2.add(refElement);
            }
            return result2;
        }
        return super.getOccurrences(element, expression);
    }

    @Override
    protected PyExpression createExpression(Project project2, String name2, PsiElement declaration) {
        String text = declaration.getText();
        String self_name = text.substring(0, text.indexOf(46));
        return PyElementGenerator.getInstance(project2).createExpressionFromText(LanguageLevel.forElement(declaration), self_name + "." + name2);
    }

    @Override
    protected PyAssignmentStatement createDeclaration(Project project2, String assignmentText, PsiElement anchor) {
        PyFunction container = (PyFunction)PsiTreeUtil.getParentOfType((PsiElement)anchor, PyFunction.class);
        String selfName = PyUtil.getFirstParameterName(container);
        LanguageLevel langLevel = LanguageLevel.forElement(anchor);
        return PyElementGenerator.getInstance(project2).createFromText(langLevel, PyAssignmentStatement.class, selfName + "." + assignmentText);
    }

    @Override
    protected void postRefactoring(PsiElement element) {
        if (PyIntroduceFieldHandler.isAssignedLocalVariable(element)) {
            element.getParent().delete();
        }
    }

    private static boolean isAssignedLocalVariable(PsiElement element) {
        PsiElement psiElement;
        if (element instanceof PyTargetExpression && (psiElement = element.getParent()) instanceof PyAssignmentStatement) {
            PyAssignmentStatement stmt = (PyAssignmentStatement)psiElement;
            if (PsiTreeUtil.getParentOfType((PsiElement)element, PyFunction.class) != null && stmt.getTargets().length == 1) {
                return true;
            }
        }
        return false;
    }

    @Override
    protected String getHelpId() {
        return "python.reference.introduceField";
    }

    @Override
    protected boolean checkIntroduceContext(PsiFile file, Editor editor2, PsiElement element) {
        if (element != null && PyIntroduceFieldHandler.isInStaticMethod(element)) {
            CommonRefactoringUtil.showErrorHint((Project)file.getProject(), (Editor)editor2, (String)PyBundle.message("refactoring.introduce.field.cannot.be.used.in.static.methods", new Object[0]), (String)RefactoringBundle.message((String)"introduce.field.title"), (String)"refactoring.extractMethod");
            return false;
        }
        return super.checkIntroduceContext(file, editor2, element);
    }

    private static boolean isInStaticMethod(PsiElement element) {
        PyFunction containingMethod = (PyFunction)PsiTreeUtil.getParentOfType((PsiElement)element, PyFunction.class, (boolean)false, (Class[])new Class[]{PyClass.class});
        if (containingMethod != null) {
            PyAstFunction.Modifier modifier = containingMethod.getModifier();
            return modifier == PyAstFunction.Modifier.STATICMETHOD;
        }
        return false;
    }

    @Override
    protected boolean isValidIntroduceContext(PsiElement element) {
        return super.isValidIntroduceContext(element) && PsiTreeUtil.getParentOfType((PsiElement)element, PyFunction.class, (boolean)false, (Class[])new Class[]{PyClass.class}) != null && PsiTreeUtil.getParentOfType((PsiElement)element, PyDecoratorList.class) == null && !PyIntroduceFieldHandler.isInStaticMethod(element);
    }

    @Override
    protected void performInplaceIntroduce(IntroduceOperation operation) {
        PsiElement statement = this.performRefactoring(operation);
        if (statement instanceof PyAssignmentStatement) {
            List<PsiElement> occurrences = operation.getOccurrences();
            PsiElement occurrence = PyIntroduceFieldHandler.findOccurrenceUnderCaret(occurrences, operation.getEditor());
            PyTargetExpression target = (PyTargetExpression)((PyAssignmentStatement)statement).getTargets()[0];
            PyIntroduceFieldHandler.putCaretOnFieldName(operation.getEditor(), (PsiElement)(occurrence != null ? occurrence : target));
            PyInplaceFieldIntroducer introducer = new PyInplaceFieldIntroducer(target, operation, occurrences);
            introducer.performInplaceRefactoring(new LinkedHashSet<String>(operation.getSuggestedNames()));
        }
    }

    private static void putCaretOnFieldName(Editor editor2, PsiElement occurrence) {
        ASTNode nameElement;
        PyQualifiedExpression qExpr = (PyQualifiedExpression)PsiTreeUtil.getParentOfType((PsiElement)occurrence, PyQualifiedExpression.class, (boolean)false);
        if (qExpr != null && !qExpr.isQualified()) {
            qExpr = (PyQualifiedExpression)PsiTreeUtil.getParentOfType((PsiElement)qExpr, PyQualifiedExpression.class);
        }
        if (qExpr != null && (nameElement = qExpr.getNameElement()) != null) {
            int offset = nameElement.getTextRange().getStartOffset();
            editor2.getCaretModel().moveToOffset(offset);
        }
    }

    @Override
    protected String getRefactoringId() {
        return "refactoring.python.introduce.field";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaration";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operation";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/refactoring/introduce/field/PyIntroduceFieldHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/refactoring/introduce/field/PyIntroduceFieldHandler";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "addFieldToSetUp";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isTestClass";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addDeclaration";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "inConstructor";
                break;
            }
            case 6: 
            case 7: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getOccurrences";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 7 -> new IllegalStateException(string);
        };
    }

    private static class ResolvingVisitor
    extends PyRecursiveElementVisitor {
        private boolean hasLocalScopeDependencies = false;
        private final ScopeOwner myScope;

        ResolvingVisitor(ScopeOwner scope) {
            this.myScope = scope;
        }

        @Override
        public void visitPyReferenceExpression(@NotNull PyReferenceExpression node) {
            if (node == null) {
                ResolvingVisitor.$$$reportNull$$$0(0);
            }
            super.visitPyReferenceExpression(node);
            PsiElement result2 = node.getReference().resolve();
            if (result2 != null && PsiTreeUtil.getParentOfType((PsiElement)result2, ScopeOwner.class) == this.myScope) {
                PyAstFunction.Modifier modifier;
                PyFunction function;
                PyParameter[] parameters;
                ScopeOwner scopeOwner;
                if (result2 instanceof PyParameter && (scopeOwner = this.myScope) instanceof PyFunction && (parameters = (function = (PyFunction)scopeOwner).getParameterList().getParameters()).length > 0 && result2 == parameters[0] && (modifier = function.getModifier()) != PyAstFunction.Modifier.STATICMETHOD) {
                    return;
                }
                this.hasLocalScopeDependencies = true;
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/jetbrains/python/refactoring/introduce/field/PyIntroduceFieldHandler$ResolvingVisitor", "visitPyReferenceExpression"));
        }
    }

    private static final class AddFieldDeclaration
    implements Function<String, PyStatement> {
        private final PsiElement myDeclaration;

        private AddFieldDeclaration(PsiElement declaration) {
            this.myDeclaration = declaration;
        }

        @Override
        public PyStatement apply(String self_name) {
            if ("self".equals(self_name)) {
                return (PyStatement)this.myDeclaration;
            }
            String text = this.myDeclaration.getText();
            Project project2 = this.myDeclaration.getProject();
            return PyElementGenerator.getInstance(project2).createFromText(LanguageLevel.getDefault(), PyStatement.class, text.replaceFirst("self\\.", self_name + "."));
        }
    }

    private static class PyInplaceFieldIntroducer
    extends InplaceVariableIntroducer<PsiElement> {
        private final PyTargetExpression myTarget;
        private final IntroduceOperation myOperation;
        private final PyIntroduceFieldPanel myPanel;

        PyInplaceFieldIntroducer(PyTargetExpression target, IntroduceOperation operation, List<PsiElement> occurrences) {
            super((PsiNamedElement)target, operation.getEditor(), operation.getProject(), RefactoringBundle.message((String)"introduce.field.title"), occurrences.toArray(PsiElement.EMPTY_ARRAY), null);
            this.myTarget = target;
            this.myOperation = operation;
            this.myPanel = operation.getAvailableInitPlaces().size() > 1 ? new PyIntroduceFieldPanel(this.myProject, operation.getAvailableInitPlaces()) : null;
        }

        protected PsiElement checkLocalScope() {
            return this.myTarget.getContainingFile();
        }

        protected JComponent getComponent() {
            return this.myPanel == null ? null : this.myPanel.getRootPanel();
        }

        protected void moveOffsetAfter(boolean success) {
            if (success && this.myPanel != null && this.myPanel.getInitPlace() != IntroduceHandler.InitPlace.SAME_METHOD || this.myOperation.getInplaceInitPlace() != IntroduceHandler.InitPlace.SAME_METHOD) {
                WriteAction.run(() -> {
                    IntroduceHandler.InitPlace initPlace;
                    PyAssignmentStatement initializer = (PyAssignmentStatement)PsiTreeUtil.getParentOfType((PsiElement)this.myTarget, PyAssignmentStatement.class);
                    assert (initializer != null);
                    Function<String, PyStatement> callback = __ -> initializer;
                    PyClass pyClass = PyUtil.getContainingClassOrSelf(initializer);
                    IntroduceHandler.InitPlace initPlace2 = initPlace = this.myPanel != null ? this.myPanel.getInitPlace() : this.myOperation.getInplaceInitPlace();
                    if (initPlace == IntroduceHandler.InitPlace.CONSTRUCTOR) {
                        AddFieldQuickFix.addFieldToInit(this.myProject, pyClass, "", callback);
                    } else if (initPlace == IntroduceHandler.InitPlace.SET_UP) {
                        PyIntroduceFieldHandler.addFieldToSetUp(pyClass, callback);
                    }
                    if (this.myOperation.getOccurrences().size() > 0) {
                        initializer.delete();
                    } else {
                        PyExpression copy = PyElementGenerator.getInstance(this.myProject).createExpressionFromText(LanguageLevel.forElement(this.myTarget), this.myTarget.getText());
                        initializer.replace((PsiElement)copy);
                    }
                    initializer.delete();
                });
            }
        }
    }
}

