/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.target;

import com.intellij.execution.process.CapturingProcessHandler;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.target.TargetBasedSdkAdditionalData;
import com.intellij.execution.target.TargetBasedSdks;
import com.intellij.execution.target.TargetEnvironment;
import com.intellij.execution.target.TargetEnvironmentRequest;
import com.intellij.execution.target.TargetProgressIndicator;
import com.intellij.execution.target.TargetProgressIndicatorAdapter;
import com.intellij.execution.target.TargetedCommandLine;
import com.intellij.execution.target.TargetedCommandLineBuilder;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.Ref;
import com.intellij.remote.RemoteSdkException;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.sdk.flavors.PythonSdkFlavor;
import com.jetbrains.python.target.PyTargetAwareAdditionalData;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u001a\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u001a \u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u00022\b\u0010\u0003\u001a\u0004\u0018\u00010\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u001a(\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u00022\b\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0007\u001a\u00020\u00012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\b"}, d2={"getInterpreterVersion", "", "Lcom/jetbrains/python/target/PyTargetAwareAdditionalData;", "project", "Lcom/intellij/openapi/project/Project;", "nullForUnparsableVersion", "", "interpreterPath", "intellij.python.community.impl"})
@JvmName(name="PyInterpreterVersionUtil")
public final class PyInterpreterVersionUtil {
    @Nullable
    public static final String getInterpreterVersion(@NotNull PyTargetAwareAdditionalData $this$getInterpreterVersion, @Nullable Project project2, boolean nullForUnparsableVersion) throws RemoteSdkException {
        Intrinsics.checkNotNullParameter((Object)$this$getInterpreterVersion, (String)"<this>");
        String string = $this$getInterpreterVersion.getInterpreterPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getInterpreterPath(...)");
        return PyInterpreterVersionUtil.getInterpreterVersion($this$getInterpreterVersion, project2, string, nullForUnparsableVersion);
    }

    public static /* synthetic */ String getInterpreterVersion$default(PyTargetAwareAdditionalData pyTargetAwareAdditionalData, Project project2, boolean bl, int n, Object object) throws RemoteSdkException {
        if ((n & 2) != 0) {
            bl = true;
        }
        return PyInterpreterVersionUtil.getInterpreterVersion(pyTargetAwareAdditionalData, project2, bl);
    }

    @Nullable
    public static final String getInterpreterVersion(@NotNull PyTargetAwareAdditionalData $this$getInterpreterVersion, @Nullable Project project2, @NotNull String interpreterPath, boolean nullForUnparsableVersion) throws RemoteSdkException {
        Intrinsics.checkNotNullParameter((Object)$this$getInterpreterVersion, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)interpreterPath, (String)"interpreterPath");
        TargetBasedSdkAdditionalData targetBasedSdkAdditionalData = $this$getInterpreterVersion;
        Project project3 = project2;
        if (project3 == null) {
            Project project4 = ProjectManager.getInstance().getDefaultProject();
            project3 = project4;
            Intrinsics.checkNotNullExpressionValue((Object)project4, (String)"getDefaultProject(...)");
        }
        TargetEnvironmentRequest targetEnvironmentRequest = TargetBasedSdks.getTargetEnvironmentRequest((TargetBasedSdkAdditionalData)targetBasedSdkAdditionalData, (Project)project3);
        if (targetEnvironmentRequest == null) {
            throw new IllegalStateException("Unable to get target configuration from Python SDK data");
        }
        TargetEnvironmentRequest targetEnvironmentRequest2 = targetEnvironmentRequest;
        Ref ref = Ref.create();
        Intrinsics.checkNotNullExpressionValue((Object)ref, (String)"create(...)");
        Ref result2 = ref;
        Ref ref2 = Ref.create();
        Intrinsics.checkNotNullExpressionValue((Object)ref2, (String)"create(...)");
        Ref exception = ref2;
        String string = PyBundle.message("python.sdk.getting.remote.interpreter.version", new Object[0]);
        Task.Modal task2 = new Task.Modal(project2, $this$getInterpreterVersion, targetEnvironmentRequest2, interpreterPath, nullForUnparsableVersion, (Ref<String>)result2, (Ref<RemoteSdkException>)exception, string){
            final /* synthetic */ PyTargetAwareAdditionalData $this_getInterpreterVersion;
            final /* synthetic */ TargetEnvironmentRequest $targetEnvironmentRequest;
            final /* synthetic */ String $interpreterPath;
            final /* synthetic */ boolean $nullForUnparsableVersion;
            final /* synthetic */ Ref<String> $result;
            final /* synthetic */ Ref<RemoteSdkException> $exception;
            {
                this.$this_getInterpreterVersion = $receiver;
                this.$targetEnvironmentRequest = $targetEnvironmentRequest;
                this.$interpreterPath = $interpreterPath;
                this.$nullForUnparsableVersion = $nullForUnparsableVersion;
                this.$result = $result;
                this.$exception = $exception;
                super($project, $super_call_param$1, true);
            }

            public void run(@NotNull ProgressIndicator indicator) {
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                PythonSdkFlavor<?> pythonSdkFlavor = this.$this_getInterpreterVersion.getFlavor();
                Intrinsics.checkNotNullExpressionValue(pythonSdkFlavor, (String)"getFlavor(...)");
                PythonSdkFlavor<?> flavor = pythonSdkFlavor;
                try {
                    try {
                        TargetedCommandLineBuilder targetedCommandLineBuilder = new TargetedCommandLineBuilder(this.$targetEnvironmentRequest);
                        targetedCommandLineBuilder.setExePath(this.$interpreterPath);
                        String string = flavor.getVersionOption();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getVersionOption(...)");
                        targetedCommandLineBuilder.addParameter(string);
                        TargetEnvironment targetEnvironment = this.$targetEnvironmentRequest.prepareEnvironment((TargetProgressIndicator)new TargetProgressIndicatorAdapter(indicator));
                        TargetedCommandLine targetedCommandLine = targetedCommandLineBuilder.build();
                        Process process2 = targetEnvironment.createProcess(targetedCommandLine, indicator);
                        String commandLineString = CollectionsKt.joinToString$default((Iterable)targetedCommandLine.collectCommandsSynchronously(), (CharSequence)" ", null, null, (int)0, null, null, (int)62, null);
                        CapturingProcessHandler capturingProcessHandler = new CapturingProcessHandler(process2, Charsets.UTF_8, commandLineString);
                        ProcessOutput processOutput = capturingProcessHandler.runProcess();
                        Intrinsics.checkNotNullExpressionValue((Object)processOutput, (String)"runProcess(...)");
                        ProcessOutput processOutput2 = processOutput;
                        if (processOutput2.getExitCode() == 0) {
                            String version2 = flavor.getVersionStringFromOutput(processOutput2);
                            if (version2 != null || this.$nullForUnparsableVersion) {
                                this.$result.set((Object)version2);
                                return;
                            }
                            throw new RemoteSdkException(PyBundle.message("python.sdk.empty.version.string", new Object[0]), processOutput2.getStdout(), processOutput2.getStderr());
                        }
                        Object[] objectArray = new Object[]{processOutput2.getExitCode()};
                        throw new RemoteSdkException(PyBundle.message("python.sdk.non.zero.exit.code", objectArray), processOutput2.getStdout(), processOutput2.getStderr());
                    }
                    catch (Exception e) {
                        RemoteSdkException remoteSdkException = RemoteSdkException.cantObtainRemoteCredentials((Throwable)e);
                        Intrinsics.checkNotNullExpressionValue((Object)((Object)remoteSdkException), (String)"cantObtainRemoteCredentials(...)");
                        throw (Throwable)remoteSdkException;
                    }
                }
                catch (RemoteSdkException e) {
                    this.$exception.set((Object)((Object)e));
                    return;
                }
            }
        };
        if (!ProgressManager.getInstance().hasProgressIndicator()) {
            UIUtil.invokeAndWaitIfNeeded(() -> PyInterpreterVersionUtil.getInterpreterVersion$lambda$0(task2));
        } else {
            task2.run(ProgressManager.getInstance().getProgressIndicator());
        }
        if (!exception.isNull()) {
            Object object = exception.get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
            throw (Throwable)object;
        }
        return (String)result2.get();
    }

    public static /* synthetic */ String getInterpreterVersion$default(PyTargetAwareAdditionalData pyTargetAwareAdditionalData, Project project2, String string, boolean bl, int n, Object object) throws RemoteSdkException {
        if ((n & 4) != 0) {
            bl = true;
        }
        return PyInterpreterVersionUtil.getInterpreterVersion(pyTargetAwareAdditionalData, project2, string, bl);
    }

    private static final void getInterpreterVersion$lambda$0(Task.Modal $task) {
        Intrinsics.checkNotNullParameter((Object)$task, (String)"$task");
        ProgressManager.getInstance().run((Task)$task);
    }
}

