/*
 * Decompiled with CFR 0.152.
 */
package com.openhtmltopdf.resource;

import com.openhtmltopdf.resource.AbstractResource;
import com.openhtmltopdf.resource.FSEntityResolver;
import com.openhtmltopdf.util.LogMessageId;
import com.openhtmltopdf.util.ThreadCtx;
import com.openhtmltopdf.util.XRLog;
import com.openhtmltopdf.util.XRRuntimeException;
import java.io.InputStream;
import java.io.Reader;
import java.util.logging.Level;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.sax.SAXSource;
import org.w3c.dom.Document;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

public class XMLResource
extends AbstractResource {
    private Document document;
    private static final XMLResourceBuilder XML_RESOURCE_BUILDER = new XMLResourceBuilder();

    private XMLResource(InputStream stream) {
        super(stream);
    }

    private XMLResource(InputSource source) {
        super(source);
    }

    public static XMLResource load(InputStream stream) {
        return XMLResource.XML_RESOURCE_BUILDER.createXMLResource(new XMLResource(stream));
    }

    public static XMLResource load(InputSource source) {
        return XMLResource.XML_RESOURCE_BUILDER.createXMLResource(new XMLResource(source));
    }

    public static XMLResource load(Reader reader) {
        return XMLResource.XML_RESOURCE_BUILDER.createXMLResource(new XMLResource(new InputSource(reader)));
    }

    public Document getDocument() {
        return this.document;
    }

    void setDocument(Document document2) {
        this.document = document2;
    }

    public static final XMLReader newXMLReader() {
        XMLReader xmlReader = null;
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            XMLResource.setSaxParserRequestedFeatures(factory);
            SAXParser parser2 = factory.newSAXParser();
            xmlReader = parser2.getXMLReader();
        }
        catch (Exception ex) {
            XRLog.log(Level.INFO, LogMessageId.LogMessageId1Param.GENERAL_MESSAGE, ex.getMessage());
        }
        if (xmlReader == null) {
            throw new XRRuntimeException("Could not instantiate any SAX 2 parser, including JDK default. The name of the class to use may have been read from the 'javax.xml.parsers.SAXParserFactory' System property, which is set to: " + System.getProperty("javax.xml.parsers.SAXParserFactory"));
        }
        XRLog.log(Level.INFO, LogMessageId.LogMessageId1Param.LOAD_SAX_XMLREADER_IN_USE, xmlReader.getClass().getName());
        return xmlReader;
    }

    private static <T> boolean trySetFeature(String feature, T value2, SetFeature<T> tryer) {
        try {
            tryer.setFeature(feature, value2);
            return true;
        }
        catch (Exception e) {
            XRLog.log(Level.WARNING, LogMessageId.LogMessageId2Param.XML_FEATURE_NOT_ABLE_TO_SET, (Object)feature, value2, e);
            return false;
        }
    }

    private static void setSaxParserRequestedFeatures(SAXParserFactory factory) {
        factory.setValidating(false);
        factory.setNamespaceAware(true);
        boolean b = true;
        b &= XMLResource.trySetFeature("http://apache.org/xml/features/disallow-doctype-decl", false, factory::setFeature);
        b &= XMLResource.trySetFeature("http://xml.org/sax/features/external-general-entities", false, factory::setFeature);
        b &= XMLResource.trySetFeature("http://xml.org/sax/features/external-parameter-entities", false, factory::setFeature);
        b &= XMLResource.trySetFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", true, factory::setFeature);
        if (!(b &= XMLResource.trySetFeature("http://javax.xml.XMLConstants/feature/secure-processing", true, factory::setFeature))) {
            XRLog.log(Level.SEVERE, LogMessageId.LogMessageId0Param.LOAD_UNABLE_TO_DISABLE_XML_EXTERNAL_ENTITIES);
        }
    }

    private static class XMLResourceBuilder {
        private XMLResourceBuilder() {
        }

        private void setXmlReaderSecurityFeatures(XMLReader xmlReader) {
            boolean b = true;
            b &= XMLResource.trySetFeature("http://apache.org/xml/features/disallow-doctype-decl", false, xmlReader::setFeature);
            b &= XMLResource.trySetFeature("http://xml.org/sax/features/external-general-entities", false, xmlReader::setFeature);
            b &= XMLResource.trySetFeature("http://xml.org/sax/features/external-parameter-entities", false, xmlReader::setFeature);
            b &= XMLResource.trySetFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", true, xmlReader::setFeature);
            if (!(b &= XMLResource.trySetFeature("http://javax.xml.XMLConstants/feature/secure-processing", true, xmlReader::setFeature))) {
                XRLog.log(Level.SEVERE, LogMessageId.LogMessageId0Param.LOAD_UNABLE_TO_DISABLE_XML_EXTERNAL_ENTITIES);
            }
        }

        private void setDocumentBuilderSecurityFeatures(DocumentBuilderFactory dbf) {
            boolean b = true;
            b &= XMLResource.trySetFeature("http://apache.org/xml/features/disallow-doctype-decl", false, dbf::setFeature);
            b &= XMLResource.trySetFeature("http://xml.org/sax/features/external-general-entities", false, dbf::setFeature);
            b &= XMLResource.trySetFeature("http://xml.org/sax/features/external-parameter-entities", false, dbf::setFeature);
            b &= XMLResource.trySetFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false, dbf::setFeature);
            if (!(b &= XMLResource.trySetFeature("http://javax.xml.XMLConstants/feature/secure-processing", true, dbf::setFeature))) {
                XRLog.log(Level.SEVERE, LogMessageId.LogMessageId0Param.LOAD_UNABLE_TO_DISABLE_XML_EXTERNAL_ENTITIES);
            }
        }

        private void setTranformerFactorySecurityFeatures(TransformerFactory xformFactory) {
            boolean b = true;
            b &= XMLResource.trySetFeature("http://javax.xml.XMLConstants/property/accessExternalDTD", "", xformFactory::setAttribute);
            if (!(b &= XMLResource.trySetFeature("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "", xformFactory::setAttribute))) {
                XRLog.log(Level.SEVERE, LogMessageId.LogMessageId0Param.LOAD_UNABLE_TO_DISABLE_XML_EXTERNAL_ENTITIES);
            }
        }

        private TransformerFactory loadPreferredTransformerFactory(String preferredImpl) {
            try {
                return TransformerFactory.newInstance(preferredImpl, null);
            }
            catch (TransformerFactoryConfigurationError e) {
                XRLog.log(Level.SEVERE, LogMessageId.LogMessageId1Param.LOAD_COULD_NOT_LOAD_PREFERRED_XML, "transformer");
                return TransformerFactory.newInstance();
            }
        }

        private DocumentBuilderFactory loadPreferredDocumentBuilderFactory(String preferredImpl) {
            try {
                return preferredImpl == null ? DocumentBuilderFactory.newInstance() : DocumentBuilderFactory.newInstance(preferredImpl, null);
            }
            catch (FactoryConfigurationError e) {
                XRLog.log(Level.SEVERE, LogMessageId.LogMessageId1Param.LOAD_COULD_NOT_LOAD_PREFERRED_XML, "document builder");
                return DocumentBuilderFactory.newInstance();
            }
        }

        private XMLResource createXMLResource(XMLResource target) {
            SAXSource input = null;
            DOMResult output2 = null;
            TransformerFactory xformFactory = null;
            Transformer idTransform = null;
            XMLReader xmlReader = null;
            long st = 0L;
            xmlReader = XMLResource.newXMLReader();
            this.setXmlReaderSecurityFeatures(xmlReader);
            this.addHandlers(xmlReader);
            this.setParserFeatures(xmlReader);
            st = System.currentTimeMillis();
            try {
                input = new SAXSource(xmlReader, target.getResourceInputSource());
                String preferredDocumentBuilderFactory = ThreadCtx.get().sharedContext()._preferredDocumentBuilderFactoryImplementationClass;
                DocumentBuilderFactory dbf = this.loadPreferredDocumentBuilderFactory(preferredDocumentBuilderFactory);
                this.setDocumentBuilderSecurityFeatures(dbf);
                dbf.setNamespaceAware(true);
                dbf.setValidating(false);
                output2 = new DOMResult(dbf.newDocumentBuilder().newDocument());
                String preferredTransformerFactory = ThreadCtx.get().sharedContext()._preferredTransformerFactoryImplementationClass;
                xformFactory = preferredTransformerFactory == null ? TransformerFactory.newInstance() : this.loadPreferredTransformerFactory(preferredTransformerFactory);
                this.setTranformerFactorySecurityFeatures(xformFactory);
                idTransform = xformFactory.newTransformer();
            }
            catch (Exception ex) {
                throw new XRRuntimeException("Failed on configuring SAX to DOM transformer.", ex);
            }
            try {
                idTransform.transform(input, output2);
            }
            catch (Exception ex) {
                throw new XRRuntimeException("Can't load the XML resource (using TRaX transformer). " + ex.getMessage(), ex);
            }
            long end = System.currentTimeMillis();
            target.setElapsedLoadTime(end - st);
            XRLog.log(Level.INFO, LogMessageId.LogMessageId1Param.LOAD_LOADED_DOCUMENT_TIME, target.getElapsedLoadTime());
            target.setDocument((Document)output2.getNode());
            return target;
        }

        private void addHandlers(XMLReader xmlReader) {
            try {
                xmlReader.setEntityResolver(FSEntityResolver.instance());
                xmlReader.setErrorHandler(new ErrorHandler(){

                    @Override
                    public void error(SAXParseException ex) {
                        XRLog.log(Level.INFO, LogMessageId.LogMessageId1Param.LOAD_EXCEPTION_MESSAGE, ex.getMessage());
                    }

                    @Override
                    public void fatalError(SAXParseException ex) {
                        XRLog.log(Level.INFO, LogMessageId.LogMessageId1Param.LOAD_EXCEPTION_MESSAGE, ex.getMessage());
                    }

                    @Override
                    public void warning(SAXParseException ex) {
                        XRLog.log(Level.INFO, LogMessageId.LogMessageId1Param.LOAD_EXCEPTION_MESSAGE, ex.getMessage());
                    }
                });
            }
            catch (Exception ex) {
                throw new XRRuntimeException("Failed on configuring SAX parser/XMLReader.", ex);
            }
        }

        private void setParserFeatures(XMLReader xmlReader) {
            boolean b = true;
            b &= XMLResource.trySetFeature("http://xml.org/sax/features/validation", false, xmlReader::setFeature);
            if (!(b &= XMLResource.trySetFeature("http://xml.org/sax/features/namespaces", true, xmlReader::setFeature))) {
                XRLog.log(Level.WARNING, LogMessageId.LogMessageId0Param.LOAD_COULD_NOT_SET_VALIDATION_NAMESPACE_FEATURES_FOR_XML_PARSER);
            }
        }
    }

    @FunctionalInterface
    static interface SetFeature<T> {
        public void setFeature(String var1, T var2) throws Exception;
    }
}

