/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ext.enumerated.reference.internal;

import com.vladsch.flexmark.ext.enumerated.reference.EnumeratedReferenceBase;
import com.vladsch.flexmark.ext.enumerated.reference.EnumeratedReferenceBlock;
import com.vladsch.flexmark.ext.enumerated.reference.EnumeratedReferenceExtension;
import com.vladsch.flexmark.ext.enumerated.reference.EnumeratedReferenceLink;
import com.vladsch.flexmark.ext.enumerated.reference.EnumeratedReferenceRepository;
import com.vladsch.flexmark.ext.enumerated.reference.EnumeratedReferenceText;
import com.vladsch.flexmark.parser.LinkRefProcessor;
import com.vladsch.flexmark.parser.LinkRefProcessorFactory;
import com.vladsch.flexmark.util.ast.Document;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.data.DataHolder;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import org.jetbrains.annotations.NotNull;

public class EnumeratedReferenceLinkRefProcessor
implements LinkRefProcessor {
    static final boolean WANT_EXCLAMATION_PREFIX = false;
    static final int BRACKET_NESTING_LEVEL = 0;
    private final EnumeratedReferenceRepository enumeratedReferenceRepository;

    public EnumeratedReferenceLinkRefProcessor(Document document2) {
        this.enumeratedReferenceRepository = EnumeratedReferenceExtension.ENUMERATED_REFERENCES.get(document2);
    }

    @Override
    public boolean getWantExclamationPrefix() {
        return false;
    }

    @Override
    public int getBracketNestingLevel() {
        return 0;
    }

    @Override
    public boolean isMatch(@NotNull BasedSequence nodeChars) {
        return !(nodeChars.length() < 3 || nodeChars.charAt(0) != '[' || nodeChars.charAt(1) != '@' && nodeChars.charAt(1) != '#' || nodeChars.endCharAt(1) != ']' || nodeChars.length() != 3 && Character.isDigit(nodeChars.charAt(2)));
    }

    @Override
    @NotNull
    public Node createNode(@NotNull BasedSequence nodeChars) {
        EnumeratedReferenceBlock enumeratedReferenceBlock;
        BasedSequence enumeratedReferenceId = (BasedSequence)((BasedSequence)nodeChars.midSequence(2, -1)).trim();
        EnumeratedReferenceBlock enumeratedReferenceBlock2 = enumeratedReferenceBlock = enumeratedReferenceId.length() > 0 ? (EnumeratedReferenceBlock)this.enumeratedReferenceRepository.get(enumeratedReferenceId.toString()) : null;
        if (nodeChars.charAt(1) == '@') {
            EnumeratedReferenceLink enumeratedReference = new EnumeratedReferenceLink(nodeChars.subSequence(0, 2), enumeratedReferenceId, (BasedSequence)nodeChars.endSequence(1));
            enumeratedReference.setEnumeratedReferenceBlock(enumeratedReferenceBlock);
            return enumeratedReference;
        }
        EnumeratedReferenceText enumeratedReferenceText = new EnumeratedReferenceText(nodeChars.subSequence(0, 2), enumeratedReferenceId, (BasedSequence)nodeChars.endSequence(1));
        enumeratedReferenceText.setEnumeratedReferenceBlock(enumeratedReferenceBlock);
        return enumeratedReferenceText;
    }

    @Override
    @NotNull
    public BasedSequence adjustInlineText(@NotNull Document document2, @NotNull Node node) {
        assert (node instanceof EnumeratedReferenceBase);
        return ((EnumeratedReferenceBase)node).getText();
    }

    @Override
    public boolean allowDelimiters(@NotNull BasedSequence chars, @NotNull Document document2, @NotNull Node node) {
        return true;
    }

    @Override
    public void updateNodeElements(@NotNull Document document2, @NotNull Node node) {
    }

    public static class Factory
    implements LinkRefProcessorFactory {
        @Override
        @NotNull
        public LinkRefProcessor apply(@NotNull Document document2) {
            return new EnumeratedReferenceLinkRefProcessor(document2);
        }

        @Override
        public boolean getWantExclamationPrefix(@NotNull DataHolder options) {
            return false;
        }

        @Override
        public int getBracketNestingLevel(@NotNull DataHolder options) {
            return 0;
        }
    }
}

