/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indexing.shared.platform.hash;

import com.intellij.util.hash.ContentHashEnumerator;
import com.intellij.util.io.ScannableDataEnumeratorEx;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0004J\u0016\u0010\u000b\u001a\n \r*\u0004\u0018\u00010\f0\f2\u0006\u0010\u0007\u001a\u00020\u0006J\u000e\u0010\u000e\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\u0006R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/indexing/shared/platform/hash/SharedIndexContentEnumerators;", "", "()V", "hashFileName", "", "getHashEnumeratorPath", "Ljava/nio/file/Path;", "chunkRootPath", "isRelatedToEnumerator", "", "path", "newEnumeratorForGenerator", "Lcom/intellij/util/hash/ContentHashEnumerator;", "kotlin.jvm.PlatformType", "openEnumeratorForAttachedSharedIndex", "intellij.indexing.shared"})
public final class SharedIndexContentEnumerators {
    @NotNull
    public static final SharedIndexContentEnumerators INSTANCE = new SharedIndexContentEnumerators();
    @NotNull
    private static final String hashFileName = "hashes";

    private SharedIndexContentEnumerators() {
    }

    public final boolean isRelatedToEnumerator(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return StringsKt.startsWith$default((String)path, (String)hashFileName, (boolean)false, (int)2, null);
    }

    @NotNull
    public final Path getHashEnumeratorPath(@NotNull Path chunkRootPath) {
        Intrinsics.checkNotNullParameter((Object)chunkRootPath, (String)"chunkRootPath");
        Path path = chunkRootPath.resolve(hashFileName);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        return path;
    }

    @NotNull
    public final ContentHashEnumerator openEnumeratorForAttachedSharedIndex(@NotNull Path chunkRootPath) {
        Intrinsics.checkNotNullParameter((Object)chunkRootPath, (String)"chunkRootPath");
        return new ContentHashEnumerator(chunkRootPath){
            private final /* synthetic */ ContentHashEnumerator $$delegate_0;
            {
                this.$$delegate_0 = ContentHashEnumerator.open((Path)SharedIndexContentEnumerators.INSTANCE.getHashEnumeratorPath($chunkRootPath));
            }

            public void close() {
                this.$$delegate_0.close();
            }

            public void closeAndClean() {
                this.$$delegate_0.closeAndClean();
            }

            public int enumerateEx(byte[] p0) {
                return this.$$delegate_0.enumerateEx(p0);
            }

            public boolean forEach(@NotNull ScannableDataEnumeratorEx.ValueReader<? super byte[]> p0) {
                Intrinsics.checkNotNullParameter(p0, (String)"p0");
                return this.$$delegate_0.forEach(p0);
            }

            public void force() {
                this.$$delegate_0.force();
            }

            public boolean isDirty() {
                return this.$$delegate_0.isDirty();
            }

            public int recordsCount() {
                return this.$$delegate_0.recordsCount();
            }

            public int tryEnumerate(@Nullable byte[] p0) {
                return this.$$delegate_0.tryEnumerate((Object)p0);
            }

            @Nullable
            public byte[] valueOf(int p0) {
                return this.$$delegate_0.valueOf(p0);
            }

            public int enumerate(@Nullable byte[] value) {
                throw new UnsupportedOperationException("Enumerator is read-only");
            }
        };
    }

    public final ContentHashEnumerator newEnumeratorForGenerator(@NotNull Path chunkRootPath) {
        Intrinsics.checkNotNullParameter((Object)chunkRootPath, (String)"chunkRootPath");
        return ContentHashEnumerator.open((Path)this.getHashEnumeratorPath(chunkRootPath));
    }
}

