/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.completion.ml.experiment;

import com.intellij.completion.ml.experiment.ClientExperimentStatusKt;
import com.intellij.completion.ml.experiment.ExperimentConfig;
import com.intellij.completion.ml.experiment.ExperimentGroupConfig;
import com.intellij.completion.ml.experiment.ExperimentInfo;
import com.intellij.completion.ml.experiment.ExperimentLanguageConfig;
import com.intellij.completion.ml.experiment.ExperimentStatus;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.internal.statistic.eventLog.EventLogConfiguration;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.registry.RegistryValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u001b\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00060\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0000\u00a2\u0006\u0002\b\u0014J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u001d\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00060\u00112\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0002\u00a2\u0006\u0002\u0010\u001aJ\b\u0010\u001b\u001a\u00020\tH\u0016J\u0010\u0010\u001c\u001a\u00020\u000f2\u0006\u0010\u001d\u001a\u00020\tH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/intellij/completion/ml/experiment/ClientExperimentStatus;", "Lcom/intellij/completion/ml/experiment/ExperimentStatus;", "()V", "experimentConfig", "Lcom/intellij/completion/ml/experiment/ExperimentConfig;", "experimentGroupRegistryValue", "", "Ljava/lang/Integer;", "isDisabledByEvaluation", "", "languageToGroup", "", "", "Lcom/intellij/completion/ml/experiment/ExperimentInfo;", "disable", "", "extractGroupsMapping", "", "language", "Lcom/intellij/lang/Language;", "extractGroupsMapping$intellij_completionMlRanking", "findMatchingLanguage", "forLanguage", "getBucketsMapping", "seed", "", "(Ljava/lang/Long;)Ljava/util/List;", "isDisabled", "setDisabled", "value", "intellij.completionMlRanking"})
@SourceDebugExtension(value={"SMAP\nClientExperimentStatus.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClientExperimentStatus.kt\ncom/intellij/completion/ml/experiment/ClientExperimentStatus\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,128:1\n1#2:129\n766#3:130\n857#3,2:131\n1747#3,3:133\n1549#3:136\n1620#3,3:137\n*S KotlinDebug\n*F\n+ 1 ClientExperimentStatus.kt\ncom/intellij/completion/ml/experiment/ClientExperimentStatus\n*L\n107#1:130\n107#1:131,2\n109#1:133,3\n122#1:136\n122#1:137,3\n*E\n"})
public final class ClientExperimentStatus
implements ExperimentStatus {
    @NotNull
    private final ExperimentConfig experimentConfig = ClientExperimentStatusKt.loadExperimentInfo();
    @NotNull
    private final Map<String, ExperimentInfo> languageToGroup = new HashMap();
    private final boolean isDisabledByEvaluation;
    @Nullable
    private Integer experimentGroupRegistryValue;

    public ClientExperimentStatus() {
        Object object = System.getenv("EVALUATION_ML_EXPERIMENT_DISABLED");
        this.isDisabledByEvaluation = object != null && (object = StringsKt.toBooleanStrictOrNull((String)object)) != null ? (Boolean)object : false;
        List<Integer> bucketsMapping = this.getBucketsMapping(this.experimentConfig.getSeed());
        EventLogConfiguration eventLogConfiguration = EventLogConfiguration.Companion.getInstance();
        for (ExperimentLanguageConfig languageSettings : this.experimentConfig.getLanguages()) {
            Object v1;
            block2: {
                int bucket = ((Number)bucketsMapping.get(eventLogConfiguration.getBucket())).intValue() % languageSettings.getExperimentBucketsCount();
                int groupNumber = languageSettings.getIncludeGroups().size() > bucket ? ((Number)languageSettings.getIncludeGroups().get(bucket)).intValue() : this.experimentConfig.getVersion();
                Iterable iterable = this.experimentConfig.getGroups();
                for (Object t : iterable) {
                    ExperimentGroupConfig it = (ExperimentGroupConfig)t;
                    boolean bl = false;
                    if (!(it.getNumber() == groupNumber)) continue;
                    v1 = t;
                    break block2;
                }
                v1 = null;
            }
            ExperimentGroupConfig group = v1;
            ExperimentInfo groupInfo = group == null ? new ExperimentInfo(false, this.experimentConfig.getVersion(), false, false, false, false, 60, null) : new ExperimentInfo(true, group.getNumber(), group.getUseMLRanking(), group.getShowArrows(), group.getCalculateFeatures(), languageSettings.getShouldLogElementFeatures());
            this.languageToGroup.put(languageSettings.getId(), groupInfo);
        }
    }

    @Override
    @NotNull
    public ExperimentInfo forLanguage(@NotNull Language language) {
        ExperimentInfo experimentInfo;
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        if (ApplicationManager.getApplication().isUnitTestMode() || this.isDisabledByEvaluation) {
            return new ExperimentInfo(false, 0, false, false, false, false, 60, null);
        }
        String string = this.findMatchingLanguage(language);
        if (string == null) {
            return new ExperimentInfo(false, this.experimentConfig.getVersion(), false, false, false, false, 60, null);
        }
        String matchingLanguage = string;
        RegistryValue registryValue = Registry.get((String)"completion.ml.override.experiment.group.number");
        Intrinsics.checkNotNullExpressionValue((Object)registryValue, (String)"get(...)");
        RegistryValue experimentGroupRegistry = registryValue;
        if (experimentGroupRegistry.isChangedFromDefault() && !experimentGroupRegistry.isChangedSinceAppStart()) {
            this.experimentGroupRegistryValue = experimentGroupRegistry.asInteger();
        }
        if (this.experimentGroupRegistryValue != null) {
            Object v3;
            block7: {
                Iterable iterable = this.experimentConfig.getGroups();
                for (Object t : iterable) {
                    ExperimentGroupConfig it = (ExperimentGroupConfig)t;
                    boolean bl = false;
                    Integer n = this.experimentGroupRegistryValue;
                    if (!(n != null && it.getNumber() == n.intValue())) continue;
                    v3 = t;
                    break block7;
                }
                v3 = null;
            }
            ExperimentGroupConfig group = v3;
            if (group != null) {
                this.setDisabled(false);
                return new ExperimentInfo(true, group.getNumber(), group.getUseMLRanking(), group.getShowArrows(), group.getCalculateFeatures(), true);
            }
        }
        if ((experimentInfo = this.languageToGroup.get(matchingLanguage)) == null) {
            experimentInfo = new ExperimentInfo(false, this.experimentConfig.getVersion(), false, false, false, false, 60, null);
        }
        return experimentInfo;
    }

    @Override
    public void disable() {
        if (ApplicationManager.getApplication().isEAP()) {
            this.setDisabled(true);
        }
    }

    @Override
    public boolean isDisabled() {
        return PropertiesComponent.getInstance().isTrueValue("ml.completion.experiment.disabled") || this.isDisabledByEvaluation;
    }

    private final void setDisabled(boolean value) {
        PropertiesComponent.getInstance().setValue("ml.completion.experiment.disabled", value);
    }

    /*
     * WARNING - void declaration
     */
    private final String findMatchingLanguage(Language language) {
        Object v2;
        block6: {
            void $this$filterTo$iv$iv;
            Collection collection = Language.getRegisteredLanguages();
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getRegisteredLanguages(...)");
            Iterable $this$filter$iv = collection;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Language it = (Language)element$iv$iv;
                boolean bl = false;
                if (!language.isKindOf(it)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List baseLanguages = (List)destination$iv$iv;
            Iterable iterable2 = this.languageToGroup.keySet();
            for (Object e : iterable2) {
                boolean bl;
                block5: {
                    String languageId = (String)e;
                    boolean bl2 = false;
                    Iterable $this$any$iv = baseLanguages;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            Language it = (Language)element$iv;
                            boolean bl3 = false;
                            if (!StringsKt.equals((String)languageId, (String)it.getID(), (boolean)true)) continue;
                            bl = true;
                            break block5;
                        }
                        bl = false;
                    }
                }
                if (!bl) continue;
                v2 = e;
                break block6;
            }
            v2 = null;
        }
        return v2;
    }

    private final List<Integer> getBucketsMapping(Long seed) {
        IntRange buckets = RangesKt.until((int)0, (int)256);
        return seed == null ? CollectionsKt.toList((Iterable)((Iterable)buckets)) : CollectionsKt.shuffled((Iterable)((Iterable)buckets), (Random)new Random(seed));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Integer> extractGroupsMapping$intellij_completionMlRanking(@NotNull Language language) {
        void $this$mapTo$iv$iv;
        Object v0;
        block3: {
            Intrinsics.checkNotNullParameter((Object)language, (String)"language");
            Iterable iterable = this.experimentConfig.getLanguages();
            for (Object t : iterable) {
                ExperimentLanguageConfig it = (ExperimentLanguageConfig)t;
                boolean bl = false;
                if (!StringsKt.equals((String)language.getID(), (String)it.getId(), (boolean)true)) continue;
                v0 = t;
                break block3;
            }
            v0 = null;
        }
        ExperimentLanguageConfig experimentLanguageConfig = v0;
        if (experimentLanguageConfig == null) {
            throw new IllegalArgumentException("Language " + language.getID() + " not found");
        }
        ExperimentLanguageConfig languageSettings = experimentLanguageConfig;
        List<Integer> bucketsMapping = this.getBucketsMapping(this.experimentConfig.getSeed());
        Iterable $this$map$iv = (Iterable)RangesKt.until((int)0, (int)256);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void it;
            int item$iv$iv;
            int n = item$iv$iv = ((IntIterator)iterator).nextInt();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            int bucket = ((Number)bucketsMapping.get((int)it)).intValue() % languageSettings.getExperimentBucketsCount();
            collection.add(languageSettings.getIncludeGroups().size() > bucket ? ((Number)languageSettings.getIncludeGroups().get(bucket)).intValue() : this.experimentConfig.getVersion());
        }
        return (List)destination$iv$iv;
    }
}

