/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.util.io.ScannableDataEnumeratorEx;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.io.IOException;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class InMemoryEnumerator<Data>
implements ScannableDataEnumeratorEx<Data> {
    private final Object2IntMap<Data> idByValue = new Object2IntOpenHashMap<Data>();
    private final Int2ObjectMap<Data> valueById = new Int2ObjectOpenHashMap<Data>();

    @Override
    public int enumerate(@Nullable Data value) {
        int id = this.idByValue.getOrDefault((Object)value, 0);
        if (id == 0) {
            id = this.valueById.size() + 1;
            this.valueById.put(id, value);
            this.idByValue.put(value, id);
        }
        return id;
    }

    @Override
    public int tryEnumerate(@Nullable Data value) {
        return this.idByValue.getOrDefault((Object)value, 0);
    }

    @Override
    @Nullable
    public Data valueOf(int id) {
        return (Data)this.valueById.get(id);
    }

    @Override
    public boolean forEach(@NotNull ScannableDataEnumeratorEx.ValueReader<? super Data> reader) throws IOException {
        if (reader == null) {
            InMemoryEnumerator.$$$reportNull$$$0(0);
        }
        for (Int2ObjectMap.Entry entry : this.valueById.int2ObjectEntrySet()) {
            boolean shouldContinue = reader.read(entry.getIntKey(), entry.getValue());
            if (shouldContinue) continue;
            return false;
        }
        return true;
    }

    @Override
    public int recordsCount() throws IOException {
        return this.valueById.size();
    }

    public Iterable<Data> enumeratedValues() {
        return new ArrayList(this.valueById.values());
    }

    public void registerValueWithGivenId(int id, Data value, boolean overrideExisting) {
        if (!overrideExisting && this.valueById.containsKey(id)) {
            throw new IllegalArgumentException("id(=" + id + ") is already in use (value: " + this.valueById.get(id) + ") -- use overrideExisting=true");
        }
        this.idByValue.put(value, id);
        this.valueById.put(id, value);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reader", "com/intellij/util/io/InMemoryEnumerator", "forEach"));
    }
}

