/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xmlb;

import com.intellij.openapi.util.JDOMExternalizableStringList;
import com.intellij.serialization.ClassUtil;
import com.intellij.serialization.MutableAccessor;
import com.intellij.serialization.SerializationException;
import com.intellij.util.xmlb.BeanBinding;
import com.intellij.util.xmlb.Binding;
import com.intellij.util.xmlb.CollectionBindingKt;
import com.intellij.util.xmlb.CompactCollectionBinding;
import com.intellij.util.xmlb.JDOMElementBinding;
import com.intellij.util.xmlb.MapBinding;
import com.intellij.util.xmlb.RootBinding;
import com.intellij.util.xmlb.SerializationFilter;
import com.intellij.util.xmlb.Serializer;
import com.intellij.util.xmlb.XmlSerializationException;
import com.intellij.util.xmlb.annotations.CollectionBean;
import com.intellij.util.xmlb.annotations.MapAnnotation;
import com.intellij.util.xmlb.annotations.XMap;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Text;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class XmlSerializerImpl {
    static final XmlSerializer serializer = new XmlSerializer();

    @Nullable
    public static Binding createClassBinding(@NotNull Class<?> aClass, @Nullable MutableAccessor accessor, @NotNull Type originalType, @NotNull Serializer serializer2) {
        if (aClass == null) {
            XmlSerializerImpl.$$$reportNull$$$0(0);
        }
        if (originalType == null) {
            XmlSerializerImpl.$$$reportNull$$$0(1);
        }
        if (serializer2 == null) {
            XmlSerializerImpl.$$$reportNull$$$0(2);
        }
        if (aClass.isArray()) {
            if (Element.class.isAssignableFrom(aClass.getComponentType())) {
                assert (accessor != null);
                return new JDOMElementBinding(accessor);
            }
            return CollectionBindingKt.createCollectionBinding(serializer2, aClass.getComponentType(), accessor, true);
        }
        if (Collection.class.isAssignableFrom(aClass) && originalType instanceof ParameterizedType) {
            CollectionBean listBean;
            if (accessor != null && (listBean = accessor.getAnnotation(CollectionBean.class)) != null) {
                return new CompactCollectionBinding(accessor);
            }
            return CollectionBindingKt.createCollectionBinding(serializer2, ClassUtil.typeToClass(((ParameterizedType)originalType).getActualTypeArguments()[0]), accessor, false);
        }
        if (Map.class.isAssignableFrom(aClass) && originalType instanceof ParameterizedType) {
            XMap newAnnotation = null;
            MapAnnotation oldAnnotation = null;
            if (accessor != null) {
                newAnnotation = accessor.getAnnotation(XMap.class);
                oldAnnotation = newAnnotation == null ? accessor.getAnnotation(MapAnnotation.class) : null;
            }
            boolean isSurroundWithTag = newAnnotation == null && (oldAnnotation == null || oldAnnotation.surroundWithTag());
            return new MapBinding(oldAnnotation, newAnnotation, aClass, isSurroundWithTag);
        }
        if (accessor != null) {
            if (Element.class.isAssignableFrom(aClass)) {
                return new JDOMElementBinding(accessor);
            }
            if (aClass == JDOMExternalizableStringList.class) {
                return new CompactCollectionBinding(accessor);
            }
        }
        return null;
    }

    @NotNull
    static Element serialize(@NotNull Object object, @Nullable SerializationFilter filter2) throws SerializationException {
        Element element;
        Binding binding;
        block7: {
            if (object == null) {
                XmlSerializerImpl.$$$reportNull$$$0(3);
            }
            Class<?> aClass = object.getClass();
            binding = serializer.getRootBinding(aClass, aClass);
            if (!(binding instanceof BeanBinding)) break block7;
            Element element2 = Objects.requireNonNull(((BeanBinding)binding).serialize(object, true, filter2));
            if (element2 == null) {
                XmlSerializerImpl.$$$reportNull$$$0(4);
            }
            return element2;
        }
        try {
            element = ((RootBinding)binding).serialize(object, filter2);
        }
        catch (SerializationException e2) {
            throw e2;
        }
        catch (Exception e3) {
            throw new XmlSerializationException("Can't serialize instance of " + object.getClass(), e3);
        }
        if (element == null) {
            XmlSerializerImpl.$$$reportNull$$$0(5);
        }
        return element;
    }

    @Nullable
    static Object convert(@Nullable String value, @NotNull Class<?> valueClass) {
        if (valueClass == null) {
            XmlSerializerImpl.$$$reportNull$$$0(6);
        }
        if (value == null) {
            return null;
        }
        if (valueClass == String.class) {
            return value;
        }
        if (valueClass == Integer.TYPE || valueClass == Integer.class) {
            return Integer.parseInt(value);
        }
        if (valueClass == Boolean.TYPE || valueClass == Boolean.class) {
            return Boolean.parseBoolean(value);
        }
        if (valueClass == Double.TYPE || valueClass == Double.class) {
            return Double.parseDouble(value);
        }
        if (valueClass == Float.TYPE || valueClass == Float.class) {
            return Float.valueOf(Float.parseFloat(value));
        }
        if (valueClass == Long.TYPE || valueClass == Long.class) {
            return Long.parseLong(value);
        }
        if (valueClass.isEnum()) {
            for (Object enumConstant : valueClass.getEnumConstants()) {
                if (!enumConstant.toString().equals(value)) continue;
                return enumConstant;
            }
            return null;
        }
        if (Date.class.isAssignableFrom(valueClass)) {
            try {
                return new Date(Long.parseLong(value));
            }
            catch (NumberFormatException e2) {
                return new Date(0L);
            }
        }
        return value;
    }

    static void doSet(@NotNull Object host, @Nullable String value, @NotNull MutableAccessor accessor, @NotNull Class<?> valueClass) {
        if (host == null) {
            XmlSerializerImpl.$$$reportNull$$$0(7);
        }
        if (accessor == null) {
            XmlSerializerImpl.$$$reportNull$$$0(8);
        }
        if (valueClass == null) {
            XmlSerializerImpl.$$$reportNull$$$0(9);
        }
        if (value == null) {
            accessor.set(host, null);
        } else if (valueClass == String.class) {
            accessor.set(host, value);
        } else if (valueClass == Integer.TYPE) {
            accessor.setInt(host, Integer.parseInt(value));
        } else if (valueClass == Boolean.TYPE) {
            accessor.setBoolean(host, Boolean.parseBoolean(value));
        } else if (valueClass == Double.TYPE) {
            accessor.setDouble(host, Double.parseDouble(value));
        } else if (valueClass == Float.TYPE) {
            accessor.setFloat(host, Float.parseFloat(value));
        } else if (valueClass == Long.TYPE) {
            accessor.setLong(host, Long.parseLong(value));
        } else if (valueClass == Short.TYPE) {
            accessor.setShort(host, Short.parseShort(value));
        } else if (valueClass.isEnum()) {
            accessor.set(host, ClassUtil.stringToEnum(value, valueClass, false));
        } else if (Date.class.isAssignableFrom(valueClass)) {
            try {
                accessor.set(host, new Date(Long.parseLong(value)));
            }
            catch (NumberFormatException e2) {
                accessor.set(host, new Date(0L));
            }
        } else {
            Object deserializedValue = value;
            if (valueClass == Boolean.class) {
                deserializedValue = Boolean.parseBoolean(value);
            } else if (valueClass == Integer.class) {
                deserializedValue = Integer.parseInt(value);
            } else if (valueClass == Short.class) {
                deserializedValue = Short.parseShort(value);
            } else if (valueClass == Long.class) {
                deserializedValue = Long.parseLong(value);
            } else if (valueClass == Double.class) {
                deserializedValue = Double.parseDouble(value);
            } else if (valueClass == Float.class) {
                deserializedValue = Float.valueOf(Float.parseFloat(value));
            } else if (XmlSerializerImpl.callFromStringIfDefined(host, value, accessor, valueClass)) {
                return;
            }
            accessor.set(host, deserializedValue);
        }
    }

    private static boolean callFromStringIfDefined(@NotNull Object host, @NotNull String value, @NotNull MutableAccessor accessor, @NotNull Class<?> valueClass) {
        Method fromText;
        if (host == null) {
            XmlSerializerImpl.$$$reportNull$$$0(10);
        }
        if (value == null) {
            XmlSerializerImpl.$$$reportNull$$$0(11);
        }
        if (accessor == null) {
            XmlSerializerImpl.$$$reportNull$$$0(12);
        }
        if (valueClass == null) {
            XmlSerializerImpl.$$$reportNull$$$0(13);
        }
        try {
            fromText = valueClass.getMethod("fromText", String.class);
        }
        catch (NoSuchMethodException ignored) {
            return false;
        }
        try {
            fromText.setAccessible(true);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        try {
            accessor.set(host, fromText.invoke(null, value));
            return true;
        }
        catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
            return false;
        }
    }

    @NotNull
    static String convertToString(@NotNull Object value) {
        if (value == null) {
            XmlSerializerImpl.$$$reportNull$$$0(14);
        }
        if (value instanceof Date) {
            String string2 = Long.toString(((Date)value).getTime());
            if (string2 == null) {
                XmlSerializerImpl.$$$reportNull$$$0(15);
            }
            return string2;
        }
        String string3 = value.toString();
        if (string3 == null) {
            XmlSerializerImpl.$$$reportNull$$$0(16);
        }
        return string3;
    }

    @NotNull
    static String getTextValue(@NotNull Element element, @NotNull String defaultText) {
        if (element == null) {
            XmlSerializerImpl.$$$reportNull$$$0(17);
        }
        if (defaultText == null) {
            XmlSerializerImpl.$$$reportNull$$$0(18);
        }
        List<Content> content = element.getContent();
        int size = content.size();
        StringBuilder builder = null;
        for (int i2 = 0; i2 < size; ++i2) {
            Content child = content.get(i2);
            if (!(child instanceof Text)) continue;
            String value = child.getValue();
            if (builder == null && i2 == size - 1) {
                String string2 = value;
                if (string2 == null) {
                    XmlSerializerImpl.$$$reportNull$$$0(19);
                }
                return string2;
            }
            if (builder == null) {
                builder = new StringBuilder();
            }
            builder.append(value);
        }
        String string3 = builder == null ? defaultText : builder.toString();
        if (string3 == null) {
            XmlSerializerImpl.$$$reportNull$$$0(20);
        }
        return string3;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string2;
        switch (n2) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 15: 
            case 16: 
            case 19: 
            case 20: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 15: 
            case 16: 
            case 19: 
            case 20: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serializer";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 4: 
            case 5: 
            case 15: 
            case 16: 
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/xmlb/XmlSerializerImpl";
                break;
            }
            case 6: 
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueClass";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "host";
                break;
            }
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "accessor";
                break;
            }
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultText";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/xmlb/XmlSerializerImpl";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "serialize";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "convertToString";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextValue";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createClassBinding";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "serialize";
                break;
            }
            case 4: 
            case 5: 
            case 15: 
            case 16: 
            case 19: 
            case 20: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "convert";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "doSet";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "callFromStringIfDefined";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "convertToString";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getTextValue";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 4: 
            case 5: 
            case 15: 
            case 16: 
            case 19: 
            case 20: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    static final class XmlSerializer
    extends XmlSerializerBase {
        private Reference<Map<Type, Binding>> bindings;

        XmlSerializer() {
        }

        @NotNull
        private Map<Type, Binding> getBindingCacheMap() {
            Map<Type, Binding> map2;
            Map<Type, Binding> map3 = map2 = this.bindings == null ? null : this.bindings.get();
            if (map2 == null) {
                map2 = new ConcurrentHashMap<Type, Binding>();
                this.bindings = new SoftReference<Map<Type, Binding>>(map2);
            }
            Map<Type, Binding> map4 = map2;
            if (map4 == null) {
                XmlSerializer.$$$reportNull$$$0(0);
            }
            return map4;
        }

        @Override
        @NotNull
        public synchronized Binding getRootBinding(@NotNull Class<?> aClass, @NotNull Type originalType) {
            Map<Type, Binding> map2;
            Binding binding;
            if (aClass == null) {
                XmlSerializer.$$$reportNull$$$0(1);
            }
            if (originalType == null) {
                XmlSerializer.$$$reportNull$$$0(2);
            }
            if ((binding = (map2 = this.getBindingCacheMap()).get(originalType)) == null) {
                binding = XmlSerializerImpl.createClassBinding(aClass, null, originalType, this);
                if (binding == null) {
                    binding = new BeanBinding(aClass);
                }
                map2.put(originalType, binding);
                try {
                    binding.init(originalType, this);
                }
                catch (Error | RuntimeException e2) {
                    map2.remove(originalType);
                    throw e2;
                }
            }
            Binding binding2 = binding;
            if (binding2 == null) {
                XmlSerializer.$$$reportNull$$$0(3);
            }
            return binding2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n2) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n3;
            String string2;
            switch (n2) {
                default: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n2) {
                default: {
                    n3 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n3 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/util/xmlb/XmlSerializerImpl$XmlSerializer";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "aClass";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "originalType";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getBindingCacheMap";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/util/xmlb/XmlSerializerImpl$XmlSerializer";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRootBinding";
                    break;
                }
            }
            switch (n2) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getRootBinding";
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n2) {
                default: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static abstract class XmlSerializerBase
    implements Serializer {
        @Override
        @Nullable
        public final Binding getBinding(@NotNull Class<?> aClass, @NotNull Type type2) {
            if (aClass == null) {
                XmlSerializerBase.$$$reportNull$$$0(0);
            }
            if (type2 == null) {
                XmlSerializerBase.$$$reportNull$$$0(1);
            }
            return ClassUtil.isPrimitive(aClass) ? null : this.getRootBinding(aClass, type2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n2) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "aClass";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "type";
                    break;
                }
            }
            objectArray[1] = "com/intellij/util/xmlb/XmlSerializerImpl$XmlSerializerBase";
            objectArray[2] = "getBinding";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

