/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer;

import io.netty.buffer.ByteBuf;
import io.netty.util.CharsetUtil;
import io.netty.util.internal.ObjectUtil;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class ByteBufOutputStream
extends OutputStream
implements DataOutput {
    private final ByteBuf buffer;
    private final int startIndex;
    private DataOutputStream utf8out;
    private boolean closed;

    public ByteBufOutputStream(ByteBuf buffer) {
        this.buffer = ObjectUtil.checkNotNull(buffer, "buffer");
        this.startIndex = buffer.writerIndex();
    }

    public int writtenBytes() {
        return this.buffer.writerIndex() - this.startIndex;
    }

    @Override
    public void write(byte[] b2, int off, int len) throws IOException {
        if (len == 0) {
            return;
        }
        this.buffer.writeBytes(b2, off, len);
    }

    @Override
    public void write(byte[] b2) throws IOException {
        this.buffer.writeBytes(b2);
    }

    @Override
    public void write(int b2) throws IOException {
        this.buffer.writeByte(b2);
    }

    @Override
    public void writeBoolean(boolean v2) throws IOException {
        this.buffer.writeBoolean(v2);
    }

    @Override
    public void writeByte(int v2) throws IOException {
        this.buffer.writeByte(v2);
    }

    @Override
    public void writeBytes(String s2) throws IOException {
        this.buffer.writeCharSequence(s2, CharsetUtil.US_ASCII);
    }

    @Override
    public void writeChar(int v2) throws IOException {
        this.buffer.writeChar(v2);
    }

    @Override
    public void writeChars(String s2) throws IOException {
        int len = s2.length();
        for (int i2 = 0; i2 < len; ++i2) {
            this.buffer.writeChar(s2.charAt(i2));
        }
    }

    @Override
    public void writeDouble(double v2) throws IOException {
        this.buffer.writeDouble(v2);
    }

    @Override
    public void writeFloat(float v2) throws IOException {
        this.buffer.writeFloat(v2);
    }

    @Override
    public void writeInt(int v2) throws IOException {
        this.buffer.writeInt(v2);
    }

    @Override
    public void writeLong(long v2) throws IOException {
        this.buffer.writeLong(v2);
    }

    @Override
    public void writeShort(int v2) throws IOException {
        this.buffer.writeShort((short)v2);
    }

    @Override
    public void writeUTF(String s2) throws IOException {
        DataOutputStream out = this.utf8out;
        if (out == null) {
            if (this.closed) {
                throw new IOException("The stream is closed");
            }
            this.utf8out = out = new DataOutputStream(this);
        }
        out.writeUTF(s2);
    }

    public ByteBuf buffer() {
        return this.buffer;
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        try {
            super.close();
        }
        finally {
            if (this.utf8out != null) {
                this.utf8out.close();
            }
        }
    }
}

