/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.stax2.ri.evt;

import java.io.IOException;
import java.io.Writer;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.events.StartDocument;
import org.codehaus.stax2.XMLStreamWriter2;
import org.codehaus.stax2.ri.evt.BaseEventImpl;

public class StartDocumentEventImpl
extends BaseEventImpl
implements StartDocument {
    private final boolean mStandaloneSet;
    private final boolean mIsStandalone;
    private final String mVersion;
    private final boolean mEncodingSet;
    private final String mEncodingScheme;
    private final String mSystemId;

    public StartDocumentEventImpl(Location loc, XMLStreamReader r2) {
        super(loc);
        this.mStandaloneSet = r2.standaloneSet();
        this.mIsStandalone = r2.isStandalone();
        String version = r2.getVersion();
        if (version == null || version.length() == 0) {
            version = "1.0";
        }
        this.mVersion = version;
        this.mEncodingScheme = r2.getCharacterEncodingScheme();
        this.mEncodingSet = this.mEncodingScheme != null && this.mEncodingScheme.length() > 0;
        this.mSystemId = loc != null ? loc.getSystemId() : "";
    }

    public StartDocumentEventImpl(Location loc) {
        this(loc, (String)null);
    }

    public StartDocumentEventImpl(Location loc, String encoding) {
        this(loc, encoding, null);
    }

    public StartDocumentEventImpl(Location loc, String encoding, String version) {
        this(loc, encoding, version, false, false);
    }

    public StartDocumentEventImpl(Location loc, String encoding, String version, boolean standaloneSet, boolean isStandalone) {
        super(loc);
        this.mEncodingScheme = encoding;
        this.mEncodingSet = encoding != null && encoding.length() > 0;
        this.mVersion = version;
        this.mStandaloneSet = standaloneSet;
        this.mIsStandalone = isStandalone;
        this.mSystemId = "";
    }

    @Override
    public boolean encodingSet() {
        return this.mEncodingSet;
    }

    @Override
    public String getCharacterEncodingScheme() {
        return this.mEncodingScheme;
    }

    @Override
    public String getSystemId() {
        return this.mSystemId;
    }

    @Override
    public String getVersion() {
        return this.mVersion;
    }

    @Override
    public boolean isStandalone() {
        return this.mIsStandalone;
    }

    @Override
    public boolean standaloneSet() {
        return this.mStandaloneSet;
    }

    @Override
    public int getEventType() {
        return 7;
    }

    @Override
    public boolean isStartDocument() {
        return true;
    }

    @Override
    public void writeAsEncodedUnicode(Writer w2) throws XMLStreamException {
        try {
            w2.write("<?xml version=\"");
            if (this.mVersion == null || this.mVersion.length() == 0) {
                w2.write("1.0");
            } else {
                w2.write(this.mVersion);
            }
            w2.write(34);
            if (this.mEncodingSet) {
                w2.write(" encoding=\"");
                w2.write(this.mEncodingScheme);
                w2.write(34);
            }
            if (this.mStandaloneSet) {
                if (this.mIsStandalone) {
                    w2.write(" standalone=\"yes\"");
                } else {
                    w2.write(" standalone=\"no\"");
                }
            }
            w2.write(" ?>");
        }
        catch (IOException ie) {
            this.throwFromIOE(ie);
        }
    }

    @Override
    public void writeUsing(XMLStreamWriter2 w2) throws XMLStreamException {
        w2.writeStartDocument();
    }

    @Override
    public boolean equals(Object o2) {
        if (o2 == this) {
            return true;
        }
        if (o2 == null) {
            return false;
        }
        if (!(o2 instanceof StartDocument)) {
            return false;
        }
        StartDocument other = (StartDocument)o2;
        return this.encodingSet() == other.encodingSet() && this.isStandalone() == other.isStandalone() && this.standaloneSet() == other.standaloneSet() && StartDocumentEventImpl.stringsWithNullsEqual(this.getCharacterEncodingScheme(), other.getCharacterEncodingScheme()) && StartDocumentEventImpl.stringsWithNullsEqual(this.getSystemId(), other.getSystemId()) && StartDocumentEventImpl.stringsWithNullsEqual(this.getVersion(), other.getVersion());
    }

    @Override
    public int hashCode() {
        int hash = 0;
        if (this.encodingSet()) {
            ++hash;
        }
        if (this.isStandalone()) {
            --hash;
        }
        if (this.standaloneSet()) {
            hash ^= 1;
        }
        if (this.mVersion != null) {
            hash ^= this.mVersion.hashCode();
        }
        if (this.mEncodingScheme != null) {
            hash ^= this.mEncodingScheme.hashCode();
        }
        if (this.mSystemId != null) {
            hash ^= this.mSystemId.hashCode();
        }
        return hash;
    }
}

