/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdclient.ui.diff;

import com.intellij.diff.util.DiffDrawUtil;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.Range;
import com.intellij.diff.util.TextDiffType;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.EditorMarkupModel;
import com.intellij.openapi.editor.ex.EditorPopupHandler;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.impl.ContextMenuPopupHandler;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.util.IntPair;
import com.jetbrains.rd.actions.ActionProvider;
import com.jetbrains.rd.ide.model.ActionRegistrationModel;
import com.jetbrains.rd.ide.model.BackgroundType;
import com.jetbrains.rd.ide.model.BorderType;
import com.jetbrains.rd.ide.model.DiffMarkerType;
import com.jetbrains.rd.ide.model.DiffPaintMode;
import com.jetbrains.rdclient.ui.diff.ChangedBlock;
import com.jetbrains.rdclient.ui.diff.UnifiedChangedBlock;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000V\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u001a\u001e\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010\u001a\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u001a\n\u0010\u0016\u001a\u00020\u0017*\u00020\u0018\u001a\n\u0010\u0019\u001a\u00020\u001a*\u00020\u001b\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u0015\u0010\u0000\u001a\u00020\u0005*\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0007\u00a8\u0006\u001c"}, d2={"lineRange", "Lcom/intellij/diff/util/Range;", "Lcom/jetbrains/rdclient/ui/diff/ChangedBlock;", "getLineRange", "(Lcom/jetbrains/rdclient/ui/diff/ChangedBlock;)Lcom/intellij/diff/util/Range;", "Lcom/intellij/util/IntPair;", "Lcom/jetbrains/rdclient/ui/diff/UnifiedChangedBlock;", "(Lcom/jetbrains/rdclient/ui/diff/UnifiedChangedBlock;)Lcom/intellij/util/IntPair;", "getGroup", "Lcom/intellij/openapi/actionSystem/ActionGroup;", "group", "Lcom/jetbrains/rd/ide/model/ActionRegistrationModel;", "getHighlighterLineRange", "highlighter", "Lcom/intellij/openapi/editor/ex/RangeHighlighterEx;", "isEmptyRange", "", "isEOF", "setupDiffEditor", "", "editor", "Lcom/intellij/openapi/editor/ex/EditorEx;", "fromModel", "Lcom/intellij/diff/util/DiffDrawUtil$PaintMode;", "Lcom/jetbrains/rd/ide/model/DiffPaintMode;", "toTextDiffType", "Lcom/intellij/diff/util/TextDiffType;", "Lcom/jetbrains/rd/ide/model/DiffMarkerType;", "intellij.rd.client"})
public final class UtilKt {
    public static final void setupDiffEditor(@NotNull EditorEx editor2, @Nullable ActionRegistrationModel group) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        if (editor2 instanceof EditorImpl) {
            ((EditorImpl)editor2).suppressDisposedPainting(true);
        }
        DiffUtil.setFoldingModelSupport((EditorEx)editor2);
        editor2.getSettings().setCaretRowShown(false);
        MarkupModelEx markupModelEx = editor2.getMarkupModel();
        Intrinsics.checkNotNull((Object)markupModelEx, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.ex.EditorMarkupModel");
        ((EditorMarkupModel)markupModelEx).setErrorStripeVisible(true);
        editor2.installPopupHandler((EditorPopupHandler)new ContextMenuPopupHandler.Simple(UtilKt.getGroup(group)));
        editor2.reinitSettings();
    }

    @Nullable
    public static final ActionGroup getGroup(@Nullable ActionRegistrationModel group) {
        AnAction anAction = ActionProvider.Companion.getAction(group);
        return anAction instanceof ActionGroup ? (ActionGroup)anAction : null;
    }

    @NotNull
    public static final TextDiffType toTextDiffType(@NotNull DiffMarkerType $this$toTextDiffType) {
        TextDiffType textDiffType;
        Intrinsics.checkNotNullParameter((Object)$this$toTextDiffType, (String)"<this>");
        if ($this$toTextDiffType == DiffMarkerType.INSERTED) {
            TextDiffType textDiffType2 = TextDiffType.INSERTED;
            textDiffType = textDiffType2;
            Intrinsics.checkNotNullExpressionValue((Object)textDiffType2, (String)"INSERTED");
        } else if ($this$toTextDiffType == DiffMarkerType.DELETED) {
            TextDiffType textDiffType3 = TextDiffType.DELETED;
            textDiffType = textDiffType3;
            Intrinsics.checkNotNullExpressionValue((Object)textDiffType3, (String)"DELETED");
        } else {
            TextDiffType textDiffType4 = TextDiffType.MODIFIED;
            textDiffType = textDiffType4;
            Intrinsics.checkNotNullExpressionValue((Object)textDiffType4, (String)"MODIFIED");
        }
        return textDiffType;
    }

    @NotNull
    public static final DiffDrawUtil.PaintMode fromModel(@NotNull DiffPaintMode $this$fromModel) {
        Intrinsics.checkNotNullParameter((Object)$this$fromModel, (String)"<this>");
        DiffDrawUtil.BackgroundType background = switch (WhenMappings.$EnumSwitchMapping$0[$this$fromModel.getBackgroundType().ordinal()]) {
            case 1 -> DiffDrawUtil.BackgroundType.NONE;
            case 2 -> DiffDrawUtil.BackgroundType.DEFAULT;
            case 3 -> DiffDrawUtil.BackgroundType.IGNORED;
            default -> throw new NoWhenBranchMatchedException();
        };
        DiffDrawUtil.BorderType border = switch (WhenMappings.$EnumSwitchMapping$1[$this$fromModel.getBorderType().ordinal()]) {
            case 1 -> DiffDrawUtil.BorderType.NONE;
            case 2 -> DiffDrawUtil.BorderType.LINE;
            case 3 -> DiffDrawUtil.BorderType.DOTTED;
            default -> throw new NoWhenBranchMatchedException();
        };
        return new DiffDrawUtil.PaintMode(background, border);
    }

    @NotNull
    public static final IntPair getHighlighterLineRange(@NotNull RangeHighlighterEx highlighter2, boolean isEmptyRange, boolean isEOF) {
        int endLine;
        Intrinsics.checkNotNullParameter((Object)highlighter2, (String)"highlighter");
        Document document = highlighter2.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        Document document2 = document;
        int startLine = document2.getLineNumber(highlighter2.getAffectedAreaStartOffset());
        int n = isEOF ? DiffUtil.getLineCount((Document)document2) : (endLine = isEmptyRange ? startLine : document2.getLineNumber(highlighter2.getAffectedAreaEndOffset()));
        if (isEOF && isEmptyRange) {
            return new IntPair(endLine, endLine);
        }
        return new IntPair(startLine, endLine);
    }

    @NotNull
    public static final Range getLineRange(@NotNull ChangedBlock $this$lineRange) {
        Intrinsics.checkNotNullParameter((Object)$this$lineRange, (String)"<this>");
        IntPair lines1 = UtilKt.getHighlighterLineRange($this$lineRange.getHighlighter1(), $this$lineRange.getBlockModel1().isEmptyRange(), $this$lineRange.getBlockModel1().isEOF());
        IntPair lines2 = UtilKt.getHighlighterLineRange($this$lineRange.getHighlighter2(), $this$lineRange.getBlockModel2().isEmptyRange(), $this$lineRange.getBlockModel2().isEOF());
        return new Range(lines1.first, lines1.second, lines2.first, lines2.second);
    }

    @NotNull
    public static final IntPair getLineRange(@NotNull UnifiedChangedBlock $this$lineRange) {
        Intrinsics.checkNotNullParameter((Object)$this$lineRange, (String)"<this>");
        return UtilKt.getHighlighterLineRange($this$lineRange.getHighlighter(), $this$lineRange.getBlockModel().isEmptyRange(), $this$lineRange.getBlockModel().isEOF());
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[BackgroundType.values().length];
            try {
                nArray[BackgroundType.NONE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BackgroundType.DEFAULT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BackgroundType.IGNORED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[BorderType.values().length];
            try {
                nArray[BorderType.NONE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BorderType.LINE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BorderType.DOTTED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

