/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.auth.postgresql.conf;

import java.io.File;
import org.apache.guacamole.GuacamoleException;
import org.apache.guacamole.auth.jdbc.JDBCEnvironment;
import org.apache.guacamole.auth.jdbc.security.PasswordPolicy;
import org.apache.guacamole.auth.postgresql.conf.PostgreSQLGuacamoleProperties;
import org.apache.guacamole.auth.postgresql.conf.PostgreSQLPasswordPolicy;
import org.apache.guacamole.auth.postgresql.conf.PostgreSQLSSLMode;
import org.apache.guacamole.properties.GuacamoleProperty;
import org.apache.ibatis.session.SqlSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PostgreSQLEnvironment
extends JDBCEnvironment {
    private static final Logger logger = LoggerFactory.getLogger(PostgreSQLEnvironment.class);
    private static final String DEFAULT_HOSTNAME = "localhost";
    private static final int DEFAULT_PORT = 5432;
    private static final int DEFAULT_STATEMENT_TIMEOUT = 0;
    private static final int DEFAULT_SOCKET_TIMEOUT = 0;
    private static final boolean DEFAULT_USER_REQUIRED = false;
    private final int DEFAULT_ABSOLUTE_MAX_CONNECTIONS = 0;
    private final int DEFAULT_MAX_CONNECTIONS_PER_USER = 1;
    private final int DEFAULT_MAX_GROUP_CONNECTIONS_PER_USER = 1;
    private final int DEFAULT_MAX_CONNECTIONS = 0;
    private final int DEFAULT_MAX_GROUP_CONNECTIONS = 0;
    private final PostgreSQLSSLMode DEFAULT_SSL_MODE = PostgreSQLSSLMode.PREFER;
    private static final int DEFAULT_BATCH_SIZE = 5000;

    public boolean isUserRequired() throws GuacamoleException {
        return (Boolean)this.getProperty((GuacamoleProperty)PostgreSQLGuacamoleProperties.POSTGRESQL_USER_REQUIRED, false);
    }

    public int getAbsoluteMaxConnections() throws GuacamoleException {
        return (Integer)this.getProperty((GuacamoleProperty)PostgreSQLGuacamoleProperties.POSTGRESQL_ABSOLUTE_MAX_CONNECTIONS, 0);
    }

    public int getBatchSize() throws GuacamoleException {
        return (Integer)this.getProperty((GuacamoleProperty)PostgreSQLGuacamoleProperties.POSTGRESQL_BATCH_SIZE, 5000);
    }

    public int getDefaultMaxConnections() throws GuacamoleException {
        return (Integer)this.getProperty((GuacamoleProperty)PostgreSQLGuacamoleProperties.POSTGRESQL_DEFAULT_MAX_CONNECTIONS, 0);
    }

    public int getDefaultMaxGroupConnections() throws GuacamoleException {
        return (Integer)this.getProperty((GuacamoleProperty)PostgreSQLGuacamoleProperties.POSTGRESQL_DEFAULT_MAX_GROUP_CONNECTIONS, 0);
    }

    public int getDefaultMaxConnectionsPerUser() throws GuacamoleException {
        return (Integer)this.getProperty((GuacamoleProperty)PostgreSQLGuacamoleProperties.POSTGRESQL_DEFAULT_MAX_CONNECTIONS_PER_USER, 1);
    }

    public int getDefaultMaxGroupConnectionsPerUser() throws GuacamoleException {
        return (Integer)this.getProperty((GuacamoleProperty)PostgreSQLGuacamoleProperties.POSTGRESQL_DEFAULT_MAX_GROUP_CONNECTIONS_PER_USER, 1);
    }

    public PasswordPolicy getPasswordPolicy() {
        return new PostgreSQLPasswordPolicy(this);
    }

    public String getPostgreSQLHostname() throws GuacamoleException {
        return (String)this.getProperty((GuacamoleProperty)PostgreSQLGuacamoleProperties.POSTGRESQL_HOSTNAME, DEFAULT_HOSTNAME);
    }

    public int getPostgreSQLPort() throws GuacamoleException {
        return (Integer)this.getProperty((GuacamoleProperty)PostgreSQLGuacamoleProperties.POSTGRESQL_PORT, 5432);
    }

    public String getPostgreSQLDatabase() throws GuacamoleException {
        return (String)this.getRequiredProperty((GuacamoleProperty)PostgreSQLGuacamoleProperties.POSTGRESQL_DATABASE);
    }

    public String getUsername() throws GuacamoleException {
        return (String)this.getRequiredProperty((GuacamoleProperty)PostgreSQLGuacamoleProperties.POSTGRESQL_USERNAME);
    }

    public String getPassword() throws GuacamoleException {
        return (String)this.getRequiredProperty((GuacamoleProperty)PostgreSQLGuacamoleProperties.POSTGRESQL_PASSWORD);
    }

    public int getPostgreSQLDefaultStatementTimeout() throws GuacamoleException {
        return (Integer)this.getProperty((GuacamoleProperty)PostgreSQLGuacamoleProperties.POSTGRESQL_DEFAULT_STATEMENT_TIMEOUT, 0);
    }

    public int getPostgreSQLSocketTimeout() throws GuacamoleException {
        return (Integer)this.getProperty((GuacamoleProperty)PostgreSQLGuacamoleProperties.POSTGRESQL_SOCKET_TIMEOUT, 0);
    }

    public boolean isRecursiveQuerySupported(SqlSession session) {
        return true;
    }

    public PostgreSQLSSLMode getPostgreSQLSSLMode() throws GuacamoleException {
        return (PostgreSQLSSLMode)((Object)this.getProperty((GuacamoleProperty)PostgreSQLGuacamoleProperties.POSTGRESQL_SSL_MODE, (Object)this.DEFAULT_SSL_MODE));
    }

    public File getPostgreSQLSSLClientCertFile() throws GuacamoleException {
        return (File)this.getProperty((GuacamoleProperty)PostgreSQLGuacamoleProperties.POSTGRESQL_SSL_CERT_FILE);
    }

    public File getPostgreSQLSSLClientKeyFile() throws GuacamoleException {
        return (File)this.getProperty((GuacamoleProperty)PostgreSQLGuacamoleProperties.POSTGRESQL_SSL_KEY_FILE);
    }

    public File getPostgreSQLSSLClientRootCertFile() throws GuacamoleException {
        return (File)this.getProperty((GuacamoleProperty)PostgreSQLGuacamoleProperties.POSTGRESQL_SSL_ROOT_CERT_FILE);
    }

    public String getPostgreSQLSSLClientKeyPassword() throws GuacamoleException {
        return (String)this.getProperty((GuacamoleProperty)PostgreSQLGuacamoleProperties.POSTGRESQL_SSL_KEY_PASSWORD);
    }

    public boolean autoCreateAbsentAccounts() throws GuacamoleException {
        return (Boolean)this.getProperty((GuacamoleProperty)PostgreSQLGuacamoleProperties.POSTGRESQL_AUTO_CREATE_ACCOUNTS, false);
    }
}

