;;;; dbide-data.el --- DocBook IDE element and attribute data
;; $Id: dbide-data.el,v 1.2 2000/03/29 19:12:16 nwalsh Exp $

;; Copyright (C) 2000 Norman Walsh
;; Based extensively on (one might go so far as to say "totally hacked
;; from") Tony Graham's xslide.

;; Author: Norman Walsh <ndw@nwalsh.com>
;; Created: 29 March 2000
;; Version: $Revision: 1.2 $
;; Keywords: languages, xml, docbook

;; Changes:

;; 2002-06-12 Ville Skytt
;; - Updated to DocBook 4.1.2
;;   - Added "condition" and "security" to common attributes.
;;   - Marked attributes and elements that have been removed.

;;; This file is not part of GNU Emacs.

;; This program is free software; you can redistribute it and/or
;; modify it under the terms of the GNU General Public License
;; as published by the Free Software Foundation; either version 2
;; of the License, or (at your option) any later version.
;; 
;; This program is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.
;; 
;; You should have received a copy of the GNU General Public License
;; along with this program; if not, write to the Free Software
;; Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.


;;;; Commentary:

;; Data about elements and attributes in DOCBOOK documents collected
;; in one place

;; Send bugs to docbookide-bug@menteith.com
;; Use `docbook-submit-bug-report' for bug reports


;;;; Variables

;; These are broken into separate lists to avoid problems with nesting
;; depth

(defvar docbook-element-symbol-alist
  (list
    '("abbrev"
      "inline"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "userlevel" "vendor" "xreflabel")
      "xabbrev")
    '("abstract"
      "block"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "userlevel" "vendor" "xreflabel")
      "xabstract")
    '("accel"
      "inline"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "userlevel" "vendor" "xreflabel")
      "xaccel")
    '("ackno"
      "block"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "userlevel" "vendor" "xreflabel")
      "xackno")
    '("acronym"
      "inline"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "userlevel" "vendor" "xreflabel")
      "xacronym")
    '("action"
      "inline"
      ("arch" "condition" "conformance" "id" "lang" "moreinfo" "os" "remap"
       "revision" "revisionflag" "role" "security" "userlevel" "vendor"
       "xreflabel")
      "xaction")
    '("address"
      "block"
      ("arch" "condition" "conformance" "format" "id" "lang" "linenumbering"
       "os" "remap" "revision" "revisionflag" "role" "security" "userlevel"
       "vendor" "xreflabel")
      "xaddress")
    '("affiliation"
      "block"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "userlevel" "vendor" "xreflabel")
      "xaffiliation")
    '("alt"
      "block"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "userlevel" "vendor" "xreflabel")
      "xalt")
    '("anchor"
      "empty"
      ("arch" "condition" "conformance" "id" "lang" "os" "pagenum" "remap"
       "revision" "revisionflag" "role" "security" "userlevel" "vendor"
       "xreflabel")
      "xanchor")
    '("answer"
      "block"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "userlevel" "vendor" "xreflabel")
      "xanswer")
    '("appendix"
      "block"
      ("arch" "condition" "conformance" "id" "label" "lang" "os" "remap"
       "revision" "revisionflag" "role" "security" "status" "userlevel"
       "vendor" "xreflabel")
      "xappendix")
    '("appendixinfo"
      "block"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "userlevel" "vendor" "xreflabel")
      "xappendixinfo")
    '("application"
      "inline"
      ("arch" "class" "condition" "conformance" "id" "lang" "moreinfo" "os"
       "remap" "revision" "revisionflag" "role" "security" "userlevel" "vendor"
       "xreflabel")
      "xapplication")
    '("area"
      "empty"
      ("arch" "condition" "conformance" "coords" "id" "label" "lang" "linkends"
       "os" "otherunits" "remap" "revision" "revisionflag" "role" "units"
       "userlevel" "vendor" "xreflabel")
      "xarea")
    '("areaset"
      "block"
      ("arch" "condition" "conformance" "coords" "id" "label" "lang" "os"
       "otherunits" "remap" "revision" "revisionflag" "role" "units"
       "userlevel" "vendor" "xreflabel")
      "xareaset")
    '("areaspec"
      "block"
      ("arch" "condition" "conformance" "id" "lang" "os" "otherunits" "remap"
       "revision" "revisionflag" "role" "units" "userlevel" "vendor"
       "xreflabel")
      "xareaspec")
    '("arg"
      "inline"
      ("arch" "choice" "condition" "conformance" "id" "lang" "os" "remap" "rep"
       "revision" "revisionflag" "role" "security" "userlevel" "vendor"
       "xreflabel")
      "xarg")
    '("artheader"
      "block"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "userlevel" "vendor" "xreflabel")
      "xartheader")
    '("article"
      "block"
      ("arch" "class" "condition" "conformance" "id" "lang" "os" "parentbook"
       "remap" "revision" "revisionflag" "role" "security" "status" "userlevel"
       "vendor" "xreflabel")
      "xarticle")
    '("articleinfo"
      "block"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "userlevel" "vendor" "xreflabel")
      "xarticleinfo")
    '("artpagenums"
      "inline"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "userlevel" "vendor" "xreflabel")
      "xartpagenums")
    '("attribution"
      "block"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "userlevel" "vendor" "xreflabel")
      "xattribution")
    '("audiodata"
      "block"
      ("arch" "condition" "conformance" "entityref" "fileref" "format" "id"
       "lang" "os" "remap" "revision" "revisionflag" "role" "srccredit"
       "userlevel" "vendor" "xreflabel")
      "xaudiodata")
    '("audioobject"
      "block"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "userlevel" "vendor" "xreflabel")
      "xaudioobject")
    '("author"
      "inline"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "userlevel" "vendor" "xreflabel")
      "xauthor")
    '("authorblurb"
      "block"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "userlevel" "vendor" "xreflabel")
      "xauthorblurb")
    '("authorgroup"
      "block"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "userlevel" "vendor" "xreflabel")
      "xauthorgroup")
    '("authorinitials"
      "inline"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "userlevel" "vendor" "xreflabel")
      "xauthorinitials")))

(defvar docbook-element-symbol-alist-1
  (list
    '("beginpage"
      "empty"
      ("arch" "condition" "conformance" "id" "lang" "os" "pagenum" "remap"
       "revision" "revisionflag" "role" "security" "userlevel" "vendor"
       "xreflabel")
      "xbeginpage")
    '("bibliodiv"
      "block"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "status" "userlevel" "vendor"
       "xreflabel")
      "xbibliodiv")
    '("biblioentry"
      "block"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "userlevel" "vendor" "xreflabel")
      "xbiblioentry")
    '("bibliography"
      "block"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "status" "userlevel" "vendor"
       "xreflabel")
      "xbibliography")
    '("bibliographyinfo"
      "block"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "userlevel" "vendor" "xreflabel")
      "xbibliographyinfo")
    '("bibliomisc"
      "block"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "userlevel" "vendor" "xreflabel")
      "xbibliomisc")
    '("bibliomixed"
      "block"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "userlevel" "vendor" "xreflabel")
      "xbibliomixed")
    '("bibliomset"
      "block"
      ("arch" "condition" "conformance" "id" "lang" "os" "relation" "remap"
       "revision" "revisionflag" "role" "security" "userlevel" "vendor"
       "xreflabel")
      "xbibliomset")
    '("biblioset"
      "block"
      ("arch" "condition" "conformance" "id" "lang" "os" "relation" "remap"
       "revision" "revisionflag" "role" "security" "userlevel" "vendor"
       "xreflabel")
      "xbiblioset")
    '("blockquote"
      "block"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "userlevel" "vendor" "xreflabel")
      "xblockquote")
    '("book"
      "block"
      ("arch" "condition" "conformance" "fpi" "id" "label" "lang" "os" "remap"
       "revision" "revisionflag" "role" "security" "status" "userlevel"
       "vendor" "xreflabel")
      "xbook")
    ;; Removed in DocBook XML 4.1.
    '("bookbiblio"
      "block"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "userlevel" "vendor" "xreflabel")
      "xbookbiblio")
    '("bookinfo"
      "block"
      ("arch" "condition" "conformance" "contents" "id" "lang" "os" "remap"
       "revision" "revisionflag" "role" "security" "userlevel" "vendor"
       "xreflabel")
      "xbookinfo")
    '("bridgehead"
      "block"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "renderas"
       "revision" "revisionflag" "role" "security" "userlevel" "vendor"
       "xreflabel")
      "xbridgehead")
    '("callout"
      "block"
      ("arch" "arearefs" "condition" "conformance" "id" "lang" "os" "remap"
       "revision" "revisionflag" "role" "security" "userlevel" "vendor"
       "xreflabel")
      "xcallout")
    '("calloutlist"
      "block"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "userlevel" "vendor" "xreflabel")
      "xcalloutlist")
    '("caption"
      "block"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "userlevel" "vendor" "xreflabel")
      "xcaption")
    '("caution"
      "block"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "userlevel" "vendor" "xreflabel")
      "xcaution")
    '("chapter"
      "block"
      ("arch" "condition" "conformance" "id" "label" "lang" "os" "remap"
       "revision" "revisionflag" "role" "security" "status" "userlevel"
       "vendor" "xreflabel")
      "xchapter")
    '("chapterinfo"
      "block"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "userlevel" "vendor" "xreflabel")
      "xchapterinfo")
    '("citation"
      "inline"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "userlevel" "vendor" "xreflabel")
      "xcitation")
    '("citerefentry"
      "inline"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "userlevel" "vendor" "xreflabel")
      "xciterefentry")
    '("citetitle"
      "inline"
      ("arch" "condition" "conformance" "id" "lang" "os" "pubwork" "remap"
       "revision" "revisionflag" "role" "security" "userlevel" "vendor"
       "xreflabel")
      "xcitetitle")
    '("city"
      "inline"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "userlevel" "vendor" "xreflabel")
      "xcity")
    '("classname"
      "inline"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "userlevel" "vendor" "xreflabel")
      "xclassname")
    '("classsynopsis"
      "block"
      ("arch" "class" "condition" "conformance" "id" "lang" "language" "os"
       "remap" "revision" "revisionflag" "role" "security" "userlevel" "vendor"
       "xreflabel")
      "xclasssynopsis")
    '("classsynopsisinfo"
      "block"
      ("arch" "condition" "conformance" "format" "id" "lang" "linenumbering"
       "os" "remap" "revision" "revisionflag" "role" "security" "userlevel"
       "vendor" "xreflabel")
      "xclasssynopsisinfo")
    '("cmdsynopsis"
      "block"
      ("arch" "cmdlength" "condition" "conformance" "id" "label" "lang" "os"
       "remap" "revision" "revisionflag" "role" "sepchar" "userlevel" "vendor"
       "xreflabel")
      "xcmdsynopsis")
    '("co"
      "empty"
      ("arch" "condition" "conformance" "id" "label" "lang" "linkends" "os"
       "remap" "revision" "revisionflag" "role" "security" "userlevel" "vendor"
       "xreflabel")
      "xco")
    '("collab"
      "inline"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "userlevel" "vendor" "xreflabel")
      "xcollab")
    '("collabname"
      "inline"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "userlevel" "vendor" "xreflabel")
      "xcollabname")
    '("colophon"
      "block"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "status" "userlevel" "vendor"
       "xreflabel")
      "xcolophon")
    '("colspec"
      "block"
      ("align" "arch" "char" "charoff" "colname" "colnum" "colsep" "colwidth"
       "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "rowsep" "userlevel" "vendor" "xreflabel")
      "xcolspec")
    '("command"
      "inline"
      ("arch" "condition" "conformance" "id" "lang" "moreinfo" "os" "remap"
       "revision" "revisionflag" "role" "security" "userlevel" "vendor"
       "xreflabel")
      "xcommand")
    ;; Removed in DocBook XML 4.1, see "remark".
    '("comment"
      "inline"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "userlevel" "vendor" "xreflabel")
      "xcomment")
    '("computeroutput"
      "inline"
      ("arch" "condition" "conformance" "id" "lang" "moreinfo" "os" "remap"
       "revision" "revisionflag" "role" "security" "userlevel" "vendor"
       "xreflabel")
      "xcomputeroutput")
    '("confdates"
      "inline"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "userlevel" "vendor" "xreflabel")
      "xconfdates")
    '("confgroup"
      "inline"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "userlevel" "vendor" "xreflabel")
      "xconfgroup")
    '("confnum"
      "inline"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "userlevel" "vendor" "xreflabel")
      "xconfnum")
    '("confsponsor"
      "inline"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "userlevel" "vendor" "xreflabel")
      "xconfsponsor")
    '("conftitle"
      "inline"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "userlevel" "vendor" "xreflabel")
      "xconftitle")
    '("constant"
      "inline"
      ("arch" "class" "condition" "conformance" "id" "lang" "os" "remap"
       "revision" "revisionflag" "role" "security" "userlevel" "vendor"
       "xreflabel")
      "xconstant")
    '("constructorsynopsis"
      "block"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "userlevel" "vendor" "xreflabel")
      "xconstructorsynopsis")
    '("contractnum"
      "inline"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "userlevel" "vendor" "xreflabel")
      "xcontractnum")
    '("contractsponsor"
      "inline"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "userlevel" "vendor" "xreflabel")
      "xcontractsponsor")
    '("contrib"
      "inline"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "userlevel" "vendor" "xreflabel")
      "xcontrib")
    '("copyright"
      "inline"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "userlevel" "vendor" "xreflabel")
      "xcopyright")
    '("corpauthor"
      "inline"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision" "revisionflag" "role" "security" "userlevel" "vendor" "xreflabel")
      "xcorpauthor")
    '("corpname"
      "inline"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "userlevel" "vendor" "xreflabel")
      "xcorpname")
    '("country"
      "inline"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "userlevel" "vendor" "xreflabel")
      "xcountry")))

(defvar docbook-element-symbol-alist-2
  (list
    '("database"
      "inline"
      ("arch" "class" "condition" "conformance" "id" "lang" "moreinfo" "os"
       "remap" "revision" "revisionflag" "role" "security" "userlevel" "vendor"
       "xreflabel")
      "xdatabase")
    '("date"
      "inline"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "userlevel" "vendor" "xreflabel")
      "xdate")
    '("dedication"
      "block"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "status" "userlevel" "vendor"
       "xreflabel")
      "xdedication")
    '("destructorsynopsis"
      "block"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "userlevel" "vendor" "xreflabel")
      "xdestructorsynopsis")
    ;; Removed in DocBook XML 4.1.
    '("docinfo"
      "block"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "userlevel" "vendor" "xreflabel")
      "xdocinfo")
    '("edition"
      "inline"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "userlevel" "vendor" "xreflabel")
      "xedition")
    '("editor"
      "inline"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "userlevel" "vendor" "xreflabel")
      "xeditor")
    '("email"
      "inline"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "userlevel" "vendor" "xreflabel")
      "xemail")
    '("emphasis"
      "inline"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "userlevel" "vendor" "xreflabel")
      "xemphasis")
    '("entry"
      "block"
      ("align" "arch" "char" "charoff" "colname" "colsep" "condition"
       "conformance" "id" "lang" "morerows" "nameend" "namest" "os" "remap"
       "revision" "revisionflag" "role" "rotate" "rowsep" "spanname"
       "userlevel" "valign" "vendor" "xreflabel")
      "xentry")
    '("entrytbl"
      "block"
      ("align" "arch" "char" "charoff" "colname" "cols" "colsep" "condition"
       "conformance" "id" "lang" "nameend" "namest" "os" "remap" "revision"
       "revisionflag" "role" "rowsep" "spanname" "tgroupstyle" "userlevel"
       "vendor" "xreflabel")
      "xentrytbl")
    '("envar"
      "inline"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "userlevel" "vendor" "xreflabel")
      "xenvar")
    '("epigraph"
      "block"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "userlevel" "vendor" "xreflabel")
      "xepigraph")
    '("equation"
      "block"
      ("arch" "condition" "conformance" "id" "label" "lang" "os" "remap"
       "revision" "revisionflag" "role" "security" "userlevel" "vendor"
       "xreflabel")
      "xequation")
    '("errorcode"
      "inline"
      ("arch" "condition" "conformance" "id" "lang" "moreinfo" "os" "remap"
       "revision" "revisionflag" "role" "security" "userlevel" "vendor"
       "xreflabel")
      "xerrorcode")
    '("errorname"
      "inline"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "userlevel" "vendor" "xreflabel")
      "xerrorname")
    '("errortype"
      "inline"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "userlevel" "vendor" "xreflabel")
      "xerrortype")
    '("example"
      "block"
      ("arch" "condition" "conformance" "id" "label" "lang" "os" "remap"
       "revision" "revisionflag" "role" "security" "userlevel" "vendor" "width"
       "xreflabel")
      "xexample")
    '("exceptionname"
      "inline"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "userlevel" "vendor" "xreflabel")
      "xexceptionname")
    '("fax"
      "inline"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "userlevel" "vendor" "xreflabel")
      "xfax")
    '("fieldsynopsis"
      "block"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "userlevel" "vendor" "xreflabel")
      "xfieldsynopsis")
    '("figure"
      "block"
      ("arch" "condition" "conformance" "float" "id" "label" "lang" "os"
       "pgwide" "remap" "revision" "revisionflag" "role" "security" "userlevel"
       "vendor" "xreflabel")
      "xfigure")
    '("filename"
      "inline"
      ("arch" "class" "condition" "conformance" "id" "lang" "moreinfo" "os"
       "path" "remap" "revision" "revisionflag" "role" "security" "userlevel"
       "vendor" "xreflabel")
      "xfilename")
    '("firstname"
      "inline"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "userlevel" "vendor" "xreflabel")
      "xfirstname")
    '("firstterm"
      "inline"
      ("arch" "condition" "conformance" "id" "lang" "linkend" "os" "remap"
       "revision" "revisionflag" "role" "security" "userlevel" "vendor"
       "xreflabel")
      "xfirstterm")
    '("footnote"
      "block"
      ("arch" "condition" "conformance" "id" "label" "lang" "os" "remap"
       "revision" "revisionflag" "role" "security" "userlevel" "vendor"
       "xreflabel")
      "xfootnote")
    '("footnoteref"
      "empty"
      ("arch" "condition" "conformance" "id" "label" "lang" "linkend" "os"
       "remap" "revision" "revisionflag" "role" "security" "userlevel" "vendor"
       "xreflabel")
      "xfootnoteref")
    '("foreignphrase"
      "inline"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "userlevel" "vendor" "xreflabel")
      "xforeignphrase")
    '("formalpara"
      "block"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "userlevel" "vendor" "xreflabel")
      "xformalpara")
    '("funcdef"
      "inline"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "userlevel" "vendor" "xreflabel")
      "xfuncdef")
    '("funcparams"
      "inline"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "userlevel" "vendor" "xreflabel")
      "xfuncparams")
    '("funcprototype"
      "block"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "userlevel" "vendor" "xreflabel")
      "xfuncprototype")
    '("funcsynopsis"
      "block"
      ("arch" "condition" "conformance" "id" "label" "lang" "os" "remap"
       "revision" "revisionflag" "role" "security" "userlevel" "vendor"
       "xreflabel")
      "xfuncsynopsis")
    '("funcsynopsisinfo"
      "block"
      ("arch" "condition" "conformance" "format" "id" "lang" "linenumbering"
       "os" "remap" "revision" "revisionflag" "role" "security" "userlevel"
       "vendor" "xreflabel")
      "xfuncsynopsisinfo")
    '("function"
      "inline"
      ("arch" "condition" "conformance" "id" "lang" "moreinfo" "os" "remap"
       "revision" "revisionflag" "role" "security" "userlevel" "vendor"
       "xreflabel")
      "xfunction")))

(defvar docbook-element-symbol-alist-3
  (list
    '("glossary"
      "block"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "status" "userlevel" "vendor"
       "xreflabel")
      "xglossary")
    '("glossaryinfo"
      "block"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "userlevel" "vendor" "xreflabel")
      "xglossaryinfo")
    '("glossdef"
      "block"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "subject" "userlevel" "vendor"
       "xreflabel")
      "xglossdef")
    '("glossdiv"
      "block"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "status" "userlevel" "vendor"
       "xreflabel")
      "xglossdiv")
    '("glossentry"
      "block"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "sortas" "userlevel" "vendor"
       "xreflabel")
      "xglossentry")
    '("glosslist"
      "block"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "userlevel" "vendor" "xreflabel")
      "xglosslist")
    '("glosssee"
      "block"
      ("arch" "condition" "conformance" "id" "lang" "os" "otherterm" "remap"
       "revision" "revisionflag" "role" "security" "userlevel" "vendor"
       "xreflabel")
      "xglosssee")
    '("glossseealso"
      "block"
      ("arch" "condition" "conformance" "id" "lang" "os" "otherterm" "remap"
       "revision" "revisionflag" "role" "security" "userlevel" "vendor"
       "xreflabel")
      "xglossseealso")
    '("glossterm"
      "inline"
      ("arch" "baseform" "condition" "conformance" "id" "lang" "linkend" "os"
       "remap" "revision" "revisionflag" "role" "security" "userlevel" "vendor"
       "xreflabel")
      "xglossterm")
    '("graphic"
      "block"
      ("align" "arch" "condition" "conformance" "depth" "entityref" "fileref"
       "format" "id" "lang" "os" "remap" "revision" "revisionflag" "role"
       "scale" "scalefit" "security" "srccredit" "userlevel" "vendor" "width"
       "xreflabel")
      "xgraphic")
    '("graphicco"
      "block"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "userlevel" "vendor" "xreflabel")
      "xgraphicco")
    '("group"
      "inline"
      ;; "optmult" and "reqmult" removed in DocBook XML 4.1.
      ("arch" "choice" "condition" "conformance" "id" "lang" "optmult" "os"
       "remap" "rep" "reqmult" "revision" "revisionflag" "role" "security"
       "userlevel" "vendor" "xreflabel")
      "xgroup")
    '("guibutton"
      "inline"
      ("arch" "condition" "conformance" "id" "lang" "moreinfo" "os" "remap"
       "revision" "revisionflag" "role" "security" "userlevel" "vendor"
       "xreflabel")
      "xguibutton")
    '("guiicon"
      "inline"
      ("arch" "condition" "conformance" "id" "lang" "moreinfo" "os" "remap"
       "revision" "revisionflag" "role" "security" "userlevel" "vendor"
       "xreflabel")
      "xguiicon")
    '("guilabel"
      "inline"
      ("arch" "condition" "conformance" "id" "lang" "moreinfo" "os" "remap"
       "revision" "revisionflag" "role" "security" "userlevel" "vendor"
       "xreflabel")
      "xguilabel")
    '("guimenu"
      "inline"
      ("arch" "condition" "conformance" "id" "lang" "moreinfo" "os" "remap"
       "revision" "revisionflag" "role" "security" "userlevel" "vendor"
       "xreflabel")
      "xguimenu")
    '("guimenuitem"
      "inline"
      ("arch" "condition" "conformance" "id" "lang" "moreinfo" "os" "remap"
       "revision" "revisionflag" "role" "security" "userlevel" "vendor"
       "xreflabel")
      "xguimenuitem")
    '("guisubmenu"
      "inline"
      ("arch" "condition" "conformance" "id" "lang" "moreinfo" "os" "remap"
       "revision" "revisionflag" "role" "security" "userlevel" "vendor"
       "xreflabel")
      "xguisubmenu")
    '("hardware"
      "inline"
      ("arch" "condition" "conformance" "id" "lang" "moreinfo" "os" "remap"
       "revision" "revisionflag" "role" "security" "userlevel" "vendor"
       "xreflabel")
      "xhardware")
    '("highlights"
      "block"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "userlevel" "vendor" "xreflabel")
      "xhighlights")
    '("holder"
      "inline"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "userlevel" "vendor" "xreflabel")
      "xholder")
    '("honorific"
      "inline"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "userlevel" "vendor" "xreflabel")
      "xhonorific")
    '("imagedata"
      "block"
      ("align" "arch" "condition" "conformance" "depth" "entityref" "fileref"
       "format" "id" "lang" "os" "remap" "revision" "revisionflag" "role"
       "scale" "scalefit" "security" "srccredit" "userlevel" "vendor" "width"
       "xreflabel")
      "ximagedata")
    '("imageobject"
      "block"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "userlevel" "vendor" "xreflabel")
      "ximageobject")
    '("imageobjectco"
      "block"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "userlevel" "vendor" "xreflabel")
      "ximageobjectco")
    '("important"
      "block"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "userlevel" "vendor" "xreflabel")
      "ximportant")
    '("index"
      "block"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "userlevel" "vendor" "xreflabel")
      "xindex")
    '("indexdiv"
      "block"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "userlevel" "vendor" "xreflabel")
      "xindexdiv")
    '("indexentry"
      "block"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "userlevel" "vendor" "xreflabel")
      "xindexentry")
    '("indexinfo"
      "block"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "userlevel" "vendor" "xreflabel")
      "xindexinfo")
    '("indexterm"
      "inline"
      ("arch" "class" "condition" "conformance" "id" "lang" "os" "pagenum"
       "remap" "revision" "revisionflag" "role" "scope" "security"
       "significance" "startref" "userlevel" "vendor" "xreflabel" "zone" )
      "xindexterm")
    '("informalequation"
      "block"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "userlevel" "vendor" "xreflabel")
      "xinformalequation")
    '("informalexample"
      "block"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "userlevel" "vendor" "width"
       "xreflabel")
      "xinformalexample")
    '("informalfigure"
      "block"
      ("arch" "condition" "conformance" "float" "id" "label" "lang" "os"
       "pgwide" "remap" "revision" "revisionflag" "role" "security" "userlevel"
       "vendor" "xreflabel")
      "xinformalfigure")
    '("informaltable"
      "block"
      ("arch" "colsep" "condition" "conformance" "frame" "id" "label" "lang"
       "orient" "os" "pgwide" "remap" "revision" "revisionflag" "role" "rowsep"
       "security" "shortentry" "tabstyle" "tocentry" "userlevel" "vendor"
       "xreflabel")
      "xinformaltable")
    '("initializer"
      "inline"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "userlevel" "vendor" "xreflabel")
      "xinitializer")
    '("inlineequation"
      "inline"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "userlevel" "vendor" "xreflabel")
      "xinlineequation")
    '("inlinegraphic"
      "inline"
      ("align" "arch" "condition" "conformance" "depth" "entityref" "fileref"
       "format" "id" "lang" "os" "remap" "revision" "revisionflag" "role"
       "scale" "scalefit" "security" "srccredit" "userlevel" "vendor" "width"
       "xreflabel")
      "xinlinegraphic")
    '("inlinemediaobject"
      "inline"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "userlevel" "vendor" "xreflabel")
      "xinlinemediaobject")
    '("interface"
      "inline"
      ("arch" "class" "condition" "conformance" "id" "lang" "moreinfo" "os"
       "remap" "revision" "revisionflag" "role" "security" "userlevel" "vendor"
       "xreflabel")
      "xinterface")
    ;; Removed in DocBook XML 4.1.
    '("interfacedefinition"
      "inline"
      ("arch" "condition" "conformance" "id" "lang" "moreinfo" "os" "remap"
       "revision" "revisionflag" "role" "security" "userlevel" "vendor"
       "xreflabel")
      "xinterfacedefinition")
    '("interfacename"
      "inline"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "userlevel" "vendor" "xreflabel")
      "xinterfacename")
    '("invpartnumber"
      "inline"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "userlevel" "vendor" "xreflabel")
      "xinvpartnumber")
    '("isbn"
      "inline"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "userlevel" "vendor" "xreflabel")
      "xisbn")
    '("issn"
      "inline"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "userlevel" "vendor" "xreflabel")
      "xissn")
    '("issuenum"
      "inline"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "userlevel" "vendor" "xreflabel")
      "xissuenum")
    '("itemizedlist"
      "block"
      ("arch" "condition" "conformance" "id" "lang" "mark" "os" "remap"
       "revision" "revisionflag" "role" "security" "spacing" "userlevel"
       "vendor" "xreflabel")
      "xitemizedlist")
    '("itermset"
      "block"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "userlevel" "vendor" "xreflabel")
      "xitermset")))

(defvar docbook-element-symbol-alist-4
  (list
    '("jobtitle"
      "inline"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "userlevel" "vendor" "xreflabel")
      "xjobtitle")
    '("keycap"
      "inline"
      ("arch" "condition" "conformance" "id" "lang" "moreinfo" "os" "remap"
       "revision" "revisionflag" "role" "security" "userlevel" "vendor"
       "xreflabel")
      "xkeycap")
    '("keycode"
      "inline"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "userlevel" "vendor" "xreflabel")
      "xkeycode")
    '("keycombo"
      "inline"
      ("action" "arch" "condition" "conformance" "id" "lang" "moreinfo" "os"
       "otheraction" "remap" "revision" "revisionflag" "role" "security"
       "userlevel" "vendor" "xreflabel")
      "xkeycombo")
    '("keysym"
      "inline"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "userlevel" "vendor" "xreflabel")
      "xkeysym")
    '("keyword"
      "inline"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "userlevel" "vendor" "xreflabel")
      "xkeyword")
    '("keywordset"
      "block"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "userlevel" "vendor" "xreflabel")
      "xkeywordset")
    '("label"
      "inline"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "userlevel" "vendor" "xreflabel")
      "xlabel")
    '("legalnotice"
      "block"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "userlevel" "vendor" "xreflabel")
      "xlegalnotice")
    '("lineage"
      "inline"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "userlevel" "vendor" "xreflabel")
      "xlineage")
    '("lineannotation"
      "inline"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "userlevel" "vendor" "xreflabel")
      "xlineannotation")
    '("link"
      "inline"
      ("arch" "condition" "conformance" "endterm" "id" "lang" "linkend" "os"
       "remap" "revision" "revisionflag" "role" "security" "type" "userlevel"
       "vendor" "xreflabel")
      "xlink")
    '("listitem"
      "block"
      ("arch" "condition" "conformance" "id" "lang" "os" "override" "remap"
       "revision" "revisionflag" "role" "security" "userlevel" "vendor"
       "xreflabel")
      "xlistitem")
    '("literal"
      "inline"
      ("arch" "condition" "conformance" "id" "lang" "moreinfo" "os" "remap"
       "revision" "revisionflag" "role" "security" "userlevel" "vendor"
       "xreflabel")
      "xliteral")
    '("literallayout"
      "block"
      ("arch" "class" "condition" "conformance" "format" "id" "lang"
       "linenumbering" "os" "remap" "revision" "revisionflag" "role" "security"
       "userlevel" "vendor" "width" "xreflabel")
      "xliterallayout")
    '("lot"
      "block"
      ("arch" "condition" "conformance" "id" "label" "lang" "os" "remap"
       "revision" "revisionflag" "role" "security" "userlevel" "vendor"
       "xreflabel")
      "xlot")
    '("lotentry"
      "block"
      ("arch" "condition" "conformance" "id" "lang" "linkend" "os" "pagenum"
       "remap" "revision" "revisionflag" "role" "security" "srccredit"
       "userlevel" "vendor" "xreflabel")
      "xlotentry")
    '("manvolnum"
      "inline"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "userlevel" "vendor" "xreflabel")
      "xmanvolnum")
    '("markup"
      "inline"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "userlevel" "vendor" "xreflabel")
      "xmarkup")
    '("medialabel"
      "inline"
      ("arch" "class" "condition" "conformance" "id" "lang" "os" "remap"
       "revision" "revisionflag" "role" "security" "userlevel" "vendor"
       "xreflabel")
      "xmedialabel")
    '("mediaobject"
      "block"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "userlevel" "vendor" "xreflabel")
      "xmediaobject")
    '("mediaobjectco"
      "block"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "userlevel" "vendor" "xreflabel")
      "xmediaobjectco")
    '("member"
      "block"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "userlevel" "vendor" "xreflabel")
      "xmember")
    '("menuchoice"
      "inline"
      ("arch" "condition" "conformance" "id" "lang" "moreinfo" "os" "remap"
       "revision" "revisionflag" "role" "security" "userlevel" "vendor"
       "xreflabel")
      "xmenuchoice")
    '("methodname"
      "inline"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "userlevel" "vendor" "xreflabel")
      "xmethodname")
    '("methodparam"
      "inline"
      ("arch" "choice" "condition" "conformance" "id" "lang" "os" "remap" "rep"
       "revision" "revisionflag" "role" "security" "userlevel" "vendor"
       "xreflabel")
      "xmethodparam")
    '("methodsynopsis"
      "block"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "userlevel" "vendor" "xreflabel")
      "xmethodsynopsis")
    '("modespec"
      "block"
      ("application" "arch" "condition" "conformance" "id" "lang" "os" "remap"
       "revision" "revisionflag" "role" "security" "userlevel" "vendor"
       "xreflabel")
      "xmodespec")
    '("modifier"
      "inline"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "userlevel" "vendor" "xreflabel")
      "xmodifier")
    '("mousebutton"
      "inline"
      ("arch" "condition" "conformance" "id" "lang" "moreinfo" "os" "remap"
       "revision" "revisionflag" "role" "security" "userlevel" "vendor"
       "xreflabel")
      "xmousebutton")
    '("msg"
      "block"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "userlevel" "vendor" "xreflabel")
      "xmsg")
    '("msgaud"
      "block"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "userlevel" "vendor" "xreflabel")
      "xmsgaud")
    '("msgentry"
      "block"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "userlevel" "vendor" "xreflabel")
      "xmsgentry")
    '("msgexplan"
      "block"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "userlevel" "vendor" "xreflabel")
      "xmsgexplan")
    '("msginfo"
      "block"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "userlevel" "vendor" "xreflabel")
      "xmsginfo")
    '("msglevel"
      "block"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "userlevel" "vendor" "xreflabel")
      "xmsglevel")
    '("msgmain"
      "block"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "userlevel" "vendor" "xreflabel")
      "xmsgmain")
    '("msgorig"
      "block"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "userlevel" "vendor" "xreflabel")
      "xmsgorig")
    '("msgrel"
      "block"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "userlevel" "vendor" "xreflabel")
      "xmsgrel")
    '("msgset"
      "block"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "userlevel" "vendor" "xreflabel")
      "xmsgset")
    '("msgsub"
      "block"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "userlevel" "vendor" "xreflabel")
      "xmsgsub")
    '("msgtext"
      "block"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "userlevel" "vendor" "xreflabel")
      "xmsgtext")))

(defvar docbook-element-symbol-alist-5
  (list
    '("note"
      "block"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "userlevel" "vendor" "xreflabel")
      "xnote")
    '("objectinfo"
      "block"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "userlevel" "vendor" "xreflabel")
      "xobjectinfo")
    '("olink"
      "inline"
      ("arch" "condition" "conformance" "id" "lang" "linkmode" "localinfo" "os"
       "remap" "revision" "revisionflag" "role" "security" "targetdocent"
       "type" "userlevel" "vendor" "xreflabel")
      "xolink")
    '("ooclass"
      "inline"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "userlevel" "vendor" "xreflabel")
      "xooclass")
    '("ooexception"
      "inline"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "userlevel" "vendor" "xreflabel")
      "xooexception")
    '("oointerface"
      "inline"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "userlevel" "vendor" "xreflabel")
      "xoointerface")
    '("option"
      "inline"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "userlevel" "vendor" "xreflabel")
      "xoption")
    '("optional"
      "inline"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "userlevel" "vendor" "xreflabel")
      "xoptional")
    '("orderedlist"
      "block"
      ("arch" "condition" "conformance" "continuation" "id" "inheritnum" "lang"
       "numeration" "os" "remap" "revision" "revisionflag" "role" "security"
       "spacing" "userlevel" "vendor" "xreflabel")
      "xorderedlist")
    '("orgdiv"
      "inline"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "userlevel" "vendor" "xreflabel")
      "xorgdiv")
    '("orgname"
      "inline"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "userlevel" "vendor" "xreflabel")
      "xorgname")
    '("otheraddr"
      "inline"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "userlevel" "vendor" "xreflabel")
      "xotheraddr")
    '("othercredit"
      "inline"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "userlevel" "vendor" "xreflabel")
      "xothercredit")
    '("othername"
      "inline"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "userlevel" "vendor" "xreflabel")
      "xothername")
    '("pagenums"
      "inline"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "userlevel" "vendor" "xreflabel")
      "xpagenums")
    '("para"
      "block"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "userlevel" "vendor" "xreflabel")
      "xpara")
    '("paramdef"
      "inline"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "userlevel" "vendor" "xreflabel")
      "xparamdef")
    '("parameter"
      "inline"
      ("arch" "class" "condition" "conformance" "id" "lang" "moreinfo" "os"
       "remap" "revision" "revisionflag" "role" "security" "userlevel" "vendor"
       "xreflabel")
      "xparameter")
    '("part"
      "block"
      ("arch" "condition" "conformance" "id" "label" "lang" "os" "remap"
       "revision" "revisionflag" "role" "security" "status" "userlevel"
       "vendor" "xreflabel")
      "xpart")
    '("partinfo"
      "block"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "userlevel" "vendor" "xreflabel")
      "xpartinfo")
    '("partintro"
      "block"
      ("arch" "condition" "conformance" "id" "label" "lang" "os" "remap"
       "revision" "revisionflag" "role" "security" "userlevel" "vendor"
       "xreflabel")
      "xpartintro")
    '("phone"
      "inline"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "userlevel" "vendor" "xreflabel")
      "xphone")
    '("phrase"
      "inline"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "userlevel" "vendor" "xreflabel")
      "xphrase")
    '("pob"
      "inline"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "userlevel" "vendor" "xreflabel")
      "xpob")
    '("postcode"
      "inline"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "userlevel" "vendor" "xreflabel")
      "xpostcode")
    '("preface"
      "block"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "status" "userlevel" "vendor"
       "xreflabel")
      "xpreface")
    '("prefaceinfo"
      "block"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "userlevel" "vendor" "xreflabel")
      "xprefaceinfo")
    '("primary"
      "inline"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "sortas" "userlevel" "vendor"
       "xreflabel")
      "xprimary")
    '("primaryie"
      "block"
      ("arch" "condition" "conformance" "id" "lang" "linkends" "os" "remap"
       "revision" "revisionflag" "role" "security" "userlevel" "vendor"
       "xreflabel")
      "xprimaryie")
    '("printhistory"
      "block"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "userlevel" "vendor" "xreflabel")
      "xprinthistory")
    '("procedure"
      "block"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "userlevel" "vendor" "xreflabel")
      "xprocedure")
    '("productname"
      "inline"
      ("arch" "class" "condition" "conformance" "id" "lang" "os" "remap"
       "revision" "revisionflag" "role" "security" "userlevel" "vendor"
       "xreflabel")
      "xproductname")
    '("productnumber"
      "inline"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "userlevel" "vendor" "xreflabel")
      "xproductnumber")
    '("programlisting"
      "block"
      ("arch" "condition" "conformance" "format" "id" "lang" "linenumbering"
       "os" "remap" "revision" "revisionflag" "role" "security" "userlevel"
       "vendor" "width" "xreflabel")
      "xprogramlisting")
    '("programlistingco"
      "block"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "userlevel" "vendor" "xreflabel")
      "xprogramlistingco")
    '("prompt"
      "inline"
      ("arch" "condition" "conformance" "id" "lang" "moreinfo" "os" "remap"
       "revision" "revisionflag" "role" "security" "userlevel" "vendor"
       "xreflabel")
      "xprompt")
    '("property"
      "inline"
      ("arch" "condition" "conformance" "id" "lang" "moreinfo" "os" "remap"
       "revision" "revisionflag" "role" "security" "userlevel" "vendor"
       "xreflabel")
      "xproperty")
    '("pubdate"
      "inline"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "userlevel" "vendor" "xreflabel")
      "xpubdate")
    '("publisher"
      "inline"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "userlevel" "vendor" "xreflabel")
      "xpublisher")
    '("publishername"
      "inline"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "userlevel" "vendor" "xreflabel")
      "xpublishername")
    '("pubsnumber"
      "inline"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "userlevel" "vendor" "xreflabel")
      "xpubsnumber")))

(defvar docbook-element-symbol-alist-6
  (list
    '("qandadiv"
      "block"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "status" "userlevel" "vendor"
       "xreflabel")
      "xqandadiv")
    '("qandaentry"
      "block"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "userlevel" "vendor" "xreflabel")
      "xqandaentry")
    '("qandaset"
      "block"
      ("arch" "condition" "conformance" "defaultlabel" "id" "lang" "os" "remap"
       "revision" "revisionflag" "role" "security" "userlevel" "vendor"
       "xreflabel")
      "xqandaset")
    '("question"
      "block"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "userlevel" "vendor" "xreflabel")
      "xquestion")
    '("quote"
      "inline"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "userlevel" "vendor" "xreflabel")
      "xquote")
    '("refclass"
      "block"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "userlevel" "vendor" "xreflabel")
      "xrefclass")
    '("refdescriptor"
      "block"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "userlevel" "vendor" "xreflabel")
      "xrefdescriptor")
    '("refentry"
      "block"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "status" "userlevel" "vendor"
       "xreflabel")
      "xrefentry")
    '("refentryinfo"
      "block"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "userlevel" "vendor" "xreflabel")
      "xrefentryinfo")
    '("refentrytitle"
      "inline"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "userlevel" "vendor" "xreflabel")
      "xrefentrytitle")
    '("reference"
      "block"
      ("arch" "condition" "conformance" "id" "label" "lang" "os" "remap"
       "revision" "revisionflag" "role" "security" "status" "userlevel"
       "vendor" "xreflabel")
      "xreference")
    '("referenceinfo"
      "block"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "userlevel" "vendor" "xreflabel")
      "xreferenceinfo")
    '("refmeta"
      "block"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "userlevel" "vendor" "xreflabel")
      "xrefmeta")
    '("refmiscinfo"
      "block"
      ("arch" "class" "condition" "conformance" "id" "lang" "os" "remap"
       "revision" "revisionflag" "role" "security" "userlevel" "vendor"
       "xreflabel")
      "xrefmiscinfo")
    '("refname"
      "inline"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "userlevel" "vendor" "xreflabel")
      "xrefname")
    '("refnamediv"
      "block"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "userlevel" "vendor" "xreflabel")
      "xrefnamediv")
    '("refpurpose"
      "inline"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "userlevel" "vendor" "xreflabel")
      "xrefpurpose")
    '("refsect1"
      "block"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "userlevel" "vendor" "xreflabel")
      "xrefsect1")
    '("refsect1info"
      "block"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "userlevel" "vendor" "xreflabel")
      "xrefsect1info")
    '("refsect2"
      "block"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "userlevel" "vendor" "xreflabel")
      "xrefsect2")
    '("refsect2info"
      "block"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "userlevel" "vendor" "xreflabel")
      "xrefsect2info")
    '("refsect3"
      "block"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "userlevel" "vendor" "xreflabel")
      "xrefsect3")
    '("refsect3info"
      "block"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "userlevel" "vendor" "xreflabel")
      "xrefsect3info")
    '("refsynopsisdiv"
      "block"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "userlevel" "vendor" "xreflabel")
      "xrefsynopsisdiv")
    '("refsynopsisdivinfo"
      "block"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "userlevel" "vendor" "xreflabel")
      "xrefsynopsisdivinfo")
    '("releaseinfo"
      "inline"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "userlevel" "vendor" "xreflabel")
      "xreleaseinfo")
    '("remark"
      "inline"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "userlevel" "vendor" "xreflabel")
      "xremark")
    '("replaceable"
      "inline"
      ("arch" "class" "condition" "conformance" "id" "lang" "os" "remap"
       "revision" "revisionflag" "role" "security" "userlevel" "vendor"
       "xreflabel")
      "xreplaceable")
    '("returnvalue"
      "inline"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "userlevel" "vendor" "xreflabel")
      "xreturnvalue")
    '("revdescription"
      "block"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "userlevel" "vendor" "xreflabel")
      "xrevdescription")
    '("revhistory"
      "block"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "userlevel" "vendor" "xreflabel")
      "xrevhistory")
    '("revision"
      "inline"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "userlevel" "vendor" "xreflabel")
      "xrevision")
    '("revnumber"
      "inline"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "userlevel" "vendor" "xreflabel")
      "xrevnumber")
    '("revremark"
      "inline"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "userlevel" "vendor" "xreflabel")
      "xrevremark")
    '("row"
      "block"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "rowsep" "security" "userlevel" "valign" "vendor"
       "xreflabel")
      "xrow")))

(defvar docbook-element-symbol-alist-7
  (list
    '("sbr"
      "empty"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "userlevel" "vendor" "xreflabel")
      "xsbr")
    '("screen"
      "block"
      ("arch" "condition" "conformance" "format" "id" "lang" "linenumbering"
       "os" "remap" "revision" "revisionflag" "role" "security" "userlevel"
       "vendor" "width" "xreflabel")
      "xscreen")
    '("screenco"
      "block"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "userlevel" "vendor" "xreflabel")
      "xscreenco")
    '("screeninfo"
      "block"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "userlevel" "vendor" "xreflabel")
      "xscreeninfo")
    '("screenshot"
      "block"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "userlevel" "vendor" "xreflabel")
      "xscreenshot")
    '("secondary"
      "inline"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "sortas" "userlevel" "vendor"
       "xreflabel")
      "xsecondary")
    '("secondaryie"
      "block"
      ("arch" "condition" "conformance" "id" "lang" "linkends" "os" "remap"
       "revision" "revisionflag" "role" "security" "userlevel" "vendor"
       "xreflabel")
      "xsecondaryie")
    '("sect1"
      "block"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "userlevel" "vendor" "xreflabel")
      "xsect1")
    '("sect1info"
      "block"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "userlevel" "vendor" "xreflabel")
      "xsect1info")
    '("sect2"
      "block"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "userlevel" "vendor" "xreflabel")
      "xsect2")
    '("sect2info"
      "block"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "userlevel" "vendor" "xreflabel")
      "xsect2info")
    '("sect3"
      "block"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "userlevel" "vendor" "xreflabel")
      "xsect3")
    '("sect3info"
      "block"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "userlevel" "vendor" "xreflabel")
      "xsect3info")
    '("sect4"
      "block"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "userlevel" "vendor" "xreflabel")
      "xsect4")
    '("sect4info"
      "block"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "userlevel" "vendor" "xreflabel")
      "xsect4info")
    '("sect5"
      "block"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "userlevel" "vendor" "xreflabel")
      "xsect5")
    '("sect5info"
      "block"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "userlevel" "vendor" "xreflabel")
      "xsect5info")
    '("section"
      "block"
      ("arch" "condition" "conformance" "id" "label" "lang" "os" "remap"
       "revision" "revisionflag" "role" "security" "status" "userlevel"
       "vendor" "xreflabel")
      "xsection")
    '("sectioninfo"
      "block"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "userlevel" "vendor" "xreflabel")
      "xsectioninfo")
    '("see"
      "inline"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "userlevel" "vendor" "xreflabel")
      "xsee")
    '("seealso"
      "inline"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "userlevel" "vendor" "xreflabel")
      "xseealso")
    '("seealsoie"
      "block"
      ("arch" "condition" "conformance" "id" "lang" "linkends" "os" "remap"
       "revision" "revisionflag" "role" "security" "userlevel" "vendor"
       "xreflabel")
      "xseealsoie")
    '("seeie"
      "block"
      ("arch" "condition" "conformance" "id" "lang" "linkend" "os" "remap"
       "revision" "revisionflag" "role" "security" "userlevel" "vendor"
       "xreflabel")
      "xseeie")
    '("seg"
      "block"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "userlevel" "vendor" "xreflabel")
      "xseg")
    '("seglistitem"
      "block"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "userlevel" "vendor" "xreflabel")
      "xseglistitem")
    '("segmentedlist"
      "block"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "userlevel" "vendor" "xreflabel")
      "xsegmentedlist")
    '("segtitle"
      "block"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "userlevel" "vendor" "xreflabel")
      "xsegtitle")
    ;; Removed in DocBook XML 4.1.
    '("seriesinfo"
      "inline"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "userlevel" "vendor" "xreflabel")
      "xseriesinfo")
    '("seriesvolnums"
      "inline"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "userlevel" "vendor" "xreflabel")
      "xseriesvolnums")
    '("set"
      "block"
      ("arch" "condition" "conformance" "fpi" "id" "lang" "os" "remap"
       "revision" "revisionflag" "role" "security" "status" "userlevel"
       "vendor" "xreflabel")
      "xset")
    '("setindex"
      "block"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "userlevel" "vendor" "xreflabel")
      "xsetindex")
    '("setindexinfo"
      "block"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "userlevel" "vendor" "xreflabel")
      "xsetindexinfo")
    '("setinfo"
      "block"
      ("arch" "condition" "conformance" "contents" "id" "lang" "os" "remap"
       "revision" "revisionflag" "role" "security" "userlevel" "vendor"
       "xreflabel")
      "xsetinfo")
    '("sgmltag"
      "inline"
      ("arch" "class" "condition" "conformance" "id" "lang" "os" "remap"
       "revision" "revisionflag" "role" "security" "userlevel" "vendor"
       "xreflabel")
      "xsgmltag")
    '("shortaffil"
      "inline"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "userlevel" "vendor" "xreflabel")
      "xshortaffil")
    '("shortcut"
      "inline"
      ("action" "arch" "condition" "conformance" "id" "lang" "moreinfo" "os"
       "otheraction" "remap" "revision" "revisionflag" "role" "security"
       "userlevel" "vendor" "xreflabel")
      "xshortcut")
    '("sidebar"
      "block"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "userlevel" "vendor" "xreflabel")
      "xsidebar")
    '("sidebarinfo"
      "block"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "userlevel" "vendor" "xreflabel")
      "xsidebarinfo")
    '("simpara"
      "block"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "userlevel" "vendor" "xreflabel")
      "xsimpara")
    '("simplelist"
      "block"
      ("arch" "columns" "condition" "conformance" "id" "lang" "os" "remap"
       "revision" "revisionflag" "role" "security" "type" "userlevel" "vendor"
       "xreflabel")
      "xsimplelist")
    '("simplemsgentry"
      "block"
      ("arch" "audience" "condition" "conformance" "id" "lang" "level" "origin"
       "os" "remap" "revision" "revisionflag" "role" "security" "userlevel"
       "vendor" "xreflabel")
      "xsimplemsgentry")
    '("simplesect"
      "block"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "userlevel" "vendor" "xreflabel")
      "xsimplesect")
    '("spanspec"
      "block"
      ("align" "arch" "char" "charoff" "colsep" "condition" "conformance" "id"
       "lang" "nameend" "namest" "os" "remap" "revision" "revisionflag" "role"
       "rowsep" "security" "spanname" "userlevel" "vendor" "xreflabel")
      "xspanspec")
    '("state"
      "inline"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "userlevel" "vendor" "xreflabel")
      "xstate")
    '("step"
      "block"
      ("arch" "condition" "conformance" "id" "lang" "os" "performance" "remap"
       "revision" "revisionflag" "role" "security" "userlevel" "vendor"
       "xreflabel")
      "xstep")
    '("street"
      "inline"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "userlevel" "vendor" "xreflabel")
      "xstreet")
    '("structfield"
      "inline"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "userlevel" "vendor" "xreflabel")
      "xstructfield")
    '("structname"
      "inline"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "userlevel" "vendor" "xreflabel")
      "xstructname")
    '("subject"
      "block"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "userlevel" "vendor" "weight"
       "xreflabel")
      "xsubject")
    '("subjectset"
      "block"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "scheme" "userlevel" "vendor" "xreflabel")
      "xsubjectset")
    '("subjectterm"
      "block"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "userlevel" "vendor" "xreflabel")
      "xsubjectterm")
    '("subscript"
      "inline"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "userlevel" "vendor" "xreflabel")
      "xsubscript")
    '("substeps"
      "block"
      ("arch" "condition" "conformance" "id" "lang" "os" "performance" "remap"
       "revision" "revisionflag" "role" "security" "userlevel" "vendor"
       "xreflabel")
      "xsubsteps")
    '("subtitle"
      "block"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "userlevel" "vendor" "xreflabel")
      "xsubtitle")
    '("superscript"
      "inline"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "userlevel" "vendor" "xreflabel")
      "xsuperscript")
    '("surname"
      "inline"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "userlevel" "vendor" "xreflabel")
      "xsurname")
    '("symbol"
      "inline"
      ("arch" "class" "condition" "conformance" "id" "lang" "os" "remap"
       "revision" "revisionflag" "role" "security" "userlevel" "vendor"
       "xreflabel")
      "xsymbol")
    '("synopfragment"
      "block"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "userlevel" "vendor" "xreflabel")
      "xsynopfragment")
    '("synopfragmentref"
      "block"
      ("arch" "condition" "conformance" "id" "lang" "linkend" "os" "remap"
       "revision" "revisionflag" "role" "security" "userlevel" "vendor"
       "xreflabel")
      "xsynopfragmentref")
    '("synopsis"
      "block"
      ("arch" "condition" "conformance" "format" "id" "label" "lang"
       "linenumbering" "os" "remap" "revision" "revisionflag" "role" "security"
       "userlevel" "vendor" "xreflabel")
      "xsynopsis")
    '("systemitem"
      "inline"
      ("arch" "class" "condition" "conformance" "id" "lang" "moreinfo" "os"
       "remap" "revision" "revisionflag" "role" "security" "userlevel" "vendor"
       "xreflabel")
      "xsystemitem")))

(defvar docbook-element-symbol-alist-8
  (list
    '("table"
      "block"
      ("arch" "colsep" "condition" "conformance" "frame" "id" "label" "lang"
       "orient" "os" "pgwide" "remap" "revision" "revisionflag" "role" "rowsep"
       "security" "shortentry" "tabstyle" "tocentry" "userlevel" "vendor"
       "xreflabel")
      "xtable")
    '("tbody"
      "block"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "userlevel" "valign" "vendor"
       "xreflabel")
      "xtbody")
    '("term"
      "inline"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "userlevel" "vendor" "xreflabel")
      "xterm")
    '("tertiary"
      "inline"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "sortas" "userlevel" "vendor"
       "xreflabel")
      "xtertiary")
    '("tertiaryie"
      "block"
      ("arch" "condition" "conformance" "id" "lang" "linkends" "os" "remap"
       "revision" "revisionflag" "role" "security" "userlevel" "vendor"
       "xreflabel")
      "xtertiaryie")
    '("textobject"
      "block"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "userlevel" "vendor" "xreflabel")
      "xtextobject")
    '("tfoot"
      "block"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "userlevel" "valign" "vendor"
       "xreflabel")
      "xtfoot")
    '("tgroup"
      "block"
      ("align" "arch" "char" "charoff" "cols" "colsep" "condition"
       "conformance" "id" "lang" "os" "remap" "revision" "revisionflag" "role"
       "rowsep" "security" "tgroupstyle" "userlevel" "vendor" "xreflabel")
      "xtgroup")
    '("thead"
      "block"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "userlevel" "valign" "vendor"
       "xreflabel")
      "xthead")
    '("tip"
      "block"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "userlevel" "vendor" "xreflabel")
      "xtip")
    '("title"
      "block"
      ("arch" "condition" "conformance" "id" "lang" "os" "pagenum" "remap"
       "revision" "revisionflag" "role" "security" "userlevel" "vendor"
       "xreflabel")
      "xtitle")
    '("titleabbrev"
      "block"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "userlevel" "vendor" "xreflabel")
      "xtitleabbrev")
    '("toc"
      "block"
      ("arch" "condition" "conformance" "id" "lang" "os" "pagenum" "remap"
       "revision" "revisionflag" "role" "security" "userlevel" "vendor"
       "xreflabel")
      "xtoc")
    '("tocback"
      "block"
      ("arch" "condition" "conformance" "id" "label" "lang" "linkend" "os"
       "pagenum" "remap" "revision" "revisionflag" "role" "security"
       "userlevel" "vendor" "xreflabel")
      "xtocback")
    '("tocchap"
      "block"
      ("arch" "condition" "conformance" "id" "label" "lang" "os" "remap"
       "revision" "revisionflag" "role" "security" "userlevel" "vendor"
       "xreflabel")
      "xtocchap")
    '("tocentry"
      "block"
      ("arch" "condition" "conformance" "id" "lang" "linkend" "os" "pagenum"
       "remap" "revision" "revisionflag" "role" "security" "userlevel" "vendor"
       "xreflabel")
      "xtocentry")
    '("tocfront"
      "block"
      ("arch" "condition" "conformance" "id" "label" "lang" "linkend" "os"
       "pagenum" "remap" "revision" "revisionflag" "role" "security"
       "userlevel" "vendor" "xreflabel")
      "xtocfront")
    '("toclevel1"
      "block"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "userlevel" "vendor" "xreflabel")
      "xtoclevel1")
    '("toclevel2"
      "block"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "userlevel" "vendor" "xreflabel")
      "xtoclevel2")
    '("toclevel3"
      "block"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "userlevel" "vendor" "xreflabel")
      "xtoclevel3")
    '("toclevel4"
      "block"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "userlevel" "vendor" "xreflabel")
      "xtoclevel4")
    '("toclevel5"
      "block"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "userlevel" "vendor" "xreflabel")
      "xtoclevel5")
    '("tocpart"
      "block"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "userlevel" "vendor" "xreflabel")
      "xtocpart")
    '("token"
      "inline"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "userlevel" "vendor" "xreflabel")
      "xtoken")
    '("trademark"
      "inline"
      ("arch" "class" "condition" "conformance" "id" "lang" "os" "remap"
       "revision" "revisionflag" "role" "security" "userlevel" "vendor"
       "xreflabel")
      "xtrademark")
    '("type"
      "inline"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "userlevel" "vendor" "xreflabel")
      "xtype")
    '("ulink"
      "inline"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "type" "url" "userlevel" "vendor"
       "xreflabel")
      "xulink")
    '("userinput"
      "inline"
      ("arch" "condition" "conformance" "id" "lang" "moreinfo" "os" "remap"
       "revision" "revisionflag" "role" "security" "userlevel" "vendor"
       "xreflabel")
      "xuserinput")
    '("varargs"
      "inline"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "userlevel" "vendor" "xreflabel")
      "xvarargs")
    '("variablelist"
      "block"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "termlength" "userlevel" "vendor" "xreflabel")
      "xvariablelist")
    '("varlistentry"
      "block"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "userlevel" "vendor" "xreflabel")
      "xvarlistentry")
    '("varname"
      "inline"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "userlevel" "vendor" "xreflabel")
      "xvarname")
    '("videodata"
      "block"
      ("align" "arch" "condition" "conformance" "depth" "entityref" "fileref"
       "format" "id" "lang" "os" "remap" "revision" "revisionflag" "role"
       "scale" "scalefit" "security" "srccredit" "userlevel" "vendor" "width"
       "xreflabel")
      "xvideodata")
    '("videoobject"
      "block"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "userlevel" "vendor" "xreflabel")
      "xvideoobject")
    '("void"
      "inline"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "userlevel" "vendor" "xreflabel")
      "xvoid")
    '("volumenum"
      "inline"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "userlevel" "vendor" "xreflabel")
      "xvolumenum")
    '("warning"
      "block"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "userlevel" "vendor" "xreflabel")
      "xwarning")
    '("wordasword"
      "inline"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "userlevel" "vendor" "xreflabel")
      "xwordasword")
    '("xref"
      "empty"
      ("arch" "condition" "conformance" "endterm" "id" "lang" "linkend" "os"
       "remap" "revision" "revisionflag" "role" "security" "userlevel" "vendor"
       "xreflabel")
      "xxref")
    '("year"
      "inline"
      ("arch" "condition" "conformance" "id" "lang" "os" "remap" "revision"
       "revisionflag" "role" "security" "userlevel" "vendor" "xreflabel")
      "xyear")))

;; It would be nice to make these start-tag dependent

(defvar docbook-attributes-alist
  (list
   '("action" "ac" ())
   '("align" "al" ())
   '("application" "ap" ())
   '("arch" "arch" ())
   '("arearefs" "ar" ())
   '("audience" "au" ())
   '("baseform" "bf" ())
   '("char" "char" ())
   '("charoff" "charo" ())
   '("choice" "ch" ())
   '("class" "cl" ())
   '("cmdlength" "cmdl" ())
   '("colname" "cna" ())
   '("colnum" "cnu" ())
   '("cols" "cols" ())
   '("colsep" "colsep" ())
   '("columns" "columns" ())
   '("colwidth" "colw" ())
   '("condition" "cond" ())
   '("conformance" "conf" ())
   '("contents" "contents" ())
   '("continuation" "cont" ())
   '("coords" "co" ())
   '("defaultlabel" "dl" ())
   '("depth" "de" ())
   '("endterm" "et" ())
   '("entityref" "er" ())
   '("fileref" "fr" ())
   '("float" "fl" ())
   '("format" "fo" ())
   '("fpi" "fpi" ())
   '("frame" "fr" ())
   '("id" "id" ())
   '("inheritnum" "in" ())
   '("label" "la" ())
   '("lang" "lang" ())
   '("language" "language" ())
   '("level" "level" ())
   '("linenumbering" "ln" ())
   '("linkend" "le" ())
   '("linkends" "les" ())
   '("linkmode" "lm" ())
   '("localinfo" "li" ())
   '("mark" "ma" ())
   '("moreinfo" "morei" ())
   '("morerows" "morer" ())
   '("nameend" "ne" ())
   '("namest" "ns" ())
   '("numeration" "nu" ())
   '("optmult" "om" ())                          ;; Removed in DocBook XML 4.1.
   '("orient" "or" ())
   '("origin" "orig" ())
   '("os" "os" ())
   '("otheraction" "otha" ())
   '("otherterm" "otht" ())
   '("otherunits" "othu" ())
   '("override" "over" ())
   '("pagenum" "pn" ())
   '("parentbook" "pb" ())
   '("path" "path" ())
   '("performance" "perf" ())
   '("pgwide" "pgw" ())
   '("pubwork" "pw" ())
   '("relation" "rel" ())
   '("remap" "rem" ())
   '("renderas" "ras" ())
   '("rep" "rep" ())
   '("reqmult" "reqm" ())                        ;; Removed in DocBook XML 4.1.
   '("revision" "rev" ())
   '("revisionflag" "revf" ())
   '("role" "role" ())
   '("rotate" "rot" ())
   '("rowsep" "row" ())
   '("scale" "sc" ())
   '("scalefit" "scf" ())
   '("scheme" "sch" ())
   '("scope" "sc" ())
   '("security" "sec" ())
   '("sepchar" "sepc" ())
   '("shortentry" "sh" ())
   '("significance" "sig" ())
   '("sortas" "sas" ())
   '("spacing" "spac" ())
   '("spanname" "sn" ())
   '("srccredit" "srcc" ())
   '("startref" "str" ())
   '("status" "stat" ())
   '("subject" "subj" ())
   '("tabstyle" "tabs" ())
   '("targetdocent" "tdoc" ())
   '("termlength" "tlen" ())
   '("tgroupstyle" "tgs" ())
   '("tocentry" "toce" ())
   '("type" "type" ())
   '("units" "un" ())
   '("url" "url" ())
   '("userlevel" "ul" ())
   '("valign" "val" ())
   '("vendor" "ven" ())
   '("weight" "we" ())
   '("width" "wi" ())
   '("xreflabel" "xr" ())
   '("zone" "zo" ())))

;; If docbook-insert-tag inserts one of the following elements,
;; the corresponding content is also inserted automatically

(defvar docbook-autoinsert-alist
  (list
   (list "chapter" "<title>^</title>")
   (list "section" "<title>^</title>")
   (list "sect1" "<title>^</title>")
   (list "sect2" "<title>^</title>")
   (list "sect3" "<title>^</title>")
   (list "sect4" "<title>^</title>")
   (list "sect5" "<title>^</title>")
   (list "figure" "<title>^</title>")
   (list "example" "<title>^</title>")
   (list "equation" "<title>^</title>")
   (list "table" "<title>^</title>")
   (list "book"
	 (concat
	  "\n"
	  "  <bookinfo>\n"
	  "    <title>^</title>\n"
	  "    <author><firstname></firstname><surname></surname></author>\n"
	  "    <date>"
	  (substring (current-time-string) 8 10)
	  " "
	  (substring (current-time-string) 4 7)
	  " "
	  (substring (current-time-string) 20 24)
	  "</date>\n"
	  "  </bookinfo>\n"))
   (list "article" 
	 (concat
	  "\n"
	  "  <artheader>\n"
	  "    <title>^</title>\n"
	  "    <author><firstname></firstname><surname></surname></author>\n"
	  "    <date>"
	  (substring (current-time-string) 8 10)
	  " "
	  (substring (current-time-string) 4 7)
	  " "
	  (substring (current-time-string) 20 24)
	  "</date>\n"
	  "  </artheader>\n"))
   (list "author" "<firstname>^</firstname><surname></surname>")
   (list "editor" "<firstname>^</firstname><surname></surname>")
   (list "simplelist" "<member>^</member>")
   (list "varlistentry" "<term>^</term>\n  <listitem><para></para></listitem>")
   ))

(setq docbook-all-attribute-alist
      (sort
       docbook-attributes-alist
       (lambda (a b) (string< (car a) (car b)))))

(setq docbook-all-elements-alist
      (sort
       (append
	(mapcar (lambda (x)
		  (cons (car x)
			(cdr x)))
		docbook-element-symbol-alist)
	(mapcar (lambda (x)
		  (cons (car x)
			(cdr x)))
		docbook-element-symbol-alist-1)
	(mapcar (lambda (x)
		  (cons (car x)
			(cdr x)))
		docbook-element-symbol-alist-2)
	(mapcar (lambda (x)
		  (cons (car x)
			(cdr x)))
		docbook-element-symbol-alist-3)
	(mapcar (lambda (x)
		  (cons (car x)
			(cdr x)))
		docbook-element-symbol-alist-4)
	(mapcar (lambda (x)
		  (cons (car x)
			(cdr x)))
		docbook-element-symbol-alist-5)
	(mapcar (lambda (x)
		  (cons (car x)
			(cdr x)))
		docbook-element-symbol-alist-6)
	(mapcar (lambda (x)
		  (cons (car x)
			(cdr x)))
		docbook-element-symbol-alist-7)
	(mapcar (lambda (x)
		  (cons (car x)
			(cdr x)))
		docbook-element-symbol-alist-8))
       (lambda (a b) (string< (car a) (car b)))))

(setq docbook-all-autoinsert-alist
      (sort
       docbook-autoinsert-alist
       (lambda (a b) (string< (car a) (car b)))))

(provide 'dbide-data)

;; end of dbide-data.el
