/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.micronaut.db;

import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TypeParameterTree;
import com.sun.source.tree.VariableTree;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.EventListener;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.util.ElementFilter;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.lexer.JavaTokenId;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.GeneratorUtilities;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.TypeUtilities;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.j2ee.core.api.support.java.GenerationUtils;
import org.openide.filesystems.FileObject;
import org.openide.util.WeakListeners;

public final class Utils {
    private static final String CONTROLLER_ANNOTATION_NAME = "io.micronaut.http.annotation.Controller";
    private static final String GET_ANNOTATION_NAME = "io.micronaut.http.annotation.Get";
    private static final String DELETE_ANNOTATION_NAME = "io.micronaut.http.annotation.Delete";
    private static final String PUT_ANNOTATION_NAME = "io.micronaut.http.annotation.Put";
    private static final String POST_ANNOTATION_NAME = "io.micronaut.http.annotation.Post";
    private static final String BODY_ANNOTATION_NAME = "io.micronaut.http.annotation.Body";
    private static final String VALID_ANNOTATION_NAME = "jakarta.validation.Valid";
    private static final String CRUD_REPOSITORY_TYPE_NAME = "io.micronaut.data.repository.CrudRepository";
    private static final String PAGEABLE_REPOSITORY_TYPE_NAME = "io.micronaut.data.repository.PageableRepository";
    private static final String PAGEABLE_TYPE_NAME = "io.micronaut.data.model.Pageable";
    private static final String HTTP_RESPONSE_TYPE_NAME = "io.micronaut.http.HttpResponse";
    private static final String COMPLETION_CASE_SENSITIVE = "completion-case-sensitive";
    private static final boolean COMPLETION_CASE_SENSITIVE_DEFAULT = true;
    private static final String JAVA_COMPLETION_SUBWORDS = "javaCompletionSubwords";
    private static final boolean JAVA_COMPLETION_SUBWORDS_DEFAULT = false;
    private static final PreferenceChangeListener preferencesTracker = new PreferenceChangeListener(){

        @Override
        public void preferenceChange(PreferenceChangeEvent evt) {
            String settingName;
            String string = settingName = evt == null ? null : evt.getKey();
            if (settingName == null || Utils.COMPLETION_CASE_SENSITIVE.equals(settingName)) {
                caseSensitive = preferences.getBoolean(Utils.COMPLETION_CASE_SENSITIVE, true);
            }
            if (settingName == null || Utils.JAVA_COMPLETION_SUBWORDS.equals(settingName)) {
                javaCompletionSubwords = preferences.getBoolean(Utils.JAVA_COMPLETION_SUBWORDS, false);
            }
        }
    };
    private static final AtomicBoolean inited = new AtomicBoolean(false);
    private static Preferences preferences;
    private static boolean caseSensitive;
    private static boolean javaCompletionSubwords;
    private static String cachedPrefix;
    private static Pattern cachedCamelCasePattern;
    private static Pattern cachedSubwordsPattern;

    public static List<VariableElement> collectMissingDataEndpoints(CompilationInfo info, TypeElement te, String prefix, DataEndpointConsumer consumer) {
        AnnotationMirror controllerAnn = Utils.getAnnotation(te.getAnnotationMirrors(), CONTROLLER_ANNOTATION_NAME);
        if (controllerAnn == null) {
            return Collections.emptyList();
        }
        List<VariableElement> repositories = Utils.getRepositoriesFor(info, te);
        if (!repositories.isEmpty()) {
            String controllerId = null;
            for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : controllerAnn.getElementValues().entrySet()) {
                if (!"value".contentEquals(entry.getKey().getSimpleName()) && !"uri".contentEquals(entry.getKey().getSimpleName())) continue;
                controllerId = (String)entry.getValue().getValue();
            }
            List<ExecutableElement> methods = ElementFilter.methodsIn(te.getEnclosedElements());
            for (VariableElement repository : repositories) {
                TypeMirror repositoryType = repository.asType();
                if (repositoryType.getKind() != TypeKind.DECLARED) continue;
                TypeMirror pageableRepositoryType = info.getTypes().erasure(info.getElements().getTypeElement(PAGEABLE_REPOSITORY_TYPE_NAME).asType());
                boolean isPageableRepository = info.getTypes().isSubtype(info.getTypes().erasure(repositoryType), pageableRepositoryType);
                TypeElement repositoryTypeElement = (TypeElement)((DeclaredType)repositoryType).asElement();
                String id = null;
                if (repositories.size() > 1) {
                    id = '/' + repositoryTypeElement.getSimpleName().toString().toLowerCase();
                    if (id.endsWith("repository")) {
                        id = id.substring(0, id.length() - 10);
                    }
                    if (controllerId != null && !controllerId.equals(id)) continue;
                }
                List repositoryMethods = ElementFilter.methodsIn(info.getElements().getAllMembers(repositoryTypeElement)).stream().filter(method -> {
                    String methodName = method.getSimpleName().toString();
                    if ("findAll".equals(methodName)) {
                        if (isPageableRepository) {
                            TypeMirror paramType = method.getParameters().size() == 1 ? method.getParameters().get(0).asType() : null;
                            return paramType != null && paramType.getKind() == TypeKind.DECLARED && PAGEABLE_TYPE_NAME.contentEquals(((TypeElement)((DeclaredType)paramType).asElement()).getQualifiedName());
                        }
                        return method.getParameters().isEmpty();
                    }
                    if (methodName.endsWith("All")) {
                        return false;
                    }
                    if (methodName.startsWith("find")) {
                        return true;
                    }
                    if (methodName.startsWith("delete")) {
                        return true;
                    }
                    if (methodName.startsWith("save")) {
                        return true;
                    }
                    return methodName.startsWith("update");
                }).collect(Collectors.toList());
                for (ExecutableElement repositoryMethod : repositoryMethods) {
                    if (Utils.getEndpointMethodFor(info, methods, (DeclaredType)repository.asType(), repositoryMethod, id) != null) continue;
                    consumer.accept(repository, repositoryMethod, controllerId, id);
                }
            }
        }
        return repositories;
    }

    public static AnnotationMirror getAnnotation(List<? extends AnnotationMirror> annotations, String annotationName) {
        return Utils.getAnnotation(annotations, annotationName, new HashSet<TypeElement>());
    }

    public static List<VariableElement> getRepositoriesFor(CompilationInfo info, TypeElement te) {
        ArrayList<VariableElement> repositories = new ArrayList<VariableElement>();
        TypeMirror tm = info.getTypes().erasure(info.getElements().getTypeElement(CRUD_REPOSITORY_TYPE_NAME).asType());
        for (VariableElement ve : ElementFilter.fieldsIn(te.getEnclosedElements())) {
            if (ve.asType().getKind() != TypeKind.DECLARED || !info.getTypes().isSubtype(info.getTypes().erasure(ve.asType()), tm)) continue;
            repositories.add(ve);
        }
        return repositories;
    }

    public static MethodTree createControllerFindAllDataEndpointMethod(WorkingCopy copy, TypeElement repositoryTypeElement, String repositoryFieldName, String controllerId, String idProefix) {
        TypeMirror repositoryType = repositoryTypeElement.asType();
        if (repositoryType.getKind() == TypeKind.DECLARED) {
            TypeMirror pageableRepositoryType = copy.getTypes().erasure(copy.getElements().getTypeElement(PAGEABLE_REPOSITORY_TYPE_NAME).asType());
            boolean isPageableRepository = copy.getTypes().isSubtype(copy.getTypes().erasure(repositoryType), pageableRepositoryType);
            ExecutableElement delegateMethod = ElementFilter.methodsIn(copy.getElements().getAllMembers(repositoryTypeElement)).stream().filter(method -> {
                if (!"findAll".contentEquals(method.getSimpleName())) {
                    return false;
                }
                if (isPageableRepository) {
                    TypeMirror paramType = method.getParameters().size() == 1 ? method.getParameters().get(0).asType() : null;
                    return paramType != null && paramType.getKind() == TypeKind.DECLARED && PAGEABLE_TYPE_NAME.contentEquals(((TypeElement)((DeclaredType)paramType).asElement()).getQualifiedName());
                }
                return method.getParameters().isEmpty();
            }).findFirst().orElse(null);
            if (delegateMethod != null) {
                return Utils.createControllerDataEndpointMethod(copy, (DeclaredType)repositoryType, repositoryFieldName, delegateMethod, controllerId, idProefix);
            }
        }
        return null;
    }

    public static MethodTree createControllerDataEndpointMethod(WorkingCopy copy, DeclaredType repositoryType, String repositoryFieldName, ExecutableElement delegateMethod, String controllerId, String idPrefix) {
        TreeMaker tm = copy.getTreeMaker();
        GenerationUtils gu = GenerationUtils.newInstance((WorkingCopy)copy);
        ExecutableType delegateMethodType = (ExecutableType)copy.getTypes().asMemberOf(repositoryType, delegateMethod);
        String delegateMethodName = delegateMethod.getSimpleName().toString();
        ArrayList<AnnotationTree> annotations = new ArrayList<AnnotationTree>();
        String annotationTypeName = Utils.getControllerDataEndpointAnnotationTypeName(delegateMethodName);
        String value = Utils.getControllerDataEndpointAnnotationValue(delegateMethod, delegateMethodType, idPrefix);
        annotations.add(value != null ? gu.createAnnotation(annotationTypeName, List.of(tm.Literal((Object)value))) : gu.createAnnotation(annotationTypeName));
        if (DELETE_ANNOTATION_NAME.equals(annotationTypeName)) {
            annotations.add(gu.createAnnotation("io.micronaut.http.annotation.Status", List.of(tm.MemberSelect(tm.QualIdent("io.micronaut.http.HttpStatus"), (CharSequence)"NO_CONTENT"))));
        }
        ModifiersTree mods = tm.Modifiers(Set.of(Modifier.PUBLIC), annotations);
        String methodName = Utils.getControllerDataEndpointMethodName(delegateMethodName, idPrefix);
        TypeMirror returnType = Utils.getControllerDataEndpointReturnType((CompilationInfo)copy, delegateMethodName, delegateMethodType);
        ArrayList<TypeParameterTree> typeParams = new ArrayList<TypeParameterTree>();
        for (TypeVariable typeVariable : delegateMethodType.getTypeVariables()) {
            typeParams.add(tm.TypeParameter((CharSequence)typeVariable.asElement().getSimpleName(), List.of((ExpressionTree)tm.Type(typeVariable.getUpperBound()))));
        }
        List<? extends VariableTree> params = Utils.getControllerDataEndpointParams(copy, delegateMethod, delegateMethodType);
        String string = Utils.getControllerDataEndpointBody(copy, repositoryFieldName, delegateMethod, delegateMethodType, controllerId, idPrefix);
        return tm.Method(mods, (CharSequence)methodName, tm.Type(returnType), typeParams, params, List.of(), string, null);
    }

    public static String getControllerDataEndpointMethodName(String delegateMethodName, String postfix) {
        String name;
        switch (delegateMethodName) {
            case "findAll": {
                name = "list";
                break;
            }
            case "findById": {
                name = "get";
                break;
            }
            case "deleteById": {
                name = "delete";
                break;
            }
            default: {
                name = delegateMethodName;
            }
        }
        if (postfix != null) {
            if (postfix.startsWith("/")) {
                postfix = postfix.substring(1);
            }
            if (!postfix.isEmpty()) {
                return name + Character.toUpperCase(postfix.charAt(0)) + postfix.substring(1);
            }
        }
        return name;
    }

    public static TypeMirror getControllerDataEndpointReturnType(CompilationInfo info, String delegateMethodName, ExecutableType type) {
        TypeMirror returnType = type.getReturnType();
        if (delegateMethodName.startsWith("update")) {
            returnType = info.getTypes().getDeclaredType(info.getElements().getTypeElement(HTTP_RESPONSE_TYPE_NAME), new TypeMirror[0]);
        } else if (delegateMethodName.startsWith("save")) {
            returnType = info.getTypes().getDeclaredType(info.getElements().getTypeElement(HTTP_RESPONSE_TYPE_NAME), returnType);
        } else if ("findAll".equals(delegateMethodName) && !type.getParameterTypes().isEmpty() && returnType.getKind() == TypeKind.DECLARED) {
            TypeElement te = (TypeElement)((DeclaredType)returnType).asElement();
            Optional<ExecutableElement> getContentMethod = ElementFilter.methodsIn(info.getElements().getAllMembers(te)).stream().filter(m -> "getContent".contentEquals(m.getSimpleName()) && m.getParameters().isEmpty()).findAny();
            if (getContentMethod.isPresent()) {
                returnType = ((ExecutableType)info.getTypes().asMemberOf((DeclaredType)returnType, getContentMethod.get())).getReturnType();
            }
        }
        return returnType;
    }

    public static String getControllerDataEndpointAnnotationTypeName(String delegateMethodName) {
        if (delegateMethodName.startsWith("find")) {
            return GET_ANNOTATION_NAME;
        }
        if (delegateMethodName.startsWith("delete")) {
            return DELETE_ANNOTATION_NAME;
        }
        if (delegateMethodName.startsWith("save")) {
            return POST_ANNOTATION_NAME;
        }
        if (delegateMethodName.startsWith("update")) {
            return PUT_ANNOTATION_NAME;
        }
        return null;
    }

    public static String getControllerDataEndpointAnnotationValue(ExecutableElement delegateMethod, ExecutableType delegateMethodType, String idPrefix) {
        VariableElement idElement;
        String delegateMethodName = delegateMethod.getSimpleName().toString();
        if (delegateMethodName.endsWith("ById") && !delegateMethod.getParameters().isEmpty()) {
            String id = delegateMethod.getParameters().get(0).getSimpleName().toString();
            return idPrefix != null ? idPrefix + "/{" + id + "}" : "/{" + id + "}";
        }
        if (delegateMethodName.startsWith("update") && (idElement = Utils.getIdElement(delegateMethod.getParameters())) != null) {
            String id = idElement.getSimpleName().toString();
            return idPrefix != null ? idPrefix + "/{" + id + "}" : "/{" + id + "}";
        }
        return idPrefix;
    }

    public static List<TypeElement> getRelevantAnnotations(VariableElement variableElement) {
        ArrayList<TypeElement> annotations = new ArrayList<TypeElement>();
        for (AnnotationMirror annotationMirror : variableElement.getAnnotationMirrors()) {
            TypeElement te = (TypeElement)annotationMirror.getAnnotationType().asElement();
            String fqn = te.getQualifiedName().toString();
            if (!fqn.equals("io.micronaut.data.annotation.Id") && !fqn.startsWith("jakarta.validation.constraints.")) continue;
            annotations.add(te);
        }
        return annotations;
    }

    public static boolean isJPASupported(SourceGroup sg) {
        return Utils.resolveClassName(sg, "io.micronaut.data.jpa.repository.JpaRepository");
    }

    public static boolean isDBSupported(SourceGroup sg) {
        return Utils.resolveClassName(sg, "io.micronaut.data.annotation.Id");
    }

    public static boolean startsWith(String theString, String prefix) {
        return Utils.isCamelCasePrefix(prefix) ? (Utils.isCaseSensitive() ? Utils.startsWithCamelCase(theString, prefix) : Utils.startsWithCamelCase(theString, prefix) || Utils.startsWithPlain(theString, prefix)) : Utils.startsWithPlain(theString, prefix);
    }

    public static CharSequence getTypeName(CompilationInfo info, TypeMirror type, boolean fqn, boolean varArg) {
        EnumSet<TypeUtilities.TypeNameOptions> options = EnumSet.noneOf(TypeUtilities.TypeNameOptions.class);
        if (fqn) {
            options.add(TypeUtilities.TypeNameOptions.PRINT_FQN);
        }
        if (varArg) {
            options.add(TypeUtilities.TypeNameOptions.PRINT_AS_VARARG);
        }
        return info.getTypeUtilities().getTypeName(type, options.toArray(new TypeUtilities.TypeNameOptions[0]));
    }

    private static ExecutableElement getEndpointMethodFor(CompilationInfo info, List<ExecutableElement> methods, DeclaredType repositoryType, ExecutableElement delegateMethod, String id) {
        String delegateMethodName = delegateMethod.getSimpleName().toString();
        String annotationName = Utils.getControllerDataEndpointAnnotationTypeName(delegateMethodName);
        if (annotationName != null) {
            String methodName = Utils.getControllerDataEndpointMethodName(delegateMethodName, id);
            ExecutableType delegateMethodType = (ExecutableType)info.getTypes().asMemberOf(repositoryType, delegateMethod);
            String value = Utils.getControllerDataEndpointAnnotationValue(delegateMethod, delegateMethodType, id);
            for (ExecutableElement method : methods) {
                AnnotationMirror annotation;
                if (!methodName.contentEquals(method.getSimpleName()) || (annotation = Utils.getAnnotation(method.getAnnotationMirrors(), annotationName, new HashSet<TypeElement>())) == null) continue;
                Map<? extends ExecutableElement, ? extends AnnotationValue> elementValues = annotation.getElementValues();
                Object val = null;
                for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : elementValues.entrySet()) {
                    if (!"value".contentEquals(entry.getKey().getSimpleName())) continue;
                    val = entry.getValue().getValue();
                }
                if (!Objects.equals(value, val)) continue;
                return method;
            }
        }
        return null;
    }

    private static VariableElement getIdElement(List<? extends VariableElement> elements) {
        for (VariableElement variableElement : elements) {
            for (AnnotationMirror annotationMirror : variableElement.getAnnotationMirrors()) {
                TypeElement annotationElement = (TypeElement)annotationMirror.getAnnotationType().asElement();
                if (!"io.micronaut.data.annotation.Id".contentEquals(annotationElement.getQualifiedName()) && !"javax.persistence.Id".contentEquals(annotationElement.getQualifiedName())) continue;
                return variableElement;
            }
        }
        return null;
    }

    private static List<? extends VariableTree> getControllerDataEndpointParams(WorkingCopy copy, ExecutableElement delegateMethod, ExecutableType type) {
        TreeMaker tm = copy.getTreeMaker();
        GenerationUtils gu = GenerationUtils.newInstance((WorkingCopy)copy);
        ArrayList<VariableTree> params = new ArrayList<VariableTree>();
        String delegateMethodName = delegateMethod.getSimpleName().toString();
        VariableElement idElem = Utils.getIdElement(delegateMethod.getParameters());
        if (idElem == null && delegateMethodName.endsWith("ById") && !delegateMethod.getParameters().isEmpty()) {
            idElem = delegateMethod.getParameters().get(0);
        }
        Iterator<? extends VariableElement> it = delegateMethod.getParameters().iterator();
        Iterator<? extends TypeMirror> tIt = type.getParameterTypes().iterator();
        while (it.hasNext() && tIt.hasNext()) {
            VariableElement param = it.next();
            TypeMirror paramType = tIt.next();
            ArrayList<AnnotationTree> annotations = new ArrayList<AnnotationTree>();
            if ("findAll".equals(delegateMethodName)) {
                annotations.add(gu.createAnnotation(VALID_ANNOTATION_NAME));
            } else if (idElem == null) {
                annotations.add(gu.createAnnotation(BODY_ANNOTATION_NAME));
                annotations.add(gu.createAnnotation(VALID_ANNOTATION_NAME));
            } else if (idElem != param) {
                annotations.add(gu.createAnnotation(BODY_ANNOTATION_NAME, List.of(tm.Literal((Object)param.getSimpleName().toString()))));
                for (AnnotationMirror annotationMirror : param.getAnnotationMirrors()) {
                    annotations.add(gu.createAnnotation(((TypeElement)annotationMirror.getAnnotationType().asElement()).getQualifiedName().toString()));
                }
            }
            params.add(tm.Variable(tm.Modifiers(0L, annotations), (CharSequence)param.getSimpleName(), tm.Type(paramType), null));
        }
        return params;
    }

    private static String getControllerDataEndpointBody(WorkingCopy copy, String repositoryFieldName, ExecutableElement delegateMethod, ExecutableType delegateMethodType, String controllerId, String idPrefix) {
        String idUri;
        String delegateMethodName = delegateMethod.getSimpleName().toString();
        StringBuilder delegateMethodCall = new StringBuilder();
        delegateMethodCall.append(repositoryFieldName).append('.').append(delegateMethodName).append('(');
        Iterator<? extends VariableElement> it = delegateMethod.getParameters().iterator();
        while (it.hasNext()) {
            VariableElement param = it.next();
            delegateMethodCall.append(param.getSimpleName());
            if (!it.hasNext()) continue;
            delegateMethodCall.append(',');
        }
        delegateMethodCall.append(')');
        if (delegateMethodName.equals("findAll") && !delegateMethod.getParameters().isEmpty()) {
            return "{return " + delegateMethodCall.toString() + ".getContent();}";
        }
        if (delegateMethodName.startsWith("find")) {
            return "{return " + delegateMethodCall.toString() + ";}";
        }
        if (delegateMethodName.startsWith("delete")) {
            return "{" + delegateMethodCall.toString() + ";}";
        }
        if (delegateMethodName.startsWith("save")) {
            copy.rewrite((Tree)copy.getCompilationUnit(), (Tree)GeneratorUtilities.get((WorkingCopy)copy).addImports(copy.getCompilationUnit(), Set.of(copy.getElements().getTypeElement("java.net.URI"))));
            idUri = Utils.getIdUri(delegateMethod, delegateMethodType, controllerId, idPrefix);
            CharSequence typeName = Utils.getTypeName((CompilationInfo)copy, delegateMethodType.getReturnType(), false, false);
            StringBuilder sb = new StringBuilder(typeName);
            sb.setCharAt(0, Character.toLowerCase(sb.charAt(0)));
            return "{" + typeName + " " + sb.toString() + " = " + delegateMethodCall.toString() + "return HttpResponse.created(" + sb.toString() + ").headers(headers -> headers.location(" + idUri + "));}";
        }
        if (delegateMethodName.startsWith("update")) {
            copy.rewrite((Tree)copy.getCompilationUnit(), (Tree)GeneratorUtilities.get((WorkingCopy)copy).addImports(copy.getCompilationUnit(), Set.of(copy.getElements().getTypeElement("java.net.URI"), copy.getElements().getTypeElement("io.micronaut.http.HttpHeaders"))));
            idUri = Utils.getIdUri(delegateMethod, delegateMethodType, controllerId, idPrefix);
            return "{" + delegateMethodCall.toString() + ";return HttpResponse.noContent().header(HttpHeaders.LOCATION, " + idUri + ".getPath());}";
        }
        return "{}";
    }

    private static AnnotationMirror getAnnotation(List<? extends AnnotationMirror> annotations, String annotationName, HashSet<TypeElement> checked) {
        for (AnnotationMirror annotationMirror : annotations) {
            AnnotationMirror nestedAnnotation;
            TypeElement annotationElement = (TypeElement)annotationMirror.getAnnotationType().asElement();
            if (annotationName.contentEquals(annotationElement.getQualifiedName())) {
                return annotationMirror;
            }
            if (!checked.add(annotationElement) || (nestedAnnotation = Utils.getAnnotation(annotationElement.getAnnotationMirrors(), annotationName, checked)) == null) continue;
            return nestedAnnotation;
        }
        return null;
    }

    private static String getIdUri(ExecutableElement delegateMethod, ExecutableType delegateMethodType, String controllerId, String idPrefix) {
        StringBuilder idGet = new StringBuilder();
        VariableElement idElem = Utils.getIdElement(delegateMethod.getParameters());
        if (idElem != null) {
            idGet.append(idElem.getSimpleName());
        } else {
            Iterator<? extends VariableElement> it = delegateMethod.getParameters().iterator();
            Iterator<? extends TypeMirror> tIt = delegateMethodType.getParameterTypes().iterator();
            if (it.hasNext() && tIt.hasNext()) {
                VariableElement idField;
                DeclaredType entityType = null;
                TypeMirror tm = tIt.next();
                if (tm.getKind() == TypeKind.TYPEVAR) {
                    TypeMirror upperBound = ((TypeVariable)tm).getUpperBound();
                    if (upperBound.getKind() == TypeKind.DECLARED) {
                        entityType = (DeclaredType)upperBound;
                    }
                } else if (tm.getKind() == TypeKind.DECLARED) {
                    entityType = (DeclaredType)tm;
                }
                if (entityType != null && (idField = Utils.getIdElement(ElementFilter.fieldsIn(entityType.asElement().getEnclosedElements()))) != null) {
                    StringBuilder getter = new StringBuilder(idField.getSimpleName());
                    getter.setCharAt(0, Character.toUpperCase(getter.charAt(0)));
                    getter.insert(0, "get").append("()");
                    idGet.append(it.next().getSimpleName()).append('.').append(getter.toString());
                }
            }
        }
        StringBuilder sb = new StringBuilder("URI.create(\"");
        if (controllerId != null) {
            sb.append(controllerId);
        }
        if (idPrefix != null) {
            sb.append(idPrefix);
        }
        sb.append("/\"");
        if (idGet.length() > 0) {
            sb.append(" + ").append((CharSequence)idGet);
        }
        return sb.append(')').toString();
    }

    private static boolean isCamelCasePrefix(String prefix) {
        if (prefix == null || prefix.length() < 2 || prefix.charAt(0) == '\"') {
            return false;
        }
        for (int i = 1; i < prefix.length(); ++i) {
            if (!Character.isUpperCase(prefix.charAt(i))) continue;
            return true;
        }
        return false;
    }

    private static boolean isCaseSensitive() {
        Utils.lazyInit();
        return caseSensitive;
    }

    private static boolean isSubwordSensitive() {
        Utils.lazyInit();
        return javaCompletionSubwords;
    }

    private static boolean startsWithPlain(String theString, String prefix) {
        if (theString == null || theString.length() == 0) {
            return false;
        }
        if (prefix == null || prefix.length() == 0) {
            return true;
        }
        if (Utils.isSubwordSensitive()) {
            if (!prefix.equals(cachedPrefix)) {
                cachedCamelCasePattern = null;
                cachedSubwordsPattern = null;
            }
            if (cachedSubwordsPattern == null) {
                cachedPrefix = prefix;
                String patternString = Utils.createSubwordsPattern(prefix);
                Pattern pattern = cachedSubwordsPattern = patternString != null ? Pattern.compile(patternString) : null;
            }
            if (cachedSubwordsPattern != null && cachedSubwordsPattern.matcher(theString).matches()) {
                return true;
            }
        }
        return Utils.isCaseSensitive() ? theString.startsWith(prefix) : theString.toLowerCase(Locale.ENGLISH).startsWith(prefix.toLowerCase(Locale.ENGLISH));
    }

    private static String createSubwordsPattern(String prefix) {
        StringBuilder sb = new StringBuilder(3 + 8 * prefix.length());
        sb.append(".*?");
        for (int i = 0; i < prefix.length(); ++i) {
            char charAt = prefix.charAt(i);
            if (!Character.isJavaIdentifierPart(charAt)) {
                return null;
            }
            if (Character.isLowerCase(charAt)) {
                sb.append("[");
                sb.append(charAt);
                sb.append(Character.toUpperCase(charAt));
                sb.append("]");
            } else {
                sb.append(charAt);
            }
            sb.append(".*?");
        }
        return sb.toString();
    }

    private static boolean startsWithCamelCase(String theString, String prefix) {
        if (theString == null || theString.length() == 0 || prefix == null || prefix.length() == 0) {
            return false;
        }
        if (!prefix.equals(cachedPrefix)) {
            cachedCamelCasePattern = null;
            cachedSubwordsPattern = null;
        }
        if (cachedCamelCasePattern == null) {
            int index;
            StringBuilder sb = new StringBuilder();
            int lastIndex = 0;
            do {
                String token = prefix.substring(lastIndex, (index = Utils.findNextUpper(prefix, lastIndex + 1)) == -1 ? prefix.length() : index);
                sb.append(token);
                sb.append(index != -1 ? "[\\p{javaLowerCase}\\p{Digit}_\\$]*" : ".*");
                lastIndex = index;
            } while (index != -1);
            cachedPrefix = prefix;
            cachedCamelCasePattern = Pattern.compile(sb.toString());
        }
        return cachedCamelCasePattern.matcher(theString).matches();
    }

    private static int findNextUpper(String text, int offset) {
        for (int i = offset; i < text.length(); ++i) {
            if (!Character.isUpperCase(text.charAt(i))) continue;
            return i;
        }
        return -1;
    }

    private static void lazyInit() {
        if (inited.compareAndSet(false, true)) {
            preferences = (Preferences)MimeLookup.getLookup((String)JavaTokenId.language().mimeType()).lookup(Preferences.class);
            preferences.addPreferenceChangeListener((PreferenceChangeListener)WeakListeners.create(PreferenceChangeListener.class, (EventListener)preferencesTracker, (Object)preferences));
            preferencesTracker.preferenceChange(null);
        }
    }

    private static boolean resolveClassName(SourceGroup sg, String fqn) {
        if (sg == null) {
            return false;
        }
        ClassPath compile = ClassPath.getClassPath((FileObject)sg.getRootFolder(), (String)"classpath/compile");
        if (compile == null) {
            return false;
        }
        return compile.findResource(fqn.replace('.', '/') + ".class") != null;
    }

    static {
        caseSensitive = true;
        javaCompletionSubwords = false;
        cachedPrefix = null;
        cachedCamelCasePattern = null;
        cachedSubwordsPattern = null;
    }

    @FunctionalInterface
    public static interface DataEndpointConsumer {
        public void accept(VariableElement var1, ExecutableElement var2, String var3, String var4);
    }
}

