/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.micronaut.expression;

import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.Scope;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import com.sun.source.util.Trees;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.ClassIndex;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.classfile.CPEntry;
import org.netbeans.modules.classfile.ClassFile;
import org.netbeans.modules.classfile.Code;
import org.netbeans.modules.classfile.ConstantPool;
import org.netbeans.modules.classfile.Method;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

public final class EvaluationContext {
    private static final String REGISTRATIONS_METADATA = "META-INF/services/io.micronaut.inject.visitor.TypeElementVisitor";
    private static final String CONTEXT_REGISTRAR_CLASS = "io.micronaut.expressions.context.ExpressionEvaluationContextRegistrar";
    private static final String CONTEXT_REGISTRAR_METHOD_NAME = "getContextClassName";
    private static final String CONTEXT_REGISTRAR_METHOD_SIGNATURE = "()Ljava/lang/String;";
    private static final String ANNOTATION_CONTEXT_CLASS = "io.micronaut.context.annotation.AnnotationExpressionContext";
    private final CompilationInfo info;
    private final ClassPath compileCP;
    private final ClassPath processorCP;
    private final Scope scope;
    private final Element annotationMemeber;
    private List<TypeElement> contextClasses = null;

    public static EvaluationContext get(CompilationInfo info, TreePath path) {
        Project project = FileOwnerQuery.getOwner((FileObject)info.getFileObject());
        ClassPath processorCP = EvaluationContext.getProcessorClasspath(project);
        return processorCP.findResource(CONTEXT_REGISTRAR_CLASS.replace('.', '/') + ".class") != null ? new EvaluationContext(info, EvaluationContext.getCompileClasspath(project), processorCP, path) : null;
    }

    private EvaluationContext(CompilationInfo info, ClassPath compileCP, ClassPath processorCP, TreePath path) {
        this.info = info;
        this.compileCP = compileCP;
        this.processorCP = processorCP;
        this.scope = info.getTrees().getScope(path);
        this.annotationMemeber = path.getLeaf().getKind() == Tree.Kind.ASSIGNMENT ? info.getTrees().getElement(new TreePath(path, ((AssignmentTree)path.getLeaf()).getVariable())) : null;
    }

    public Trees getTrees() {
        return this.info.getTrees();
    }

    public Types getTypes() {
        return this.info.getTypes();
    }

    public Elements getElements() {
        return this.info.getElements();
    }

    public Scope getScope() {
        return this.scope;
    }

    public List<ExecutableElement> getContextMethods() {
        if (this.contextClasses == null) {
            this.initializeContextClasses();
        }
        ArrayList<ExecutableElement> methods = new ArrayList<ExecutableElement>();
        for (TypeElement contextClass : this.contextClasses) {
            methods.addAll(ElementFilter.methodsIn(contextClass.getEnclosedElements()));
        }
        return methods;
    }

    private void initializeContextClasses() {
        this.contextClasses = new ArrayList<TypeElement>();
        ElementHandle handle = ElementHandle.createTypeElementHandle((ElementKind)ElementKind.INTERFACE, (String)CONTEXT_REGISTRAR_CLASS);
        Set elements = this.info.getClasspathInfo().getClassIndex().getElements(handle, EnumSet.of(ClassIndex.SearchKind.IMPLEMENTORS), EnumSet.allOf(ClassIndex.SearchScope.class));
        if (this.compileCP != null && this.processorCP != null) {
            for (FileObject fo : this.processorCP.findAllResources(REGISTRATIONS_METADATA)) {
                try {
                    for (String fqn : fo.asLines()) {
                        TypeElement cls;
                        ConstantPool constantPool;
                        CPEntry entry;
                        Object value;
                        Code code;
                        byte[] byteCodes;
                        ClassFile classFile;
                        Method method;
                        FileObject clsFO;
                        TypeElement te = this.info.getElements().getTypeElement(fqn);
                        if (te == null || !elements.contains(ElementHandle.create((Element)te)) || (clsFO = this.compileCP.findResource(fqn.replace('.', '/') + ".class")) == null || (method = (classFile = new ClassFile(clsFO.getInputStream())).getMethod(CONTEXT_REGISTRAR_METHOD_NAME, CONTEXT_REGISTRAR_METHOD_SIGNATURE)) == null || (byteCodes = (code = method.getCode()).getByteCodes()).length != 3 || byteCodes[0] != 18 || byteCodes[2] != -80 || !((value = (entry = (constantPool = classFile.getConstantPool()).get((int)byteCodes[1])).getValue()) instanceof String) || (cls = this.info.getElements().getTypeElement((String)value)) == null) continue;
                        this.contextClasses.add(cls);
                    }
                }
                catch (Exception ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }
        if (this.annotationMemeber != null) {
            this.addAnnotationContextClasses(this.annotationMemeber);
            this.addAnnotationContextClasses(this.annotationMemeber.getEnclosingElement());
        }
    }

    private void addAnnotationContextClasses(Element element) {
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            Element metaAnn = annotationMirror.getAnnotationType().asElement();
            if (metaAnn.getKind() != ElementKind.ANNOTATION_TYPE || !ANNOTATION_CONTEXT_CLASS.contentEquals(((TypeElement)metaAnn).getQualifiedName())) continue;
            for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : annotationMirror.getElementValues().entrySet()) {
                Object value;
                if ("className".contentEquals(entry.getKey().getSimpleName())) {
                    TypeElement te;
                    value = entry.getValue().getValue();
                    if (!(value instanceof String) || (te = this.info.getElements().getTypeElement((CharSequence)value)) == null) continue;
                    this.contextClasses.add(te);
                    continue;
                }
                if (!"value".contentEquals(entry.getKey().getSimpleName()) || !((value = entry.getValue().getValue()) instanceof DeclaredType)) continue;
                this.contextClasses.add((TypeElement)((DeclaredType)value).asElement());
            }
        }
    }

    private static ClassPath getProcessorClasspath(Project project) {
        SourceGroup[] srcGroups = ProjectUtils.getSources((Project)project).getSourceGroups("java");
        if (srcGroups.length > 0) {
            return ClassPath.getClassPath((FileObject)srcGroups[0].getRootFolder(), (String)"classpath/processor");
        }
        return null;
    }

    private static ClassPath getCompileClasspath(Project project) {
        SourceGroup[] srcGroups = ProjectUtils.getSources((Project)project).getSourceGroups("java");
        if (srcGroups.length > 0) {
            return ClassPath.getClassPath((FileObject)srcGroups[0].getRootFolder(), (String)"classpath/compile");
        }
        return null;
    }
}

