/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.jaxws;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.deployment.devmodules.api.Deployment;
import org.netbeans.modules.j2ee.deployment.devmodules.api.InstanceRemovedException;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eePlatform;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.javaee.specs.support.api.JaxWs;
import org.netbeans.modules.javaee.specs.support.api.JaxWsStackSupport;
import org.netbeans.modules.maven.jaxws.ServerType;
import org.netbeans.modules.websvc.wsstack.api.WSStack;
import org.openide.util.Lookup;

public class WSStackUtils {
    private Project project;
    private J2eePlatform j2eePlatform;
    public static final String DEVNULL = "DEV-NULL";

    public WSStackUtils(Project project) {
        this.project = project;
        this.j2eePlatform = this.getJ2eePlatform(project);
    }

    private J2eePlatform getJ2eePlatform(Project project) {
        String serverInstanceID;
        J2eeModuleProvider provider = (J2eeModuleProvider)project.getLookup().lookup(J2eeModuleProvider.class);
        if (provider != null && (serverInstanceID = provider.getServerInstanceID()) != null && !serverInstanceID.equals(DEVNULL)) {
            try {
                return Deployment.getDefault().getServerInstance(serverInstanceID).getJ2eePlatform();
            }
            catch (InstanceRemovedException ex) {
                Logger.getLogger(this.getClass().getName()).log(Level.INFO, "Failed to find J2eePlatform", ex);
            }
        }
        return null;
    }

    public boolean isWsitSupported() {
        if (this.j2eePlatform != null) {
            WSStack wsStack = JaxWsStackSupport.getJaxWsStack((J2eePlatform)this.j2eePlatform);
            return wsStack != null && wsStack.isFeatureSupported((WSStack.Feature)JaxWs.Feature.WSIT);
        }
        return false;
    }

    public boolean isJsr109Supported() {
        if (this.j2eePlatform != null) {
            WSStack wsStack = JaxWsStackSupport.getJaxWsStack((J2eePlatform)this.j2eePlatform);
            return wsStack != null && wsStack.isFeatureSupported((WSStack.Feature)JaxWs.Feature.JSR109);
        }
        return true;
    }

    public boolean isJsr109OldSupported() {
        return this.j2eePlatform != null && WSStackUtils.getServerType(this.project) == ServerType.GLASSFISH;
    }

    public static ServerType getServerType(Project project) {
        J2eeModuleProvider j2eeModuleProvider = (J2eeModuleProvider)project.getLookup().lookup(J2eeModuleProvider.class);
        if (j2eeModuleProvider == null || j2eeModuleProvider.getServerInstanceID() == null || DEVNULL.equals(j2eeModuleProvider.getServerInstanceID())) {
            return ServerType.NOT_SPECIFIED;
        }
        String serverId = j2eeModuleProvider.getServerID();
        if (serverId.startsWith("Tomcat")) {
            return ServerType.TOMCAT;
        }
        if (serverId.equals("J2EE")) {
            return ServerType.GLASSFISH;
        }
        if (serverId.startsWith("gfv3")) {
            return ServerType.GLASSFISH_V3;
        }
        if (serverId.equals("GlassFish")) {
            return ServerType.GLASSFISH;
        }
        if (serverId.equals("APPSERVER")) {
            return ServerType.GLASSFISH;
        }
        if (serverId.equals("JavaEE")) {
            return ServerType.GLASSFISH;
        }
        if (serverId.startsWith("JBoss")) {
            return ServerType.JBOSS;
        }
        if (serverId.startsWith("WebLogic")) {
            return ServerType.WEBLOGIC;
        }
        if (serverId.startsWith("WebSphere")) {
            return ServerType.WEBSPHERE;
        }
        return ServerType.UNKNOWN;
    }

    public ServerType getServerType() {
        return WSStackUtils.getServerType(this.project);
    }

    public <T> WSStack<T> getWsStack(Class<T> stackDescriptor) {
        if (this.j2eePlatform != null) {
            return WSStack.findWSStack((Lookup)this.j2eePlatform.getLookup(), stackDescriptor);
        }
        return null;
    }
}

