/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.layoutsupport.delegates;

import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.LayoutManager2;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JToolBar;
import org.netbeans.modules.form.layoutsupport.AbstractLayoutSupport;
import org.netbeans.modules.form.layoutsupport.LayoutConstraints;

public class JToolBarSupport
extends AbstractLayoutSupport {
    private int assistantParams;

    @Override
    public Class getSupportedClass() {
        return JToolBar.class;
    }

    @Override
    public void addComponentsToContainer(Container container, Container containerDelegate, Component[] components, int index) {
        LayoutManager lm = containerDelegate.getLayout();
        if (lm instanceof LayoutManager2) {
            ((LayoutManager2)lm).invalidateLayout(containerDelegate);
        }
        super.addComponentsToContainer(container, containerDelegate, components, index);
    }

    @Override
    public int getNewIndex(Container container, Container containerDelegate, Component component, int index, Point posInCont, Point posInComp) {
        if (!(container instanceof JToolBar)) {
            return -1;
        }
        int orientation = ((JToolBar)container).getOrientation();
        this.assistantParams = 0;
        Component[] components = container.getComponents();
        for (int i = 0; i < components.length; ++i) {
            if (component == components[i]) {
                --this.assistantParams;
                continue;
            }
            Rectangle b = components[i].getBounds();
            if (orientation == 0) {
                if (posInCont.x >= b.x + b.width / 2) continue;
                this.assistantParams += i;
                return i;
            }
            if (posInCont.y >= b.y + b.height / 2) continue;
            this.assistantParams += i;
            return i;
        }
        this.assistantParams += components.length;
        return components.length;
    }

    @Override
    public String getAssistantContext() {
        return "toolbarLayout";
    }

    @Override
    public Object[] getAssistantParams() {
        return new Object[]{this.assistantParams + 1};
    }

    @Override
    public boolean paintDragFeedback(Container container, Container containerDelegate, Component component, LayoutConstraints newConstraints, int newIndex, Graphics g) {
        Rectangle rect;
        if (!(container instanceof JToolBar)) {
            return false;
        }
        int orientation = ((JToolBar)container).getOrientation();
        Component[] components = container.getComponents();
        if (newIndex >= 0 && newIndex < components.length && component == components[newIndex]) {
            ++newIndex;
        }
        if (components.length == 0 || components.length == 1 && components[0] == component) {
            Insets ins = container.getInsets();
            rect = orientation == 0 ? new Rectangle(ins.left, ins.top + (container.getHeight() - ins.top - ins.bottom - 20) / 2, 30, 20) : new Rectangle(ins.left + (container.getWidth() - ins.left - ins.right - 30) / 2, ins.top, 30, 20);
        } else if (newIndex < 0 || newIndex >= components.length) {
            int index = components[components.length - 1] == component ? components.length - 2 : components.length - 1;
            Rectangle b = components[index].getBounds();
            rect = orientation == 0 ? new Rectangle(b.x + b.width - 10, b.y, 20, b.height) : new Rectangle(b.x, b.y + b.height - 10, b.width, 20);
        } else {
            Rectangle b = components[newIndex].getBounds();
            rect = orientation == 0 ? new Rectangle(b.x - 10, b.y, 20, b.height) : new Rectangle(b.x, b.y - 10, b.width, 20);
        }
        g.drawRect(rect.x, rect.y, rect.width, rect.height);
        return true;
    }
}

