/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.nette2.codegen;

import java.util.Collections;
import java.util.List;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.lib.editor.codetemplates.api.CodeTemplate;
import org.netbeans.lib.editor.codetemplates.api.CodeTemplateManager;
import org.netbeans.modules.php.nette2.codegen.ActionRenderMethodChecker;
import org.netbeans.modules.php.nette2.codegen.Bundle;
import org.netbeans.modules.php.nette2.ui.codegen.ActionRenderCodeGeneratorTableModel;
import org.netbeans.modules.php.nette2.ui.codegen.ActionRenderVisualPanel;
import org.netbeans.modules.php.nette2.utils.FileUtils;
import org.netbeans.spi.editor.codegen.CodeGenerator;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;

public class ActionRenderCodeGenerator
implements CodeGenerator {
    private ActionRenderVisualPanel panel;
    private final JTextComponent textComp;
    private FileObject presenterFile;

    private ActionRenderCodeGenerator(Lookup context) {
        this.textComp = (JTextComponent)context.lookup(JTextComponent.class);
    }

    public String getDisplayName() {
        return Bundle.LBL_ActionRenderCodeGeneratorName();
    }

    public void invoke() {
        if (this.isProcessedDialog()) {
            assert (this.panel != null);
            CodeTemplateManager manager = CodeTemplateManager.get((Document)this.textComp.getDocument());
            CodeTemplate template = manager.createTemporary(this.createActionRenderMethods());
            template.insert(this.textComp);
        }
    }

    private boolean isProcessedDialog() {
        ActionRenderMethodChecker methodChecker = new ActionRenderMethodChecker(this.getPresenterFile());
        this.panel = new ActionRenderVisualPanel(new ActionRenderCodeGeneratorTableModel(methodChecker));
        this.panel.setMethodChecker(methodChecker);
        DialogDescriptor dd = new DialogDescriptor((Object)this.panel, Bundle.LBL_ActionRenderCodeGeneratorName(), true, 2, DialogDescriptor.OK_OPTION, null);
        return DialogDisplayer.getDefault().notify((NotifyDescriptor)dd) == NotifyDescriptor.OK_OPTION;
    }

    private FileObject getPresenterFile() {
        if (this.presenterFile == null) {
            this.presenterFile = FileUtils.getFile(this.textComp);
        }
        return this.presenterFile;
    }

    private String createActionRenderMethods() {
        ActionRenderMethodChecker armc = new ActionRenderMethodChecker(this.getPresenterFile());
        StringBuilder sb = new StringBuilder();
        for (ActionRenderVisualPanel.Action action : this.panel.getActions()) {
            String actionName = action.getName();
            if (action.isGenerateAction() && !armc.existsActionMethod(actionName)) {
                sb.append(action.generateAction());
            }
            if (!action.isGenerateRender() || armc.existsRenderMethod(actionName)) continue;
            sb.append(action.generateRender());
        }
        return sb.toString();
    }

    public static class Factory
    implements CodeGenerator.Factory {
        public List<? extends CodeGenerator> create(Lookup context) {
            return Collections.singletonList(new ActionRenderCodeGenerator(context));
        }
    }
}

