/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.jakarta.web.beans.analysis.analyzer;

import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import org.netbeans.modules.jakarta.web.beans.analysis.CdiAnalysisResult;
import org.netbeans.modules.jakarta.web.beans.analysis.analyzer.ElementAnalyzer;
import org.netbeans.modules.jakarta.web.beans.analysis.analyzer.field.DelegateFieldAnalizer;
import org.netbeans.modules.jakarta.web.beans.analysis.analyzer.field.ProducerFieldAnalyzer;
import org.netbeans.modules.jakarta.web.beans.analysis.analyzer.field.TypedFieldAnalyzer;

public class FieldElementAnalyzer
implements ElementAnalyzer {
    private static final List<FieldAnalyzer> ANALYZERS = new LinkedList<FieldAnalyzer>();

    @Override
    public void analyze(Element element, TypeElement parent, AtomicBoolean cancel, CdiAnalysisResult result) {
        VariableElement var = (VariableElement)element;
        TypeMirror varType = result.getInfo().getTypes().asMemberOf((DeclaredType)parent.asType(), var);
        for (FieldAnalyzer analyzer : ANALYZERS) {
            if (cancel.get()) {
                return;
            }
            analyzer.analyze(var, varType, parent, cancel, result);
        }
    }

    static {
        ANALYZERS.add(new TypedFieldAnalyzer());
        ANALYZERS.add(new DelegateFieldAnalizer());
        ANALYZERS.add(new ProducerFieldAnalyzer());
    }

    public static interface FieldAnalyzer {
        public void analyze(VariableElement var1, TypeMirror var2, TypeElement var3, AtomicBoolean var4, CdiAnalysisResult var5);
    }
}

