/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.processtreekiller;

import com.sun.jna.Platform;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.processtreekiller.Darwin;
import org.netbeans.processtreekiller.Linux;
import org.netbeans.processtreekiller.Solaris;
import org.netbeans.processtreekiller.Windows;

public abstract class ProcessTreeKiller {
    private static final ProcessTreeKiller DEFAULT = new ProcessTreeKiller(){

        @Override
        public void kill(Process proc, Map<String, String> modelEnvVars) {
            if (proc != null) {
                proc.destroy();
            }
        }
    };
    private static final Logger LOGGER = Logger.getLogger(ProcessTreeKiller.class.getName());
    public static boolean enabled = !Boolean.getBoolean(ProcessTreeKiller.class.getName() + ".disable");

    public void kill(Process proc) {
        this.kill(proc, null);
    }

    public abstract void kill(Process var1, Map<String, String> var2);

    public void kill(Map<String, String> modelEnvVars) {
        this.kill(null, modelEnvVars);
    }

    public static ProcessTreeKiller get() {
        if (!enabled) {
            return DEFAULT;
        }
        try {
            if (Platform.isWindows()) {
                return new Windows();
            }
            if (Platform.isLinux()) {
                return new Linux();
            }
            if (Platform.isSolaris()) {
                return new Solaris();
            }
            if (Platform.isMac()) {
                return new Darwin();
            }
        }
        catch (LinkageError e) {
            LOGGER.log(Level.WARNING, "Failed to load winp. Reverting to the default", e);
            enabled = false;
        }
        return DEFAULT;
    }

    protected boolean hasMatchingEnvVars(Map<String, String> envVar, Map<String, String> modelEnvVar) {
        if (modelEnvVar.isEmpty()) {
            return false;
        }
        for (Map.Entry<String, String> e : modelEnvVar.entrySet()) {
            String v = envVar.get(e.getKey());
            if (v != null && v.equals(e.getValue())) continue;
            return false;
        }
        return true;
    }
}

