/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.keymanagement.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.keymanagement.model.UpdateVaultDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class UpdateVaultRequest
extends BmcRequest<UpdateVaultDetails> {
    private String vaultId;
    private UpdateVaultDetails updateVaultDetails;
    private String ifMatch;
    private String opcRequestId;

    public String getVaultId() {
        return this.vaultId;
    }

    public UpdateVaultDetails getUpdateVaultDetails() {
        return this.updateVaultDetails;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    @InternalSdk
    public UpdateVaultDetails getBody$() {
        return this.updateVaultDetails;
    }

    public Builder toBuilder() {
        return new Builder().vaultId(this.vaultId).updateVaultDetails(this.updateVaultDetails).ifMatch(this.ifMatch).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",vaultId=").append(String.valueOf(this.vaultId));
        sb.append(",updateVaultDetails=").append(String.valueOf((Object)this.updateVaultDetails));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdateVaultRequest)) {
            return false;
        }
        UpdateVaultRequest other = (UpdateVaultRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.vaultId, other.vaultId) && Objects.equals((Object)this.updateVaultDetails, (Object)other.updateVaultDetails) && Objects.equals(this.ifMatch, other.ifMatch) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.vaultId == null ? 43 : this.vaultId.hashCode());
        result = result * 59 + (this.updateVaultDetails == null ? 43 : this.updateVaultDetails.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<UpdateVaultRequest, UpdateVaultDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String vaultId = null;
        private UpdateVaultDetails updateVaultDetails = null;
        private String ifMatch = null;
        private String opcRequestId = null;

        public Builder vaultId(String vaultId) {
            this.vaultId = vaultId;
            return this;
        }

        public Builder updateVaultDetails(UpdateVaultDetails updateVaultDetails) {
            this.updateVaultDetails = updateVaultDetails;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdateVaultRequest o) {
            this.vaultId(o.getVaultId());
            this.updateVaultDetails(o.getUpdateVaultDetails());
            this.ifMatch(o.getIfMatch());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdateVaultRequest build() {
            UpdateVaultRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(UpdateVaultDetails body) {
            this.updateVaultDetails(body);
            return this;
        }

        public UpdateVaultRequest buildWithoutInvocationCallback() {
            UpdateVaultRequest request = new UpdateVaultRequest();
            request.vaultId = this.vaultId;
            request.updateVaultDetails = this.updateVaultDetails;
            request.ifMatch = this.ifMatch;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

