/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.keymanagement.responses;

import com.oracle.bmc.keymanagement.model.EncryptedData;
import com.oracle.bmc.responses.BmcResponse;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class EncryptResponse
extends BmcResponse {
    private String opcRequestId;
    private EncryptedData encryptedData;

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public EncryptedData getEncryptedData() {
        return this.encryptedData;
    }

    @ConstructorProperties(value={"__httpStatusCode__", "headers", "opcRequestId", "encryptedData"})
    private EncryptResponse(int __httpStatusCode__, Map<String, List<String>> headers, String opcRequestId, EncryptedData encryptedData) {
        super(__httpStatusCode__, headers);
        this.opcRequestId = opcRequestId;
        this.encryptedData = encryptedData;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",encryptedData=").append(String.valueOf((Object)this.encryptedData));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EncryptResponse)) {
            return false;
        }
        EncryptResponse other = (EncryptResponse)((Object)o);
        return super.equals(o) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals((Object)this.encryptedData, (Object)other.encryptedData);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.encryptedData == null ? 43 : this.encryptedData.hashCode());
        return result;
    }

    public static class Builder
    implements BmcResponse.Builder<EncryptResponse> {
        private int __httpStatusCode__;
        private Map<String, List<String>> headers;
        private String opcRequestId;
        private EncryptedData encryptedData;

        public Builder __httpStatusCode__(int __httpStatusCode__) {
            this.__httpStatusCode__ = __httpStatusCode__;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            this.headers = headers;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder encryptedData(EncryptedData encryptedData) {
            this.encryptedData = encryptedData;
            return this;
        }

        public Builder copy(EncryptResponse o) {
            this.__httpStatusCode__(o.get__httpStatusCode__());
            this.headers(o.getHeaders());
            this.opcRequestId(o.getOpcRequestId());
            this.encryptedData(o.getEncryptedData());
            return this;
        }

        public EncryptResponse build() {
            return new EncryptResponse(this.__httpStatusCode__, this.headers, this.opcRequestId, this.encryptedData);
        }
    }
}

