/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.http.client.jersey.internal;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Objects;
import org.apache.http.Header;
import org.apache.http.HttpEntity;

public class ApacheInputStreamEntity
extends FilterInputStream
implements HttpEntity {
    private final long contentLength;

    public ApacheInputStreamEntity(InputStream in, Long contentLength) {
        super(in);
        Objects.requireNonNull(contentLength, "Content length should be not null");
        if (contentLength <= 0L) {
            throw new IllegalArgumentException("Content length should be greater than zero");
        }
        this.contentLength = contentLength;
    }

    public boolean isRepeatable() {
        return false;
    }

    public boolean isChunked() {
        return false;
    }

    public long getContentLength() {
        return this.contentLength;
    }

    public Header getContentType() {
        return null;
    }

    public Header getContentEncoding() {
        return null;
    }

    public InputStream getContent() throws IOException, UnsupportedOperationException {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTo(OutputStream outputStream) throws IOException {
        try {
            int bytesRead;
            byte[] tmp = new byte[4096];
            while ((bytesRead = this.read(tmp)) != -1) {
                outputStream.write(tmp, 0, bytesRead);
            }
        }
        finally {
            this.close();
        }
    }

    public boolean isStreaming() {
        return true;
    }

    @Deprecated
    public void consumeContent() throws IOException {
    }
}

