/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.serialize;

import org.apache.xml.serialize.EncodingInfo;
import org.apache.xml.serialize.Encodings;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Node;
import org.w3c.dom.html.HTMLDocument;

public class OutputFormat {
    private String _method;
    private String _version;
    private int _indent = 0;
    private String _encoding = "UTF-8";
    private EncodingInfo _encodingInfo = null;
    private String _mediaType;
    private String _doctypeSystem;
    private String _doctypePublic;
    private boolean _omitXmlDeclaration = false;
    private boolean _omitDoctype = false;
    private boolean _omitComments = false;
    private boolean _stripComments = false;
    private boolean _standalone = false;
    private String[] _cdataElements;
    private String[] _nonEscapingElements;
    private String _lineSeparator = "\n";
    private int _lineWidth = 72;
    private boolean _preserve = false;
    private boolean _preserveEmptyAttributes = false;

    public OutputFormat() {
    }

    public OutputFormat(String string, String string2, boolean bl) {
        this.setMethod(string);
        this.setEncoding(string2);
        this.setIndenting(bl);
    }

    public OutputFormat(Document document) {
        this.setMethod(OutputFormat.whichMethod(document));
        this.setDoctype(OutputFormat.whichDoctypePublic(document), OutputFormat.whichDoctypeSystem(document));
        this.setMediaType(OutputFormat.whichMediaType(this.getMethod()));
    }

    public OutputFormat(Document document, String string, boolean bl) {
        this(document);
        this.setEncoding(string);
        this.setIndenting(bl);
    }

    public String[] getCDataElements() {
        return this._cdataElements;
    }

    public String getDoctypePublic() {
        return this._doctypePublic;
    }

    public String getDoctypeSystem() {
        return this._doctypeSystem;
    }

    public String getEncoding() {
        return this._encoding;
    }

    public EncodingInfo getEncodingInfo() {
        if (this._encodingInfo == null) {
            this._encodingInfo = Encodings.getEncodingInfo(this._encoding);
        }
        return this._encodingInfo;
    }

    public int getIndent() {
        return this._indent;
    }

    public boolean getIndenting() {
        return this._indent > 0;
    }

    public char getLastPrintable() {
        if (this.getEncoding() != null && this.getEncoding().equalsIgnoreCase("ASCII")) {
            return '\u00ff';
        }
        return '\uffff';
    }

    public String getLineSeparator() {
        return this._lineSeparator;
    }

    public int getLineWidth() {
        return this._lineWidth;
    }

    public String getMediaType() {
        return this._mediaType;
    }

    public String getMethod() {
        return this._method;
    }

    public String[] getNonEscapingElements() {
        return this._nonEscapingElements;
    }

    public boolean getOmitComments() {
        return this._omitComments;
    }

    public boolean getOmitDocumentType() {
        return this._omitDoctype;
    }

    public boolean getOmitXMLDeclaration() {
        return this._omitXmlDeclaration;
    }

    public boolean getPreserveEmptyAttributes() {
        return this._preserveEmptyAttributes;
    }

    public boolean getPreserveSpace() {
        return this._preserve;
    }

    public boolean getStandalone() {
        return this._standalone;
    }

    public String getVersion() {
        return this._version;
    }

    public boolean isCDataElement(String string) {
        if (this._cdataElements == null) {
            return false;
        }
        int n = 0;
        while (n < this._cdataElements.length) {
            if (this._cdataElements[n].equals(string)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public boolean isNonEscapingElement(String string) {
        if (this._nonEscapingElements == null) {
            return false;
        }
        int n = 0;
        while (n < this._nonEscapingElements.length) {
            if (this._nonEscapingElements[n].equals(string)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public void setCDataElements(String[] stringArray) {
        this._cdataElements = stringArray;
    }

    public void setDoctype(String string, String string2) {
        this._doctypePublic = string;
        this._doctypeSystem = string2;
    }

    public void setEncoding(String string) {
        this._encoding = string;
        this._encodingInfo = null;
    }

    public void setEncoding(EncodingInfo encodingInfo) {
        this._encoding = encodingInfo.getName();
        this._encodingInfo = encodingInfo;
    }

    public void setIndent(int n) {
        this._indent = n < 0 ? 0 : n;
    }

    public void setIndenting(boolean bl) {
        if (bl) {
            this._indent = 4;
            this._lineWidth = 72;
        } else {
            this._indent = 0;
            this._lineWidth = 0;
        }
    }

    public void setLineSeparator(String string) {
        this._lineSeparator = string == null ? "\n" : string;
    }

    public void setLineWidth(int n) {
        this._lineWidth = n <= 0 ? 0 : n;
    }

    public void setMediaType(String string) {
        this._mediaType = string;
    }

    public void setMethod(String string) {
        this._method = string;
    }

    public void setNonEscapingElements(String[] stringArray) {
        this._nonEscapingElements = stringArray;
    }

    public void setOmitComments(boolean bl) {
        this._omitComments = bl;
    }

    public void setOmitDocumentType(boolean bl) {
        this._omitDoctype = bl;
    }

    public void setOmitXMLDeclaration(boolean bl) {
        this._omitXmlDeclaration = bl;
    }

    public void setPreserveEmptyAttributes(boolean bl) {
        this._preserveEmptyAttributes = bl;
    }

    public void setPreserveSpace(boolean bl) {
        this._preserve = bl;
    }

    public void setStandalone(boolean bl) {
        this._standalone = bl;
    }

    public void setVersion(String string) {
        this._version = string;
    }

    public static String whichDoctypePublic(Document document) {
        DocumentType documentType = document.getDoctype();
        if (documentType != null) {
            try {
                return documentType.getPublicId();
            }
            catch (Error error) {}
        }
        if (document instanceof HTMLDocument) {
            return "-//W3C//DTD XHTML 1.0 Strict//EN";
        }
        return null;
    }

    public static String whichDoctypeSystem(Document document) {
        DocumentType documentType = document.getDoctype();
        if (documentType != null) {
            try {
                return documentType.getSystemId();
            }
            catch (Error error) {}
        }
        if (document instanceof HTMLDocument) {
            return "http://www.w3.org/TR/WD-html-in-xml/DTD/xhtml1-strict.dtd";
        }
        return null;
    }

    public static String whichMediaType(String string) {
        if (string.equalsIgnoreCase("xml")) {
            return "text/xml";
        }
        if (string.equalsIgnoreCase("html")) {
            return "text/html";
        }
        if (string.equalsIgnoreCase("xhtml")) {
            return "text/html";
        }
        if (string.equalsIgnoreCase("text")) {
            return "text/plain";
        }
        if (string.equalsIgnoreCase("fop")) {
            return "application/pdf";
        }
        return null;
    }

    public static String whichMethod(Document document) {
        if (document instanceof HTMLDocument) {
            return "html";
        }
        Node node = document.getFirstChild();
        while (node != null) {
            if (node.getNodeType() == 1) {
                if (node.getNodeName().equalsIgnoreCase("html")) {
                    return "html";
                }
                if (node.getNodeName().equalsIgnoreCase("root")) {
                    return "fop";
                }
                return "xml";
            }
            if (node.getNodeType() == 3) {
                String string = node.getNodeValue();
                int n = 0;
                while (n < string.length()) {
                    if (string.charAt(n) != ' ' && string.charAt(n) != '\n' && string.charAt(n) != '\t' && string.charAt(n) != '\r') {
                        return "xml";
                    }
                    ++n;
                }
            }
            node = node.getNextSibling();
        }
        return "xml";
    }

    public static class DTD {
        public static final String HTMLPublicId = "-//W3C//DTD HTML 4.0//EN";
        public static final String HTMLSystemId = "http://www.w3.org/TR/WD-html-in-xml/DTD/xhtml1-strict.dtd";
        public static final String XHTMLPublicId = "-//W3C//DTD XHTML 1.0 Strict//EN";
        public static final String XHTMLSystemId = "http://www.w3.org/TR/WD-html-in-xml/DTD/xhtml1-strict.dtd";
    }

    public static class Defaults {
        public static final int Indent = 4;
        public static final String Encoding = "UTF-8";
        public static final int LineWidth = 72;
    }
}

