/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.history.connection;

import java.util.Collections;
import java.util.Set;
import org.apache.guacamole.GuacamoleException;
import org.apache.guacamole.history.connection.HistoryConnectionRecord;
import org.apache.guacamole.net.auth.ActivityRecordSet;
import org.apache.guacamole.net.auth.ConnectionRecord;
import org.apache.guacamole.net.auth.DecoratingActivityRecordSet;
import org.apache.guacamole.net.auth.Permissions;
import org.apache.guacamole.net.auth.User;
import org.apache.guacamole.net.auth.permission.ObjectPermission;
import org.apache.guacamole.net.auth.permission.SystemPermission;

public class RecordedConnectionActivityRecordSet
extends DecoratingActivityRecordSet<ConnectionRecord> {
    private final boolean isAdmin;
    private final Set<ObjectPermission> connectionPermissions;

    public RecordedConnectionActivityRecordSet(User currentUser, ActivityRecordSet<ConnectionRecord> activityRecordSet) throws GuacamoleException {
        super(activityRecordSet);
        Permissions perms = currentUser.getEffectivePermissions();
        this.isAdmin = perms.getSystemPermissions().hasPermission(SystemPermission.Type.ADMINISTER);
        this.connectionPermissions = this.isAdmin ? Collections.emptySet() : perms.getConnectionPermissions().getPermissions();
    }

    private boolean canViewLogs(ConnectionRecord record) {
        if (this.isAdmin) {
            return true;
        }
        String identifier = record.getConnectionIdentifier();
        if (identifier == null) {
            return false;
        }
        ObjectPermission canUpdate = new ObjectPermission(ObjectPermission.Type.UPDATE, identifier);
        return this.connectionPermissions.contains(canUpdate);
    }

    protected ConnectionRecord decorate(ConnectionRecord record) throws GuacamoleException {
        if (this.canViewLogs(record)) {
            return new HistoryConnectionRecord(record);
        }
        return record;
    }
}

