
#ifndef KTEXTTEMPLATE_EXPORT_H
#define KTEXTTEMPLATE_EXPORT_H

#ifdef KTEXTTEMPLATE_STATIC_DEFINE
#  define KTEXTTEMPLATE_EXPORT
#  define KTEXTTEMPLATE_NO_EXPORT
#else
#  ifndef KTEXTTEMPLATE_EXPORT
#    ifdef KF6TextTemplate_EXPORTS
        /* We are building this library */
#      define KTEXTTEMPLATE_EXPORT __attribute__((visibility("default")))
#    else
        /* We are using this library */
#      define KTEXTTEMPLATE_EXPORT __attribute__((visibility("default")))
#    endif
#  endif

#  ifndef KTEXTTEMPLATE_NO_EXPORT
#    define KTEXTTEMPLATE_NO_EXPORT __attribute__((visibility("hidden")))
#  endif
#endif

#ifndef KTEXTTEMPLATE_DECL_DEPRECATED
#  define KTEXTTEMPLATE_DECL_DEPRECATED __attribute__ ((__deprecated__))
#endif

#ifndef KTEXTTEMPLATE_DECL_DEPRECATED_EXPORT
#  define KTEXTTEMPLATE_DECL_DEPRECATED_EXPORT KTEXTTEMPLATE_EXPORT KTEXTTEMPLATE_DECL_DEPRECATED
#endif

#ifndef KTEXTTEMPLATE_DECL_DEPRECATED_NO_EXPORT
#  define KTEXTTEMPLATE_DECL_DEPRECATED_NO_EXPORT KTEXTTEMPLATE_NO_EXPORT KTEXTTEMPLATE_DECL_DEPRECATED
#endif

/* NOLINTNEXTLINE(readability-avoid-unconditional-preprocessor-if) */
#if 0 /* DEFINE_NO_DEPRECATED */
#  ifndef KTEXTTEMPLATE_NO_DEPRECATED
#    define KTEXTTEMPLATE_NO_DEPRECATED
#  endif
#endif
#include <ktexttemplate_version.h>

#define KTEXTTEMPLATE_DECL_DEPRECATED_TEXT(text) __attribute__ ((__deprecated__(text)))

/* Take any defaults from group settings */
#if !defined(KTEXTTEMPLATE_NO_DEPRECATED) && !defined(KTEXTTEMPLATE_DISABLE_DEPRECATED_BEFORE_AND_AT)
#  ifdef KF_NO_DEPRECATED
#    define KTEXTTEMPLATE_NO_DEPRECATED
#  elif defined(KF_DISABLE_DEPRECATED_BEFORE_AND_AT)
#    define KTEXTTEMPLATE_DISABLE_DEPRECATED_BEFORE_AND_AT KF_DISABLE_DEPRECATED_BEFORE_AND_AT
#  endif
#endif
#if !defined(KTEXTTEMPLATE_DISABLE_DEPRECATED_BEFORE_AND_AT) && defined(KF_DISABLE_DEPRECATED_BEFORE_AND_AT)
#  define KTEXTTEMPLATE_DISABLE_DEPRECATED_BEFORE_AND_AT KF_DISABLE_DEPRECATED_BEFORE_AND_AT
#endif

#if !defined(KTEXTTEMPLATE_NO_DEPRECATED_WARNINGS) && !defined(KTEXTTEMPLATE_DEPRECATED_WARNINGS_SINCE)
#  ifdef KF_NO_DEPRECATED_WARNINGS
#    define KTEXTTEMPLATE_NO_DEPRECATED_WARNINGS
#  elif defined(KF_DEPRECATED_WARNINGS_SINCE)
#    define KTEXTTEMPLATE_DEPRECATED_WARNINGS_SINCE KF_DEPRECATED_WARNINGS_SINCE
#  endif
#endif
#if !defined(KTEXTTEMPLATE_DEPRECATED_WARNINGS_SINCE) && defined(KF_DEPRECATED_WARNINGS_SINCE)
#  define KTEXTTEMPLATE_DEPRECATED_WARNINGS_SINCE KF_DEPRECATED_WARNINGS_SINCE
#endif

#if defined(KTEXTTEMPLATE_NO_DEPRECATED)
#  undef KTEXTTEMPLATE_DEPRECATED
#  define KTEXTTEMPLATE_DEPRECATED_EXPORT KTEXTTEMPLATE_EXPORT
#  define KTEXTTEMPLATE_DEPRECATED_NO_EXPORT KTEXTTEMPLATE_NO_EXPORT
#elif defined(KTEXTTEMPLATE_NO_DEPRECATED_WARNINGS)
#  define KTEXTTEMPLATE_DEPRECATED
#  define KTEXTTEMPLATE_DEPRECATED_EXPORT KTEXTTEMPLATE_EXPORT
#  define KTEXTTEMPLATE_DEPRECATED_NO_EXPORT KTEXTTEMPLATE_NO_EXPORT
#else
#  define KTEXTTEMPLATE_DEPRECATED KTEXTTEMPLATE_DECL_DEPRECATED
#  define KTEXTTEMPLATE_DEPRECATED_EXPORT KTEXTTEMPLATE_DECL_DEPRECATED_EXPORT
#  define KTEXTTEMPLATE_DEPRECATED_NO_EXPORT KTEXTTEMPLATE_DECL_DEPRECATED_NO_EXPORT
#endif

/* No deprecated API had been removed from build */
#define KTEXTTEMPLATE_EXCLUDE_DEPRECATED_BEFORE_AND_AT 0

#define KTEXTTEMPLATE_BUILD_DEPRECATED_SINCE(major, minor) 1

#ifdef KTEXTTEMPLATE_NO_DEPRECATED
#  define KTEXTTEMPLATE_DISABLE_DEPRECATED_BEFORE_AND_AT KTEXTTEMPLATE_VERSION
#endif
#ifdef KTEXTTEMPLATE_NO_DEPRECATED_WARNINGS
#  define KTEXTTEMPLATE_DEPRECATED_WARNINGS_SINCE 0
#endif

#ifndef KTEXTTEMPLATE_DEPRECATED_WARNINGS_SINCE
#  ifdef KTEXTTEMPLATE_DISABLE_DEPRECATED_BEFORE_AND_AT
#    define KTEXTTEMPLATE_DEPRECATED_WARNINGS_SINCE KTEXTTEMPLATE_DISABLE_DEPRECATED_BEFORE_AND_AT
#  else
#    define KTEXTTEMPLATE_DEPRECATED_WARNINGS_SINCE KTEXTTEMPLATE_VERSION
#  endif
#endif

#ifndef KTEXTTEMPLATE_DISABLE_DEPRECATED_BEFORE_AND_AT
#  define KTEXTTEMPLATE_DISABLE_DEPRECATED_BEFORE_AND_AT 0
#endif

#ifdef KTEXTTEMPLATE_DEPRECATED
#  define KTEXTTEMPLATE_ENABLE_DEPRECATED_SINCE(major, minor) (((major<<16)|(minor<<8)) > KTEXTTEMPLATE_DISABLE_DEPRECATED_BEFORE_AND_AT)
#else
#  define KTEXTTEMPLATE_ENABLE_DEPRECATED_SINCE(major, minor) 0
#endif

#endif /* KTEXTTEMPLATE_EXPORT_H */
