<?php

declare(strict_types=1);

/**
 * @copyright Copyright (c) 2016, ownCloud, Inc.
 *
 * @author Joas Schilling <coding@schilljs.com>
 * @author Morris Jobke <hey@morrisjobke.de>
 * @author Olivier Paroz <github@oparoz.com>
 * @author Roeland Jago Douma <roeland@famdouma.nl>
 *
 * @license AGPL-3.0
 *
 * This code is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License, version 3,
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License, version 3,
 * along with this program. If not, see <http://www.gnu.org/licenses/>
 *
 */
namespace OCP\AppFramework\Utility;

/**
 * Interface ControllerMethodReflector
 *
 * Reads and parses annotations from doc comments
 *
 * @since 8.0.0
 * @deprecated 22.0.0 will be obsolete with native attributes in PHP8
 * @see https://help.nextcloud.com/t/how-should-we-use-php8-attributes/104278
 */
interface IControllerMethodReflector {
	/**
	 * @param object $object an object or classname
	 * @param string $method the method which we want to inspect
	 * @return void
	 * @since 8.0.0
	 * @deprecated 17.0.0 Reflect should not be called multiple times and only be used internally. This will be removed in Nextcloud 18
	 */
	public function reflect($object, string $method);

	/**
	 * Inspects the PHPDoc parameters for types
	 *
	 * @param string $parameter the parameter whose type comments should be
	 * parsed
	 * @return string|null type in the type parameters (@param int $something)
	 * would return int or null if not existing
	 * @since 8.0.0
	 * @deprecated 22.0.0 this method is only used internally
	 */
	public function getType(string $parameter);

	/**
	 * @return array the arguments of the method with key => default value
	 * @since 8.0.0
	 * @deprecated 22.0.0 this method is only used internally
	 */
	public function getParameters(): array;

	/**
	 * Check if a method contains an annotation
	 *
	 * @param string $name the name of the annotation
	 * @return bool true if the annotation is found
	 * @since 8.0.0
	 * @deprecated 22.0.0 will be obsolete with native attributes in PHP8
	 * @see https://help.nextcloud.com/t/how-should-we-use-php8-attributes/104278
	 */
	public function hasAnnotation(string $name): bool;
}
