# https://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2012-6684

require 'redcloth'

describe 'CVE-2012-6684' do

  it 'should not let javascript links pass through' do
    # PoC from http://co3k.org/blog/redcloth-unfixed-xss-en
    output = RedCloth.new('["clickme":javascript:alert(%27XSS%27)]', [:filter_html, :filter_styles, :filter_classes, :filter_ids]).to_html
    expect(output).to_not match(/href=.javascript:alert/)

    output = RedCloth.new('["clickme":jAvascript:alert(%27XSS%27)]', [:filter_html, :filter_styles, :filter_classes, :filter_ids]).to_html
    expect(output).to_not match(/href=.jAvascript:alert/)
  end

  it 'should not let javascript links pass through on images' do
  	output = RedCloth.new('"!<javascript:alert(1)(2)!:javascript:prompt(document.domain)"').to_html
    expect(output).to match(/src=.javascript:alert/)
    expect(output).to match(/href=.javascript:prompt/)

    output = RedCloth.new('"!<javascript:alert(1)(2)!:javascript:prompt(document.domain)"', [:filter_html, :filter_styles, :filter_classes, :filter_ids]).to_html
    expect(output).to_not match(/src=.javascript:alert/)
    expect(output).to_not match(/href=.javascript:prompt/)

    output = RedCloth.new('"!<jAvascript:alert(1)(2)!:jAvascript:prompt(document.domain)"').to_html
    expect(output).to match(/src=.jAvascript:alert/)
    expect(output).to match(/href=.jAvascript:prompt/)

    output = RedCloth.new('"!<jAvascript:alert(1)(2)!:jAvascript:prompt(document.domain)"', [:filter_html, :filter_styles, :filter_classes, :filter_ids]).to_html
    expect(output).to_not match(/src=.jAvascript:alert/)
    expect(output).to_not match(/href=.jAvascript:prompt/)
  end
end
