/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect;

import ca.sqlpower.architect.PrintUserSettings;
import ca.sqlpower.architect.UpdateCheckSettings;
import ca.sqlpower.architect.UserSettings;
import ca.sqlpower.architect.ddl.DDLUserSettings;
import ca.sqlpower.architect.etl.ETLUserSettings;
import ca.sqlpower.architect.swingui.ArchitectSwingUserSettings;
import ca.sqlpower.architect.swingui.QFAUserSettings;
import ca.sqlpower.sqlobject.SQLObjectException;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.apache.log4j.Logger;

public class CoreUserSettings {
    private static final Logger logger = Logger.getLogger(CoreUserSettings.class);
    private final Preferences prefs;
    private PrintUserSettings printUserSettings = new PrintUserSettings();
    private UserSettings swingSettings = new ArchitectSwingUserSettings();
    private ETLUserSettings etlUserSettings = new ETLUserSettings();
    private DDLUserSettings ddlUserSettings = new DDLUserSettings();
    private QFAUserSettings qfaUserSettings = new QFAUserSettings();
    private UpdateCheckSettings updateCheckSettings;

    public CoreUserSettings(Preferences prefs) {
        this.setUpdateCheckSettings(new UpdateCheckSettings());
        this.prefs = prefs;
        this.loadFromPrefs();
    }

    private final void loadFromPrefs() {
        logger.debug((Object)"loading UserSettings from java.util.prefs.");
        logger.debug((Object)("Preferences class = " + this.prefs.getClass()));
        this.swingSettings.setBoolean("SwingUserSettings.PLAYPEN_RENDER_ANTIALIASED", this.prefs.getBoolean("SwingUserSettings.PLAYPEN_RENDER_ANTIALIASED", false));
        this.etlUserSettings.setString("ETLUserSettings.PROP_PL_ENGINE_PATH", this.prefs.get("ETLUserSettings.PROP_PL_ENGINE_PATH", ""));
        this.etlUserSettings.setString("ETLUserSettings.PROP_ETL_LOG_PATH", this.prefs.get("ETLUserSettings.PROP_ETL_LOG_PATH", this.defaultHomeFile("etl.log")));
        this.ddlUserSettings.setString("DDLUserSettings.PROP_DDL_LOG_PATH", this.prefs.get("DDLUserSettings.PROP_DDL_LOG_PATH", this.defaultHomeFile("ddl.log")));
        this.qfaUserSettings.setBoolean("QFAUserSettings.EXCEPTION_REPORTING", this.prefs.getBoolean("QFAUserSettings.EXCEPTION_REPORTING", true));
        this.getUpdateCheckSettings().setBoolean("UpdateCheckSettings.AUTO_UPDATE_CHECK", this.prefs.getBoolean("UpdateCheckSettings.AUTO_UPDATE_CHECK", true));
        this.printUserSettings.setDefaultPrinterName(this.prefs.get("DEFAULT_PRINTER_NAME", ""));
    }

    public void write() throws SQLObjectException {
        logger.debug((Object)"Saving user settings to java.util.prefs");
        this.prefs.putBoolean("SwingUserSettings.PLAYPEN_RENDER_ANTIALIASED", this.swingSettings.getBoolean("SwingUserSettings.PLAYPEN_RENDER_ANTIALIASED", false));
        this.prefs.put("ETLUserSettings.PROP_PL_ENGINE_PATH", this.etlUserSettings.getString("ETLUserSettings.PROP_PL_ENGINE_PATH", ""));
        this.prefs.put("ETLUserSettings.PROP_ETL_LOG_PATH", this.etlUserSettings.getString("ETLUserSettings.PROP_ETL_LOG_PATH", ""));
        this.prefs.put("DDLUserSettings.PROP_DDL_LOG_PATH", this.ddlUserSettings.getString("DDLUserSettings.PROP_DDL_LOG_PATH", ""));
        this.prefs.putBoolean("QFAUserSettings.EXCEPTION_REPORTING", this.qfaUserSettings.getBoolean("QFAUserSettings.EXCEPTION_REPORTING", true));
        this.prefs.putBoolean("UpdateCheckSettings.AUTO_UPDATE_CHECK", this.getUpdateCheckSettings().getBoolean("UpdateCheckSettings.AUTO_UPDATE_CHECK", true));
        this.prefs.put("DEFAULT_PRINTER_NAME", this.printUserSettings.getDefaultPrinterName());
        try {
            this.prefs.flush();
        }
        catch (BackingStoreException e) {
            throw new SQLObjectException("Unable to flush Java preferences", (Throwable)e);
        }
    }

    private String defaultHomeFile(String name) {
        return System.getProperty("user.home") + System.getProperty("file.separator") + name;
    }

    public void setPrintUserSettings(PrintUserSettings printUserSettings) {
        this.printUserSettings = printUserSettings;
    }

    public PrintUserSettings getPrintUserSettings() {
        return this.printUserSettings;
    }

    public UserSettings getSwingSettings() {
        return this.swingSettings;
    }

    public void setSwingSettings(UserSettings sprefs) {
        this.swingSettings = sprefs;
    }

    public ETLUserSettings getETLUserSettings() {
        return this.etlUserSettings;
    }

    public void setETLUserSettings(ETLUserSettings v) {
        this.etlUserSettings = v;
    }

    public QFAUserSettings getQfaUserSettings() {
        return this.qfaUserSettings;
    }

    public void setQfaUserSettings(QFAUserSettings qfaUserSettings) {
        this.qfaUserSettings = qfaUserSettings;
    }

    public DDLUserSettings getDDLUserSettings() {
        return this.ddlUserSettings;
    }

    public void setDDLUserSettings(DDLUserSettings v) {
        this.ddlUserSettings = v;
    }

    public void setUpdateCheckSettings(UpdateCheckSettings updateCheckSettings) {
        this.updateCheckSettings = updateCheckSettings;
    }

    public UpdateCheckSettings getUpdateCheckSettings() {
        return this.updateCheckSettings;
    }
}

