/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.common.cloud;

import java.lang.invoke.MethodHandles;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Map;
import org.apache.solr.common.Callable;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.SolrZkClient;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.solr.common.cloud.ZooKeeperException;
import org.apache.solr.common.util.Utils;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SecurityNodeWatcher
implements Watcher {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final ZkStateReader zkStateReader;
    private ZkStateReader.ConfigData securityData;
    private final Callable<SolrZkClient.NodeData> callback;

    public SecurityNodeWatcher(ZkStateReader zkStateReader, Runnable securityNodeListener) {
        this.zkStateReader = zkStateReader;
        this.callback = data -> {
            ZkStateReader.ConfigData cd = new ZkStateReader.ConfigData();
            cd.data = data.data == null || data.data.length == 0 ? Collections.emptyMap() : Utils.getDeepCopy((Map)((Map)Utils.fromJSON((byte[])data.data)), (int)4, (boolean)false);
            cd.version = data.stat == null ? -1 : data.stat.getVersion();
            this.securityData = cd;
            if (securityNodeListener != null) {
                securityNodeListener.run();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(WatchedEvent event) {
        if (Watcher.Event.EventType.None.equals((Object)event.getType())) {
            return;
        }
        try {
            SecurityNodeWatcher securityNodeWatcher = this;
            synchronized (securityNodeWatcher) {
                log.debug("Updating [{}] ... ", (Object)"/security.json");
                SolrZkClient.NodeData data = new SolrZkClient.NodeData(new Stat(), "{}".getBytes(StandardCharsets.UTF_8));
                if (Watcher.Event.EventType.NodeDeleted.equals((Object)event.getType())) {
                    this.zkStateReader.getZkClient().exists("/security.json", this, true);
                } else {
                    data = this.zkStateReader.getZkClient().getNode("/security.json", this, true);
                }
                try {
                    this.callback.call((Object)data);
                }
                catch (Exception e) {
                    log.error("Error running collections node listener", (Throwable)e);
                }
            }
        }
        catch (KeeperException.ConnectionLossException | KeeperException.SessionExpiredException e) {
            log.warn("ZooKeeper watch triggered, but Solr cannot talk to ZK: ", e);
        }
        catch (KeeperException e) {
            log.error("A ZK error has occurred", (Throwable)e);
            throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, "", e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            log.warn("Interrupted", (Throwable)e);
        }
    }

    void register() throws InterruptedException, KeeperException {
        this.zkStateReader.getZkClient().exists("/security.json", this, true);
        this.securityData = this.getSecurityProps(true);
    }

    ZkStateReader.ConfigData getSecurityProps(boolean getFresh) {
        if (!getFresh) {
            if (this.securityData == null) {
                return new ZkStateReader.ConfigData(Collections.emptyMap(), -1);
            }
            return new ZkStateReader.ConfigData(this.securityData.data, this.securityData.version);
        }
        try {
            if (this.zkStateReader.getZkClient().exists("/security.json", true).booleanValue()) {
                SolrZkClient.NodeData d = this.zkStateReader.getZkClient().getNode("/security.json", null, true);
                return d != null && d.data.length > 0 ? new ZkStateReader.ConfigData((Map)Utils.fromJSON((byte[])d.data), d.stat.getVersion()) : null;
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error reading security properties", (Throwable)e);
        }
        catch (KeeperException e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error reading security properties", (Throwable)e);
        }
        return null;
    }
}

