/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud;

import java.util.List;
import java.util.concurrent.CountDownLatch;
import org.apache.solr.cloud.DistributedLock;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.SolrZkClient;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;

abstract class ZkDistributedLock
implements DistributedLock {
    static final char LOCK_PREFIX_SUFFIX = '_';
    static final String READ_LOCK_PREFIX = "R_";
    static final String WRITE_LOCK_PREFIX = "W_";
    private final SolrZkClient zkClient;
    private final String lockDir;
    private final String lockNode;
    protected final long sequence;
    protected volatile boolean released = false;

    protected ZkDistributedLock(SolrZkClient zkClient, String lockDir, String lockNodePrefix) throws KeeperException, InterruptedException {
        this.zkClient = zkClient;
        this.lockDir = lockDir;
        this.lockNode = zkClient.create(lockDir + "/" + lockNodePrefix, null, CreateMode.EPHEMERAL_SEQUENTIAL, false);
        this.sequence = ZkDistributedLock.getSequenceFromNodename(this.lockNode);
    }

    @Override
    public void waitUntilAcquired() {
        try {
            if (this.released) {
                throw new IllegalStateException("Bug. waitUntilAcquired() should not be called after release(). " + this.lockNode);
            }
            String nodeToWatch = this.nodeToWatch();
            while (nodeToWatch != null) {
                DeletedNodeWatcher watcher = new DeletedNodeWatcher(nodeToWatch);
                if (this.zkClient.exists(nodeToWatch, (Watcher)watcher, true) != null) {
                    watcher.await();
                }
                nodeToWatch = this.nodeToWatch();
            }
        }
        catch (KeeperException e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
        }
    }

    @Override
    public void release() {
        try {
            this.zkClient.delete(this.lockNode, -1, true);
            this.released = true;
        }
        catch (KeeperException e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
        }
    }

    @Override
    public boolean isAcquired() {
        try {
            if (this.released) {
                throw new IllegalStateException("Bug. isAcquired() should not be called after release(). " + this.lockNode);
            }
            return this.nodeToWatch() == null;
        }
        catch (KeeperException e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
        }
    }

    String nodeToWatch() throws KeeperException, InterruptedException {
        List locks = this.zkClient.getChildren(this.lockDir, null, true);
        boolean foundSelf = false;
        for (String lock : locks) {
            long seq = ZkDistributedLock.getSequenceFromNodename(lock);
            if (seq == this.sequence) {
                foundSelf = true;
                continue;
            }
            if (seq >= this.sequence || !this.isBlockedByNodeType(lock)) continue;
            return this.lockDir + "/" + lock;
        }
        if (!foundSelf) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Missing lock node " + this.lockNode);
        }
        return null;
    }

    abstract boolean isBlockedByNodeType(String var1);

    static long getSequenceFromNodename(String lockNode) {
        int SEQUENCE_LENGTH = 10;
        if (lockNode.charAt(lockNode.length() - 10 - 1) != '_') {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unexpected lock node path " + lockNode);
        }
        return Long.parseLong(lockNode.substring(lockNode.length() - 10));
    }

    public String toString() {
        return this.lockNode;
    }

    private static class DeletedNodeWatcher
    implements Watcher {
        final CountDownLatch latch = new CountDownLatch(1);
        final String nodeBeingWatched;
        String errorMessage = null;

        DeletedNodeWatcher(String nodeBeingWatched) {
            this.nodeBeingWatched = nodeBeingWatched;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void process(WatchedEvent event) {
            if (event.getType() == Watcher.Event.EventType.None) {
                return;
            }
            if (event.getType() != Watcher.Event.EventType.NodeDeleted) {
                DeletedNodeWatcher deletedNodeWatcher = this;
                synchronized (deletedNodeWatcher) {
                    this.errorMessage = "Received unexpected watch event " + event.getType() + " on " + this.nodeBeingWatched;
                }
            }
            this.latch.countDown();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void await() throws InterruptedException {
            this.latch.await();
            DeletedNodeWatcher deletedNodeWatcher = this;
            synchronized (deletedNodeWatcher) {
                if (this.errorMessage != null) {
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, this.errorMessage);
                }
            }
        }
    }

    static class Write
    extends ZkDistributedLock {
        protected Write(SolrZkClient zkClient, String lockPath) throws KeeperException, InterruptedException {
            super(zkClient, lockPath, ZkDistributedLock.WRITE_LOCK_PREFIX);
        }

        @Override
        boolean isBlockedByNodeType(String otherLockName) {
            return true;
        }
    }

    static class Read
    extends ZkDistributedLock {
        protected Read(SolrZkClient zkClient, String lockPath) throws KeeperException, InterruptedException {
            super(zkClient, lockPath, ZkDistributedLock.READ_LOCK_PREFIX);
        }

        @Override
        boolean isBlockedByNodeType(String otherLockName) {
            return otherLockName.startsWith(ZkDistributedLock.WRITE_LOCK_PREFIX);
        }
    }
}

