/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.component;

import com.codahale.metrics.Counter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.lucene.index.ExitableDirectoryReader;
import org.apache.lucene.search.TotalHits;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.cloud.ZkController;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.core.CloseHook;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.PluginInfo;
import org.apache.solr.core.SolrCore;
import org.apache.solr.handler.RequestHandlerBase;
import org.apache.solr.handler.component.DebugComponent;
import org.apache.solr.handler.component.HttpShardHandler;
import org.apache.solr.handler.component.ResponseBuilder;
import org.apache.solr.handler.component.SearchComponent;
import org.apache.solr.handler.component.ShardHandler;
import org.apache.solr.handler.component.ShardHandlerFactory;
import org.apache.solr.handler.component.ShardRequest;
import org.apache.solr.handler.component.ShardResponse;
import org.apache.solr.logging.MDCLoggingContext;
import org.apache.solr.metrics.MetricsMap;
import org.apache.solr.metrics.SolrMetricsContext;
import org.apache.solr.pkg.PackageAPI;
import org.apache.solr.pkg.PackageListeners;
import org.apache.solr.pkg.SolrPackageLoader;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.request.SolrRequestInfo;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.search.CursorMark;
import org.apache.solr.search.SortSpec;
import org.apache.solr.security.AuthorizationContext;
import org.apache.solr.security.PermissionNameProvider;
import org.apache.solr.util.RTimerTree;
import org.apache.solr.util.SolrPluginUtils;
import org.apache.solr.util.circuitbreaker.CircuitBreaker;
import org.apache.solr.util.circuitbreaker.CircuitBreakerRegistry;
import org.apache.solr.util.circuitbreaker.CircuitBreakerUtils;
import org.apache.solr.util.plugin.PluginInfoInitialized;
import org.apache.solr.util.plugin.SolrCoreAware;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class SearchHandler
extends RequestHandlerBase
implements SolrCoreAware,
PluginInfoInitialized,
PermissionNameProvider {
    static final String INIT_COMPONENTS = "components";
    static final String INIT_FIRST_COMPONENTS = "first-components";
    static final String INIT_LAST_COMPONENTS = "last-components";
    protected static final String SHARD_HANDLER_SUFFIX = "[shard]";
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    @Deprecated(since="9.4")
    private static final AtomicLong ridCounter = new AtomicLong();
    @Deprecated(since="9.4")
    private static final boolean DISABLE_REQUEST_ID_DEFAULT = Boolean.getBoolean("solr.disableRequestId");
    private RequestHandlerBase.HandlerMetrics metricsShard = RequestHandlerBase.HandlerMetrics.NO_OP;
    private final Map<String, Counter> shardPurposes = new ConcurrentHashMap<String, Counter>();
    protected volatile List<SearchComponent> components;
    private ShardHandlerFactory shardHandlerFactory;
    private PluginInfo shfInfo;
    private SolrCore core;

    protected List<String> getDefaultComponents() {
        ArrayList<String> names = new ArrayList<String>(9);
        names.add("query");
        names.add("facet");
        names.add("facet_module");
        names.add("mlt");
        names.add("highlight");
        names.add("stats");
        names.add("debug");
        names.add("expand");
        names.add("terms");
        return names;
    }

    @Override
    public void init(PluginInfo info) {
        this.init(info.initArgs);
        for (PluginInfo child : info.children) {
            if (!"shardHandlerFactory".equals(child.type)) continue;
            this.shfInfo = child;
            break;
        }
    }

    @Override
    public void initializeMetrics(SolrMetricsContext parentContext, String scope) {
        super.initializeMetrics(parentContext, scope);
        this.metricsShard = new RequestHandlerBase.HandlerMetrics(this.solrMetricsContext, this.getCategory().toString(), scope + SHARD_HANDLER_SUFFIX);
        this.solrMetricsContext.gauge(new MetricsMap(map -> this.shardPurposes.forEach((k, v) -> map.putNoEx((CharSequence)k, (Object)v.getCount()))), true, "purposes", this.getCategory().toString(), scope + SHARD_HANDLER_SUFFIX);
    }

    @Override
    public RequestHandlerBase.HandlerMetrics getMetricsForThisRequest(SolrQueryRequest req) {
        return req.getParams().getBool("isShard", false) ? this.metricsShard : this.metrics;
    }

    @Override
    public PermissionNameProvider.Name getPermissionName(AuthorizationContext ctx) {
        return PermissionNameProvider.Name.READ_PERM;
    }

    @Override
    public void inform(SolrCore core) {
        this.core = core;
        List c = (List)this.initArgs.get(INIT_COMPONENTS);
        HashSet<String> missing = new HashSet<String>(core.getSearchComponents().checkContains(c));
        List first = (List)this.initArgs.get(INIT_FIRST_COMPONENTS);
        missing.addAll(core.getSearchComponents().checkContains(first));
        List last = (List)this.initArgs.get(INIT_LAST_COMPONENTS);
        missing.addAll(core.getSearchComponents().checkContains(last));
        if (!missing.isEmpty()) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Missing SearchComponents named : " + missing);
        }
        if (c != null && (first != null || last != null)) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "First/Last components only valid if you do not declare 'components'");
        }
        if (this.shfInfo == null) {
            this.shardHandlerFactory = core.getCoreContainer().getShardHandlerFactory();
        } else {
            this.shardHandlerFactory = core.createInitInstance(this.shfInfo, ShardHandlerFactory.class, null, null);
            core.addCloseHook(new CloseHook(){

                @Override
                public void preClose(SolrCore core) {
                    SearchHandler.this.shardHandlerFactory.close();
                }
            });
            this.shardHandlerFactory.setSecurityBuilder(core.getCoreContainer().getPkiAuthenticationSecurityBuilder());
        }
        if (core.getCoreContainer().isZooKeeperAware()) {
            core.getPackageListeners().addListener(new PackageListeners.Listener(){

                @Override
                public String packageName() {
                    return null;
                }

                @Override
                public Map<String, PackageAPI.PkgVersion> packageDetails() {
                    return Collections.emptyMap();
                }

                @Override
                public void changed(SolrPackageLoader.SolrPackage pkg, PackageListeners.Listener.Ctx ctx) {
                    SearchHandler.this.components = null;
                }
            });
        }
    }

    private void initComponents() {
        Object declaredComponents = this.initArgs.get(INIT_COMPONENTS);
        List first = (List)this.initArgs.get(INIT_FIRST_COMPONENTS);
        List last = (List)this.initArgs.get(INIT_LAST_COMPONENTS);
        List list = null;
        boolean makeDebugLast = true;
        if (declaredComponents == null) {
            list = this.getDefaultComponents();
            if (first != null) {
                List clist = first;
                clist.addAll(list);
                list = clist;
            }
            if (last != null) {
                list.addAll(last);
            }
        } else {
            list = (List)declaredComponents;
            if (first != null || last != null) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "First/Last components only valid if you do not declare 'components'");
            }
            makeDebugLast = false;
        }
        ArrayList<SearchComponent> components = new ArrayList<SearchComponent>(list.size());
        DebugComponent dbgCmp = null;
        for (String c : list) {
            SearchComponent comp = this.core.getSearchComponent(c);
            if (comp instanceof DebugComponent && makeDebugLast) {
                dbgCmp = (DebugComponent)comp;
                continue;
            }
            components.add(comp);
            log.debug("Adding  component:{}", (Object)comp);
        }
        if (makeDebugLast && dbgCmp != null) {
            components.add(dbgCmp);
            log.debug("Adding  debug component:{}", dbgCmp);
        }
        this.components = components;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SearchComponent> getComponents() {
        List<SearchComponent> result = this.components;
        if (result == null) {
            SearchHandler searchHandler = this;
            synchronized (searchHandler) {
                if (this.components == null) {
                    this.initComponents();
                }
                result = this.components;
            }
        }
        return result;
    }

    private boolean isDistrib(SolrQueryRequest req) {
        boolean isZkAware = req.getCoreContainer().isZooKeeperAware();
        boolean isDistrib = req.getParams().getBool("distrib", isZkAware);
        if (!isDistrib) {
            String shards = req.getParams().get("shards");
            isDistrib = shards != null && shards.indexOf(47) > 0;
        }
        return isDistrib;
    }

    public ShardHandler getAndPrepShardHandler(SolrQueryRequest req, ResponseBuilder rb) {
        ShardHandler shardHandler = null;
        CoreContainer cc = req.getCoreContainer();
        boolean isZkAware = cc.isZooKeeperAware();
        if (rb.isDistrib) {
            shardHandler = this.shardHandlerFactory.getShardHandler();
            shardHandler.prepDistributed(rb);
            if (!rb.isDistrib) {
                shardHandler = null;
            }
        }
        if (isZkAware) {
            boolean zkConnected;
            String shardsTolerant = req.getParams().get("shards.tolerant");
            boolean requireZkConnected = shardsTolerant != null && shardsTolerant.equals("requireZkConnected");
            ZkController zkController = cc.getZkController();
            boolean bl = zkConnected = zkController != null && !zkController.getZkClient().getConnectionManager().isLikelyExpired();
            if (requireZkConnected && !zkConnected) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "ZooKeeper is not connected");
            }
            NamedList<Object> headers = rb.rsp.getResponseHeader();
            if (headers != null) {
                headers.add("zkConnected", (Object)zkConnected);
            }
        }
        return shardHandler;
    }

    protected ResponseBuilder newResponseBuilder(SolrQueryRequest req, SolrQueryResponse rsp, List<SearchComponent> components) {
        return new ResponseBuilder(req, rsp, components);
    }

    protected boolean checkCircuitBreakers(SolrQueryRequest req, SolrQueryResponse rsp, ResponseBuilder rb) {
        if (SearchHandler.isInternalShardRequest(req)) {
            if (log.isTraceEnabled()) {
                log.trace("Internal request, skipping circuit breaker check");
            }
            return false;
        }
        RTimerTree timer = rb.isDebug() ? req.getRequestTimer() : null;
        CircuitBreakerRegistry circuitBreakerRegistry = req.getCore().getCircuitBreakerRegistry();
        if (circuitBreakerRegistry.isEnabled(SolrRequest.SolrRequestType.QUERY)) {
            List<CircuitBreaker> trippedCircuitBreakers;
            if (timer != null) {
                RTimerTree subt = timer.sub("circuitbreaker");
                rb.setTimer(subt);
                trippedCircuitBreakers = circuitBreakerRegistry.checkTripped(SolrRequest.SolrRequestType.QUERY);
                rb.getTimer().stop();
            } else {
                trippedCircuitBreakers = circuitBreakerRegistry.checkTripped(SolrRequest.SolrRequestType.QUERY);
            }
            return CircuitBreakerUtils.reportErrorIfBreakersTripped(rsp, trippedCircuitBreakers);
        }
        return false;
    }

    @Override
    public void handleRequestBody(SolrQueryRequest req, SolrQueryResponse rsp) throws Exception {
        RTimerTree timer;
        if (req.getParams().getBool("isShard", false)) {
            int purpose = req.getParams().getInt("shards.purpose", 0);
            SolrPluginUtils.forEachRequestPurpose(purpose, n -> this.shardPurposes.computeIfAbsent((String)n, name -> new Counter()).inc());
        }
        List<SearchComponent> components = this.getComponents();
        ResponseBuilder rb = this.newResponseBuilder(req, rsp, components);
        if (rb.requestInfo != null) {
            rb.requestInfo.setResponseBuilder(rb);
        }
        rb.isDistrib = this.isDistrib(req);
        this.tagRequestWithRequestId(rb);
        boolean dbg = req.getParams().getBool("debugQuery", false);
        rb.setDebug(dbg);
        if (!dbg) {
            SolrPluginUtils.getDebugInterests(req.getParams().getParams("debug"), rb);
        }
        RTimerTree rTimerTree = timer = rb.isDebug() ? req.getRequestTimer() : null;
        if (this.checkCircuitBreakers(req, rsp, rb)) {
            return;
        }
        this.processComponents(req, rsp, rb, timer, components);
        if (!rb.isDistrib && req.getParams().getBool("shards.info", false) && rb.shortCircuitedURL != null) {
            SimpleOrderedMap shardInfo = new SimpleOrderedMap();
            SimpleOrderedMap nl = new SimpleOrderedMap();
            if (rsp.getException() != null) {
                Throwable cause = rsp.getException();
                if (cause instanceof SolrServerException) {
                    cause = ((SolrServerException)cause).getRootCause();
                } else if (cause.getCause() != null) {
                    cause = cause.getCause();
                }
                nl.add("error", (Object)cause.toString());
                if (!this.core.getCoreContainer().hideStackTrace()) {
                    StringWriter trace = new StringWriter();
                    cause.printStackTrace(new PrintWriter(trace));
                    nl.add("trace", (Object)trace.toString());
                }
            } else if (rb.getResults() != null) {
                nl.add("numFound", (Object)rb.getResults().docList.matches());
                nl.add("numFoundExact", (Object)(rb.getResults().docList.hitCountRelation() == TotalHits.Relation.EQUAL_TO ? 1 : 0));
                nl.add("maxScore", (Object)Float.valueOf(rb.getResults().docList.maxScore()));
            }
            nl.add("shardAddress", (Object)rb.shortCircuitedURL);
            nl.add("time", (Object)req.getRequestTimer().getTime());
            int pos = rb.shortCircuitedURL.indexOf("://");
            String shardInfoName = pos != -1 ? rb.shortCircuitedURL.substring(pos + 3) : rb.shortCircuitedURL;
            shardInfo.add(shardInfoName, (Object)nl);
            rsp.getValues().add("shards.info", (Object)shardInfo);
        }
    }

    private void processComponents(SolrQueryRequest req, SolrQueryResponse rsp, ResponseBuilder rb, RTimerTree timer, List<SearchComponent> components) throws IOException {
        ShardHandler shardHandler1 = this.getAndPrepShardHandler(req, rb);
        if (!SearchHandler.prepareComponents(req, rb, timer, components)) {
            return;
        }
        SortSpec spec = rb.getSortSpec();
        String string = rb.req.getParams().get("cursorMark");
        if (null != spec && null != string) {
            CursorMark cursorMark = new CursorMark(rb.req.getSchema(), spec);
            cursorMark.parseSerializedTotem(string);
            rb.setCursorMark(cursorMark);
        }
        if (!rb.isDistrib) {
            try {
                if (!rb.isDebug()) {
                    for (SearchComponent searchComponent : components) {
                        if (SearchHandler.checkLimitsBefore(searchComponent, "process", rb.req, rb.rsp, components)) {
                            SearchHandler.shortCircuitedResults(req, rb);
                            return;
                        }
                        searchComponent.process(rb);
                    }
                } else {
                    RTimerTree subt = timer.sub("process");
                    for (SearchComponent searchComponent : components) {
                        if (SearchHandler.checkLimitsBefore(searchComponent, "process debug", rb.req, rb.rsp, components)) {
                            SearchHandler.shortCircuitedResults(req, rb);
                            return;
                        }
                        rb.setTimer(subt.sub(searchComponent.getName()));
                        searchComponent.process(rb);
                        rb.getTimer().stop();
                    }
                    subt.stop();
                    if (rb.isDebugTimings()) {
                        rb.addDebugInfo("timing", timer.asNamedList());
                    }
                }
            }
            catch (ExitableDirectoryReader.ExitingReaderException ex) {
                log.warn("Query: {}; ", (Object)req.getParamString(), (Object)ex);
                SearchHandler.shortCircuitedResults(req, rb);
            }
        } else {
            if (rb.outgoing == null) {
                rb.outgoing = new ArrayList<ShardRequest>();
            }
            rb.finished = new ArrayList<ShardRequest>();
            int nextStage = 0;
            do {
                rb.stage = nextStage;
                nextStage = Integer.MAX_VALUE;
                for (SearchComponent searchComponent : components) {
                    if (SearchHandler.checkLimitsBefore(searchComponent, "distrib", rb.req, rb.rsp, components)) {
                        SearchHandler.shortCircuitedResults(req, rb);
                        return;
                    }
                    nextStage = Math.min(nextStage, searchComponent.distributedProcess(rb));
                }
                block6: while (rb.outgoing.size() > 0) {
                    while (rb.outgoing.size() > 0) {
                        ShardRequest shardRequest = rb.outgoing.remove(0);
                        shardRequest.actualShards = shardRequest.shards;
                        if (shardRequest.actualShards == ShardRequest.ALL_SHARDS) {
                            shardRequest.actualShards = rb.shards;
                        }
                        shardRequest.responses = new ArrayList<ShardResponse>(shardRequest.actualShards.length);
                        for (String shard : shardRequest.actualShards) {
                            String shardQt;
                            ModifiableSolrParams params = new ModifiableSolrParams((SolrParams)shardRequest.params);
                            ShardHandler.setShardAttributesToParams(params, shardRequest.purpose);
                            params.setNonNull("queryID", (Object)rb.queryID);
                            if (rb.requestInfo != null) {
                                params.set("NOW", new String[]{Long.toString(rb.requestInfo.getNOW().getTime())});
                            }
                            if ((shardQt = params.get("shards.qt")) != null) {
                                params.set("qt", new String[]{shardQt});
                            } else {
                                String reqPath = (String)req.getContext().get("path");
                                if (!"/select".equals(reqPath)) {
                                    params.set("qt", new String[]{reqPath});
                                }
                            }
                            shardHandler1.submit(shardRequest, shard, params);
                        }
                    }
                    boolean bl = HttpShardHandler.getShardsTolerantAsBool(rb.req);
                    while (rb.outgoing.size() == 0) {
                        ShardResponse shardResponse;
                        ShardResponse shardResponse2 = shardResponse = bl ? shardHandler1.takeCompletedIncludingErrors() : shardHandler1.takeCompletedOrError();
                        if (shardResponse == null) continue block6;
                        AtomicReference detailMesg = new AtomicReference();
                        boolean anyResponsesPartial = shardResponse.getShardRequest().responses.stream().anyMatch(response -> {
                            NamedList resp = response.getSolrResponse().getResponse();
                            if (resp == null) {
                                return false;
                            }
                            Object recursive = resp.findRecursive(new String[]{"responseHeader", "partialResults"});
                            if (recursive != null) {
                                String message = "[Shard:" + response.getShardAddress() + "]" + resp.findRecursive(new String[]{"responseHeader", "partialResultsDetails"});
                                detailMesg.compareAndSet(null, message);
                            }
                            return recursive != null;
                        });
                        if (anyResponsesPartial) {
                            rb.rsp.addPartialResponseDetail(detailMesg.get());
                            rsp.setPartialResults(rb.req);
                        }
                        if (shardResponse.getException() != null) {
                            if (!bl) {
                                shardHandler1.cancelAll();
                                SearchHandler.throwSolrException(shardResponse.getException());
                            } else {
                                boolean allShardsFailed;
                                boolean includesTopIdsPurpose = (shardResponse.getShardRequest().purpose & 4) != 0;
                                boolean allResponsesHaveExceptions = shardResponse.getShardRequest().responses.stream().allMatch(response -> response.getException() != null);
                                boolean bl2 = allShardsFailed = includesTopIdsPurpose && allResponsesHaveExceptions;
                                if (allShardsFailed) {
                                    SearchHandler.throwSolrException(shardResponse.getException());
                                } else {
                                    rsp.setPartialResults(rb.req);
                                }
                            }
                        }
                        rb.finished.add(shardResponse.getShardRequest());
                        for (SearchComponent c : components) {
                            if (SearchHandler.checkLimitsBefore(c, "handleResponses next stage:" + SearchHandler.stageInEnglish(nextStage), rb.req, rb.rsp, components)) {
                                SearchHandler.shortCircuitedResults(req, rb);
                                return;
                            }
                            c.handleResponses(rb, shardResponse.getShardRequest());
                        }
                    }
                }
                for (SearchComponent searchComponent : components) {
                    if (SearchHandler.checkLimitsBefore(searchComponent, "finishStage stage:" + SearchHandler.stageInEnglish(nextStage), rb.req, rb.rsp, components)) {
                        return;
                    }
                    searchComponent.finishStage(rb);
                }
            } while (nextStage != Integer.MAX_VALUE);
        }
    }

    private static boolean prepareComponents(SolrQueryRequest req, ResponseBuilder rb, RTimerTree timer, List<SearchComponent> components) throws IOException {
        if (timer == null) {
            for (SearchComponent component : components) {
                if (SearchHandler.checkLimitsBefore(component, "prepare", rb.req, rb.rsp, components)) {
                    SearchHandler.shortCircuitedResults(req, rb);
                    return false;
                }
                component.prepare(rb);
            }
        } else {
            RTimerTree subt = timer.sub("prepare");
            for (SearchComponent c : components) {
                if (SearchHandler.checkLimitsBefore(c, "prepare debug", rb.req, rb.rsp, components)) {
                    SearchHandler.shortCircuitedResults(req, rb);
                    return false;
                }
                rb.setTimer(subt.sub(c.getName()));
                c.prepare(rb);
                rb.getTimer().stop();
            }
            subt.stop();
        }
        return true;
    }

    private static String stageInEnglish(int nextStage) {
        switch (nextStage) {
            case 0: {
                return "START";
            }
            case 1000: {
                return "PARSE_QUERY";
            }
            case 1500: {
                return "TOP_GROUPS";
            }
            case 2000: {
                return "EXECUTE_QUERY";
            }
            case 3000: {
                return "GET_FIELDS";
            }
            case 0x7FFFFFFF: {
                return "FINISHING";
            }
        }
        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unrecognized stage:" + nextStage);
    }

    private static void shortCircuitedResults(SolrQueryRequest req, ResponseBuilder rb) {
        if (rb.rsp.getResponse() == null) {
            rb.rsp.addResponse(new SolrDocumentList());
            String cursorStr = rb.req.getParams().get("cursorMark");
            if (null != cursorStr) {
                rb.rsp.add("nextCursorMark", cursorStr);
            }
        }
        if (rb.isDebug()) {
            NamedList debug = new NamedList();
            debug.add("explain", (Object)new NamedList());
            rb.rsp.add("debug", debug);
        }
        rb.rsp.setPartialResults(rb.req);
    }

    private static boolean checkLimitsBefore(SearchComponent c, String when, SolrQueryRequest req, SolrQueryResponse resp, List<SearchComponent> components) {
        return SolrRequestInfo.getQueryLimits(req, resp).maybeExitWithPartialResults(() -> "[" + when + "] Limit(s) exceeded prior to " + c.getName() + " in " + components.stream().map(SearchComponent::getName).collect(Collectors.toList()));
    }

    private static void throwSolrException(Throwable shardResponseException) throws SolrException {
        if (shardResponseException instanceof SolrException) {
            throw (SolrException)shardResponseException;
        }
        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, shardResponseException);
    }

    private void tagRequestWithRequestId(ResponseBuilder rb) {
        boolean ridTaggingDisabled = rb.req.getParams().getBool("disableRequestId", DISABLE_REQUEST_ID_DEFAULT);
        if (!ridTaggingDisabled) {
            String rid = SearchHandler.getOrGenerateRequestId(rb.req);
            MDC.put((String)"rid", (String)rid);
            if (StrUtils.isBlank((String)rb.req.getParams().get("rid"))) {
                ModifiableSolrParams params = new ModifiableSolrParams(rb.req.getParams());
                params.add("rid", new String[]{rid});
                rb.req.setParams((SolrParams)params);
            }
            if (rb.isDistrib) {
                rb.rsp.addToLog("rid", rid);
            }
        }
    }

    public static String getOrGenerateRequestId(SolrQueryRequest req) {
        String rid = req.getParams().get("rid");
        if (StrUtils.isNotBlank((String)rid)) {
            return rid;
        }
        String traceId = MDCLoggingContext.getTraceId();
        if (StrUtils.isNotBlank((String)traceId)) {
            return traceId;
        }
        return SearchHandler.generateRid(req);
    }

    private static String generateRid(SolrQueryRequest req) {
        String hostName = req.getCoreContainer().getHostName();
        return hostName + "-" + ridCounter.getAndIncrement();
    }

    @Override
    public String getDescription() {
        StringBuilder sb = new StringBuilder();
        sb.append("Search using components: ");
        if (this.components != null) {
            for (SearchComponent c : this.components) {
                sb.append(c.getName());
                sb.append(",");
            }
        }
        return sb.toString();
    }

    @Override
    public Boolean registerV2() {
        return Boolean.TRUE;
    }
}

