/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Base64;
import java.util.Collection;
import kafka.common.ZkNodeChangeNotificationListener;
import kafka.server.CreateTokenResult;
import kafka.server.DelegationTokenManager;
import kafka.server.DelegationTokenManager$;
import kafka.server.DelegationTokenManagerZk$;
import kafka.server.DelegationTokenManagerZk$TokenChangedNotificationHandler$;
import kafka.server.KafkaConfig;
import kafka.utils.CoreUtils$;
import kafka.zk.DelegationTokenChangeNotificationSequenceZNode$;
import kafka.zk.DelegationTokenChangeNotificationZNode$;
import kafka.zk.DelegationTokensZNode$;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.token.delegation.DelegationToken;
import org.apache.kafka.common.security.token.delegation.TokenInformation;
import org.apache.kafka.common.security.token.delegation.internals.DelegationTokenCache;
import org.apache.kafka.common.utils.Time;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\t=t!\u0002\u001a4\u0011\u0003Ad!\u0002\u001e4\u0011\u0003Y\u0004\"\u0002\"\u0002\t\u0003\u0019\u0005b\u0002#\u0002\u0005\u0004%\t!\u0012\u0005\u0007\u001d\u0006\u0001\u000b\u0011\u0002$\t\u000f=\u000b!\u0019!C\u0001\u000b\"1\u0001+\u0001Q\u0001\n\u0019Cq!U\u0001C\u0002\u0013\u0005Q\t\u0003\u0004S\u0003\u0001\u0006IA\u0012\u0005\b'\u0006\u0011\r\u0011\"\u0001F\u0011\u0019!\u0016\u0001)A\u0005\r\"9Q+\u0001b\u0001\n\u0003)\u0005B\u0002,\u0002A\u0003%a\tC\u0004X\u0003\t\u0007I\u0011A#\t\ra\u000b\u0001\u0015!\u0003G\u0011\u001dI\u0016A1A\u0005\u0002\u0015CaAW\u0001!\u0002\u00131\u0005bB.\u0002\u0005\u0004%\t!\u0012\u0005\u00079\u0006\u0001\u000b\u0011\u0002$\t\u000fu\u000b!\u0019!C\u0001=\"1!-\u0001Q\u0001\n}CQaY\u0001\u0005\u0002\u0011Dq!!\u0005\u0002\t\u0003\t\u0019BB\u0003;g\u0001\tY\u0003\u0003\u0007\u00024]\u0011\t\u0011)A\u0005\u0003k\tY\u0004\u0003\u0007\u0002>]\u0011\t\u0011)A\u0005\u0003\u007f\tY\u0005\u0003\u0007\u0002N]\u0011\t\u0011)A\u0005\u0003\u001f\nY\u0006\u0003\u0006\u0002^]\u0011)\u0019!C\u0001\u0003?B!\"!\u001c\u0018\u0005\u0003\u0005\u000b\u0011BA1\u0011\u0019\u0011u\u0003\"\u0001\u0002p!Y\u00111P\fA\u0002\u0003\u0007I\u0011BA?\u0011-\tIi\u0006a\u0001\u0002\u0004%I!a#\t\u0017\u0005]u\u00031A\u0001B\u0003&\u0011q\u0010\u0005\b\u00033;B\u0011IAN\u0011\u001d\tij\u0006C\u0005\u00037Cq!a(\u0018\t\u0013\t\t\u000bC\u0004\u00020^!\t%a'\t\u000f\u0005Ev\u0003\"\u0011\u00024\"9\u0011qW\f\u0005B\u0005e\u0006bBA~/\u0011%\u0011Q \u0005\b\u0005\u001f9B\u0011\u0002B\t\u0011\u001d\u0011yb\u0006C!\u0005CAqA!\u000e\u0018\t\u0003\u00129\u0004C\u0004\u0003L]!\tE!\u0014\t\u000f\tEs\u0003\"\u0011\u0002\u001c\u001e9!1K\f\t\u0002\tUca\u0002B,/!\u0005!\u0011\f\u0005\u0007\u0005:\"\tA!\u0019\t\u000f\t\rd\u0006\"\u0011\u0003f!q!1N\f\u0011\u0002\u0007\u0005\t\u0011\"\u0003\u0003n\u0005m\u0013\u0001\u0007#fY\u0016<\u0017\r^5p]R{7.\u001a8NC:\fw-\u001a:[W*\u0011A'N\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003Y\nQa[1gW\u0006\u001c\u0001\u0001\u0005\u0002:\u00035\t1G\u0001\rEK2,w-\u0019;j_:$vn[3o\u001b\u0006t\u0017mZ3s5.\u001c\"!\u0001\u001f\u0011\u0005u\u0002U\"\u0001 \u000b\u0003}\nQa]2bY\u0006L!!\u0011 \u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\t\u0001(\u0001\u0005Po:,'oS3z+\u00051\u0005CA$M\u001b\u0005A%BA%K\u0003\u0011a\u0017M\\4\u000b\u0003-\u000bAA[1wC&\u0011Q\n\u0013\u0002\u0007'R\u0014\u0018N\\4\u0002\u0013=;h.\u001a:LKf\u0004\u0013!\u0005+pW\u0016t'+Z9vKN$XM]&fs\u0006\u0011Bk\\6f]J+\u0017/^3ti\u0016\u00148*Z=!\u0003-\u0011VM\\3xKJ\u001c8*Z=\u0002\u0019I+g.Z<feN\\U-\u001f\u0011\u0002#%\u001b8/^3US6,7\u000f^1na.+\u00170\u0001\nJgN,X\rV5nKN$\u0018-\u001c9LKf\u0004\u0013aD'bqRKW.Z:uC6\u00048*Z=\u0002!5\u000b\u0007\u0010V5nKN$\u0018-\u001c9LKf\u0004\u0013AE#ya&\u0014\u0018\u0010V5nKN$\u0018-\u001c9LKf\f1#\u0012=qSJLH+[7fgR\fW\u000e]&fs\u0002\n!\u0002V8lK:LEmS3z\u0003-!vn[3o\u0013\u0012\\U-\u001f\u0011\u0002\u0015Y+'o]5p].+\u00170A\u0006WKJ\u001c\u0018n\u001c8LKf\u0004\u0013AD\"veJ,g\u000e\u001e,feNLwN\\\u000b\u0002?B\u0011Q\bY\u0005\u0003Cz\u00121!\u00138u\u0003=\u0019UO\u001d:f]R4VM]:j_:\u0004\u0013a\u0005;p\u0015N|gnQ8na\u0006$\u0018N\u00197f\u001b\u0006\u0004HCA3v!\u00111W\u000e\u001d:\u000f\u0005\u001d\\\u0007C\u00015?\u001b\u0005I'B\u000168\u0003\u0019a$o\\8u}%\u0011ANP\u0001\u0007!J,G-\u001a4\n\u00059|'aA'ba*\u0011AN\u0010\t\u0003MFL!!T8\u0011\u0005u\u001a\u0018B\u0001;?\u0005\r\te.\u001f\u0005\u0006mV\u0001\ra^\u0001\ni>\\WM\\%oM>\u00042\u0001_A\u0007\u001b\u0005I(B\u0001>|\u0003)!W\r\\3hCRLwN\u001c\u0006\u0003yv\fQ\u0001^8lK:T!A`@\u0002\u0011M,7-\u001e:jifTA!!\u0001\u0002\u0004\u000511m\\7n_:T1ANA\u0003\u0015\u0011\t9!!\u0003\u0002\r\u0005\u0004\u0018m\u00195f\u0015\t\tY!A\u0002pe\u001eL1!a\u0004z\u0005A!vn[3o\u0013:4wN]7bi&|g.A\u0005ge>l')\u001f;fgR!\u0011QCA\u000e!\u0011i\u0014qC<\n\u0007\u0005eaH\u0001\u0004PaRLwN\u001c\u0005\b\u0003;1\u0002\u0019AA\u0010\u0003\u0015\u0011\u0017\u0010^3t!\u0015i\u0014\u0011EA\u0013\u0013\r\t\u0019C\u0010\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0004{\u0005\u001d\u0012bAA\u0015}\t!!)\u001f;f'\r9\u0012Q\u0006\t\u0004s\u0005=\u0012bAA\u0019g\t1B)\u001a7fO\u0006$\u0018n\u001c8U_.,g.T1oC\u001e,'/\u0001\u0004d_:4\u0017n\u001a\t\u0004s\u0005]\u0012bAA\u001dg\tY1*\u00194lC\u000e{gNZ5h\u0013\u0011\t\u0019$a\f\u0002\u0015Q|7.\u001a8DC\u000eDW\r\u0005\u0003\u0002B\u0005\u001dSBAA\"\u0015\r\t)%_\u0001\nS:$XM\u001d8bYNLA!!\u0013\u0002D\t!B)\u001a7fO\u0006$\u0018n\u001c8U_.,gnQ1dQ\u0016LA!!\u0010\u00020\u0005!A/[7f!\u0011\t\t&a\u0016\u000e\u0005\u0005M#bAA+\u007f\u0006)Q\u000f^5mg&!\u0011\u0011LA*\u0005\u0011!\u0016.\\3\n\t\u00055\u0013qF\u0001\tu.\u001cE.[3oiV\u0011\u0011\u0011\r\t\u0005\u0003G\nI'\u0004\u0002\u0002f)\u0019\u0011qM\u001b\u0002\u0005i\\\u0017\u0002BA6\u0003K\u0012QbS1gW\u0006T6n\u00117jK:$\u0018!\u0003>l\u00072LWM\u001c;!))\t\t(a\u001d\u0002v\u0005]\u0014\u0011\u0010\t\u0003s]Aq!a\r\u001e\u0001\u0004\t)\u0004C\u0004\u0002>u\u0001\r!a\u0010\t\u000f\u00055S\u00041\u0001\u0002P!9\u0011QL\u000fA\u0002\u0005\u0005\u0014a\u0005;pW\u0016t7\t[1oO\u0016d\u0015n\u001d;f]\u0016\u0014XCAA@!\u0011\t\t)!\"\u000e\u0005\u0005\r%bAA\u0001k%!\u0011qQAB\u0005\u0001R6NT8eK\u000eC\u0017M\\4f\u001d>$\u0018NZ5dCRLwN\u001c'jgR,g.\u001a:\u0002/Q|7.\u001a8DQ\u0006tw-\u001a'jgR,g.\u001a:`I\u0015\fH\u0003BAG\u0003'\u00032!PAH\u0013\r\t\tJ\u0010\u0002\u0005+:LG\u000fC\u0005\u0002\u0016~\t\t\u00111\u0001\u0002\u0000\u0005\u0019\u0001\u0010J\u0019\u0002)Q|7.\u001a8DQ\u0006tw-\u001a'jgR,g.\u001a:!\u0003\u001d\u0019H/\u0019:ukB$\"!!$\u0002\u00131|\u0017\rZ\"bG\",\u0017AD4fiR{7.\u001a8Ge>l'l\u001b\u000b\u0005\u0003G\u000bY\u000bE\u0003>\u0003/\t)\u000bE\u0002y\u0003OK1!!+z\u0005=!U\r\\3hCRLwN\u001c+pW\u0016t\u0007BBAWG\u0001\u0007\u0001/A\u0004u_.,g.\u00133\u0002\u0011MDW\u000f\u001e3po:\f1\"\u001e9eCR,Gk\\6f]R!\u0011QRA[\u0011\u0019aX\u00051\u0001\u0002&\u0006Y1M]3bi\u0016$vn[3o)1\ti)a/\u0002L\u0006=\u0017Q]Ax\u0011\u001d\tiL\na\u0001\u0003\u007f\u000bQa\\<oKJ\u0004B!!1\u0002H6\u0011\u00111\u0019\u0006\u0004\u0003\u000bl\u0018\u0001B1vi\"LA!!3\u0002D\nq1*\u00194lCB\u0013\u0018N\\2ja\u0006d\u0007bBAgM\u0001\u0007\u0011qX\u0001\u000fi>\\WM\u001c*fcV,7\u000f^3s\u0011\u001d\t\tN\na\u0001\u0003'\f\u0001B]3oK^,'o\u001d\t\u0007\u0003+\fy.a0\u000f\t\u0005]\u00171\u001c\b\u0004Q\u0006e\u0017\"A \n\u0007\u0005ug(A\u0004qC\u000e\\\u0017mZ3\n\t\u0005\u0005\u00181\u001d\u0002\u0005\u0019&\u001cHOC\u0002\u0002^zBq!a:'\u0001\u0004\tI/A\u0007nCbd\u0015NZ3US6,Wj\u001d\t\u0004{\u0005-\u0018bAAw}\t!Aj\u001c8h\u0011\u001d\t\tP\na\u0001\u0003g\f\u0001C]3ta>t7/Z\"bY2\u0014\u0017mY6\u0011\t\u0005U\u0018q_\u0007\u0002/%!\u0011\u0011`A\u0018\u0005Y\u0019%/Z1uKJ+7\u000f]8og\u0016\u001c\u0015\r\u001c7cC\u000e\\\u0017\u0001C4fiR{7.\u001a8\u0015\t\u0005\r\u0016q \u0005\b\u0005\u00039\u0003\u0019\u0001B\u0002\u0003\u0011AW.Y2\u0011\t\t\u0015!1B\u0007\u0003\u0005\u000fQ1A!\u0003K\u0003\rq\u0017n\\\u0005\u0005\u0005\u001b\u00119A\u0001\u0006CsR,')\u001e4gKJ\fa\"\u00197m_^,G\rV8SK:,w\u000f\u0006\u0004\u0003\u0014\te!Q\u0004\t\u0004{\tU\u0011b\u0001B\f}\t9!i\\8mK\u0006t\u0007b\u0002B\u000eQ\u0001\u0007\u0011qX\u0001\naJLgnY5qC2DQA\u001e\u0015A\u0002]\f!B]3oK^$vn[3o))\tiIa\t\u0003&\t\u001d\"1\u0006\u0005\b\u00057I\u0003\u0019AA`\u0011\u001d\u0011\t!\u000ba\u0001\u0005\u0007AqA!\u000b*\u0001\u0004\tI/A\bsK:,w\u000fT5gKRKW.Z't\u0011\u001d\u0011i#\u000ba\u0001\u0005_\tQB]3oK^\u001c\u0015\r\u001c7cC\u000e\\\u0007\u0003BA{\u0005cIAAa\r\u00020\t)\"+\u001a8foJ+7\u000f]8og\u0016\u001c\u0015\r\u001c7cC\u000e\\\u0017aC3ya&\u0014X\rV8lK:$\"\"!$\u0003:\tm\"Q\bB!\u0011\u001d\u0011YB\u000ba\u0001\u0003\u007fCqA!\u0001+\u0001\u0004\u0011\u0019\u0001C\u0004\u0003@)\u0002\r!!;\u0002!\u0015D\b/\u001b:f\u0019&4W\rV5nK6\u001b\bb\u0002B\"U\u0001\u0007!QI\u0001\u0017Kb\u0004\u0018N]3SKN\u0004xN\\:f\u0007\u0006dGNY1dWB!\u0011Q\u001fB$\u0013\u0011\u0011I%a\f\u0003-\u0015C\b/\u001b:f%\u0016\u001c\bo\u001c8tK\u000e\u000bG\u000e\u001c2bG.\f1B]3n_Z,Gk\\6f]R!\u0011Q\u0012B(\u0011\u0019\tik\u000ba\u0001a\u0006aQ\r\u001f9je\u0016$vn[3og\u0006yBk\\6f]\u000eC\u0017M\\4fI:{G/\u001b4jG\u0006$\u0018n\u001c8IC:$G.\u001a:\u0011\u0007\u0005UhFA\u0010U_.,gn\u00115b]\u001e,GMT8uS\u001aL7-\u0019;j_:D\u0015M\u001c3mKJ\u001cBA\f\u001f\u0003\\A!\u0011\u0011\u0011B/\u0013\u0011\u0011y&a!\u0003'9{G/\u001b4jG\u0006$\u0018n\u001c8IC:$G.\u001a:\u0015\u0005\tU\u0013a\u00059s_\u000e,7o\u001d(pi&4\u0017nY1uS>tG\u0003BAG\u0005OBqA!\u001b1\u0001\u0004\ty\"\u0001\u0007u_.,g.\u00133CsR,7/\u0001\u0006tkB,'\u000f\n;j[\u0016,\"!a\u0014")
public class DelegationTokenManagerZk
extends DelegationTokenManager {
    private volatile DelegationTokenManagerZk$TokenChangedNotificationHandler$ TokenChangedNotificationHandler$module;
    private final KafkaZkClient zkClient;
    private ZkNodeChangeNotificationListener tokenChangeListener;

    public static Option<TokenInformation> fromBytes(byte[] bytes) {
        return DelegationTokenManagerZk$.MODULE$.fromBytes(bytes);
    }

    public static Map<String, Object> toJsonCompatibleMap(TokenInformation tokenInfo) {
        return DelegationTokenManagerZk$.MODULE$.toJsonCompatibleMap(tokenInfo);
    }

    public static int CurrentVersion() {
        return DelegationTokenManagerZk$.MODULE$.CurrentVersion();
    }

    public static String VersionKey() {
        return DelegationTokenManagerZk$.MODULE$.VersionKey();
    }

    public static String TokenIdKey() {
        return DelegationTokenManagerZk$.MODULE$.TokenIdKey();
    }

    public static String ExpiryTimestampKey() {
        return DelegationTokenManagerZk$.MODULE$.ExpiryTimestampKey();
    }

    public static String MaxTimestampKey() {
        return DelegationTokenManagerZk$.MODULE$.MaxTimestampKey();
    }

    public static String IssueTimestampKey() {
        return DelegationTokenManagerZk$.MODULE$.IssueTimestampKey();
    }

    public static String RenewersKey() {
        return DelegationTokenManagerZk$.MODULE$.RenewersKey();
    }

    public static String TokenRequesterKey() {
        return DelegationTokenManagerZk$.MODULE$.TokenRequesterKey();
    }

    public static String OwnerKey() {
        return DelegationTokenManagerZk$.MODULE$.OwnerKey();
    }

    public DelegationTokenManagerZk$TokenChangedNotificationHandler$ TokenChangedNotificationHandler() {
        if (this.TokenChangedNotificationHandler$module == null) {
            this.TokenChangedNotificationHandler$lzycompute$1();
        }
        return this.TokenChangedNotificationHandler$module;
    }

    private /* synthetic */ Time super$time() {
        return super.time();
    }

    public KafkaZkClient zkClient() {
        return this.zkClient;
    }

    private ZkNodeChangeNotificationListener tokenChangeListener() {
        return this.tokenChangeListener;
    }

    private void tokenChangeListener_$eq(ZkNodeChangeNotificationListener x$1) {
        this.tokenChangeListener = x$1;
    }

    @Override
    public void startup() {
        if (super.config().tokenAuthEnabled()) {
            this.zkClient().createDelegationTokenPaths();
            this.loadCache();
            this.tokenChangeListener_$eq(new ZkNodeChangeNotificationListener(this.zkClient(), DelegationTokenChangeNotificationZNode$.MODULE$.path(), DelegationTokenChangeNotificationSequenceZNode$.MODULE$.SequenceNumberPrefix(), this.TokenChangedNotificationHandler(), 900000L, Time.SYSTEM));
            this.tokenChangeListener().init();
            return;
        }
    }

    private void loadCache() {
        Object object = this.lock();
        synchronized (object) {
            Seq<String> tokens = this.zkClient().getChildren(DelegationTokensZNode$.MODULE$.path());
            this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(44).append("Loading the token cache. Total token count: ").append(tokens.size()).toString());
            tokens.foreach((Function1 & Serializable)tokenId -> {
                DelegationTokenManagerZk.$anonfun$loadCache$2(this, tokenId);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    public Option<DelegationToken> kafka$server$DelegationTokenManagerZk$$getTokenFromZk(String tokenId) {
        Option<TokenInformation> option = this.zkClient().getDelegationTokenInfo(tokenId);
        if (option instanceof Some) {
            TokenInformation tokenInformation = (TokenInformation)((Some)option).value();
            byte[] hmac = DelegationTokenManager$.MODULE$.createHmac(tokenId, this.secretKey());
            return new Some((Object)new DelegationToken(tokenInformation, hmac));
        }
        if (None$.MODULE$.equals(option)) {
            return None$.MODULE$;
        }
        throw new MatchError(option);
    }

    @Override
    public void shutdown() {
        if (super.config().tokenAuthEnabled()) {
            if (this.tokenChangeListener() != null) {
                this.tokenChangeListener().close();
                return;
            }
            return;
        }
    }

    @Override
    public void updateToken(DelegationToken token) {
        this.zkClient().setOrCreateDelegationToken(token);
        this.updateCache(token);
        this.zkClient().createTokenChangeNotification(token.tokenInfo().tokenId());
    }

    @Override
    public void createToken(KafkaPrincipal owner, KafkaPrincipal tokenRequester, List<KafkaPrincipal> renewers, long maxLifeTimeMs, Function1<CreateTokenResult, BoxedUnit> responseCallback) {
        if (!super.config().tokenAuthEnabled()) {
            responseCallback.apply((Object)new CreateTokenResult(owner, tokenRequester, -1L, -1L, -1L, "", (byte[])Array$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$, (ClassTag)ClassTag$.MODULE$.Byte()), Errors.DELEGATION_TOKEN_AUTH_DISABLED));
            return;
        }
        Object object = this.lock();
        synchronized (object) {
            String tokenId = CoreUtils$.MODULE$.generateUuidAsBase64();
            long issueTimeStamp = super.time().milliseconds();
            long maxLifeTime = maxLifeTimeMs <= 0L ? this.tokenMaxLifetime() : Math.min(maxLifeTimeMs, this.tokenMaxLifetime());
            long maxLifeTimeStamp = issueTimeStamp + maxLifeTime;
            long expiryTimeStamp = Math.min(maxLifeTimeStamp, issueTimeStamp + this.defaultTokenRenewTime());
            TokenInformation tokenInfo = new TokenInformation(tokenId, owner, tokenRequester, (Collection)CollectionConverters$.MODULE$.SeqHasAsJava(renewers).asJava(), issueTimeStamp, maxLifeTimeStamp, expiryTimeStamp);
            byte[] hmac = DelegationTokenManager$.MODULE$.createHmac(tokenId, this.secretKey());
            DelegationToken token = new DelegationToken(tokenInfo, hmac);
            this.updateToken(token);
            this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(40).append("Created a delegation token: ").append(tokenId).append(" for owner: ").append(owner).toString());
            responseCallback.apply((Object)new CreateTokenResult(owner, tokenRequester, issueTimeStamp, expiryTimeStamp, maxLifeTimeStamp, tokenId, hmac, Errors.NONE));
            return;
        }
    }

    private Option<DelegationToken> getToken(ByteBuffer hmac) {
        None$ none$;
        try {
            byte[] byteArray = new byte[hmac.remaining()];
            hmac.get(byteArray);
            String base64Pwd = Base64.getEncoder().encodeToString(byteArray);
            TokenInformation tokenInfo = super.tokenCache().tokenForHmac(base64Pwd);
            if (tokenInfo != null) {
                return new Some((Object)new DelegationToken(tokenInfo, byteArray));
            }
            none$ = None$.MODULE$;
        }
        catch (Exception e) {
            this.error((Function0<String>)(Function0 & Serializable)() -> "Exception while getting token for hmac", (Function0<Throwable>)(Function0 & Serializable)() -> e);
            none$ = None$.MODULE$;
        }
        return none$;
    }

    private boolean allowedToRenew(KafkaPrincipal principal, TokenInformation tokenInfo) {
        return principal.equals((Object)tokenInfo.owner()) || CollectionConverters$.MODULE$.CollectionHasAsScala(tokenInfo.renewers()).asScala().toList().contains((Object)principal);
    }

    @Override
    public void renewToken(KafkaPrincipal principal, ByteBuffer hmac, long renewLifeTimeMs, Function2<Errors, Object, BoxedUnit> renewCallback) {
        if (!super.config().tokenAuthEnabled()) {
            renewCallback.apply((Object)Errors.DELEGATION_TOKEN_AUTH_DISABLED, (Object)BoxesRunTime.boxToLong((long)-1L));
            return;
        }
        Object object = this.lock();
        synchronized (object) {
            Option<DelegationToken> option = this.getToken(hmac);
            if (option instanceof Some) {
                DelegationToken token = (DelegationToken)((Some)option).value();
                long now = super.time().milliseconds();
                TokenInformation tokenInfo = token.tokenInfo();
                if (!this.allowedToRenew(principal, tokenInfo)) {
                    BoxedUnit cfr_ignored_0 = (BoxedUnit)renewCallback.apply((Object)Errors.DELEGATION_TOKEN_OWNER_MISMATCH, (Object)BoxesRunTime.boxToLong((long)-1L));
                } else if (tokenInfo.maxTimestamp() < now || tokenInfo.expiryTimestamp() < now) {
                    BoxedUnit cfr_ignored_1 = (BoxedUnit)renewCallback.apply((Object)Errors.DELEGATION_TOKEN_EXPIRED, (Object)BoxesRunTime.boxToLong((long)-1L));
                } else {
                    long renewLifeTime = renewLifeTimeMs < 0L ? this.defaultTokenRenewTime() : renewLifeTimeMs;
                    long renewTimeStamp = now + renewLifeTime;
                    long expiryTimeStamp = Math.min(tokenInfo.maxTimestamp(), renewTimeStamp);
                    tokenInfo.setExpiryTimestamp(expiryTimeStamp);
                    this.updateToken(token);
                    this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(48).append("Delegation token renewed for token: ").append(tokenInfo.tokenId()).append(" for owner: ").append(tokenInfo.owner()).toString());
                    BoxedUnit cfr_ignored_2 = (BoxedUnit)renewCallback.apply((Object)Errors.NONE, (Object)BoxesRunTime.boxToLong((long)expiryTimeStamp));
                }
            } else if (None$.MODULE$.equals(option)) {
                BoxedUnit cfr_ignored_3 = (BoxedUnit)renewCallback.apply((Object)Errors.DELEGATION_TOKEN_NOT_FOUND, (Object)BoxesRunTime.boxToLong((long)-1L));
            } else {
                throw new MatchError(option);
            }
            return;
        }
    }

    @Override
    public void expireToken(KafkaPrincipal principal, ByteBuffer hmac, long expireLifeTimeMs, Function2<Errors, Object, BoxedUnit> expireResponseCallback) {
        if (!super.config().tokenAuthEnabled()) {
            expireResponseCallback.apply((Object)Errors.DELEGATION_TOKEN_AUTH_DISABLED, (Object)BoxesRunTime.boxToLong((long)-1L));
            return;
        }
        Object object = this.lock();
        synchronized (object) {
            Option<DelegationToken> option = this.getToken(hmac);
            if (option instanceof Some) {
                DelegationToken token = (DelegationToken)((Some)option).value();
                TokenInformation tokenInfo = token.tokenInfo();
                long now = super.time().milliseconds();
                if (!this.allowedToRenew(principal, tokenInfo)) {
                    BoxedUnit cfr_ignored_0 = (BoxedUnit)expireResponseCallback.apply((Object)Errors.DELEGATION_TOKEN_OWNER_MISMATCH, (Object)BoxesRunTime.boxToLong((long)-1L));
                } else if (expireLifeTimeMs < 0L) {
                    this.removeToken(tokenInfo.tokenId());
                    this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(37).append("Token expired for token: ").append(tokenInfo.tokenId()).append(" for owner: ").append(tokenInfo.owner()).toString());
                    BoxedUnit cfr_ignored_1 = (BoxedUnit)expireResponseCallback.apply((Object)Errors.NONE, (Object)BoxesRunTime.boxToLong((long)now));
                } else if (tokenInfo.maxTimestamp() < now || tokenInfo.expiryTimestamp() < now) {
                    BoxedUnit cfr_ignored_2 = (BoxedUnit)expireResponseCallback.apply((Object)Errors.DELEGATION_TOKEN_EXPIRED, (Object)BoxesRunTime.boxToLong((long)-1L));
                } else {
                    long expiryTimeStamp = Math.min(tokenInfo.maxTimestamp(), now + expireLifeTimeMs);
                    tokenInfo.setExpiryTimestamp(expiryTimeStamp);
                    this.updateToken(token);
                    this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(43).append("Updated expiry time for token: ").append(tokenInfo.tokenId()).append(" for owner: ").append(tokenInfo.owner()).toString());
                    BoxedUnit cfr_ignored_3 = (BoxedUnit)expireResponseCallback.apply((Object)Errors.NONE, (Object)BoxesRunTime.boxToLong((long)expiryTimeStamp));
                }
            } else if (None$.MODULE$.equals(option)) {
                BoxedUnit cfr_ignored_4 = (BoxedUnit)expireResponseCallback.apply((Object)Errors.DELEGATION_TOKEN_NOT_FOUND, (Object)BoxesRunTime.boxToLong((long)-1L));
            } else {
                throw new MatchError(option);
            }
            return;
        }
    }

    @Override
    public void removeToken(String tokenId) {
        this.zkClient().deleteDelegationToken(tokenId);
        this.removeCache(tokenId);
        this.zkClient().createTokenChangeNotification(tokenId);
    }

    @Override
    public void expireTokens() {
        Object object = this.lock();
        synchronized (object) {
            this.getAllTokenInformation().foreach((Function1 & Serializable)tokenInfo -> {
                DelegationTokenManagerZk.$anonfun$expireTokens$1(this, tokenInfo);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    private final void TokenChangedNotificationHandler$lzycompute$1() {
        synchronized (this) {
            if (this.TokenChangedNotificationHandler$module == null) {
                this.TokenChangedNotificationHandler$module = new DelegationTokenManagerZk$TokenChangedNotificationHandler$(this);
            }
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$loadCache$2(DelegationTokenManagerZk $this, String tokenId) {
        try {
            Option<DelegationToken> option = $this.kafka$server$DelegationTokenManagerZk$$getTokenFromZk(tokenId);
            if (option instanceof Some) {
                DelegationToken token = (DelegationToken)((Some)option).value();
                $this.updateCache(token);
            } else if (!None$.MODULE$.equals(option)) {
                throw new MatchError(option);
            }
        }
        catch (Throwable ex) {
            $this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(39).append("Error while getting Token for tokenId: ").append(tokenId).toString(), (Function0<Throwable>)(Function0 & Serializable)() -> ex);
        }
    }

    public static final /* synthetic */ void $anonfun$expireTokens$1(DelegationTokenManagerZk $this, TokenInformation tokenInfo) {
        long now = $this.super$time().milliseconds();
        if (tokenInfo.maxTimestamp() < now || tokenInfo.expiryTimestamp() < now) {
            $this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(48).append("Delegation token expired for token: ").append(tokenInfo.tokenId()).append(" for owner: ").append(tokenInfo.owner()).toString());
            $this.removeToken(tokenInfo.tokenId());
            return;
        }
    }

    public DelegationTokenManagerZk(KafkaConfig config, DelegationTokenCache tokenCache, Time time, KafkaZkClient zkClient) {
        this.zkClient = zkClient;
        super(config, tokenCache, time);
    }
}

