/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer.internals.events;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import org.apache.kafka.clients.consumer.OffsetAndTimestamp;
import org.apache.kafka.clients.consumer.internals.CachedSupplier;
import org.apache.kafka.clients.consumer.internals.CommitRequestManager;
import org.apache.kafka.clients.consumer.internals.ConsumerMetadata;
import org.apache.kafka.clients.consumer.internals.MembershipManager;
import org.apache.kafka.clients.consumer.internals.RequestManagers;
import org.apache.kafka.clients.consumer.internals.events.ApplicationEvent;
import org.apache.kafka.clients.consumer.internals.events.AssignmentChangeApplicationEvent;
import org.apache.kafka.clients.consumer.internals.events.CommitApplicationEvent;
import org.apache.kafka.clients.consumer.internals.events.CommitOnCloseApplicationEvent;
import org.apache.kafka.clients.consumer.internals.events.ConsumerRebalanceListenerCallbackCompletedEvent;
import org.apache.kafka.clients.consumer.internals.events.EventProcessor;
import org.apache.kafka.clients.consumer.internals.events.FetchCommittedOffsetsApplicationEvent;
import org.apache.kafka.clients.consumer.internals.events.LeaveOnCloseApplicationEvent;
import org.apache.kafka.clients.consumer.internals.events.ListOffsetsApplicationEvent;
import org.apache.kafka.clients.consumer.internals.events.NewTopicsMetadataUpdateRequestEvent;
import org.apache.kafka.clients.consumer.internals.events.PollApplicationEvent;
import org.apache.kafka.clients.consumer.internals.events.ResetPositionsApplicationEvent;
import org.apache.kafka.clients.consumer.internals.events.SubscriptionChangeApplicationEvent;
import org.apache.kafka.clients.consumer.internals.events.TopicMetadataApplicationEvent;
import org.apache.kafka.clients.consumer.internals.events.UnsubscribeApplicationEvent;
import org.apache.kafka.clients.consumer.internals.events.ValidatePositionsApplicationEvent;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.utils.LogContext;
import org.slf4j.Logger;

public class ApplicationEventProcessor
extends EventProcessor<ApplicationEvent> {
    private final Logger log;
    private final ConsumerMetadata metadata;
    private final RequestManagers requestManagers;

    public ApplicationEventProcessor(LogContext logContext, BlockingQueue<ApplicationEvent> applicationEventQueue, RequestManagers requestManagers, ConsumerMetadata metadata) {
        super(logContext, applicationEventQueue);
        this.log = logContext.logger(ApplicationEventProcessor.class);
        this.requestManagers = requestManagers;
        this.metadata = metadata;
    }

    @Override
    public boolean process() {
        return this.process((T event, Optional<KafkaException> error) -> error.ifPresent(e -> this.log.warn("Error processing event {}", (Object)e.getMessage(), e)));
    }

    @Override
    public void process(ApplicationEvent event) {
        switch (event.type()) {
            case COMMIT: {
                this.process((CommitApplicationEvent)event);
                return;
            }
            case POLL: {
                this.process((PollApplicationEvent)event);
                return;
            }
            case FETCH_COMMITTED_OFFSETS: {
                this.process((FetchCommittedOffsetsApplicationEvent)event);
                return;
            }
            case NEW_TOPICS_METADATA_UPDATE: {
                this.process((NewTopicsMetadataUpdateRequestEvent)event);
                return;
            }
            case ASSIGNMENT_CHANGE: {
                this.process((AssignmentChangeApplicationEvent)event);
                return;
            }
            case TOPIC_METADATA: {
                this.process((TopicMetadataApplicationEvent)event);
                return;
            }
            case LIST_OFFSETS: {
                this.process((ListOffsetsApplicationEvent)event);
                return;
            }
            case RESET_POSITIONS: {
                this.process((ResetPositionsApplicationEvent)event);
                return;
            }
            case VALIDATE_POSITIONS: {
                this.process((ValidatePositionsApplicationEvent)event);
                return;
            }
            case SUBSCRIPTION_CHANGE: {
                this.process((SubscriptionChangeApplicationEvent)event);
                return;
            }
            case UNSUBSCRIBE: {
                this.process((UnsubscribeApplicationEvent)event);
                return;
            }
            case CONSUMER_REBALANCE_LISTENER_CALLBACK_COMPLETED: {
                this.process((ConsumerRebalanceListenerCallbackCompletedEvent)event);
                return;
            }
            case COMMIT_ON_CLOSE: {
                this.process((CommitOnCloseApplicationEvent)event);
                return;
            }
            case LEAVE_ON_CLOSE: {
                this.process((LeaveOnCloseApplicationEvent)event);
                return;
            }
        }
        this.log.warn("Application event type " + (Object)((Object)event.type()) + " was not expected");
    }

    @Override
    private void process(PollApplicationEvent event) {
        if (!this.requestManagers.commitRequestManager.isPresent()) {
            return;
        }
        this.requestManagers.commitRequestManager.ifPresent(m -> m.updateAutoCommitTimer(event.pollTimeMs()));
        this.requestManagers.heartbeatRequestManager.ifPresent(hrm -> hrm.resetPollTimer(event.pollTimeMs()));
    }

    @Override
    private void process(CommitApplicationEvent event) {
        if (!this.requestManagers.commitRequestManager.isPresent()) {
            KafkaException exception = new KafkaException("Unable to commit offset. Most likely because the group.id wasn't set");
            event.future().completeExceptionally(exception);
            return;
        }
        CommitRequestManager manager = this.requestManagers.commitRequestManager.get();
        Optional<Long> expirationTimeMs = event.retryTimeoutMs().map(this::getExpirationTimeForTimeout);
        event.chain(manager.addOffsetCommitRequest(event.offsets(), expirationTimeMs, false));
    }

    @Override
    private void process(FetchCommittedOffsetsApplicationEvent event) {
        if (!this.requestManagers.commitRequestManager.isPresent()) {
            event.future().completeExceptionally(new KafkaException("Unable to fetch committed offset because the CommittedRequestManager is not available. Check if group.id was set correctly"));
            return;
        }
        CommitRequestManager manager = this.requestManagers.commitRequestManager.get();
        long expirationTimeMs = this.getExpirationTimeForTimeout(event.timeout());
        event.chain(manager.addOffsetFetchRequest(event.partitions(), expirationTimeMs));
    }

    @Override
    private void process(NewTopicsMetadataUpdateRequestEvent ignored) {
        this.metadata.requestUpdateForNewTopics();
    }

    @Override
    private void process(AssignmentChangeApplicationEvent event) {
        if (!this.requestManagers.commitRequestManager.isPresent()) {
            return;
        }
        CommitRequestManager manager = this.requestManagers.commitRequestManager.get();
        manager.updateAutoCommitTimer(event.currentTimeMs());
        manager.maybeAutoCommitAllConsumedAsync();
    }

    @Override
    private void process(ListOffsetsApplicationEvent event) {
        CompletableFuture<Map<TopicPartition, OffsetAndTimestamp>> future = this.requestManagers.offsetsRequestManager.fetchOffsets(event.timestampsToSearch(), event.requireTimestamps());
        event.chain(future);
    }

    @Override
    private void process(SubscriptionChangeApplicationEvent ignored) {
        if (!this.requestManagers.heartbeatRequestManager.isPresent()) {
            this.log.warn("Group membership manager not present when processing a subscribe event");
            return;
        }
        MembershipManager membershipManager = this.requestManagers.heartbeatRequestManager.get().membershipManager();
        membershipManager.onSubscriptionUpdated();
    }

    @Override
    private void process(UnsubscribeApplicationEvent event) {
        if (!this.requestManagers.heartbeatRequestManager.isPresent()) {
            KafkaException error = new KafkaException("Group membership manager not present when processing an unsubscribe event");
            event.future().completeExceptionally(error);
            return;
        }
        MembershipManager membershipManager = this.requestManagers.heartbeatRequestManager.get().membershipManager();
        CompletableFuture<Void> result = membershipManager.leaveGroup();
        event.chain(result);
    }

    @Override
    private void process(ResetPositionsApplicationEvent event) {
        CompletableFuture<Void> result = this.requestManagers.offsetsRequestManager.resetPositionsIfNeeded();
        event.chain(result);
    }

    @Override
    private void process(ValidatePositionsApplicationEvent event) {
        CompletableFuture<Void> result = this.requestManagers.offsetsRequestManager.validatePositionsIfNeeded();
        event.chain(result);
    }

    @Override
    private void process(TopicMetadataApplicationEvent event) {
        long expirationTimeMs = this.getExpirationTimeForTimeout(event.getTimeoutMs());
        CompletableFuture<Map<String, List<PartitionInfo>>> future = event.isAllTopics() ? this.requestManagers.topicMetadataRequestManager.requestAllTopicsMetadata(expirationTimeMs) : this.requestManagers.topicMetadataRequestManager.requestTopicMetadata(event.topic(), expirationTimeMs);
        event.chain(future);
    }

    @Override
    private void process(ConsumerRebalanceListenerCallbackCompletedEvent event) {
        if (!this.requestManagers.heartbeatRequestManager.isPresent()) {
            this.log.warn("An internal error occurred; the group membership manager was not present, so the notification of the {} callback execution could not be sent", (Object)event.methodName());
            return;
        }
        MembershipManager manager = this.requestManagers.heartbeatRequestManager.get().membershipManager();
        manager.consumerRebalanceListenerCallbackCompleted(event);
    }

    @Override
    private void process(CommitOnCloseApplicationEvent event) {
        if (!this.requestManagers.commitRequestManager.isPresent()) {
            return;
        }
        this.log.debug("Signal CommitRequestManager closing");
        this.requestManagers.commitRequestManager.get().signalClose();
    }

    @Override
    private void process(LeaveOnCloseApplicationEvent event) {
        if (!this.requestManagers.heartbeatRequestManager.isPresent()) {
            event.future().complete(null);
            return;
        }
        MembershipManager membershipManager = Objects.requireNonNull(this.requestManagers.heartbeatRequestManager.get().membershipManager(), "Expecting membership manager to be non-null");
        this.log.debug("Leaving group before closing");
        CompletableFuture<Void> future = membershipManager.leaveGroup();
        event.chain(future);
    }

    long getExpirationTimeForTimeout(long timeoutMs) {
        long expiration = System.currentTimeMillis() + timeoutMs;
        if (expiration < 0L) {
            return Long.MAX_VALUE;
        }
        return expiration;
    }

    public static Supplier<ApplicationEventProcessor> supplier(final LogContext logContext, final ConsumerMetadata metadata, final BlockingQueue<ApplicationEvent> applicationEventQueue, final Supplier<RequestManagers> requestManagersSupplier) {
        return new CachedSupplier<ApplicationEventProcessor>(){

            @Override
            protected ApplicationEventProcessor create() {
                RequestManagers requestManagers = (RequestManagers)requestManagersSupplier.get();
                return new ApplicationEventProcessor(logContext, applicationEventQueue, requestManagers, metadata);
            }
        };
    }
}

