/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.infinispan.changes.sessions;

import java.util.Map;
import org.infinispan.Cache;
import org.jboss.logging.Logger;
import org.keycloak.cluster.ClusterEvent;
import org.keycloak.cluster.ClusterListener;
import org.keycloak.connections.infinispan.InfinispanUtil;
import org.keycloak.connections.infinispan.TopologyInfo;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.models.sessions.infinispan.changes.SessionEntityWrapper;
import org.keycloak.models.sessions.infinispan.changes.sessions.LastSessionRefreshEvent;
import org.keycloak.models.sessions.infinispan.changes.sessions.SessionData;
import org.keycloak.models.sessions.infinispan.entities.UserSessionEntity;
import org.keycloak.models.utils.KeycloakModelUtils;

public class CrossDCLastSessionRefreshListener
implements ClusterListener {
    public static final Logger logger = Logger.getLogger(CrossDCLastSessionRefreshListener.class);
    public static final String IGNORE_REMOTE_CACHE_UPDATE = "IGNORE_REMOTE_CACHE_UPDATE";
    private final boolean offline;
    private final KeycloakSessionFactory sessionFactory;
    private final Cache<String, SessionEntityWrapper<UserSessionEntity>> cache;
    private final TopologyInfo topologyInfo;

    public CrossDCLastSessionRefreshListener(KeycloakSession session, Cache<String, SessionEntityWrapper<UserSessionEntity>> cache, boolean offline) {
        this.sessionFactory = session.getKeycloakSessionFactory();
        this.cache = cache;
        this.offline = offline;
        this.topologyInfo = InfinispanUtil.getTopologyInfo(session);
    }

    public void eventReceived(ClusterEvent event) {
        Map<String, SessionData> lastSessionRefreshes = ((LastSessionRefreshEvent)event).getLastSessionRefreshes();
        if (logger.isDebugEnabled()) {
            logger.debugf("Received refreshes. Offline %b, refreshes: %s", (Object)this.offline, lastSessionRefreshes);
        }
        lastSessionRefreshes.entrySet().stream().forEach(entry -> {
            String sessionId = (String)entry.getKey();
            String realmId = ((SessionData)entry.getValue()).realmId();
            int lastSessionRefresh = ((SessionData)entry.getValue()).lastSessionRefresh();
            if (this.shouldUpdateLocalCache(sessionId)) {
                KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)this.sessionFactory, kcSession -> {
                    UserSessionModel userSession;
                    RealmModel realm = kcSession.realms().getRealm(realmId);
                    UserSessionModel userSessionModel = userSession = this.offline ? kcSession.sessions().getOfflineUserSession(realm, sessionId) : kcSession.sessions().getUserSession(realm, sessionId);
                    if (userSession == null) {
                        logger.debugf("User session '%s' not available on node '%s' offline '%b'", (Object)sessionId, (Object)this.topologyInfo.getMyNodeName(), (Object)this.offline);
                    } else if (lastSessionRefresh > userSession.getLastSessionRefresh()) {
                        kcSession.setAttribute(IGNORE_REMOTE_CACHE_UPDATE, (Object)true);
                        userSession.setLastSessionRefresh(lastSessionRefresh);
                    }
                });
            }
        });
    }

    protected boolean shouldUpdateLocalCache(String key) {
        return this.topologyInfo.amIOwner(this.cache, key);
    }
}

