/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.property.access.internal;

import java.io.Serializable;
import java.lang.reflect.Field;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.hibernate.internal.util.ReflectHelper;
import org.hibernate.property.access.spi.PropertyAccessSerializationException;

public abstract class AbstractFieldSerialForm
implements Serializable {
    private final /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> declaringClass;
    private final @UnknownKeyFor @NonNull @Initialized String fieldName;

    protected AbstractFieldSerialForm(@UnknownKeyFor @NonNull @Initialized Field field) {
        this(field.getDeclaringClass(), field.getName());
    }

    protected AbstractFieldSerialForm(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> declaringClass, @UnknownKeyFor @NonNull @Initialized String fieldName) {
        this.declaringClass = declaringClass;
        this.fieldName = fieldName;
    }

    protected @UnknownKeyFor @NonNull @Initialized Field resolveField() {
        try {
            Field field = this.declaringClass.getDeclaredField(this.fieldName);
            ReflectHelper.ensureAccessibility(field);
            return field;
        }
        catch (NoSuchFieldException e) {
            throw new PropertyAccessSerializationException("Unable to resolve field on deserialization : " + this.declaringClass.getName() + "#" + this.fieldName);
        }
    }
}

