/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution.ch.impl;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.UnaryOperator;
import org.infinispan.commons.marshall.InstanceReusingAdvancedExternalizer;
import org.infinispan.commons.util.IntSet;
import org.infinispan.commons.util.IntSets;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.globalstate.ScopedPersistentState;
import org.infinispan.marshall.core.Ids;
import org.infinispan.remoting.transport.Address;
import org.infinispan.topology.PersistentUUID;

public class ReplicatedConsistentHash
implements ConsistentHash {
    private static final String STATE_PRIMARY_OWNERS = "primaryOwners.%d";
    private static final String STATE_PRIMARY_OWNERS_COUNT = "primaryOwners";
    private final int[] primaryOwners;
    private final List<Address> members;
    private final List<Address> membersWithState;
    private final Set<Address> membersWithStateSet;
    private final List<Address> membersWithoutState;
    private final Map<Address, Float> capacityFactors;
    private final Set<Integer> segments;

    public ReplicatedConsistentHash(List<Address> members, int[] primaryOwners) {
        this(members, null, Collections.emptyList(), primaryOwners);
    }

    public ReplicatedConsistentHash(List<Address> members, Map<Address, Float> capacityFactors, List<Address> membersWithoutState, int[] primaryOwners) {
        this.members = List.copyOf(members);
        this.membersWithoutState = List.copyOf(membersWithoutState);
        this.membersWithState = this.computeMembersWithState(members, membersWithoutState);
        this.membersWithStateSet = Set.copyOf(this.membersWithState);
        this.primaryOwners = primaryOwners;
        this.capacityFactors = capacityFactors == null ? null : Map.copyOf(capacityFactors);
        this.segments = IntSets.immutableRangeSet((int)primaryOwners.length);
    }

    public ReplicatedConsistentHash union(ReplicatedConsistentHash ch2) {
        HashMap<Address, Float> unionCapacityFactors;
        if (this.getNumSegments() != ch2.getNumSegments()) {
            throw new IllegalArgumentException("The consistent hash objects must have the same number of segments");
        }
        ArrayList<Address> unionMembers = new ArrayList<Address>(this.members);
        for (Address address : ch2.getMembers()) {
            if (this.members.contains(address)) continue;
            unionMembers.add(address);
        }
        ArrayList<Address> unionMembersWithoutState = new ArrayList<Address>(this.membersWithoutState);
        for (Address member : ch2.membersWithoutState) {
            if (ch2.membersWithStateSet.contains(member) || unionMembersWithoutState.contains(member)) continue;
            unionMembersWithoutState.add(member);
        }
        int[] nArray = new int[this.getNumSegments()];
        for (int segmentId = 0; segmentId < nArray.length; ++segmentId) {
            int primaryOwnerIndex;
            Address primaryOwner = this.locatePrimaryOwnerForSegment(segmentId);
            nArray[segmentId] = primaryOwnerIndex = unionMembers.indexOf(primaryOwner);
        }
        if (this.capacityFactors == null && ch2.capacityFactors == null) {
            unionCapacityFactors = null;
        } else if (this.capacityFactors == null) {
            unionCapacityFactors = new HashMap<Address, Float>(ch2.capacityFactors);
            for (Address address : this.members) {
                unionCapacityFactors.put(address, Float.valueOf(1.0f));
            }
        } else if (ch2.capacityFactors == null) {
            unionCapacityFactors = new HashMap<Address, Float>(this.capacityFactors);
            for (Address address : ch2.members) {
                unionCapacityFactors.put(address, Float.valueOf(1.0f));
            }
        } else {
            unionCapacityFactors = new HashMap<Address, Float>(this.capacityFactors);
            unionCapacityFactors.putAll(ch2.capacityFactors);
        }
        return new ReplicatedConsistentHash(unionMembers, unionCapacityFactors, unionMembersWithoutState, nArray);
    }

    ReplicatedConsistentHash(ScopedPersistentState state) {
        List<Address> members = ReplicatedConsistentHash.parseMembers(state, "members", "member.%d");
        List<Address> membersWithoutState = ReplicatedConsistentHash.parseMembers(state, "membersNoEntries", "memberNoEntries.%d");
        Map<Address, Float> capacityFactors = ReplicatedConsistentHash.parseCapacityFactors(state, members);
        int[] primaryOwners = ReplicatedConsistentHash.parsePrimaryOwners(state);
        this.members = List.copyOf(members);
        this.membersWithoutState = List.copyOf(membersWithoutState);
        this.membersWithState = this.computeMembersWithState(members, membersWithoutState);
        this.membersWithStateSet = Set.copyOf(this.membersWithState);
        this.primaryOwners = primaryOwners;
        this.capacityFactors = Map.copyOf(capacityFactors);
        this.segments = IntSets.immutableRangeSet((int)this.primaryOwners.length);
    }

    private static List<Address> parseMembers(ScopedPersistentState state, String numMembersPropertyName, String memberPropertyFormat) {
        String property = state.getProperty(numMembersPropertyName);
        if (property == null) {
            return Collections.emptyList();
        }
        int numMembers = Integer.parseInt(property);
        ArrayList<Address> members = new ArrayList<Address>(numMembers);
        for (int i = 0; i < numMembers; ++i) {
            PersistentUUID uuid = PersistentUUID.fromString(state.getProperty(String.format(memberPropertyFormat, i)));
            members.add(uuid);
        }
        return members;
    }

    private static Map<Address, Float> parseCapacityFactors(ScopedPersistentState state, List<Address> members) {
        String numCapacityFactorsString = state.getProperty("capacityFactors");
        if (numCapacityFactorsString == null) {
            HashMap<Address, Float> map = new HashMap<Address, Float>();
            for (Address a : members) {
                map.put(a, Float.valueOf(1.0f));
            }
            return map;
        }
        int numCapacityFactors = Integer.parseInt(numCapacityFactorsString);
        HashMap<Address, Float> capacityFactors = new HashMap<Address, Float>(numCapacityFactors * 2);
        for (int i = 0; i < numCapacityFactors; ++i) {
            float capacityFactor = Float.parseFloat(state.getProperty(String.format("capacityFactor.%d", i)));
            capacityFactors.put(members.get(i), Float.valueOf(capacityFactor));
        }
        return capacityFactors;
    }

    private static int[] parsePrimaryOwners(ScopedPersistentState state) {
        int numPrimaryOwners = state.getIntProperty(STATE_PRIMARY_OWNERS_COUNT);
        int[] primaryOwners = new int[numPrimaryOwners];
        for (int i = 0; i < numPrimaryOwners; ++i) {
            primaryOwners[i] = state.getIntProperty(String.format(STATE_PRIMARY_OWNERS, i));
        }
        return primaryOwners;
    }

    @Override
    public int getNumSegments() {
        return this.primaryOwners.length;
    }

    public int getNumOwners() {
        return this.membersWithState.size();
    }

    @Override
    public List<Address> getMembers() {
        return this.members;
    }

    @Override
    public List<Address> locateOwnersForSegment(int segmentId) {
        Address primaryOwner = this.locatePrimaryOwnerForSegment(segmentId);
        ArrayList<Address> owners = new ArrayList<Address>(this.membersWithState.size());
        owners.add(primaryOwner);
        for (Address member : this.membersWithState) {
            if (member.equals(primaryOwner)) continue;
            owners.add(member);
        }
        return owners;
    }

    @Override
    public Address locatePrimaryOwnerForSegment(int segmentId) {
        return this.members.get(this.primaryOwners[segmentId]);
    }

    @Override
    public Set<Integer> getSegmentsForOwner(Address owner) {
        if (owner == null) {
            throw new IllegalArgumentException("owner cannot be null");
        }
        if (this.membersWithStateSet.contains(owner)) {
            return this.segments;
        }
        return IntSets.immutableEmptySet();
    }

    @Override
    public Set<Integer> getPrimarySegmentsForOwner(Address owner) {
        int index = this.members.indexOf(owner);
        if (index == -1) {
            return IntSets.immutableEmptySet();
        }
        IntSet primarySegments = IntSets.mutableEmptySet((int)this.primaryOwners.length);
        for (int i = 0; i < this.primaryOwners.length; ++i) {
            if (this.primaryOwners[i] != index) continue;
            primarySegments.set(i);
        }
        return primarySegments;
    }

    @Override
    public String getRoutingTableAsString() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.primaryOwners.length; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(i).append(": ").append(this.primaryOwners[i]);
        }
        if (!this.membersWithoutState.isEmpty()) {
            sb.append("none:");
            for (Address a : this.membersWithoutState) {
                sb.append(' ').append(a);
            }
        }
        return sb.toString();
    }

    @Override
    public boolean isSegmentLocalToNode(Address nodeAddress, int segmentId) {
        return this.membersWithStateSet.contains(nodeAddress);
    }

    @Override
    public boolean isReplicated() {
        return true;
    }

    @Override
    public void toScopedState(ScopedPersistentState state) {
        int i;
        state.setProperty("consistentHash", this.getClass().getName());
        state.setProperty("members", Integer.toString(this.members.size()));
        for (i = 0; i < this.members.size(); ++i) {
            state.setProperty(String.format("member.%d", i), this.members.get(i).toString());
        }
        state.setProperty("membersNoEntries", Integer.toString(this.membersWithoutState.size()));
        for (i = 0; i < this.membersWithoutState.size(); ++i) {
            state.setProperty(String.format("memberNoEntries.%d", i), this.membersWithoutState.get(i).toString());
        }
        state.setProperty("capacityFactors", Integer.toString(this.capacityFactors.size()));
        for (i = 0; i < this.members.size(); ++i) {
            state.setProperty(String.format("capacityFactor.%d", i), this.capacityFactors.get(this.members.get(i)).toString());
        }
        state.setProperty(STATE_PRIMARY_OWNERS_COUNT, Integer.toString(this.primaryOwners.length));
        for (i = 0; i < this.primaryOwners.length; ++i) {
            state.setProperty(String.format(STATE_PRIMARY_OWNERS, i), Integer.toString(this.primaryOwners[i]));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ConsistentHash remapAddresses(UnaryOperator<Address> remapper) {
        void var4_8;
        ArrayList<Address> remappedMembers = new ArrayList<Address>(this.members.size());
        for (Address address : this.members) {
            Address a = (Address)remapper.apply(address);
            if (a == null) {
                return null;
            }
            remappedMembers.add(a);
        }
        ArrayList<Address> remappedMembersWithoutState = new ArrayList<Address>(this.membersWithoutState.size());
        for (Address member : this.membersWithoutState) {
            Address a = (Address)remapper.apply(member);
            if (a == null) {
                return null;
            }
            remappedMembersWithoutState.add(a);
        }
        Object var4_6 = null;
        if (this.capacityFactors != null) {
            HashMap<Address, Float> hashMap = new HashMap<Address, Float>(this.members.size());
            for (Address member : this.members) {
                hashMap.put((Address)remapper.apply(member), this.capacityFactors.get(member));
            }
        }
        return new ReplicatedConsistentHash(remappedMembers, (Map<Address, Float>)var4_8, remappedMembersWithoutState, this.primaryOwners);
    }

    @Override
    public Map<Address, Float> getCapacityFactors() {
        return this.capacityFactors;
    }

    private List<Address> computeMembersWithState(List<Address> members, List<Address> membersWithoutState) {
        if (membersWithoutState.isEmpty()) {
            return members;
        }
        ArrayList<Address> membersWithState = new ArrayList<Address>(members);
        membersWithState.removeAll(membersWithoutState);
        return List.copyOf(membersWithState);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ReplicatedConsistentHash{");
        sb.append("ns = ").append(this.primaryOwners.length);
        sb.append(", owners = (").append(this.members.size()).append(")[");
        int[] primaryOwned = new int[this.members.size()];
        int[] nArray = this.primaryOwners;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            int primaryOwner;
            int n2 = primaryOwner = nArray[i];
            primaryOwned[n2] = primaryOwned[n2] + 1;
        }
        boolean first = true;
        for (int i = 0; i < this.members.size(); ++i) {
            Address a = this.members.get(i);
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            sb.append(a).append(": ").append(primaryOwned[i]);
            sb.append("+");
            if (this.membersWithStateSet.contains(a)) {
                sb.append(this.getNumSegments() - primaryOwned[i]);
                continue;
            }
            sb.append("0");
        }
        sb.append("]}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.members == null ? 0 : this.members.hashCode());
        result = 31 * result + (this.membersWithoutState == null ? 0 : this.membersWithoutState.hashCode());
        result = 31 * result + Arrays.hashCode(this.primaryOwners);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ReplicatedConsistentHash other = (ReplicatedConsistentHash)obj;
        if (this.members == null ? other.members != null : !this.members.equals(other.members)) {
            return false;
        }
        if (this.membersWithoutState == null ? other.membersWithoutState != null : !this.membersWithoutState.equals(other.membersWithoutState)) {
            return false;
        }
        return Arrays.equals(this.primaryOwners, other.primaryOwners);
    }

    public static class Externalizer
    extends InstanceReusingAdvancedExternalizer<ReplicatedConsistentHash> {
        public void doWriteObject(ObjectOutput output, ReplicatedConsistentHash ch) throws IOException {
            output.writeObject(ch.members);
            output.writeObject(ch.capacityFactors);
            output.writeObject(ch.membersWithoutState);
            output.writeObject(ch.primaryOwners);
        }

        public ReplicatedConsistentHash doReadObject(ObjectInput unmarshaller) throws IOException, ClassNotFoundException {
            List members = (List)unmarshaller.readObject();
            Map capacityFactors = (Map)unmarshaller.readObject();
            List membersWithoutState = (List)unmarshaller.readObject();
            int[] primaryOwners = (int[])unmarshaller.readObject();
            return new ReplicatedConsistentHash(members, capacityFactors, membersWithoutState, primaryOwners);
        }

        public Integer getId() {
            return Ids.REPLICATED_CONSISTENT_HASH;
        }

        public Set<Class<? extends ReplicatedConsistentHash>> getTypeClasses() {
            return Collections.singleton(ReplicatedConsistentHash.class);
        }
    }
}

