/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models;

import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.keycloak.models.GroupModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.MembershipMetadata;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleMapperModel;
import org.keycloak.models.SubjectCredentialManager;
import org.keycloak.provider.ProviderEvent;
import org.keycloak.utils.StringUtil;

public interface UserModel
extends RoleMapperModel {
    public static final String USERNAME = "username";
    public static final String FIRST_NAME = "firstName";
    public static final String LAST_NAME = "lastName";
    public static final String EMAIL = "email";
    public static final String EMAIL_VERIFIED = "emailVerified";
    public static final String LOCALE = "locale";
    public static final String ENABLED = "enabled";
    public static final String IDP_ALIAS = "keycloak.session.realm.users.query.idp_alias";
    public static final String IDP_USER_ID = "keycloak.session.realm.users.query.idp_user_id";
    public static final String INCLUDE_SERVICE_ACCOUNT = "keycloak.session.realm.users.query.include_service_account";
    public static final String GROUPS = "keycloak.session.realm.users.query.groups";
    public static final String SEARCH = "keycloak.session.realm.users.query.search";
    public static final String EXACT = "keycloak.session.realm.users.query.exact";
    public static final String DISABLED_REASON = "disabledReason";
    public static final Comparator<UserModel> COMPARE_BY_USERNAME = Comparator.comparing(UserModel::getUsername, String.CASE_INSENSITIVE_ORDER);

    public String getId();

    public String getUsername();

    public void setUsername(String var1);

    public Long getCreatedTimestamp();

    public void setCreatedTimestamp(Long var1);

    public boolean isEnabled();

    public void setEnabled(boolean var1);

    public void setSingleAttribute(String var1, String var2);

    public void setAttribute(String var1, List<String> var2);

    public void removeAttribute(String var1);

    public String getFirstAttribute(String var1);

    public Stream<String> getAttributeStream(String var1);

    public Map<String, List<String>> getAttributes();

    public Stream<String> getRequiredActionsStream();

    public void addRequiredAction(String var1);

    public void removeRequiredAction(String var1);

    default public void addRequiredAction(RequiredAction action) {
        if (action == null) {
            return;
        }
        String actionName = action.name();
        this.addRequiredAction(actionName);
    }

    default public void removeRequiredAction(RequiredAction action) {
        if (action == null) {
            return;
        }
        String actionName = action.name();
        this.removeRequiredAction(actionName);
    }

    public String getFirstName();

    public void setFirstName(String var1);

    public String getLastName();

    public void setLastName(String var1);

    public String getEmail();

    public void setEmail(String var1);

    public boolean isEmailVerified();

    public void setEmailVerified(boolean var1);

    public Stream<GroupModel> getGroupsStream();

    default public Stream<GroupModel> getGroupsStream(String search, Integer first, Integer max) {
        if (search != null) {
            search = search.toLowerCase();
        }
        String finalSearch = search;
        Stream<GroupModel> groupModelStream = this.getGroupsStream().filter(group -> finalSearch == null || group.getName().toLowerCase().contains(finalSearch));
        if (first != null && first > 0) {
            groupModelStream = groupModelStream.skip(first.intValue());
        }
        if (max != null && max >= 0) {
            groupModelStream = groupModelStream.limit(max.intValue());
        }
        return groupModelStream;
    }

    default public long getGroupsCount() {
        return this.getGroupsCountByNameContaining(null);
    }

    default public long getGroupsCountByNameContaining(String search) {
        if (search == null) {
            return this.getGroupsStream().count();
        }
        String s = search.toLowerCase();
        return this.getGroupsStream().filter(group -> group.getName().toLowerCase().contains(s)).count();
    }

    public void joinGroup(GroupModel var1);

    default public void joinGroup(GroupModel group, MembershipMetadata metadata) {
        this.joinGroup(group);
    }

    public void leaveGroup(GroupModel var1);

    public boolean isMemberOf(GroupModel var1);

    public String getFederationLink();

    public void setFederationLink(String var1);

    public String getServiceAccountClientLink();

    public void setServiceAccountClientLink(String var1);

    default public boolean isFederated() {
        return StringUtil.isNotBlank(this.getFederationLink());
    }

    public SubjectCredentialManager credentialManager();

    public static enum RequiredAction {
        VERIFY_EMAIL,
        UPDATE_PROFILE,
        CONFIGURE_TOTP,
        CONFIGURE_RECOVERY_AUTHN_CODES,
        UPDATE_PASSWORD,
        TERMS_AND_CONDITIONS,
        VERIFY_PROFILE,
        UPDATE_EMAIL;

    }

    public static interface UserPreRemovedEvent
    extends ProviderEvent {
        public RealmModel getRealm();

        public UserModel getUser();

        public KeycloakSession getKeycloakSession();
    }

    public static interface UserRemovedEvent
    extends ProviderEvent {
        public RealmModel getRealm();

        public UserModel getUser();

        public KeycloakSession getKeycloakSession();
    }
}

